/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hideable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "hide;";
    public static final String HIDDEN_BY = "hiddenBy";
    public static final String TRANSPARENCY = "transparency";
    protected String hiddenBy;
    protected NamedKeyStroke hideKey;
    protected String command = "Invisible";
    protected PieceAccess access = PlayerAccess.getInstance();
    protected float transparency = 0.3f;
    protected Color bgColor;
    protected KeyCommand[] commands;
    protected KeyCommand hideCommand;

    @Override
    public void setProperty(Object object, Object object2) {
        if (HIDDEN_BY.equals(object)) {
            this.hiddenBy = (String)object2;
        } else {
            super.setProperty(object, object2);
        }
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (this.invisibleToMe()) {
            return ((BasicPiece)Decorator.getInnermost(this)).getLocalizedPublicProperty(object);
        }
        if (HIDDEN_BY.equals(object)) {
            return this.hiddenBy;
        }
        if ("Invisible".equals(object)) {
            return this.invisibleToMe() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleToOthers".equals(object)) {
            return this.invisibleToOthers() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("visibleState".equals(object)) {
            return String.valueOf(this.invisibleToOthers()) + this.invisibleToMe() + this.piece.getProperty(object);
        }
        return super.getLocalizedProperty(object);
    }

    @Override
    public Object getProperty(Object object) {
        if (HIDDEN_BY.equals(object)) {
            return this.hiddenBy;
        }
        if ("Invisible".equals(object)) {
            return this.invisibleToMe() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleToOthers".equals(object)) {
            return this.invisibleToOthers() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("visibleState".equals(object)) {
            return String.valueOf(this.invisibleToOthers()) + this.invisibleToMe() + this.piece.getProperty(object);
        }
        return super.getProperty(object);
    }

    public Hideable() {
        this("hide;I", null);
    }

    public Hideable(String string, GamePiece gamePiece) {
        this.setInner(gamePiece);
        this.mySetType(string);
    }

    @Override
    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.hideKey = decoder.nextNamedKeyStroke('I');
        this.command = decoder.nextToken("Invisible");
        this.bgColor = decoder.nextColor(null);
        this.access = PieceAccessConfigurer.decode(decoder.nextToken(null));
        this.transparency = decoder.hasMoreTokens() ? (float)decoder.nextDouble(0.3) : 0.3f;
        this.commands = null;
    }

    @Override
    public void mySetState(String string) {
        this.hiddenBy = "null".equals(string) ? null : string;
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.hideKey).append(this.command).append(this.bgColor).append(PieceAccessConfigurer.encode(this.access)).append(this.transparency);
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public String myGetState() {
        return this.hiddenBy == null ? "null" : this.hiddenBy;
    }

    public boolean invisibleToMe() {
        return !this.access.currentPlayerHasAccess(this.hiddenBy);
    }

    public boolean invisibleToOthers() {
        return this.hiddenBy != null;
    }

    @Override
    public Shape getShape() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.invisibleToMe()) {
            return;
        }
        if (this.invisibleToOthers()) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.bgColor != null) {
                graphics.setColor(this.bgColor);
                object = AffineTransform.getScaleInstance(d, d);
                ((AffineTransform)object).translate((double)n / d, (double)n2 / d);
                graphics2D.fill(((AffineTransform)object).createTransformedShape(this.piece.getShape()));
            }
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.transparency));
            this.piece.draw(graphics, n, n2, component, d);
            graphics2D.setComposite((Composite)object);
        } else {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    @Override
    public String getName() {
        if (this.invisibleToMe()) {
            return "";
        }
        if (this.invisibleToOthers()) {
            return this.piece.getName() + "(" + this.command + ")";
        }
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.hideCommand = new KeyCommand(this.command, this.hideKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.command.length() > 0 && this.hideKey != null && !this.hideKey.isNull() ? new KeyCommand[]{this.hideCommand} : new KeyCommand[0];
        }
        this.hideCommand.setEnabled(this.access.currentPlayerCanModify(this.hiddenBy));
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.hideCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            if (this.invisibleToOthers()) {
                this.hiddenBy = null;
            } else if (!this.invisibleToMe()) {
                this.hiddenBy = this.access.getCurrentPlayerId();
            }
            return changeTracker.getChangeCommand();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Invisible";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Hideable.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Deprecated
    public static void setAllHidden(boolean bl) {
        if (bl) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, "Hide command");
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("InvisibleToOthers");
        return arrayList;
    }

    protected static class Ed
    implements PieceEditor {
        protected NamedHotKeyConfigurer hideKeyInput;
        protected JTextField hideCommandInput;
        protected ColorConfigurer colorConfig;
        protected IntConfigurer transpConfig;
        protected PieceAccessConfigurer accessConfig;
        protected JPanel controls = new JPanel();

        public Ed(Hideable hideable) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.hideKeyInput = new NamedHotKeyConfigurer(null, "Keyboard command:  ", hideable.hideKey);
            this.controls.add(this.hideKeyInput.getControls());
            Box box = Box.createHorizontalBox();
            this.hideCommandInput = new JTextField(16);
            this.hideCommandInput.setMaximumSize(this.hideCommandInput.getPreferredSize());
            this.hideCommandInput.setText(hideable.command);
            box.add(new JLabel("Menu Text:  "));
            box.add(this.hideCommandInput);
            this.controls.add(box);
            this.colorConfig = new ColorConfigurer(null, "Background color:  ", hideable.bgColor);
            this.controls.add(this.colorConfig.getControls());
            this.transpConfig = new IntConfigurer(null, "Transparency (%):  ", (Integer)((int)(hideable.transparency * 100.0f)));
            this.controls.add(this.transpConfig.getControls());
            this.accessConfig = new PieceAccessConfigurer(null, "Can by hidden by:  ", hideable.access);
            this.controls.add(this.accessConfig.getControls());
        }

        public String getState() {
            return "null";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.hideKeyInput.getValueString()).append(this.hideCommandInput.getText()).append(this.colorConfig.getValue() == null ? "" : this.colorConfig.getValueString()).append(this.accessConfig.getValueString()).append((float)this.transpConfig.getIntValue(30) / 100.0f);
            return Hideable.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }
    }
}

