/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.io.IOUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deck
extends Stack
implements PlayerRoster.SideChangeListener {
    public static final String ID = "deck;";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String NO_USER = "nobody";
    protected static StackMetrics deckStackMetrics = new StackMetrics(false, 2, 2, 2, 2);
    protected boolean drawOutline = true;
    protected Color outlineColor = Color.black;
    protected Dimension size = new Dimension(40, 40);
    protected boolean shuffle = true;
    protected String faceDownOption = "Always";
    protected String shuffleOption = "Always";
    protected String shuffleCommand = "";
    protected boolean allowMultipleDraw = false;
    protected boolean allowSelectDraw = false;
    protected boolean reversible = false;
    protected String reshuffleCommand = "";
    protected String reshuffleTarget;
    protected String reshuffleMsgFormat;
    protected NamedKeyStrokeListener reshuffleListener;
    protected NamedKeyStroke reshuffleKey;
    protected String reverseMsgFormat;
    protected String reverseCommand;
    protected NamedKeyStroke reverseKey;
    protected NamedKeyStrokeListener reverseListener;
    protected String shuffleMsgFormat;
    protected NamedKeyStrokeListener shuffleListener;
    protected NamedKeyStroke shuffleKey;
    protected String faceDownMsgFormat;
    protected boolean drawFaceUp;
    protected boolean persistable;
    protected FormattedString selectDisplayProperty = new FormattedString("$BasicName$");
    protected String selectSortProperty = "";
    protected MutableProperty.Impl countProperty = new MutableProperty.Impl("", this);
    protected List<MutableProperty.Impl> expressionProperties = new ArrayList<MutableProperty.Impl>();
    protected String deckName;
    protected String localizedDeckName;
    protected boolean faceDown;
    protected int dragCount = 0;
    protected int maxStack = 10;
    protected CountExpression[] countExpressions = new CountExpression[0];
    protected boolean expressionCounting = false;
    protected List<GamePiece> nextDraw = null;
    protected KeyCommand[] commands;
    protected List<DeckGlobalKeyCommand> globalCommands = new ArrayList<DeckGlobalKeyCommand>();
    protected boolean hotkeyOnEmpty;
    protected NamedKeyStroke emptyKey;
    protected boolean restrictOption;
    protected PropertyExpression restrictExpression = new PropertyExpression();
    protected PropertySource propertySource;
    protected CommandEncoder commandEncoder = new CommandEncoder(){

        public Command decode(String string) {
            LoadDeckCommand loadDeckCommand = null;
            if (string.startsWith("DECK\t")) {
                loadDeckCommand = new LoadDeckCommand(Deck.this);
            }
            return loadDeckCommand;
        }

        public String encode(Command command) {
            String string = null;
            if (command instanceof LoadDeckCommand) {
                string = "DECK\t";
            }
            return string;
        }
    };

    public Deck() {
        this(ID);
        PlayerRoster.addSideChangeListener(this);
    }

    public Deck(String string) {
        this.mySetType(string);
        PlayerRoster.addSideChangeListener(this);
    }

    public Deck(String string, PropertySource propertySource) {
        this(string);
        this.propertySource = propertySource;
    }

    public void setPropertySource(PropertySource propertySource) {
        this.propertySource = propertySource;
        if (this.globalCommands != null) {
            for (int i = 0; i < this.globalCommands.size(); ++i) {
                this.globalCommands.get(i).setPropertySource(this.propertySource);
            }
        }
    }

    @Override
    public void sideChanged(String string, String string2) {
        this.updateCountsAll();
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.globalCommands.add(deckGlobalKeyCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.globalCommands.remove(deckGlobalKeyCommand);
    }

    protected String[] getGlobalCommands() {
        String[] stringArray = new String[this.globalCommands.size()];
        for (int i = 0; i < this.globalCommands.size(); ++i) {
            stringArray[i] = this.globalCommands.get(i).encode();
        }
        return stringArray;
    }

    protected void setGlobalCommands(String[] stringArray) {
        this.globalCommands = new ArrayList<DeckGlobalKeyCommand>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.globalCommands.add(new DeckGlobalKeyCommand(stringArray[i], this.propertySource));
        }
    }

    private void updateCountsAll() {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyValue("0");
        }
        Iterator<GamePiece> iterator = this.getPiecesIterator();
        while (iterator.hasNext()) {
            GamePiece gamePiece = iterator.next();
            if (gamePiece == null) continue;
            this.updateCounts(gamePiece, true);
        }
    }

    private void updateCounts(int n, boolean bl) {
        if (!this.doesExpressionCounting()) {
            return;
        }
        if (n >= 0 && n < this.contents.length) {
            GamePiece gamePiece = this.getPieceAt(n);
            if (gamePiece == null) {
                this.updateCountsAll();
            } else {
                this.updateCounts(gamePiece, bl);
            }
        } else {
            this.updateCountsAll();
        }
    }

    private void updateCounts(GamePiece gamePiece, boolean bl) {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int i = 0; i < this.countExpressions.length; ++i) {
            String string;
            MutableProperty.Impl impl = this.expressionProperties.get(i);
            FormattedString formattedString = new FormattedString(this.countExpressions[i].getExpression());
            PieceFilter pieceFilter = PropertiesPieceFilter.parse(formattedString.getText());
            if (!pieceFilter.accept(gamePiece) || (string = impl.getPropertyValue()) == null) continue;
            int n = Integer.decode(string);
            n = bl ? ++n : --n;
            impl.setPropertyValue(String.valueOf(n));
        }
    }

    protected void fireNumCardsProperty() {
        this.countProperty.setPropertyValue(String.valueOf(this.pieceCount));
    }

    @Override
    protected void insertPieceAt(GamePiece gamePiece, int n) {
        super.insertPieceAt(gamePiece, n);
        this.updateCounts(gamePiece, true);
        this.fireNumCardsProperty();
    }

    @Override
    protected void removePieceAt(int n) {
        int n2 = this.pieceCount;
        this.updateCounts(n, false);
        super.removePieceAt(n);
        this.fireNumCardsProperty();
        if (this.hotkeyOnEmpty && this.emptyKey != null && n2 > 0 && this.pieceCount == 0) {
            GameModule.getGameModule().fireKeyStroke(this.emptyKey);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    @Override
    public void setMap(Map map) {
        if (map != this.getMap()) {
            this.countProperty.removeFromContainer();
            if (map != null) {
                this.countProperty.addTo(map);
            }
            for (MutableProperty.Impl impl : this.expressionProperties) {
                impl.removeFromContainer();
                if (map == null) continue;
                impl.addTo(map);
            }
        }
        super.setMap(map);
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    protected void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.drawOutline = decoder.nextBoolean(true);
        this.outlineColor = ColorConfigurer.stringToColor(decoder.nextToken("0,0,0"));
        this.size.setSize(decoder.nextInt(40), decoder.nextInt(40));
        this.faceDownOption = decoder.nextToken(ALWAYS);
        this.shuffleOption = decoder.nextToken(ALWAYS);
        this.allowMultipleDraw = decoder.nextBoolean(true);
        this.allowSelectDraw = decoder.nextBoolean(true);
        this.reversible = decoder.nextBoolean(true);
        this.reshuffleCommand = decoder.nextToken("");
        this.reshuffleTarget = decoder.nextToken("");
        this.reshuffleMsgFormat = decoder.nextToken("");
        this.setDeckName(decoder.nextToken("Deck"));
        this.shuffleMsgFormat = decoder.nextToken("");
        this.reverseMsgFormat = decoder.nextToken("");
        this.faceDownMsgFormat = decoder.nextToken("");
        this.drawFaceUp = decoder.nextBoolean(false);
        this.persistable = decoder.nextBoolean(false);
        this.shuffleKey = decoder.nextNamedKeyStroke(null);
        this.reshuffleKey = decoder.nextNamedKeyStroke(null);
        this.maxStack = decoder.nextInt(10);
        this.setCountExpressions(decoder.nextStringArray(0));
        this.expressionCounting = decoder.nextBoolean(false);
        this.setGlobalCommands(decoder.nextStringArray(0));
        this.hotkeyOnEmpty = decoder.nextBoolean(false);
        this.emptyKey = decoder.nextNamedKeyStroke(null);
        this.selectDisplayProperty.setFormat(decoder.nextToken("$BasicName$"));
        this.selectSortProperty = decoder.nextToken("");
        this.restrictOption = decoder.nextBoolean(false);
        this.restrictExpression.setExpression(decoder.nextToken(""));
        this.shuffleCommand = decoder.nextToken(Resources.getString("Deck.shuffle"));
        this.reverseCommand = decoder.nextToken(Resources.getString("Deck.reverse"));
        this.reverseKey = decoder.nextNamedKeyStroke(null);
        if (this.shuffleListener == null) {
            this.shuffleListener = new NamedKeyStrokeListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().sendAndLog(Deck.this.shuffle());
                    Deck.this.repaintMap();
                }
            });
            GameModule.getGameModule().addKeyStrokeListener(this.shuffleListener);
        }
        this.shuffleListener.setKeyStroke(this.getShuffleKey());
        if (this.reshuffleListener == null) {
            this.reshuffleListener = new NamedKeyStrokeListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().sendAndLog(Deck.this.sendToDeck());
                    Deck.this.repaintMap();
                }
            });
            GameModule.getGameModule().addKeyStrokeListener(this.reshuffleListener);
        }
        this.reshuffleListener.setKeyStroke(this.getReshuffleKey());
        if (this.reverseListener == null) {
            this.reverseListener = new NamedKeyStrokeListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GameModule.getGameModule().sendAndLog(Deck.this.reverse());
                    Deck.this.repaintMap();
                }
            });
            GameModule.getGameModule().addKeyStrokeListener(this.reverseListener);
        }
        this.reverseListener.setKeyStroke(this.getReverseKey());
        DrawPile drawPile = DrawPile.findDrawPile(this.getDeckName());
        if (drawPile != null && drawPile.getDeck() == null) {
            drawPile.setDeck(this);
        }
    }

    public String getFaceDownOption() {
        return this.faceDownOption;
    }

    public boolean isDrawFaceUp() {
        return this.drawFaceUp;
    }

    public void setDrawFaceUp(boolean bl) {
        this.drawFaceUp = bl;
    }

    public void setFaceDownOption(String string) {
        this.faceDownOption = string;
        this.faceDown = !string.equals(NEVER);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size.setSize(dimension);
    }

    public String getShuffleOption() {
        return this.shuffleOption;
    }

    public void setShuffleOption(String string) {
        this.shuffleOption = string;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    @Override
    public int getMaximumVisiblePieceCount() {
        return Math.min(this.pieceCount, this.maxStack);
    }

    public String[] getCountExpressions() {
        String[] stringArray = new String[this.countExpressions.length];
        for (int i = 0; i < this.countExpressions.length; ++i) {
            stringArray[i] = this.countExpressions[i].getFullString();
        }
        return stringArray;
    }

    public boolean doesExpressionCounting() {
        return this.expressionCounting;
    }

    public String getFaceDownMsgFormat() {
        return this.faceDownMsgFormat;
    }

    public void setFaceDownMsgFormat(String string) {
        this.faceDownMsgFormat = string;
    }

    public String getReverseMsgFormat() {
        return this.reverseMsgFormat;
    }

    public void setReverseMsgFormat(String string) {
        this.reverseMsgFormat = string;
    }

    public String getReverseCommand() {
        return this.reverseCommand;
    }

    public void setReverseCommand(String string) {
        this.reverseCommand = string;
    }

    public NamedKeyStroke getReverseKey() {
        return this.reverseKey;
    }

    public void setReverseKey(NamedKeyStroke namedKeyStroke) {
        this.reverseKey = namedKeyStroke;
    }

    public String getShuffleMsgFormat() {
        return this.shuffleMsgFormat;
    }

    public void setShuffleMsgFormat(String string) {
        this.shuffleMsgFormat = string;
    }

    public NamedKeyStroke getShuffleKey() {
        return this.shuffleKey;
    }

    public void setShuffleKey(NamedKeyStroke namedKeyStroke) {
        this.shuffleKey = namedKeyStroke;
    }

    public String getShuffleCommand() {
        return this.shuffleCommand;
    }

    public void setShuffleCommand(String string) {
        this.shuffleCommand = string;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
    }

    public boolean isAllowMultipleDraw() {
        return this.allowMultipleDraw;
    }

    public void setAllowMultipleDraw(boolean bl) {
        this.allowMultipleDraw = bl;
    }

    public boolean isAllowSelectDraw() {
        return this.allowSelectDraw;
    }

    public void setMaxStack(int n) {
        this.maxStack = n;
    }

    public void setCountExpressions(String[] stringArray) {
        int n;
        CountExpression[] countExpressionArray = new CountExpression[stringArray.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            CountExpression countExpression = new CountExpression(stringArray[n]);
            if (countExpression.getName() == null) continue;
            countExpressionArray[n] = countExpression;
            ++n2;
        }
        this.countExpressions = ArrayUtils.copyOf(countExpressionArray, n2);
        while (this.countExpressions.length > this.expressionProperties.size()) {
            this.expressionProperties.add(new MutableProperty.Impl("", this));
        }
        for (n = 0; n < this.countExpressions.length; ++n) {
            this.expressionProperties.get(n).setPropertyName(this.deckName + "_" + this.countExpressions[n].getName());
        }
    }

    public void setExpressionCounting(boolean bl) {
        this.expressionCounting = bl;
    }

    public void setAllowSelectDraw(boolean bl) {
        this.allowSelectDraw = bl;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean bl) {
        this.reversible = bl;
    }

    public void setDeckName(String string) {
        if (Localization.getInstance().isTranslationInProgress()) {
            this.localizedDeckName = string;
        } else {
            this.deckName = string;
        }
        this.countProperty.setPropertyName(this.deckName + "_numPieces");
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyName(this.deckName + "_" + this.countExpressions[i].getName());
        }
    }

    public String getDeckName() {
        return this.deckName;
    }

    public String getLocalizedDeckName() {
        return this.localizedDeckName == null ? this.deckName : this.localizedDeckName;
    }

    public String getReshuffleCommand() {
        return this.reshuffleCommand;
    }

    public void setReshuffleCommand(String string) {
        this.reshuffleCommand = string;
    }

    public NamedKeyStroke getReshuffleKey() {
        return this.reshuffleKey;
    }

    public void setReshuffleKey(NamedKeyStroke namedKeyStroke) {
        this.reshuffleKey = namedKeyStroke;
    }

    public String getReshuffleTarget() {
        return this.reshuffleTarget;
    }

    public void setReshuffleTarget(String string) {
        this.reshuffleTarget = string;
    }

    public String getReshuffleMsgFormat() {
        return this.reshuffleMsgFormat;
    }

    public void setReshuffleMsgFormat(String string) {
        this.reshuffleMsgFormat = string;
    }

    public boolean isHotkeyOnEmpty() {
        return this.hotkeyOnEmpty;
    }

    public void setHotkeyOnEmpty(boolean bl) {
        this.hotkeyOnEmpty = bl;
    }

    @Deprecated
    public KeyStroke getEmptyKey() {
        return this.emptyKey.getKeyStroke();
    }

    public NamedKeyStroke getNamedEmptyKey() {
        return this.emptyKey;
    }

    @Deprecated
    public void setEmptyKey(KeyStroke keyStroke) {
        this.emptyKey = new NamedKeyStroke(keyStroke);
    }

    public void setEmptyKey(NamedKeyStroke namedKeyStroke) {
        this.emptyKey = namedKeyStroke;
    }

    public void setRestrictOption(boolean bl) {
        this.restrictOption = bl;
    }

    public boolean isRestrictOption() {
        return this.restrictOption;
    }

    public void setRestrictExpression(PropertyExpression propertyExpression) {
        this.restrictExpression = propertyExpression;
    }

    public PropertyExpression getRestrictExpression() {
        return this.restrictExpression;
    }

    public boolean mayContain(GamePiece gamePiece) {
        if (!this.restrictOption || this.restrictExpression.isNull()) {
            return true;
        }
        return this.restrictExpression.accept(gamePiece);
    }

    @Override
    public String getType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.drawOutline).append(ColorConfigurer.colorToString(this.outlineColor)).append(String.valueOf(this.size.width)).append(String.valueOf(this.size.height)).append(this.faceDownOption).append(this.shuffleOption).append(String.valueOf(this.allowMultipleDraw)).append(String.valueOf(this.allowSelectDraw)).append(String.valueOf(this.reversible)).append(this.reshuffleCommand).append(this.reshuffleTarget).append(this.reshuffleMsgFormat).append(this.deckName).append(this.shuffleMsgFormat).append(this.reverseMsgFormat).append(this.faceDownMsgFormat).append(this.drawFaceUp).append(this.persistable).append(this.shuffleKey).append(this.reshuffleKey).append(String.valueOf(this.maxStack)).append(this.getCountExpressions()).append(this.expressionCounting).append(this.getGlobalCommands()).append(this.hotkeyOnEmpty).append(this.emptyKey).append(this.selectDisplayProperty.getFormat()).append(this.selectSortProperty).append(this.restrictOption).append(this.restrictExpression).append(this.shuffleCommand).append(this.reverseCommand).append(this.reverseKey);
        return ID + sequenceEncoder.getValue();
    }

    public Command shuffle() {
        GamePiece[] gamePieceArray = new GamePiece[this.pieceCount];
        System.arraycopy(this.contents, 0, gamePieceArray, 0, this.pieceCount);
        List<GamePiece> list = Arrays.asList(gamePieceArray);
        DragBuffer.getBuffer().clear();
        Collections.shuffle(list, GameModule.getGameModule().getRNG());
        return this.setContents(list).append(this.reportCommand(this.shuffleMsgFormat, Resources.getString("Deck.shuffle")));
    }

    public PieceIterator drawCards() {
        Iterator<GamePiece> iterator;
        if (this.nextDraw != null) {
            iterator = this.nextDraw.iterator();
        } else if (this.getPieceCount() == 0) {
            iterator = Collections.emptyList().iterator();
        } else {
            int n = Math.max(this.dragCount, Math.min(1, this.getPieceCount()));
            ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
            if (ALWAYS.equals(this.shuffleOption)) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (int i = 0; i < this.getPieceCount(); ++i) {
                    arrayList2.add(i);
                }
                Random random = GameModule.getGameModule().getRNG();
                while (n-- > 0 && arrayList2.size() > 0) {
                    int n2 = random.nextInt(arrayList2.size());
                    int n3 = (Integer)arrayList2.get(n2);
                    arrayList2.remove(n2);
                    GamePiece gamePiece = this.getPieceAt(n3);
                    arrayList.add(gamePiece);
                }
            } else {
                Iterator<GamePiece> iterator2 = this.getPiecesReverseIterator();
                while (n-- > 0 && iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
            iterator = arrayList.iterator();
        }
        this.dragCount = 0;
        this.nextDraw = null;
        return new PieceIterator(iterator){

            public GamePiece nextPiece() {
                GamePiece gamePiece = super.nextPiece();
                if (Deck.this.faceDown) {
                    gamePiece.setProperty("obs;", Deck.NO_USER);
                }
                return gamePiece;
            }
        };
    }

    protected Command setContents(Collection<GamePiece> collection) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        this.removeAll();
        for (GamePiece gamePiece : collection) {
            this.insertChild(gamePiece, this.pieceCount);
        }
        return changeTracker.getChangeCommand();
    }

    @Deprecated
    protected Command setContents(Iterator<GamePiece> iterator) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        this.removeAll();
        while (iterator.hasNext()) {
            GamePiece gamePiece = iterator.next();
            this.insertChild(gamePiece, this.pieceCount);
        }
        return changeTracker.getChangeCommand();
    }

    @Override
    public String getState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        sequenceEncoder.append(this.faceDown);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
        Iterator<GamePiece> iterator = this.getPiecesIterator();
        while (iterator.hasNext()) {
            sequenceEncoder2.append(iterator.next().getId());
        }
        if (sequenceEncoder2.getValue() != null) {
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue();
    }

    @Override
    public void setState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken();
        this.setPosition(new Point(decoder.nextInt(0), decoder.nextInt(0)));
        Map map = null;
        if (!"null".equals(string2) && (map = Map.getMapById(string2)) == null) {
            ErrorDialog.dataError(new BadDataReport("No such map", string2, null));
        }
        if (map != this.getMap()) {
            if (map != null) {
                map.addPiece(this);
            } else {
                this.setMap(null);
            }
        }
        this.faceDown = "true".equals(decoder.nextToken());
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        if (decoder.hasMoreTokens()) {
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ',');
            while (decoder2.hasMoreTokens()) {
                GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(decoder2.nextToken());
                if (gamePiece == null) continue;
                arrayList.add(gamePiece);
            }
        }
        this.setContents(arrayList);
        this.commands = null;
    }

    public Command setContentsFaceDown(boolean bl) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        NullCommand nullCommand = new NullCommand();
        this.faceDown = bl;
        return changeTracker.getChangeCommand().append(nullCommand).append(this.reportCommand(this.faceDownMsgFormat, bl ? Resources.getString("Deck.face_down") : Resources.getString("Deck.face_up")));
    }

    public Command reverse() {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        Iterator<GamePiece> iterator = this.getPiecesReverseIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return this.setContents(arrayList).append(this.reportCommand(this.reverseMsgFormat, Resources.getString("Deck.reverse")));
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    @Override
    public Command pieceAdded(GamePiece gamePiece) {
        return null;
    }

    @Override
    public Command pieceRemoved(GamePiece gamePiece) {
        ChangeTracker changeTracker = new ChangeTracker(gamePiece);
        gamePiece.setProperty("ObscuredToOthers", this.isFaceDown() && !this.isDrawFaceUp());
        return changeTracker.getChangeCommand();
    }

    public void setFaceDown(boolean bl) {
        this.faceDown = bl;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        GamePiece gamePiece;
        int n3 = Math.min(this.getPieceCount(), this.maxStack);
        GamePiece gamePiece2 = gamePiece = this.nextDraw != null && this.nextDraw.size() > 0 ? this.nextDraw.get(0) : this.topPiece();
        if (gamePiece != null) {
            Object object = gamePiece.getProperty("obs;");
            gamePiece.setProperty("obs;", this.faceDown ? NO_USER : null);
            Color color = this.getBlankColor();
            Rectangle rectangle = gamePiece.getShape().getBounds();
            rectangle.setLocation(n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y));
            rectangle.setSize((int)(d * (double)rectangle.width), (int)(d * (double)rectangle.height));
            for (int i = 0; i < n3 - 1; ++i) {
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x + (int)(d * 2.0 * (double)i), rectangle.y - (int)(d * 2.0 * (double)i), rectangle.width, rectangle.height);
                    graphics.setColor(Color.black);
                    graphics.drawRect(rectangle.x + (int)(d * 2.0 * (double)i), rectangle.y - (int)(d * 2.0 * (double)i), rectangle.width, rectangle.height);
                    continue;
                }
                if (this.faceDown) {
                    gamePiece.draw(graphics, n + (int)(d * 2.0 * (double)i), n2 - (int)(d * 2.0 * (double)i), component, d);
                    continue;
                }
                this.getPieceAt(n3 - i - 1).draw(graphics, n + (int)(d * 2.0 * (double)i), n2 - (int)(d * 2.0 * (double)i), component, d);
            }
            gamePiece.draw(graphics, n + (int)(d * 2.0 * (double)(n3 - 1)), n2 - (int)(d * 2.0 * (double)(n3 - 1)), component, d);
            gamePiece.setProperty("obs;", object);
        } else if (this.drawOutline) {
            Rectangle rectangle = this.boundingBox();
            rectangle.setLocation(n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y));
            rectangle.setSize((int)(d * (double)rectangle.width), (int)(d * (double)rectangle.height));
            graphics.setColor(this.outlineColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Color getBlankColor() {
        Color color = Color.white;
        if (this.getMap() != null) {
            color = this.getMap().getStackMetrics().getBlankColor();
        }
        return color;
    }

    @Override
    public StackMetrics getStackMetrics() {
        return deckStackMetrics;
    }

    @Override
    public Rectangle boundingBox() {
        GamePiece gamePiece = this.topPiece();
        Dimension dimension = gamePiece == null ? this.size : gamePiece.getShape().getBounds().getSize();
        Rectangle rectangle = new Rectangle(new Point(), dimension);
        rectangle.translate(-rectangle.width / 2, -rectangle.height / 2);
        int n = this.getMaximumVisiblePieceCount();
        for (int i = 0; i < n; ++i) {
            rectangle.y -= 2;
            rectangle.height += 2;
            rectangle.width += 2;
        }
        return rectangle;
    }

    @Override
    public Shape getShape() {
        return this.boundingBox();
    }

    @Override
    public Object getProperty(Object object) {
        KeyCommand[] keyCommandArray = null;
        if ("NoStack".equals(object)) {
            keyCommandArray = Boolean.TRUE;
        } else if ("KeyCommands".equals(object)) {
            keyCommandArray = this.getKeyCommands();
        }
        return keyCommandArray;
    }

    protected KeyCommand[] getKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            KeyCommand keyCommand = null;
            if (USE_MENU.equals(this.shuffleOption)) {
                keyCommand = new KeyCommand(this.shuffleCommand, this.getShuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.shuffle());
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.reshuffleCommand.length() > 0) {
                keyCommand = new KeyCommand(this.reshuffleCommand, this.getReshuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.sendToDeck());
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (USE_MENU.equals(this.faceDownOption)) {
                KeyCommand keyCommand2 = new KeyCommand(this.faceDown ? Resources.getString("Deck.face_up") : Resources.getString("Deck.face_down"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        Command command = Deck.this.setContentsFaceDown(!Deck.this.faceDown);
                        GameModule.getGameModule().sendAndLog(command);
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand2);
            }
            if (this.reversible) {
                keyCommand = new KeyCommand(this.reverseCommand, NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        Command command = Deck.this.reverse();
                        GameModule.getGameModule().sendAndLog(command);
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.allowMultipleDraw) {
                keyCommand = new KeyCommand(Resources.getString("Deck.draw_multiple"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        Deck.this.promptForDragCount();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.allowSelectDraw) {
                keyCommand = new KeyCommand(Resources.getString("Deck.draw_specific"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        Deck.this.promptForNextDraw();
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
            }
            if (this.persistable) {
                keyCommand = new KeyCommand(Resources.getString("General.save"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.saveDeck());
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
                keyCommand = new KeyCommand(Resources.getString("General.load"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameModule.getGameModule().sendAndLog(Deck.this.loadDeck());
                        Deck.this.repaintMap();
                    }
                };
                arrayList.add(keyCommand);
            }
            for (DeckGlobalKeyCommand deckGlobalKeyCommand : this.globalCommands) {
                arrayList.add(deckGlobalKeyCommand.getKeyCommand(this));
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        for (int i = 0; i < this.commands.length; ++i) {
            if (Resources.getString("Deck.face_up").equals(this.commands[i].getValue("Name")) && !this.faceDown) {
                this.commands[i].putValue("Name", Resources.getString("Deck.face_down"));
                continue;
            }
            if (!Resources.getString("Deck.face_down").equals(this.commands[i].getValue("Name")) || !this.faceDown) continue;
            this.commands[i].putValue("Name", Resources.getString("Deck.face_up"));
        }
        return this.commands;
    }

    protected Command reportCommand(String string, String string2) {
        Chatter.DisplayText displayText = null;
        FormattedString formattedString = new FormattedString(string);
        formattedString.setProperty("deckName", this.getLocalizedDeckName());
        formattedString.setProperty("commandName", string2);
        String string3 = formattedString.getLocalizedText();
        if (string3.length() > 0) {
            displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string3);
            displayText.execute();
        }
        return displayText;
    }

    public void promptForDragCount() {
        String string;
        while ((string = JOptionPane.showInputDialog(Resources.getString("Deck.enter_the_number"))) != null) {
            try {
                this.dragCount = Integer.parseInt(string);
                this.dragCount = Math.min(this.dragCount, this.getPieceCount());
                if (this.dragCount < 0) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    protected void promptForNextDraw() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.map.getView()), true);
        jDialog.setTitle(Resources.getString("Deck.draw"));
        jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AvailablePiece
        implements Comparable<AvailablePiece> {
            private GamePiece piece;

            public AvailablePiece(GamePiece gamePiece) {
                this.piece = gamePiece;
            }

            @Override
            public int compareTo(AvailablePiece availablePiece) {
                if (availablePiece == null) {
                    return 1;
                }
                String string = (String)availablePiece.piece.getProperty(Deck.this.selectSortProperty);
                if (string == null) {
                    return 1;
                }
                String string2 = (String)this.piece.getProperty(Deck.this.selectSortProperty);
                if (string2 == null) {
                    return -1;
                }
                return -string.compareTo(string2);
            }

            public String toString() {
                return Deck.this.selectDisplayProperty.getText(this.piece);
            }

            public boolean equals(Object object) {
                if (!(object instanceof AvailablePiece)) {
                    return false;
                }
                return ((AvailablePiece)object).piece.equals(this.piece);
            }
        }
        Object[] objectArray = new AvailablePiece[this.getPieceCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[objectArray.length - i - 1] = new AvailablePiece(this.getPieceAt(i));
        }
        if (this.selectSortProperty != null && this.selectSortProperty.length() > 0) {
            Arrays.sort(objectArray);
        }
        final JList<AvailablePiece> jList = new JList<AvailablePiece>(objectArray);
        jList.setSelectionMode(2);
        jDialog.add(new ScrollPane(jList));
        jDialog.add(new JLabel(Resources.getString("Deck.select_cards")));
        jDialog.add(new JLabel(Resources.getString("Deck.then_click")));
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton(Resources.getString("General.ok"));
        jButton.addActionListener(new ActionListener((AvailablePiece[])objectArray, jDialog){
            final /* synthetic */ AvailablePiece[] val$pieces;
            final /* synthetic */ JDialog val$d;
            {
                this.val$pieces = availablePieceArray;
                this.val$d = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jList.getSelectedIndices();
                if (nArray.length > 0) {
                    Deck.this.nextDraw = new ArrayList<GamePiece>();
                    for (int i = 0; i < nArray.length; ++i) {
                        Deck.this.nextDraw.add(this.val$pieces[nArray[i]].piece);
                    }
                } else {
                    Deck.this.nextDraw = null;
                }
                this.val$d.dispose();
            }
        });
        box.add(jButton);
        jButton = new JButton(Resources.getString("General.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        box.add(jButton);
        jDialog.add(box);
        jDialog.pack();
        jDialog.setLocationRelativeTo(jDialog.getOwner());
        jDialog.setVisible(true);
    }

    public Command sendToDeck() {
        Command command = null;
        this.nextDraw = null;
        DrawPile drawPile = DrawPile.findDrawPile(this.reshuffleTarget);
        if (drawPile != null) {
            int n;
            if (this.reshuffleMsgFormat.length() > 0) {
                command = this.reportCommand(this.reshuffleMsgFormat, this.reshuffleCommand);
                if (command == null) {
                    command = new NullCommand();
                }
            } else {
                command = new NullCommand();
            }
            for (int i = n = this.getPieceCount() - 1; i >= 0; --i) {
                command.append(drawPile.addToContents(this.getPieceAt(i)));
            }
        }
        return command;
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    public boolean isPersistable() {
        return this.persistable;
    }

    public void setPersistable(boolean bl) {
        this.persistable = bl;
    }

    private File getSaveFileName() {
        int n;
        Object object;
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        File file = fileChooser.getSelectedFile();
        if (file != null && (object = file.getPath()) != null && (n = ((String)object).lastIndexOf(46)) > 0) {
            object = ((String)object).substring(0, n) + ".sav";
            fileChooser.setSelectedFile(new File((String)object));
        }
        if (fileChooser.showSaveDialog(this.map.getView()) != 0) {
            return null;
        }
        object = fileChooser.getSelectedFile();
        if (object != null && ((File)object).exists() && this.shouldConfirmOverwrite() && 1 == JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("Deck.overwrite", ((File)object).getName()), Resources.getString("Deck.file_exists"), 0)) {
            object = null;
        }
        return object;
    }

    private boolean shouldConfirmOverwrite() {
        return System.getProperty("os.name").trim().equalsIgnoreCase("linux");
    }

    private Command saveDeck() {
        NullCommand nullCommand = new NullCommand();
        GameModule.getGameModule().warn(Resources.getString("Deck.saving_deck"));
        File file = this.getSaveFileName();
        try {
            if (file != null) {
                this.saveDeck(file);
                GameModule.getGameModule().warn(Resources.getString("Deck.deck_saved"));
            } else {
                GameModule.getGameModule().warn(Resources.getString("Deck.save_canceled"));
            }
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, file);
        }
        return nullCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDeck(File file) throws IOException {
        Command command = new LoadDeckCommand(null);
        Object object = this.getPiecesIterator();
        while (object.hasNext()) {
            GamePiece gamePiece = object.next();
            gamePiece.setMap(null);
            command = command.append(new AddPiece(gamePiece));
        }
        object = null;
        try {
            object = new BufferedWriter(new FileWriter(file));
            GameModule.getGameModule().addCommandEncoder(this.commandEncoder);
            ((Writer)object).write(GameModule.getGameModule().encode(command));
            GameModule.getGameModule().removeCommandEncoder(this.commandEncoder);
            ((BufferedWriter)object).close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(object);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)object);
    }

    private File getLoadFileName() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.selectDotSavFile();
        if (fileChooser.showOpenDialog(this.map.getView()) != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private Command loadDeck() {
        Command command = new NullCommand();
        GameModule.getGameModule().warn(Resources.getString("Deck.loading_deck"));
        File file = this.getLoadFileName();
        try {
            if (file != null) {
                command = this.loadDeck(file);
                GameModule.getGameModule().warn(Resources.getString("Deck.deck_loaded"));
            } else {
                GameModule.getGameModule().warn(Resources.getString("Deck.load_canceled"));
            }
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command loadDeck(File file) throws IOException {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string = IOUtils.toString((Reader)bufferedReader);
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        GameModule.getGameModule().addCommandEncoder(this.commandEncoder);
        Command command = GameModule.getGameModule().decode(string);
        GameModule.getGameModule().removeCommandEncoder(this.commandEncoder);
        if (command instanceof LoadDeckCommand) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            command.execute();
            Command[] commandArray = command.getSubCommands();
            command = new NullCommand();
            for (int i = 0; i < commandArray.length; ++i) {
                command.append(commandArray[i]);
            }
            command.append(changeTracker.getChangeCommand());
            this.updateCountsAll();
        } else {
            GameModule.getGameModule().warn(Resources.getString("Deck.not_a_saved_deck", file.getName()));
            command = null;
        }
        return command;
    }

    public int getDragCount() {
        return this.dragCount;
    }

    public void setDragCount(int n) {
        this.dragCount = n;
    }

    public void setSelectDisplayProperty(String string) {
        this.selectDisplayProperty.setFormat(string);
    }

    public void setSelectSortProperty(String string) {
        this.selectSortProperty = string;
    }

    public String getSelectDisplayProperty() {
        return this.selectDisplayProperty.getFormat();
    }

    public String getSelectSortProperty() {
        return this.selectSortProperty;
    }

    protected void repaintMap() {
        if (this.map != null) {
            this.map.repaint();
        }
    }

    public static class CountExpression {
        private String fullstring;
        private String name;
        private String expression;

        public CountExpression(String string) {
            String[] stringArray = string.split("\\s*:\\s*", 2);
            if (stringArray.length == 2) {
                this.name = stringArray[0];
                this.expression = stringArray[1];
                this.fullstring = string;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFullString() {
            return this.fullstring;
        }
    }

    protected static class LoadDeckCommand
    extends Command {
        public static final String PREFIX = "DECK\t";
        private Deck target;

        public LoadDeckCommand(Deck deck) {
            this.target = deck;
        }

        protected void executeCommand() {
            this.target.removeAll();
            Command[] commandArray = this.getSubCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                if (!(commandArray[i] instanceof AddPiece)) continue;
                GamePiece gamePiece = ((AddPiece)commandArray[i]).getTarget();
                gamePiece.setId(null);
                this.target.add(gamePiece);
            }
        }

        public String getTargetId() {
            return this.target == null ? "" : this.target.getId();
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

