/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.SocketWatcher;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class SocketHandler {
    protected Socket sock;
    protected SocketWatcher handler;
    private BlockingQueue<String> writeQueue = new LinkedBlockingQueue<String>();
    private boolean isOpen = true;
    private Thread readThread;
    private Thread writeThread;
    private static final String SIGN_OFF = "!BYE";

    public SocketHandler(Socket socket, SocketWatcher socketWatcher) throws IOException {
        this.sock = socket;
        this.handler = socketWatcher;
    }

    public void start() {
        if (this.readThread == null) {
            this.readThread = this.startReadThread();
        }
        if (this.writeThread == null) {
            this.writeThread = this.startWriteThread();
        }
    }

    private Thread startReadThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string;
                    while ((string = SocketHandler.this.readNext()) != null && !SocketHandler.SIGN_OFF.equals(string)) {
                        if (string.length() <= 0) continue;
                        try {
                            SocketHandler.this.handler.handleMessage(string);
                        }
                        catch (Exception exception) {
                            System.err.println("Caught " + exception.getClass().getName() + " handling " + string);
                            exception.printStackTrace();
                        }
                    }
                }
                catch (IOException iOException) {
                    String string = iOException.getClass().getName();
                    string = string.substring(string.lastIndexOf(46) + 1);
                }
                SocketHandler.this.closeSocket();
            }
        };
        Thread thread = new Thread(runnable, "read " + this.sock.getInetAddress());
        thread.start();
        return thread;
    }

    private Thread startWriteThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    while (true) {
                        String string;
                        if ((string = SocketHandler.this.getLine()) == null) {
                            continue;
                        }
                        SocketHandler.this.writeNext(string);
                        if (SocketHandler.SIGN_OFF.equals(string)) break;
                    }
                }
                catch (IOException iOException) {
                    String string = iOException.getClass().getName();
                    string = string.substring(string.lastIndexOf(46) + 1);
                }
                SocketHandler.this.closeSocket();
            }
        };
        Thread thread = new Thread(runnable, "write " + this.sock.getInetAddress());
        thread.start();
        return thread;
    }

    protected abstract void closeStreams() throws IOException;

    protected abstract String readNext() throws IOException;

    protected abstract void writeNext(String var1) throws IOException;

    public void writeLine(String string) {
        try {
            this.writeQueue.put(string);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void close() {
        this.writeLine(SIGN_OFF);
    }

    private synchronized void closeSocket() {
        if (this.isOpen) {
            try {
                this.closeStreams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.close();
            this.isOpen = false;
            this.handler.socketClosed(this);
        }
    }

    private String getLine() {
        try {
            return this.writeQueue.take();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }
}

