/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawPile
extends SetupStack
implements PropertySource,
PropertyNameSource {
    protected Deck dummy = new Deck();
    protected boolean reshufflable;
    protected Deck myDeck;
    protected PropertySource source;
    private VisibilityCondition colorVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isDrawOutline();
        }
    };
    private VisibilityCondition reshuffleVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.reshufflable;
        }
    };
    private VisibilityCondition faceDownFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getFaceDownOption().equals(DrawPile.USE_MENU);
        }
    };
    private VisibilityCondition reverseFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isReversible();
        }
    };
    private VisibilityCondition shuffleFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getShuffleOption().equals(DrawPile.USE_MENU);
        }
    };
    private VisibilityCondition expressionCountingVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.doesExpressionCounting();
        }
    };
    private VisibilityCondition hotkeyOnEmptyVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isHotkeyOnEmpty();
        }
    };
    private VisibilityCondition selectionAllowedVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isAllowSelectDraw();
        }
    };
    private VisibilityCondition restrictExpressionVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isRestrictOption();
        }
    };
    protected static UniqueIdManager idMgr = new UniqueIdManager("Deck");
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String ALLOW_SELECT = "allowSelect";
    public static final String SELECT_DISPLAY_PROPERTY = "selectDisplayProperty";
    public static final String SELECT_SORT_PROPERTY = "selectSortProperty";
    public static final String FACE_DOWN = "faceDown";
    public static final String DRAW_FACE_UP = "drawFaceUp";
    public static final String FACE_DOWN_REPORT_FORMAT = "faceDownFormat";
    public static final String FACE_DOWN_HOTKEY = "faceDownHotkey";
    public static final String SHUFFLE = "shuffle";
    public static final String SHUFFLE_REPORT_FORMAT = "shuffleFormat";
    public static final String SHUFFLE_HOTKEY = "shuffleHotkey";
    public static final String SHUFFLE_COMMAND = "shuffleCommand";
    public static final String REVERSIBLE = "reversible";
    public static final String REVERSE_REPORT_FORMAT = "reverseFormat";
    public static final String REVERSE_HOTKEY = "reverseHotkey";
    public static final String REVERSE_COMMAND = "reverseCommand";
    public static final String DRAW = "draw";
    public static final String COLOR = "color";
    public static final String MAXSTACK = "maxStack";
    public static final String EXPRESSIONCOUNTING = "expressionCounting";
    public static final String COUNTEXPRESSIONS = "countExpressions";
    public static final String RESHUFFLABLE = "reshufflable";
    public static final String RESHUFFLE_COMMAND = "reshuffleCommand";
    public static final String RESHUFFLE_TARGET = "reshuffleTarget";
    public static final String RESHUFFLE_MESSAGE = "reshuffleMessage";
    public static final String RESHUFFLE_HOTKEY = "reshuffleHotkey";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CAN_SAVE = "canSave";
    public static final String HOTKEY_ON_EMPTY = "hotkeyOnEmpty";
    public static final String EMPTY_HOTKEY = "emptyHotkey";
    public static final String RESTRICT_OPTION = "restrictOption";
    public static final String RESTRICT_EXPRESSION = "restrictExpression";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String COMMAND_NAME = "commandName";
    public static final String DECK_NAME = "deckName";

    @Override
    public void addTo(Buildable buildable) {
        super.addTo(buildable);
        idMgr.add(this);
        this.setAttributeTranslatable("name", true);
        if (buildable instanceof PropertySource) {
            this.source = (PropertySource)((Object)buildable);
        }
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.dummy.addGlobalKeyCommand(deckGlobalKeyCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.dummy.removeGlobalKeyCommand(deckGlobalKeyCommand);
    }

    public static DrawPile findDrawPile(String string) {
        return (DrawPile)idMgr.findInstance(string);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "owningBoard", "x", "y", WIDTH, HEIGHT, ALLOW_MULTIPLE, ALLOW_SELECT, SELECT_DISPLAY_PROPERTY, SELECT_SORT_PROPERTY, FACE_DOWN, DRAW_FACE_UP, FACE_DOWN_REPORT_FORMAT, SHUFFLE, SHUFFLE_COMMAND, SHUFFLE_REPORT_FORMAT, SHUFFLE_HOTKEY, REVERSIBLE, REVERSE_COMMAND, REVERSE_REPORT_FORMAT, REVERSE_HOTKEY, DRAW, COLOR, HOTKEY_ON_EMPTY, EMPTY_HOTKEY, RESHUFFLABLE, RESHUFFLE_COMMAND, RESHUFFLE_MESSAGE, RESHUFFLE_HOTKEY, RESHUFFLE_TARGET, CAN_SAVE, MAXSTACK, EXPRESSIONCOUNTING, COUNTEXPRESSIONS, RESTRICT_OPTION, RESTRICT_EXPRESSION};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.DrawPile.owning_board"), Resources.getString("Editor.DrawPile.xposition"), Resources.getString("Editor.DrawPile.yposition"), Resources.getString("Editor.DrawPile.width"), Resources.getString("Editor.DrawPile.height"), Resources.getString("Editor.DrawPile.multi_draw"), Resources.getString("Editor.DrawPile.specific_draw"), Resources.getString("Editor.DrawPile.list_cards"), Resources.getString("Editor.DrawPile.sort_cards"), Resources.getString("Editor.DrawPile.facedown"), Resources.getString("Editor.DrawPile.faceup"), Resources.getString("Editor.DrawPile.facedown_report"), Resources.getString("Editor.DrawPile.reshuffle"), Resources.getString("Editor.DrawPile.reshuffle_text"), Resources.getString("Editor.DrawPile.reshuffle_report"), Resources.getString("Editor.DrawPile.reshuffle_key"), Resources.getString("Editor.DrawPile.reverse"), Resources.getString("Editor.DrawPile.reverse_text"), Resources.getString("Editor.DrawPile.reverse_report"), Resources.getString("Editor.DrawPile.reverse_key"), Resources.getString("Editor.DrawPile.outline"), Resources.getString("Editor.DrawPile.color"), Resources.getString("Editor.DrawPile.empty_key"), Resources.getString("Editor.DrawPile.empty_keyfrom"), Resources.getString("Editor.DrawPile.send_deck"), Resources.getString("Editor.DrawPile.send_text"), Resources.getString("Editor.DrawPile.send_report"), Resources.getString("Editor.DrawPile.send_key"), Resources.getString("Editor.DrawPile.send_deck_name"), Resources.getString("Editor.DrawPile.saved"), Resources.getString("Editor.DrawPile.maxdisplay"), Resources.getString("Editor.DrawPile.perform_express"), Resources.getString("Editor.DrawPile.count_express"), Resources.getString("Editor.DrawPile.restrict_drag"), Resources.getString("Editor.DrawPile.match_express")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, SetupStack.OwningBoardPrompt.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, PiecePropertyConfig.class, String.class, Prompt.class, Boolean.class, FormattedStringConfig.class, Prompt.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, Boolean.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, Boolean.class, Color.class, Boolean.class, NamedKeyStroke.class, Boolean.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, AssignedDeckPrompt.class, Boolean.class, Integer.class, Boolean.class, String[].class, Boolean.class, PropertyExpression.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (WIDTH.equals(string)) {
            return String.valueOf(this.dummy.getSize().width);
        }
        if (HEIGHT.equals(string)) {
            return String.valueOf(this.dummy.getSize().height);
        }
        if (FACE_DOWN.equals(string)) {
            return this.dummy.getFaceDownOption();
        }
        if (DRAW_FACE_UP.equals(string)) {
            return String.valueOf(this.dummy.isDrawFaceUp());
        }
        if (SHUFFLE.equals(string)) {
            return this.dummy.getShuffleOption();
        }
        if (REVERSIBLE.equals(string)) {
            return String.valueOf(this.dummy.isReversible());
        }
        if (ALLOW_MULTIPLE.equals(string)) {
            return String.valueOf(this.dummy.isAllowMultipleDraw());
        }
        if (ALLOW_SELECT.equals(string)) {
            return String.valueOf(this.dummy.isAllowSelectDraw());
        }
        if (SELECT_DISPLAY_PROPERTY.equals(string)) {
            return this.dummy.getSelectDisplayProperty();
        }
        if (SELECT_SORT_PROPERTY.equals(string)) {
            return this.dummy.getSelectSortProperty();
        }
        if (DRAW.equals(string)) {
            return String.valueOf(this.dummy.isDrawOutline());
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.dummy.getOutlineColor());
        }
        if (MAXSTACK.equals(string)) {
            return String.valueOf(this.dummy.getMaxStack());
        }
        if (EXPRESSIONCOUNTING.equals(string)) {
            return String.valueOf(this.dummy.doesExpressionCounting());
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.dummy.getCountExpressions());
        }
        if (RESHUFFLABLE.equals(string)) {
            return String.valueOf(this.reshufflable || this.dummy.getReshuffleCommand().length() > 0 || this.dummy.getReshuffleTarget().length() > 0 || this.dummy.getReshuffleMsgFormat().length() > 0 || this.dummy.getReshuffleKey() != NamedKeyStroke.NULL_KEYSTROKE);
        }
        if (RESHUFFLE_COMMAND.equals(string)) {
            return this.dummy.getReshuffleCommand();
        }
        if (RESHUFFLE_TARGET.equals(string)) {
            return this.dummy.getReshuffleTarget();
        }
        if (RESHUFFLE_MESSAGE.equals(string)) {
            return this.dummy.getReshuffleMsgFormat();
        }
        if (RESHUFFLE_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getReshuffleKey());
        }
        if (SHUFFLE_COMMAND.equals(string)) {
            return this.dummy.getShuffleCommand();
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getShuffleMsgFormat();
        }
        if (SHUFFLE_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getShuffleKey());
        }
        if (REVERSE_COMMAND.equals(string)) {
            return this.dummy.getReverseCommand();
        }
        if (REVERSE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getReverseMsgFormat();
        }
        if (REVERSE_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getReverseKey());
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.dummy.getFaceDownMsgFormat();
        }
        if (CAN_SAVE.equals(string)) {
            return String.valueOf(this.dummy.isPersistable());
        }
        if (HOTKEY_ON_EMPTY.equals(string)) {
            return String.valueOf(this.dummy.isHotkeyOnEmpty());
        }
        if (EMPTY_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getNamedEmptyKey());
        }
        if (RESTRICT_OPTION.equals(string)) {
            return String.valueOf(this.dummy.isRestrictOption());
        }
        if (RESTRICT_EXPRESSION.equals(string)) {
            return this.dummy.getRestrictExpression().getExpression();
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.dummy.getSize().width = (Integer)object;
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.dummy.getSize().height = (Integer)object;
        } else if (FACE_DOWN.equals(string)) {
            this.dummy.setFaceDownOption((String)object);
        } else if (DRAW_FACE_UP.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawFaceUp(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawFaceUp("true".equals(object));
            }
        } else if (CAN_SAVE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setPersistable(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setPersistable("true".equals(object));
            }
        } else if (SHUFFLE.equals(string)) {
            this.dummy.setShuffleOption((String)object);
        } else if (REVERSIBLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setReversible(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setReversible("true".equals(object));
            }
        } else if (ALLOW_MULTIPLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowMultipleDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowMultipleDraw("true".equals(object));
            }
        } else if (ALLOW_SELECT.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowSelectDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowSelectDraw("true".equals(object));
            }
        } else if (SELECT_DISPLAY_PROPERTY.equals(string)) {
            this.dummy.setSelectDisplayProperty((String)object);
        } else if (SELECT_SORT_PROPERTY.equals(string)) {
            this.dummy.setSelectSortProperty((String)object);
        } else if (DRAW.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawOutline(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawOutline("true".equals(object));
            }
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.dummy.setOutlineColor((Color)object);
        }
        if (MAXSTACK.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.dummy.setMaxStack((Integer)object);
        }
        if (EXPRESSIONCOUNTING.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setExpressionCounting(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setExpressionCounting("true".equals(object));
            }
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.dummy.setCountExpressions((String[])object);
        } else if (RESHUFFLABLE.equals(string)) {
            boolean bl = this.reshufflable = "true".equals(object) || Boolean.TRUE.equals(object);
            if (!this.reshufflable) {
                this.dummy.setReshuffleCommand("");
                this.dummy.setReshuffleKey(NamedKeyStroke.NULL_KEYSTROKE);
                this.dummy.setReshuffleTarget("");
                this.dummy.setReshuffleMsgFormat("");
            }
        } else if (RESHUFFLE_COMMAND.equals(string)) {
            this.dummy.setReshuffleCommand((String)object);
        } else if (RESHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.dummy.setReshuffleKey((NamedKeyStroke)object);
        } else if (RESHUFFLE_TARGET.equals(string)) {
            this.dummy.setReshuffleTarget((String)object);
        } else if (RESHUFFLE_MESSAGE.equals(string)) {
            this.dummy.setReshuffleMsgFormat((String)object);
        } else if (REVERSE_COMMAND.equals(string)) {
            this.dummy.setReverseCommand((String)object);
        } else if (REVERSE_REPORT_FORMAT.equals(string)) {
            this.dummy.setReverseMsgFormat((String)object);
        } else if (REVERSE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.dummy.setReverseKey((NamedKeyStroke)object);
        } else if (SHUFFLE_COMMAND.equals(string)) {
            this.dummy.setShuffleCommand((String)object);
        } else if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            this.dummy.setShuffleMsgFormat((String)object);
        } else if (SHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.dummy.setShuffleKey((NamedKeyStroke)object);
        } else if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            this.dummy.setFaceDownMsgFormat((String)object);
        } else if ("name".equals(string)) {
            this.dummy.setDeckName((String)object);
            super.setAttribute(string, object);
        } else if (HOTKEY_ON_EMPTY.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setHotkeyOnEmpty(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setHotkeyOnEmpty("true".equals(object));
            }
        } else if (EMPTY_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.dummy.setEmptyKey((NamedKeyStroke)object);
        } else if (RESTRICT_OPTION.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setRestrictOption(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setRestrictOption("true".equals(object));
            }
        } else if (RESTRICT_EXPRESSION.equals(string)) {
            if (object instanceof String) {
                object = new PropertyExpression((String)object);
            }
            this.dummy.setRestrictExpression((PropertyExpression)object);
        } else {
            super.setAttribute(string, object);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string)) {
            return this.colorVisibleCondition;
        }
        if (RESHUFFLE_COMMAND.equals(string) || RESHUFFLE_MESSAGE.equals(string) || RESHUFFLE_TARGET.equals(string) || RESHUFFLE_HOTKEY.equals(string)) {
            return this.reshuffleVisibleCondition;
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.faceDownFormatVisibleCondition;
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string) || SHUFFLE_HOTKEY.equals(string) || SHUFFLE_COMMAND.equals(string)) {
            return this.shuffleFormatVisibleCondition;
        }
        if (REVERSE_REPORT_FORMAT.equals(string) || REVERSE_HOTKEY.equals(string) || REVERSE_COMMAND.equals(string)) {
            return this.reverseFormatVisibleCondition;
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            return this.expressionCountingVisibleCondition;
        }
        if (EMPTY_HOTKEY.equals(string)) {
            return this.hotkeyOnEmptyVisibleCondition;
        }
        if (SELECT_DISPLAY_PROPERTY.equals(string) || SELECT_SORT_PROPERTY.equals(string)) {
            return this.selectionAllowedVisibleCondition;
        }
        if (RESTRICT_EXPRESSION.equals(string)) {
            return this.restrictExpressionVisibleCondition;
        }
        return null;
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CardSlot.class, DeckGlobalKeyCommand.class};
    }

    public Point getPosition() {
        Point point = new Point(this.pos);
        Board board = this.map.getBoardByName(this.owningBoardName);
        if (board != null) {
            point.translate(board.bounds().x, board.bounds().y);
        }
        return point;
    }

    public Map getMap() {
        return this.map;
    }

    public Rectangle boundingBox() {
        return this.myDeck == null ? null : this.myDeck.boundingBox();
    }

    public Command addToContents(GamePiece gamePiece) {
        if (this.myDeck != null && this.myDeck.indexOf(gamePiece) >= 0) {
            return new NullCommand();
        }
        return this.map.placeOrMerge(gamePiece, this.myDeck == null ? this.getPosition() : this.myDeck.getPosition());
    }

    @Override
    protected Stack initializeContents() {
        Stack stack = super.initializeContents();
        this.myDeck = new Deck(this.getDeckType());
        this.myDeck.setPropertySource(this.source);
        Iterator<GamePiece> iterator = stack.getPiecesIterator();
        while (iterator.hasNext()) {
            this.myDeck.add(iterator.next());
        }
        this.myDeck.setFaceDown(!NEVER.equals(this.dummy.getFaceDownOption()));
        return this.myDeck;
    }

    public void setDeck(Deck deck) {
        this.myDeck = deck;
    }

    public Deck getDeck() {
        return this.myDeck;
    }

    @Override
    protected boolean placeNonStackingSeparately() {
        return false;
    }

    protected String getDeckType() {
        return this.dummy.getType();
    }

    public Dimension getSize() {
        return this.dummy.getSize();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Deck.htm");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DrawPile.deck");
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(SELECT_DISPLAY_PROPERTY, false);
        componentI18nData.setAttributeTranslatable(SELECT_SORT_PROPERTY, false);
        return componentI18nData;
    }

    @Override
    public Object getProperty(Object object) {
        if (this.source != null) {
            return this.source.getProperty(object);
        }
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (this.source != null) {
            return this.source.getLocalizedProperty(object);
        }
        return null;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getConfigureName() + "_numPieces");
        for (String string : this.dummy.getCountExpressions()) {
            arrayList.add(this.getConfigureName() + "_" + new Deck.CountExpression(string).getName());
        }
        return arrayList;
    }

    public static class PiecePropertyConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new GamePieceFormattedStringConfigurer(string, string2);
        }
    }

    public static class FormattedStringConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{DrawPile.DECK_NAME, DrawPile.COMMAND_NAME});
        }
    }

    public static class AssignedDeckPrompt
    extends StringEnum {
        public static final String NONE = "<none>";

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(NONE);
            for (GameComponent gameComponent : GameModule.getGameModule().getGameState().getGameComponents()) {
                if (!(gameComponent instanceof Map)) continue;
                for (DrawPile drawPile : ((Map)gameComponent).getComponentsOf(DrawPile.class)) {
                    if (drawPile.getConfigureName() == null) continue;
                    arrayList.add(drawPile.getConfigureName());
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{DrawPile.ALWAYS, DrawPile.NEVER, DrawPile.USE_MENU};
        }
    }
}

