/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.io.IOUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleExtension
extends AbstractBuildable
implements GameComponent,
PluginsLoader.PluginElement,
GpIdSupport {
    private static final Logger logger = LoggerFactory.getLogger(ModuleExtension.class);
    public static final String BASE_MODULE_NAME = "module";
    public static final String BASE_MODULE_VERSION = "moduleVersion";
    public static final String VERSION = "version";
    public static final String VASSAL_VERSION_CREATED = "vassalVersion";
    public static final String UNIVERSAL = "anyModule";
    public static final String NEXT_PIECESLOT_ID = "nextPieceSlotId";
    public static final String EXTENSION_ID = "extensionId";
    public static final String DESCRIPTION = "description";
    private DataArchive archive;
    private String version = "0.0";
    protected boolean universal = false;
    private String lastSave;
    private String vassalVersionCreated;
    private AbstractAction editAction;
    protected int nextGpId = 0;
    protected String extensionId = "";
    protected JTextField idDisplay;
    protected String description = "";

    public ModuleExtension(DataArchive dataArchive) {
        this.archive = dataArchive;
    }

    public String getVersion() {
        return this.version;
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getUniversal() {
        return this.universal;
    }

    public void build() {
        Object object;
        GameModule.getGameModule().getDataArchive().addExtension(this.archive);
        GameModule.getGameModule().setGpIdSupport(this);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.archive.getInputStream("buildFile"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bufferedInputStream == null) {
            this.build(null);
        } else {
            try {
                object = Builder.createDocument(bufferedInputStream);
                this.build(object.getDocumentElement());
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                throw new ExtensionsLoader.LoadExtensionException(iOException);
            }
            finally {
                IOUtils.closeQuietly((InputStream)bufferedInputStream);
            }
        }
        GameModule.getGameModule().add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        if (this.archive instanceof ArchiveWriter) {
            this.lastSave = this.buildString();
            if (this.extensionId.length() == 0) {
                object = UUID.randomUUID().toString();
                this.extensionId = ((String)object).substring(((String)object).length() - 3);
            }
            object = new GpIdChecker(this);
            for (Buildable buildable : this.getBuildables()) {
                this.checkGpIds(buildable, (GpIdChecker)object);
            }
            ((GpIdChecker)object).fixErrors();
        }
    }

    protected void checkGpIds(Buildable buildable, GpIdChecker gpIdChecker) {
        if (buildable instanceof PieceSlot) {
            gpIdChecker.add((PieceSlot)buildable);
        } else if (buildable instanceof ExtensionElement) {
            this.checkGpIds(((ExtensionElement)buildable).getExtension(), gpIdChecker);
        } else if (buildable instanceof AbstractBuildable) {
            for (Buildable buildable2 : ((AbstractBuildable)buildable).getBuildables()) {
                this.checkGpIds(buildable2, gpIdChecker);
            }
        }
    }

    protected void updateGpIds() {
        for (Buildable buildable : this.getBuildables()) {
            this.updateGpIds(buildable);
        }
    }

    protected void updateGpIds(Buildable buildable) {
        if (buildable instanceof PieceSlot) {
            ((PieceSlot)buildable).updateGpId();
        } else if (buildable instanceof ExtensionElement) {
            this.updateGpIds(((ExtensionElement)buildable).getExtension());
        } else if (buildable instanceof AbstractBuildable) {
            for (Buildable buildable2 : ((AbstractBuildable)buildable).getBuildables()) {
                this.updateGpIds(buildable2);
            }
        }
    }

    @Override
    public int getNextGpId() {
        return this.nextGpId;
    }

    @Override
    public void setNextGpId(int n) {
        this.nextGpId = n;
    }

    @Override
    public Command getRestoreCommand() {
        return new RegCmd(this.getName(), this.version);
    }

    @Override
    public void setup(boolean bl) {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{UNIVERSAL, VERSION, DESCRIPTION, BASE_MODULE_NAME, BASE_MODULE_VERSION, VASSAL_VERSION_CREATED, NEXT_PIECESLOT_ID, EXTENSION_ID};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public void removeFrom(Buildable buildable) {
        throw new IllegalBuildException(Resources.getString("ModuleExtension.cannot_remove"));
    }

    public boolean confirmExit() {
        boolean bl = true;
        if (this.archive instanceof ArchiveWriter && !this.buildString().equals(this.lastSave)) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("ModuleExtension.save_extension"), "", 1)) {
                case 0: {
                    try {
                        this.save();
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                    break;
                }
                case 2: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public String getAttributeValueString(String string) {
        String string2 = null;
        if (BASE_MODULE_NAME.equals(string)) {
            string2 = GameModule.getGameModule().getGameName();
        } else if (BASE_MODULE_VERSION.equals(string)) {
            string2 = GameModule.getGameModule().getGameVersion();
        } else if (VERSION.equals(string)) {
            string2 = this.version;
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            string2 = this.vassalVersionCreated;
        } else if (UNIVERSAL.equals(string)) {
            string2 = String.valueOf(this.universal);
        } else if (NEXT_PIECESLOT_ID.equals(string)) {
            string2 = String.valueOf(this.nextGpId);
        } else if (EXTENSION_ID.equals(string)) {
            string2 = this.extensionId;
        } else if (DESCRIPTION.equals(string)) {
            string2 = this.description;
        }
        return string2;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (BASE_MODULE_NAME.equals(string)) {
            if (!this.universal && !GameModule.getGameModule().getGameName().equals(object)) {
                throw new ExtensionsLoader.LoadExtensionException(Resources.getString("ModuleExtension.extension_built", this.getName(), (String)object));
            }
        } else if (BASE_MODULE_VERSION.equals(string)) {
            String string2 = (String)object;
            if (!this.universal && Info.compareVersions(GameModule.getGameModule().getGameVersion(), string2) < 0) {
                GameModule.getGameModule().warn(Resources.getString("ModuleExtension.wrong_module_version", this.getName(), string2, GameModule.getGameModule().getGameVersion(), GameModule.getGameModule().getGameName()));
            }
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            this.vassalVersionCreated = (String)object;
            String string3 = Info.getVersion();
            if (Info.compareVersions(this.vassalVersionCreated, string3) > 0) {
                GameModule.getGameModule().warn(Resources.getString("ModuleExtension.wrong_vassal_version", this.getName(), (String)object, string3));
            }
        } else if (VERSION.equals(string)) {
            this.version = (String)object;
        } else if (UNIVERSAL.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.universal = (Boolean)object;
        } else if (NEXT_PIECESLOT_ID.equals(string)) {
            try {
                this.nextGpId = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (EXTENSION_ID.equals(string)) {
            this.extensionId = (String)object;
        } else if (DESCRIPTION.equals(string)) {
            this.description = (String)object;
        }
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String generateGpId() {
        return this.extensionId + ":" + this.nextGpId++;
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    public String getName() {
        String string = "Extension";
        if (this.archive != null) {
            string = this.archive.getName();
            int n = string.lastIndexOf(File.separatorChar);
            if (n < string.length()) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(46)) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public String buildString() {
        Document document = Builder.createNewDocument();
        document.appendChild(this.getBuildElement(document));
        return Builder.toString(document);
    }

    protected void write(boolean bl) throws IOException {
        String string;
        this.vassalVersionCreated = Info.getVersion();
        if (this.archive instanceof ArchiveWriter) {
            ArchiveWriter archiveWriter = (ArchiveWriter)this.archive;
            try {
                new ExtensionMetaData(this).save(archiveWriter);
            }
            catch (IOException iOException) {
                logger.error("", (Throwable)iOException);
            }
            string = this.buildString();
            archiveWriter.addFile("buildFile", new ByteArrayInputStream(string.getBytes("UTF-8")));
            if (bl) {
                archiveWriter.saveAs(true);
            } else {
                archiveWriter.save(true);
            }
        } else {
            throw new IOException("Read-only extension");
        }
        this.lastSave = string;
    }

    public void save() throws IOException {
        this.write(false);
    }

    public void saveAs() throws IOException {
        this.write(true);
    }

    public void remove(ExtensionElement extensionElement) {
        this.buildComponents.remove(extensionElement);
    }

    public Action getEditAction(final JDialog jDialog) {
        if (this.editAction == null) {
            jDialog.setName(this.getName());
            final StringConfigurer stringConfigurer = new StringConfigurer(VERSION, "Version:  ", this.version);
            jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
            jDialog.add(stringConfigurer.getControls());
            final StringConfigurer stringConfigurer2 = new StringConfigurer(DESCRIPTION, "Description:  ", this.description);
            jDialog.add(stringConfigurer2.getControls());
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Extension Id: "));
            this.idDisplay = new JTextField(12);
            this.idDisplay.setText(this.extensionId);
            this.idDisplay.setEditable(false);
            box.add(this.idDisplay);
            JButton jButton = new JButton("Change");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)JOptionPane.showInputDialog(GameModule.getGameModule().getFrame(), "Are you sure you wish to change the Extension Id?\n\nThe Extension Id links counters in existing save\ngames to the counter definitions in this Extension.\n\nIf you change the Id, then the Saved Game Updater\nmay not be able to update the counters from existing\nSaved Games.\n\nNew Extension Id:", "", 2, null, null, ModuleExtension.this.getExtensionId());
                    if (string != null && !string.equals(ModuleExtension.this.getExtensionId())) {
                        ModuleExtension.this.extensionId = string;
                        ModuleExtension.this.updateGpIds();
                        ModuleExtension.this.idDisplay.setText(ModuleExtension.this.getExtensionId());
                    }
                }
            });
            box.add(jButton);
            jDialog.add(box);
            final BooleanConfigurer booleanConfigurer = new BooleanConfigurer(UNIVERSAL, "Allow loading with any module?", this.universal);
            jDialog.add(booleanConfigurer.getControls());
            Box box2 = Box.createHorizontalBox();
            JButton jButton2 = new JButton("Save");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ModuleExtension.this.setAttribute(ModuleExtension.VERSION, stringConfigurer.getValue());
                    ModuleExtension.this.setAttribute(ModuleExtension.DESCRIPTION, stringConfigurer2.getValue());
                    ModuleExtension.this.setAttribute(ModuleExtension.UNIVERSAL, booleanConfigurer.getValue());
                    jDialog.dispose();
                }
            });
            box2.add(jButton2);
            JButton jButton3 = new JButton("Cancel");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            box2.add(jButton3);
            jDialog.add(box2);
            jDialog.pack();
            jDialog.setLocationRelativeTo(jDialog.getParent());
            this.editAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(true);
                }
            };
            URL uRL = this.getClass().getResource("/images/Edit16.gif");
            if (uRL != null) {
                this.editAction.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.editAction.putValue("Name", "Edit");
            }
            this.editAction.putValue("ShortDescription", "Extension Properties");
        }
        return this.editAction;
    }

    public static class RegCmd
    extends Command {
        private String name;
        private String version;

        public RegCmd(String string, String string2) {
            this.name = string;
            this.version = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        protected void executeCommand() {
            boolean bl = false;
            for (ModuleExtension moduleExtension : GameModule.getGameModule().getComponentsOf(ModuleExtension.class)) {
                if (!moduleExtension.getName().equals(this.name)) continue;
                bl = true;
                if (Info.compareVersions(moduleExtension.getVersion(), this.version) <= 0) break;
                GameModule.getGameModule().warn(this.getVersionErrorMsg(moduleExtension.getVersion()));
                break;
            }
            if (!bl) {
                GameModule.getGameModule().warn(this.getNotLoadedMsg());
            }
        }

        protected String getVersionErrorMsg(String string) {
            return Resources.getString("ModuleExtension.wrong_extension_version", this.version, this.name, string);
        }

        protected String getNotLoadedMsg() {
            return Resources.getString("ModuleExtension.load_extension", this.name, new ExtensionsManager(GameModule.getGameModule()).getExtensionsDirectory(false));
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

