/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.AbstractPatternPanel;
import org.jdesktop.swingx.search.Searchable;

public class JXFindPanel
extends AbstractPatternPanel {
    public static final String FIND_NEXT_ACTION_COMMAND = "findNext";
    public static final String FIND_PREVIOUS_ACTION_COMMAND = "findPrevious";
    protected Searchable searchable;
    protected JCheckBox wrapCheck;
    protected JCheckBox backCheck;
    private boolean initialized;

    public JXFindPanel() {
        this((Searchable)null);
    }

    public JXFindPanel(Searchable searchable) {
        this.setName(this.getUIString("searchTitle"));
        this.setSearchable(searchable);
        this.initActions();
    }

    public void setSearchable(Searchable searchable) {
        if (this.searchable != null && this.searchable.equals(searchable)) {
            return;
        }
        Searchable old = this.searchable;
        if (old != null) {
            old.search((Pattern)null);
        }
        this.searchable = searchable;
        this.getPatternModel().setFoundIndex(-1);
        this.firePropertyChange("searchable", old, this.searchable);
    }

    public void addNotify() {
        this.init();
        super.addNotify();
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initComponents();
        this.build();
        this.bind();
    }

    protected void bind() {
        super.bind();
        this.getActionContainerFactory().configureButton(this.wrapCheck, this.getAction("wrapSearch"), null);
        this.getActionContainerFactory().configureButton(this.backCheck, this.getAction("backwardsSearch"), null);
    }

    protected void refreshEmptyFromModel() {
        super.refreshEmptyFromModel();
        boolean enabled = !this.getPatternModel().isEmpty();
        this.getAction(FIND_NEXT_ACTION_COMMAND).setEnabled(enabled);
        this.getAction(FIND_PREVIOUS_ACTION_COMMAND).setEnabled(enabled);
    }

    public void match() {
        this.doFind();
    }

    public void findNext() {
        this.getPatternModel().setBackwards(false);
        this.doFind();
    }

    public void findPrevious() {
        this.getPatternModel().setBackwards(true);
        this.doFind();
    }

    protected void doFind() {
        boolean notFound;
        if (this.searchable == null) {
            return;
        }
        int foundIndex = this.doSearch();
        boolean bl = notFound = foundIndex == -1 && !this.getPatternModel().isEmpty();
        if (notFound && this.getPatternModel().isWrapping()) {
            boolean bl2 = notFound = this.doSearch() == -1;
        }
        if (notFound) {
            this.showNotFoundMessage();
        } else {
            this.showFoundMessage();
        }
    }

    protected int doSearch() {
        int foundIndex = this.searchable.search(this.getPatternModel().getPattern(), this.getPatternModel().getFoundIndex(), this.getPatternModel().isBackwards());
        this.getPatternModel().setFoundIndex(foundIndex);
        return this.getPatternModel().getFoundIndex();
    }

    protected void showFoundMessage() {
    }

    protected void showNotFoundMessage() {
        JOptionPane.showMessageDialog(this, "Value not found");
    }

    protected void updateLocaleState(Locale locale) {
        super.updateLocaleState(locale);
        this.setName(this.getUIString("searchTitle", locale));
    }

    protected void initExecutables() {
        this.getActionMap().put(FIND_NEXT_ACTION_COMMAND, this.createBoundAction(FIND_NEXT_ACTION_COMMAND, FIND_NEXT_ACTION_COMMAND));
        this.getActionMap().put(FIND_PREVIOUS_ACTION_COMMAND, this.createBoundAction(FIND_PREVIOUS_ACTION_COMMAND, FIND_PREVIOUS_ACTION_COMMAND));
        super.initExecutables();
    }

    protected void initComponents() {
        super.initComponents();
        this.wrapCheck = new JCheckBox();
        this.backCheck = new JCheckBox();
    }

    protected void build() {
        Box lBox = new Box(2);
        lBox.add(this.searchLabel);
        lBox.add(new JLabel(":"));
        lBox.add(new JLabel("  "));
        lBox.setAlignmentY(0.0f);
        Box rBox = new Box(3);
        rBox.add(this.searchField);
        rBox.add(this.matchCheck);
        rBox.add(this.wrapCheck);
        rBox.add(this.backCheck);
        rBox.setAlignmentY(0.0f);
        this.setLayout(new BoxLayout(this, 2));
        this.add(lBox);
        this.add(rBox);
    }
}

