/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractParent;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.Functor;
import VASSAL.tools.menu.SeparatorProxy;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuProxy
extends AbstractParent<JMenu> {
    private String text;
    private char mnemonic = '\u0000';

    public MenuProxy() {
    }

    public MenuProxy(String string) {
        this.text = string;
    }

    public SeparatorProxy addSeparator() {
        SeparatorProxy separatorProxy = new SeparatorProxy();
        this.add(separatorProxy);
        return separatorProxy;
    }

    public SeparatorProxy insertSeparator(int n) {
        SeparatorProxy separatorProxy = new SeparatorProxy();
        this.insert(separatorProxy, n);
        return separatorProxy;
    }

    public String getText() {
        return this.text;
    }

    public void setText(final String string) {
        this.text = string;
        this.forEachPeer(new Functor<JMenu>(){

            @Override
            public void apply(JMenu jMenu) {
                jMenu.setText(string);
            }
        });
    }

    @Override
    public JMenu createPeer() {
        JMenu jMenu = new JMenu(this.text);
        if (this.mnemonic != '\u0000') {
            jMenu.setMnemonic(this.mnemonic);
        }
        for (ChildProxy childProxy : this.children) {
            Object t = childProxy.createPeer();
            if (t == null) continue;
            jMenu.add((Component)t);
        }
        this.peers.add(new WeakReference<JMenu>(jMenu, this.queue));
        return jMenu;
    }

    public void setMnemonic(final char c) {
        this.mnemonic = c;
        this.forEachPeer(new Functor<JMenu>(){

            @Override
            public void apply(JMenu jMenu) {
                jMenu.setMnemonic(c);
            }
        });
    }
}

