/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.opcache.Op;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateScaleOpBitmapImpl
extends AbstractTileOpImpl
implements RotateScaleOp {
    private final ImageOp sop;
    private final double scale;
    private final double angle;
    private final RenderingHints hints;
    private final int hash;

    public RotateScaleOpBitmapImpl(ImageOp imageOp, double d, double d2) {
        this(imageOp, d, d2, ImageUtils.getDefaultHints());
    }

    public RotateScaleOpBitmapImpl(ImageOp imageOp, double d, double d2, RenderingHints renderingHints) {
        if (imageOp == null) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("scale = " + d2);
        }
        this.sop = imageOp;
        this.angle = d;
        this.scale = d2;
        this.hints = renderingHints;
        this.hash = new HashCodeBuilder().append((Object)imageOp).append(d2).append(d).append((Object)renderingHints).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        return ImageUtils.transform(this.sop.getImage(null), this.scale, this.angle, this.hints);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, this.angle).getSize();
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RotateScaleOpBitmapImpl rotateScaleOpBitmapImpl = (RotateScaleOpBitmapImpl)object;
        return this.scale == rotateScaleOpBitmapImpl.getScale() && this.angle == rotateScaleOpBitmapImpl.getAngle() && this.hints.equals(rotateScaleOpBitmapImpl.getHints()) && this.sop.equals(rotateScaleOpBitmapImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

