/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.HybridClient;
import VASSAL.chat.Room;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.LockableRoomControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class LockableJabberRoomControls
extends LockableRoomControls {
    protected ActionListener extendedRoomCreator;

    public void initializeControls(ChatServerControls chatServerControls) {
        super.initializeControls(chatServerControls);
        this.extendedRoomCreator = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LockableJabberRoomControls.this.client.isConnected()) {
                    String string;
                    Properties properties = JabberRoom.configureNewRoom();
                    if (properties != null && (string = properties.getProperty("name")).length() > 0) {
                        LockableJabberRoomControls.this.createRoom(properties);
                    }
                } else {
                    GameModule.getGameModule().warn(Resources.getString("Chat.must_connect"));
                }
            }
        };
        chatServerControls.addExtendedNewRoomHandler(this.extendedRoomCreator);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        super.uninitializeControls(chatServerControls);
        chatServerControls.removeExtendedNewRoomHandler(this.extendedRoomCreator);
    }

    public LockableJabberRoomControls(JabberClient jabberClient) {
        super(jabberClient);
    }

    protected void addLockRoomAction(JPopupMenu jPopupMenu, Room room) {
        JabberClient jabberClient = this.getJabberClient();
        if (jabberClient != null) {
            jPopupMenu.add(new LockRoomAction((JabberRoom)room, jabberClient));
        }
    }

    public JPopupMenu buildPopupForRoom(Room room, JTree jTree) {
        JPopupMenu jPopupMenu = super.buildPopupForRoom(room, jTree);
        jPopupMenu.add(new RoomPropertiesAction((JabberRoom)room));
        return jPopupMenu;
    }

    private JabberClient getJabberClient() {
        JabberClient jabberClient = null;
        if (this.client instanceof JabberClient) {
            jabberClient = (JabberClient)this.client;
        } else if (this.client instanceof HybridClient && ((HybridClient)this.client).getDelegate() instanceof JabberClient) {
            jabberClient = (JabberClient)((HybridClient)this.client).getDelegate();
        }
        return jabberClient;
    }

    protected void createRoom(Properties properties) {
        JabberRoom jabberRoom = ((JabberClient)this.client).getRoomByName(properties.getProperty("name"));
        jabberRoom.setConfig(properties);
        this.client.setRoom(jabberRoom);
    }

    protected void createRoom(String string) {
        if (this.client.isConnected()) {
            if (string != null && string.length() > 0) {
                JabberRoom jabberRoom = ((JabberClient)this.client).getRoomByName(string);
                this.client.setRoom(jabberRoom);
            }
        } else {
            GameModule.getGameModule().warn(Resources.getString("Chat.must_connect"));
        }
    }

    class RoomPropertiesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JabberRoom target;

        public RoomPropertiesAction(JabberRoom jabberRoom) {
            super(Resources.getString("General.properties"));
            this.target = jabberRoom;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.target.showConfig();
        }
    }

    class LockRoomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JabberClient client;
        private JabberRoom target;

        public LockRoomAction(JabberRoom jabberRoom, JabberClient jabberClient) {
            super(jabberRoom.isLocked() ? Resources.getString("Chat.unlock_room") : Resources.getString("Chat.lock_room"));
            this.setEnabled(jabberRoom.isOwnedByMe() && !jabberRoom.getName().equals(jabberClient.getDefaultRoomName()));
            this.target = jabberRoom;
            this.client = jabberClient;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.client.lockRoom(this.target);
        }
    }
}

