/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.SynchCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;

public class SynchEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "SYNC";
    private PlayerEncoder playerEncoder;
    private ChatServerConnection client;

    public SynchEncoder(PlayerEncoder playerEncoder, ChatServerConnection chatServerConnection) {
        this.playerEncoder = playerEncoder;
        this.client = chatServerConnection;
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_PREFIX)) {
            Player player = this.playerEncoder.stringToPlayer(string.substring(COMMAND_PREFIX.length()));
            return new SynchCommand(player, this.client);
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof SynchCommand) {
            SynchCommand synchCommand = (SynchCommand)command;
            return COMMAND_PREFIX + this.playerEncoder.playerToString(synchCommand.getPlayer());
        }
        return null;
    }
}

