/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.Buildable;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.counters.Labeler;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.ScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HexGridNumbering
extends RegularGridNumbering {
    private static final Logger logger = LoggerFactory.getLogger(HexGridNumbering.class);
    private HexGrid grid;
    private boolean stagger = true;
    public static final String STAGGER = "stagger";

    @Override
    public void addTo(Buildable buildable) {
        this.grid = (HexGrid)buildable;
        this.grid.setGridNumbering(this);
    }

    public HexGrid getGrid() {
        return this.grid;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return ArrayUtils.append(super.getAttributeDescriptions(), "Odd-numbered rows numbered higher?");
    }

    @Override
    public String[] getAttributeNames() {
        return ArrayUtils.append(super.getAttributeNames(), STAGGER);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return ArrayUtils.append(super.getAttributeTypes(), Boolean.class);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (STAGGER.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.stagger = (Boolean)object;
        } else {
            super.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (STAGGER.equals(string)) {
            return String.valueOf(this.stagger);
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        Cloneable cloneable;
        int n = (int)(d * (double)this.fontSize + 0.5);
        if (n < 5) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (bl) {
            cloneable = AffineTransform.getRotateInstance(Math.PI, (double)rectangle.x + 0.5 * (double)rectangle.width, (double)rectangle.y + 0.5 * (double)rectangle.height);
            graphics2D.transform((AffineTransform)cloneable);
            rectangle2 = ((AffineTransform)cloneable).createTransformedShape(rectangle2).getBounds();
        }
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        cloneable = rectangle.intersection(rectangle2);
        Shape shape = graphics.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area((Shape)((Object)cloneable)));
            graphics.setClip(area);
        }
        double d2 = d * this.grid.getHexWidth();
        double d3 = d * this.grid.getHexSize();
        if (this.grid.isSideways()) {
            rectangle = new Rectangle(rectangle.y, rectangle.x, rectangle.height, rectangle.width);
            cloneable = new Rectangle(((Rectangle)cloneable).y, ((Rectangle)cloneable).x, ((Rectangle)cloneable).height, ((Rectangle)cloneable).width);
        }
        int n2 = 2 * (int)Math.floor(((double)(((Rectangle)cloneable).x - rectangle.x) - d * (double)this.grid.getOrigin().x) / (2.0 * d2));
        double d4 = (double)rectangle.x + d * (double)this.grid.getOrigin().x + d2 * (double)n2;
        double d5 = (double)(((Rectangle)cloneable).x + ((Rectangle)cloneable).width) + d2;
        int n3 = (int)Math.floor(((double)(((Rectangle)cloneable).y - rectangle.y) - d * (double)this.grid.getOrigin().y) / d3);
        double d6 = (double)rectangle.y + d * (double)this.grid.getOrigin().y + d3 * (double)n3;
        double d7 = (double)(((Rectangle)cloneable).y + ((Rectangle)cloneable).height) + d3;
        Font font = new Font("Dialog", 0, n);
        Point point = new Point();
        int n4 = 3;
        int n5 = -((int)Math.round(d3 / 2.0));
        if (this.grid.isSideways() || this.rotateTextDegrees != 0) {
            n4 = 0;
            n5 = 0;
        }
        Point point2 = new Point();
        Point point3 = null;
        double d8 = 0.0;
        if (this.rotateTextDegrees != 0) {
            d8 = Math.toRadians(this.rotateTextDegrees);
            graphics2D.rotate(d8);
        }
        for (double d9 = d4; d9 < d5; d9 += 2.0 * d2) {
            for (double d10 = d6; d10 < d7; d10 += d3) {
                point.setLocation((int)Math.round(d9), (int)Math.round(d10) + n5);
                point2 = new Point(point.x, point.y - n5);
                this.grid.rotateIfSideways(point);
                point2.translate(-rectangle.x, -rectangle.y);
                this.grid.rotateIfSideways(point2);
                point2.x = (int)Math.round((double)point2.x / d);
                point2.y = (int)Math.round((double)point2.y / d);
                point3 = this.offsetLabelCenter(point, d);
                Labeler.drawLabel(graphics2D, this.getName(this.getRow(point2), this.getColumn(point2)), point3.x, point3.y, font, 0, n4, this.color, null, null);
                point.setLocation((int)Math.round(d9 + d2), (int)Math.round(d10 + d3 / 2.0) + n5);
                point2 = new Point(point.x, point.y - n5);
                this.grid.rotateIfSideways(point);
                point2.translate(-rectangle.x, -rectangle.y);
                this.grid.rotateIfSideways(point2);
                point2.x = (int)Math.round((double)point2.x / d);
                point2.y = (int)Math.round((double)point2.y / d);
                point3 = this.offsetLabelCenter(point, d);
                Labeler.drawLabel(graphics2D, this.getName(this.getRow(point2), this.getColumn(point2)), point3.x, point3.y, font, 0, n4, this.color, null, null);
            }
        }
        if (this.rotateTextDegrees != 0) {
            graphics2D.rotate(-d8);
        }
        graphics.setClip(shape);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public Point getCenterPoint(int n, int n2) {
        if (this.stagger) {
            if (this.grid.isSideways()) {
                if (n % 2 != 0) {
                    n2 = this.hDescending ? ++n2 : --n2;
                }
            } else if (n % 2 != 0) {
                n2 = this.vDescending ? ++n2 : --n2;
            }
        }
        if (this.grid.isSideways()) {
            if (this.vDescending) {
                n = this.getMaxRows() - n;
            }
            if (this.hDescending) {
                n2 = this.getMaxColumns() - n2;
            }
        } else {
            if (this.hDescending) {
                n = this.getMaxColumns() - n;
            }
            if (this.vDescending) {
                n2 = this.getMaxRows() - n2;
            }
        }
        Point point = new Point();
        point.x = (int)((double)n * this.grid.getHexWidth());
        point.x += this.grid.getOrigin().x;
        point.y = n % 2 == 0 ? (int)((double)n2 * this.grid.getHexSize()) : (int)((double)n2 * this.grid.getHexSize() + this.grid.getHexSize() / 2.0);
        point.y += this.grid.getOrigin().y;
        this.grid.rotateIfSideways(point);
        return point;
    }

    @Override
    public int getColumn(Point point) {
        int n = this.getRawColumn(point);
        if (this.vDescending && this.grid.isSideways()) {
            n = this.getMaxRows() - n;
        }
        if (this.hDescending && !this.grid.isSideways()) {
            n = this.getMaxColumns() - n;
        }
        return n;
    }

    public int getRawColumn(Point point) {
        point = new Point(point);
        this.grid.rotateIfSideways(point);
        int n = point.x - this.grid.getOrigin().x;
        n = (int)Math.floor((double)n / this.grid.getHexWidth() + 0.5);
        return n;
    }

    @Override
    protected JComponent getGridVisualizer() {
        if (this.visualizer == null) {
            this.visualizer = new JPanel(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    HexGridNumbering.this.grid.forceDraw(graphics, rectangle, rectangle, 1.0, false);
                    HexGridNumbering.this.forceDraw(graphics, rectangle, rectangle, 1.0, false);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(4 * (int)HexGridNumbering.this.grid.getHexSize(), 4 * (int)HexGridNumbering.this.grid.getHexWidth());
                }
            };
        }
        return this.visualizer;
    }

    @Override
    public int getRow(Point point) {
        int n = this.getRawRow(point);
        if (this.vDescending && !this.grid.isSideways()) {
            n = this.getMaxRows() - n;
        }
        if (this.hDescending && this.grid.isSideways()) {
            n = this.getMaxColumns() - n;
        }
        if (this.stagger) {
            if (this.grid.isSideways()) {
                if (this.getRawColumn(point) % 2 != 0) {
                    n = this.hDescending ? --n : ++n;
                }
            } else if (this.getRawColumn(point) % 2 != 0) {
                n = this.vDescending ? --n : ++n;
            }
        }
        return n;
    }

    protected int getRawRow(Point point) {
        point = new Point(point);
        this.grid.rotateIfSideways(point);
        Point point2 = this.grid.getOrigin();
        double d = this.grid.getHexWidth();
        double d2 = this.grid.getHexSize();
        int n = (int)Math.round((double)(point.x - point2.x) / d);
        int n2 = n % 2 == 0 ? (int)Math.round((double)(point.y - point2.y) / d2) : (int)Math.round(((double)(point.y - point2.y) - d2 / 2.0) / d2);
        return n2;
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.grid.setGridNumbering(null);
    }

    protected int getMaxRows() {
        return (int)Math.floor((double)this.grid.getContainer().getSize().height / this.grid.getHexWidth() + 0.5);
    }

    protected int getMaxColumns() {
        return (int)Math.floor((double)this.grid.getContainer().getSize().width / this.grid.getHexSize() + 0.5);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        class TestPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private boolean reversed;
            private double scale = 1.0;
            private HexGrid grid;
            private HexGridNumbering numbering;

            TestPanel() {
                this.setLayout(new BorderLayout());
                Box box = Box.createHorizontalBox();
                final JTextField jTextField = new JTextField("1.0");
                box.add(jTextField);
                jTextField.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        try {
                            scale = Double.parseDouble(jTextField.getText());
                            this.repaint();
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.error("", (Throwable)numberFormatException);
                        }
                    }
                });
                final JCheckBox jCheckBox = new JCheckBox("Reversed");
                jCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        reversed = jCheckBox.isSelected();
                        this.repaint();
                    }
                });
                box.add(jCheckBox);
                final JCheckBox jCheckBox2 = new JCheckBox("Sideways");
                jCheckBox2.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        grid.setAttribute("sideways", jCheckBox2.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                        this.repaint();
                    }
                });
                box.add(jCheckBox2);
                this.add("North", box);
                this.grid = new HexGrid();
                this.grid.setAttribute("color", Color.black);
                this.numbering = new HexGridNumbering();
                this.numbering.setAttribute("color", Color.black);
                this.numbering.addTo(this.grid);
                JPanel jPanel = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics graphics) {
                        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        grid.forceDraw(graphics, rectangle, this.getVisibleRect(), scale, reversed);
                        numbering.forceDraw(graphics, this.getBounds(), this.getVisibleRect(), scale, reversed);
                    }
                };
                Dimension dimension = new Dimension(4000, 4000);
                jPanel.setPreferredSize(dimension);
                this.add("Center", new ScrollPane(jPanel));
            }
        }
        jFrame.add(new TestPanel());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.height -= 100;
        dimension.width -= 100;
        jFrame.setSize(dimension);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }
}

