/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.counters.Deck;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceFinder;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenuDisplayer
extends MouseAdapter
implements Buildable {
    public static Font POPUP_MENU_FONT = new Font("Dialog", 0, 10);
    protected Map map;
    protected PieceFinder targetSelector;

    public void addTo(Buildable buildable) {
        this.targetSelector = this.createTargetSelector();
        this.map = (Map)buildable;
        this.map.addLocalMouseListener(this);
    }

    protected PieceFinder createTargetSelector() {
        return new PieceFinder.PieceInStack(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.getShape().contains(point2)) {
                    return deck;
                }
                return null;
            }
        };
    }

    public void add(Buildable buildable) {
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void build(Element element) {
    }

    public static JPopupMenu createPopup(GamePiece gamePiece) {
        return MenuDisplayer.createPopup(gamePiece, false);
    }

    public static JPopupMenu createPopup(GamePiece gamePiece, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        KeyCommand[] keyCommandArray = (KeyCommand[])gamePiece.getProperty("KeyCommands");
        if (keyCommandArray != null) {
            Object object;
            Object object2;
            Serializable serializable;
            Serializable serializable2;
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            ArrayList<KeyStroke> arrayList2 = new ArrayList<KeyStroke>();
            HashMap<KeyCommandSubMenu, JMenuItem> hashMap = new HashMap<KeyCommandSubMenu, JMenuItem>();
            HashMap<String, Serializable> hashMap2 = new HashMap<String, Serializable>();
            for (int i = 0; i < keyCommandArray.length; ++i) {
                keyCommandArray[i].setGlobal(bl);
                KeyStroke object3 = keyCommandArray[i].getKeyStroke();
                serializable2 = null;
                if (keyCommandArray[i] instanceof KeyCommandSubMenu) {
                    serializable = new JMenu(keyCommandArray[i].getLocalizedMenuText());
                    ((JComponent)serializable).setFont(POPUP_MENU_FONT);
                    hashMap.put((KeyCommandSubMenu)keyCommandArray[i], (JMenuItem)serializable);
                    serializable2 = serializable;
                    arrayList.add(serializable2);
                    arrayList2.add(KeyStroke.getKeyStroke('\u0000'));
                } else if (arrayList2.contains(object3)) {
                    serializable = (JMenuItem)arrayList.get(arrayList2.indexOf(object3));
                    object2 = ((AbstractButton)serializable).getAction();
                    if (object2 != null && ((object = (String)((AbstractButton)serializable).getAction().getValue("Name")) == null || ((String)object).length() < keyCommandArray[i].getName().length())) {
                        serializable2 = new JMenuItem(keyCommandArray[i].getLocalizedMenuText());
                        ((AbstractButton)serializable2).addActionListener(keyCommandArray[i]);
                        ((JComponent)serializable2).setFont(POPUP_MENU_FONT);
                        ((JMenuItem)serializable2).setEnabled(keyCommandArray[i].isEnabled());
                        arrayList.set(arrayList2.indexOf(object3), serializable2);
                    }
                } else {
                    arrayList2.add(object3 != null ? object3 : KeyStroke.getKeyStroke('\u0000'));
                    serializable2 = new JMenuItem(keyCommandArray[i].getLocalizedMenuText());
                    ((AbstractButton)serializable2).addActionListener(keyCommandArray[i]);
                    ((JComponent)serializable2).setFont(POPUP_MENU_FONT);
                    ((JMenuItem)serializable2).setEnabled(keyCommandArray[i].isEnabled());
                    arrayList.add(serializable2);
                }
                if (keyCommandArray[i].getName() == null || keyCommandArray[i].getName().length() <= 0 || serializable2 == null) continue;
                serializable = (ArrayList)hashMap2.get(keyCommandArray[i].getName());
                if (serializable == null) {
                    serializable = new ArrayList();
                    hashMap2.put(keyCommandArray[i].getName(), serializable);
                }
                ((ArrayList)serializable).add(serializable2);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                serializable2 = (KeyCommandSubMenu)entry.getKey();
                serializable = (JMenu)entry.getValue();
                object2 = ((KeyCommandSubMenu)serializable2).getCommands();
                while (object2.hasNext()) {
                    object = (ArrayList)hashMap2.get(object2.next());
                    if (object == null) continue;
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        JMenuItem jMenuItem = (JMenuItem)iterator.next();
                        ((JMenu)serializable).add(jMenuItem);
                        arrayList.remove(jMenuItem);
                    }
                }
            }
            for (JMenuItem jMenuItem : arrayList) {
                jPopupMenu.add(jMenuItem);
            }
        }
        return jPopupMenu;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        EventFilter eventFilter;
        GamePiece gamePiece;
        if (mouseEvent.isMetaDown() && (gamePiece = this.map.findPiece(mouseEvent.getPoint(), this.targetSelector)) != null && ((eventFilter = (EventFilter)gamePiece.getProperty("selectEventFilter")) == null || !eventFilter.rejectEvent(mouseEvent))) {
            JPopupMenu jPopupMenu = MenuDisplayer.createPopup(gamePiece, true);
            Point point = this.map.componentCoordinates(mouseEvent.getPoint());
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    MenuDisplayer.this.map.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    MenuDisplayer.this.map.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            if (this.map.getView().isShowing()) {
                jPopupMenu.show(this.map.getView(), point.x, point.y);
            }
            mouseEvent.consume();
        }
    }
}

