/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontConfigurer;
import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontStyleConfigurer
extends Configurer {
    protected JPanel p;
    protected JPanel fontPanel;
    protected JComboBox fonts;

    public FontStyleConfigurer(String string, String string2) {
        super(string, string2);
    }

    public FontStyleConfigurer(String string, String string2, FontStyle fontStyle) {
        this(string, string2);
        this.setValue(fontStyle);
    }

    public FontStyleConfigurer(String string, String string2, String string3) {
        this(string, string2, FontManager.getFontManager().getFontStyle(string3));
    }

    public String getValueString() {
        return "";
    }

    public Font getValueFont() {
        return ((FontStyle)this.value).getFont();
    }

    public FontStyle getValueFontStyle() {
        return (FontStyle)this.value;
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.fontPanel = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.name));
            box.add(this.fontPanel);
            this.p.add(box);
        }
        this.buildFonts();
        return this.p;
    }

    protected void buildFonts() {
        if (this.fontPanel == null) {
            return;
        }
        if (this.fonts != null) {
            this.fontPanel.remove(this.fonts);
        }
        this.fonts = new JComboBox();
        String[] stringArray = FontManager.getFontManager().getFontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fonts.addItem(stringArray[i]);
        }
        this.fonts.setSelectedItem(this.value == null ? "Default" : ((FontStyle)this.value).getConfigureName());
        this.fontPanel.add(this.fonts);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontStyleConfigurer.this.updateValue();
            }
        };
        this.fonts.addItemListener(itemListener);
    }

    protected void updateValue() {
        this.setValue(FontManager.getFontManager().getFontStyle((String)this.fonts.getSelectedItem()));
    }

    public void setValue(String string) {
        this.setValue(FontManager.getFontManager().getFontStyle(string));
        this.buildFonts();
    }

    public static FontStyle decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        return new FontStyle(decoder.nextToken("Default"), FontConfigurer.decode(decoder.nextToken("")));
    }

    public static String encode(FontStyle fontStyle) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(fontStyle.getConfigureName(), '|');
        sequenceEncoder.append(FontConfigurer.encode(fontStyle.getFont()));
        return sequenceEncoder.getValue();
    }
}

