/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FontConfigurer
extends Configurer {
    protected JPanel p;
    protected IntConfigurer size;
    protected BooleanConfigurer bold;
    protected BooleanConfigurer italic;
    protected BooleanConfigurer outline;
    protected JComboBox family;
    protected JTextField demo;

    public FontConfigurer(String string, String string2) {
        super(string, string2);
    }

    public FontConfigurer(String string, String string2, OutlineFont outlineFont) {
        super(string, string2);
        this.setValue(outlineFont);
    }

    public FontConfigurer(String string, String string2, FontStyle fontStyle) {
        super(string, string2);
        this.setValue(fontStyle.font);
        this.setName(fontStyle.getConfigureName());
    }

    public String getValueString() {
        return FontConfigurer.encode((OutlineFont)this.value);
    }

    public void setValue(String string) {
        this.setValue(FontConfigurer.decode(string));
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Font Family:  "));
            this.family = new JComboBox();
            for (int i = 0; i < FontManager.ALLOWABLE_FONTS.length; ++i) {
                this.family.addItem(FontManager.ALLOWABLE_FONTS[i]);
            }
            this.family.setSelectedItem(this.value == null ? "SanSerif" : this.getFontValue().getFamily());
            box.add(this.family);
            this.p.add(box);
            this.size = new IntConfigurer(null, "Size:  ", (Integer)this.getFontValue().getSize());
            this.p.add(this.size.getControls());
            box = Box.createHorizontalBox();
            this.bold = new BooleanConfigurer(null, "Bold", this.isBold());
            box.add(this.bold.getControls());
            this.italic = new BooleanConfigurer(null, "Italic", this.isItalic());
            box.add(this.italic.getControls());
            this.outline = new BooleanConfigurer(null, "Outline", this.isOutline());
            box.add(this.outline.getControls());
            this.p.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Sample:  "));
            this.demo = new JTextField("The quick brown fox", 20);
            this.demo.setEditable(false);
            box.add(this.demo);
            this.p.add(box);
            this.updateValue();
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    FontConfigurer.this.updateValue();
                }
            };
            this.family.addItemListener(itemListener);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FontConfigurer.this.updateValue();
                }
            };
            this.size.addPropertyChangeListener(propertyChangeListener);
            this.bold.addPropertyChangeListener(propertyChangeListener);
            this.italic.addPropertyChangeListener(propertyChangeListener);
            this.outline.addPropertyChangeListener(propertyChangeListener);
        }
        return this.p;
    }

    protected void updateValue() {
        int n = 0 | (this.bold.booleanValue() != false ? 1 : 0) | (this.italic.booleanValue() != false ? 2 : 0);
        OutlineFont outlineFont = new OutlineFont((String)this.family.getSelectedItem(), n, Integer.parseInt(this.size.getValueString()), this.outline.booleanValue());
        this.setValue(outlineFont);
        this.demo.setFont(outlineFont);
        Window window = SwingUtilities.getWindowAncestor(this.getControls());
        if (window != null) {
            window.pack();
        }
    }

    protected OutlineFont getFontValue() {
        return (OutlineFont)this.getValue();
    }

    public static OutlineFont decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        return new OutlineFont(decoder.nextToken("Dialog"), decoder.nextInt(0), decoder.nextInt(10), decoder.nextBoolean(false));
    }

    public static String encode(OutlineFont outlineFont) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(outlineFont.getName(), ',');
        sequenceEncoder.append(outlineFont.getStyle());
        sequenceEncoder.append(outlineFont.getSize());
        sequenceEncoder.append(outlineFont.isOutline());
        return sequenceEncoder.getValue();
    }

    public boolean isBold() {
        return (this.getFontValue().getStyle() & 1) != 0;
    }

    public boolean isItalic() {
        return (this.getFontValue().getStyle() & 2) != 0;
    }

    public boolean isOutline() {
        return this.getFontValue().isOutline();
    }
}

