/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PlayerRoster;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ObscurableOptions
implements CommandEncoder,
GameComponent {
    private static final ObscurableOptions instance = new ObscurableOptions();
    public static final String COMMAND_ID = "UNMASK\t";
    public static final String PREFS_KEY = "OpponentUnmaskable";
    private List<String> allowed = new ArrayList<String>();
    private Boolean override;

    private ObscurableOptions() {
    }

    public ObscurableOptions(String string) {
        this();
        if (string != null && string.length() > 0) {
            this.decodeOptions(string);
        } else {
            this.decodeOptions(ObscurableOptions.getInstance().encodeOptions());
        }
    }

    public static ObscurableOptions getInstance() {
        return instance;
    }

    public void allowSome(String string) {
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(PREFS_KEY, string);
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        booleanConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    ObscurableOptions.getInstance().allow(GameModule.getUserId());
                    String string = PlayerRoster.getMySide();
                    if (string != null) {
                        ObscurableOptions.getInstance().allow(string);
                    }
                } else {
                    ObscurableOptions.getInstance().disallow(GameModule.getUserId());
                    String string = PlayerRoster.getMySide();
                    if (string != null) {
                        ObscurableOptions.getInstance().disallow(string);
                    }
                }
                GameModule.getGameModule().getServer().sendToOthers(new SetAllowed(instance.allowed));
            }
        });
        if (Boolean.TRUE.equals(booleanConfigurer.getValue())) {
            this.allow(GameModule.getUserId());
        } else {
            this.disallow(GameModule.getUserId());
        }
    }

    public void setPrompt(String string) {
        Configurer configurer = GameModule.getGameModule().getPrefs().getOption(PREFS_KEY);
        if (configurer != null) {
            configurer.setName(string);
        }
    }

    public void allowAll() {
        this.override = Boolean.TRUE;
    }

    public void allowNone() {
        this.override = Boolean.FALSE;
    }

    public void allow(String string) {
        if (!this.allowed.contains(string)) {
            this.allowed.add(string);
        }
    }

    public void disallow(String string) {
        this.allowed.remove(string);
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_ID)) {
            string = string.substring(COMMAND_ID.length());
            ArrayList<String> arrayList = new ArrayList<String>();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            while (decoder.hasMoreTokens()) {
                arrayList.add(decoder.nextToken());
            }
            return new SetAllowed(arrayList);
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof SetAllowed) {
            List<String> list = ((SetAllowed)command).getAllowedIds();
            if (list.isEmpty()) {
                return COMMAND_ID;
            }
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            for (String string : list) {
                sequenceEncoder.append(string);
            }
            return COMMAND_ID + sequenceEncoder.getValue();
        }
        return null;
    }

    public String encodeOptions() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        if (this.override == null) {
            sequenceEncoder.append("");
        } else {
            sequenceEncoder.append(this.override);
        }
        sequenceEncoder.append(this.allowed.size());
        for (String string : this.allowed) {
            sequenceEncoder.append(string);
        }
        return sequenceEncoder.getValue();
    }

    public void decodeOptions(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        String string2 = decoder.nextToken("");
        this.override = string2.length() == 0 ? null : Boolean.valueOf(string2.equals("true"));
        int n = decoder.nextInt(0);
        this.allowed.clear();
        for (int i = 0; i < n; ++i) {
            string2 = decoder.nextToken("");
            if (string2.length() <= 0) continue;
            this.allowed.add(string2);
        }
    }

    public Command getRestoreCommand() {
        return new SetAllowed(this.allowed);
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.allowed.clear();
        } else if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(PREFS_KEY))) {
            this.allow(GameModule.getUserId());
        }
    }

    public boolean isUnmaskable(String string) {
        return this.override != null ? this.override.booleanValue() : this.allowed.contains(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetAllowed
    extends Command {
        private List<String> allowed;

        public SetAllowed(List<String> list) {
            this.allowed = list;
        }

        @Deprecated
        public SetAllowed(Vector<String> vector) {
            this.allowed = vector;
        }

        public List<String> getAllowedIds() {
            return this.allowed;
        }

        @Override
        protected void executeCommand() {
            ObscurableOptions.getInstance().override = null;
            ObscurableOptions.getInstance().allowed = this.allowed;
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

