/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameRefresher
implements GameComponent {
    private static final Logger logger = LoggerFactory.getLogger(GameRefresher.class);
    private Action refreshAction;
    protected GpIdSupport gpIdSupport;
    protected GpIdChecker gpIdChecker;
    protected int updatedCount;
    protected int notFoundCount;
    protected int notOwnedCount;
    protected RefreshDialog dialog;
    protected boolean testMode;

    public GameRefresher(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
    }

    public void addTo(AbstractConfigurable abstractConfigurable) {
        this.refreshAction = new AbstractAction(Resources.getString("GameRefresher.refresh_counters")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                new GameRefresher(GameRefresher.this.gpIdSupport).start();
            }
        };
        this.refreshAction.setEnabled(false);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void start() {
        this.dialog = new RefreshDialog(this);
        this.dialog.setVisible(true);
        this.dialog = null;
    }

    public void execute(boolean bl, boolean bl2) {
        Object object;
        this.testMode = bl;
        GameModule gameModule = GameModule.getGameModule();
        this.updatedCount = 0;
        this.notFoundCount = 0;
        this.notOwnedCount = 0;
        this.gpIdChecker = new GpIdChecker(bl2);
        for (PieceSlot object32 : gameModule.getAllDescendantComponentsOf(PieceSlot.class)) {
            this.gpIdChecker.add(object32);
        }
        if (this.gpIdChecker.hasErrors()) {
            ErrorDialog.show("GameRefresher.no_gpids", new Object[0]);
            this.gpIdChecker = null;
            return;
        }
        NullCommand nullCommand = new NullCommand();
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        for (GamePiece gamePiece : gameModule.getGameState().getAllPieces()) {
            if (gamePiece instanceof Deck) {
                object = ((Stack)gamePiece).getPiecesInVisibleOrderIterator();
                while (object.hasNext()) {
                    arrayList.add(0, object.next());
                }
                continue;
            }
            if (gamePiece instanceof Stack) {
                object = ((Stack)gamePiece).getPiecesInVisibleOrderIterator();
                while (object.hasNext()) {
                    GamePiece gamePiece2 = object.next();
                    if (!Boolean.TRUE.equals(gamePiece2.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece2.getProperty("Obscured"))) {
                        arrayList.add(0, gamePiece2);
                        continue;
                    }
                    ++this.notOwnedCount;
                }
                continue;
            }
            if (gamePiece.getParent() != null) continue;
            if (!Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("Obscured"))) {
                arrayList.add(0, gamePiece);
                continue;
            }
            ++this.notOwnedCount;
        }
        for (GamePiece gamePiece : arrayList) {
            if (this.isTestMode()) {
                this.testGamePiece(gamePiece);
                continue;
            }
            this.processGamePiece(gamePiece, nullCommand);
        }
        if (this.isTestMode()) {
            this.dialog.addMessage(Resources.getString("GameRefresher.counters_refreshed_test", this.updatedCount));
            if (this.notOwnedCount > 0) {
                this.dialog.addMessage(Resources.getString("GameRefresher.counters_not_owned_test", this.notOwnedCount));
            }
            if (this.notFoundCount > 0) {
                this.dialog.addMessage(Resources.getString("GameRefresher.counters_not_found_test", this.notFoundCount));
            }
        } else {
            String string = GlobalOptions.getInstance().getPlayerId();
            Chatter chatter = gameModule.getChatter();
            object = new Chatter.DisplayText(chatter, "----------");
            ((Command)object).append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.run_refresh_counters", string)));
            ((Command)object).append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_refreshed", string, this.updatedCount)));
            if (this.notOwnedCount > 0) {
                ((Command)object).append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_not_owned", string, this.notOwnedCount)));
            }
            if (this.notFoundCount > 0) {
                ((Command)object).append(new Chatter.DisplayText(chatter, Resources.getString("GameRefresher.counters_not_found", string, this.notFoundCount)));
            }
            ((Command)object).append(new Chatter.DisplayText(chatter, "----------"));
            ((Command)object).execute();
            nullCommand.append((Command)object);
            gameModule.sendAndLog(nullCommand);
        }
        this.gpIdChecker = null;
    }

    private void processGamePiece(GamePiece gamePiece, Command command) {
        int n;
        Object object;
        int n2;
        Map map = gamePiece.getMap();
        if (map == null) {
            logger.error("Can't refresh piece " + gamePiece.getName() + ": No Map");
            return;
        }
        Point point = gamePiece.getPosition();
        GamePiece gamePiece2 = this.gpIdChecker.createUpdatedPiece(gamePiece);
        Stack stack = gamePiece.getParent();
        int n3 = n2 = stack == null ? 0 : stack.indexOf(gamePiece);
        if (gamePiece.equals(gamePiece2)) {
            ++this.notFoundCount;
            logger.error("Can't refresh piece " + gamePiece.getName() + ": Can't find matching Piece Slot");
        } else {
            ++this.updatedCount;
            if (!this.isTestMode()) {
                object = map.placeOrMerge(gamePiece2, point);
                command.append((Command)object);
                RemovePiece removePiece = new RemovePiece(Decorator.getOutermost(gamePiece));
                removePiece.execute();
                command.append(removePiece);
            }
        }
        if (!this.isTestMode() && (object = gamePiece2.getParent()) != null && stack != null && object == stack && (n = ((Stack)object).indexOf(gamePiece2)) >= 0 && n2 >= 0 && n != n2) {
            String string = ((Stack)object).getState();
            ((Stack)object).insert(gamePiece2, n2);
            command.append(new ChangePiece(((Stack)object).getId(), string, ((Stack)object).getState()));
        }
    }

    private void testGamePiece(GamePiece gamePiece) {
        Map map = gamePiece.getMap();
        if (map == null) {
            logger.error("Can't refresh piece " + gamePiece.getName() + ": No Map");
            return;
        }
        if (this.gpIdChecker.findUpdatedPiece(gamePiece)) {
            ++this.updatedCount;
        } else {
            ++this.notFoundCount;
            logger.error("Can't refresh piece " + gamePiece.getName() + ": Can't find matching Piece Slot");
        }
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void setup(boolean bl) {
        this.refreshAction.setEnabled(bl);
    }

    class RefreshDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private GameRefresher refresher;
        private JTextArea results;
        private JCheckBox nameCheck;

        RefreshDialog(GameRefresher gameRefresher2) {
            this.refresher = gameRefresher2;
            this.setTitle(Resources.getString("GameRefresher.refresh_counters"));
            this.setModal(true);
            this.initComponents();
        }

        protected void initComponents() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    RefreshDialog.this.exit();
                }
            });
            this.setLayout(new MigLayout("wrap 1", "[center]"));
            JPanel jPanel = new JPanel(new MigLayout());
            JButton jButton = new JButton(Resources.getString("General.test"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RefreshDialog.this.test();
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.run"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RefreshDialog.this.run();
                }
            });
            JButton jButton3 = new JButton(Resources.getString("General.exit"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RefreshDialog.this.exit();
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            this.add(jPanel);
            this.results = new JTextArea(7, 40);
            this.results.setEditable(false);
            this.add(this.results);
            this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
            this.add(this.nameCheck);
            this.pack();
        }

        protected void exit() {
            this.setVisible(false);
        }

        protected void test() {
            this.results.setText(Resources.getString("GameRefresher.refresh_counters_test"));
            this.refresher.execute(true, this.nameCheck.isSelected());
        }

        protected void run() {
            this.results.setText("");
            this.refresher.execute(false, this.nameCheck.isSelected());
            this.exit();
        }

        public void addMessage(String string) {
            this.results.setText(this.results.getText() + "\n" + string);
        }
    }
}

