/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.slf4j.migrator.helper.SpringLayoutHelper;
import org.slf4j.migrator.internal.ConversionTask;

public class MigratorFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int BASIC_PADDING = 10;
    private static final int FOLDER_COLUMNS = 40;
    private static final String MIGRATE_COMMAND = "MIGRATE_COMMAND";
    private static final String BROWSE_COMMAND = "BROWSE_COMMAND";
    static final String EXIT_COMMAND = "EXIT_COMMAND";
    static final int X_SIZE = 700;
    static final int Y_SIZE = 400;
    private SpringLayout layoutManager = new SpringLayout();
    private SpringLayoutHelper slh = new SpringLayoutHelper(this.layoutManager, 10);
    private JLabel migrationLabel;
    private JRadioButton radioLog4j;
    private JRadioButton radioJCL;
    private JRadioButton radioJUL;
    private ButtonGroup buttonGroup;
    private JTextField folderTextField;
    private JLabel warningLabel;
    JButton migrateButton;
    private JButton browseButton;
    private JLabel folderLabel;
    private JCheckBox awareCheckBox;
    private JLabel awareLabel;
    JLabel otherLabel;
    JProgressBar progressBar;
    private JFileChooser fileChooser;

    public MigratorFrame() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(this.layoutManager);
            this.setTitle("SLF4J migrator");
            this.createComponents();
            this.constrainAll();
            this.addAllComponentsToContextPane();
            this.pack();
            this.setSize(700, 400);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createComponents() {
        this.createMigrationLabel();
        this.createRadioJCL();
        this.createRadioLog4j();
        this.createRadioJUL();
        this.createButtonGroup();
        this.createFolderLabel();
        this.createFolderTextField();
        this.createBrowseButton();
        this.createMigrateButton();
        this.createAwareCheckbox();
        this.createAwareLabel();
        this.createWarningLabel();
        this.createFileChooser();
        this.otherLabel = new JLabel();
        this.otherLabel.setText("");
        this.createProgressBar();
    }

    private void constrainAll() {
        this.layoutManager.putConstraint("West", (Component)this.migrationLabel, 10, "East", (Component)this);
        this.layoutManager.putConstraint("North", (Component)this.migrationLabel, 10, "North", (Component)this);
        this.slh.placeToTheRight(this.migrationLabel, this.radioJCL, 10, -5);
        this.slh.placeBelow(this.radioJCL, this.radioLog4j, 0, 0);
        this.slh.placeBelow(this.radioLog4j, this.radioJUL, 0, 0);
        this.slh.placeBelow(this.migrationLabel, this.folderLabel, 0, 60);
        this.slh.placeToTheRight(this.folderLabel, this.folderTextField);
        this.slh.placeToTheRight(this.folderTextField, this.browseButton, 10, -5);
        this.slh.placeBelow(this.folderLabel, this.warningLabel, 0, 30);
        this.slh.placeBelow(this.warningLabel, this.awareCheckBox, 0, 15);
        this.slh.placeToTheRight(this.awareCheckBox, this.awareLabel);
        this.slh.placeBelow(this.awareCheckBox, this.migrateButton, 0, 30);
        this.slh.placeBelow(this.migrateButton, this.otherLabel, 0, 20);
        this.slh.placeBelow(this.otherLabel, this.progressBar, 0, 10);
    }

    private void addAllComponentsToContextPane() {
        this.getContentPane().add(this.migrationLabel);
        this.getContentPane().add(this.radioJCL);
        this.getContentPane().add(this.radioLog4j);
        this.getContentPane().add(this.radioJUL);
        this.getContentPane().add(this.folderLabel);
        this.getContentPane().add(this.folderTextField);
        this.getContentPane().add(this.browseButton);
        this.getContentPane().add(this.migrateButton);
        this.getContentPane().add(this.awareCheckBox);
        this.getContentPane().add(this.awareLabel);
        this.getContentPane().add(this.warningLabel);
        this.getContentPane().add(this.otherLabel);
        this.getContentPane().add(this.progressBar);
    }

    private void createButtonGroup() {
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.radioJCL);
        this.buttonGroup.add(this.radioLog4j);
        this.buttonGroup.add(this.radioJUL);
    }

    private void createMigrationLabel() {
        this.migrationLabel = new JLabel();
        this.migrationLabel.setText("Migration Type");
    }

    private void createRadioJCL() {
        this.radioJCL = new JRadioButton();
        this.radioJCL.setText("from Jakarta Commons Logging to SLF4J");
        this.radioJCL.setToolTipText("Select this button if you wish to migrate a Java project using Jakarta Commons Logging to use SLF4J.");
    }

    private void createRadioLog4j() {
        this.radioLog4j = new JRadioButton();
        this.radioLog4j.setText("from log4j to SLF4J ");
        this.radioLog4j.setToolTipText("Select this button if you wish to migrate a Java project using log4j to use SLF4J.");
    }

    private void createRadioJUL() {
        this.radioJUL = new JRadioButton();
        this.radioJUL.setText("from JUL to SLF4J ");
        this.radioJUL.setToolTipText("Select this button if you wish to migrate a Java project using java.utl.logging (JUL) to use SLF4J.");
    }

    private void createFolderLabel() {
        this.folderLabel = new JLabel();
        this.folderLabel.setText("Project Directory");
    }

    private void createFolderTextField() {
        this.folderTextField = new JTextField();
        this.folderTextField.setColumns(40);
    }

    private void createBrowseButton() {
        this.browseButton = new JButton();
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(this);
        this.browseButton.setActionCommand(BROWSE_COMMAND);
        this.browseButton.setToolTipText("Click this button to browse the file systems on your computer.");
    }

    private void createAwareCheckbox() {
        this.awareCheckBox = new JCheckBox();
        this.awareCheckBox.setToolTipText("<html><p>Check this box of you understand that the migration tool<p>will <b>not</b> backup your Java source files.</html>");
    }

    private void createAwareLabel() {
        this.awareLabel = new JLabel();
        this.awareLabel.setText("<html><p>I am aware that this tool will directly modify all Java source files</p><p>in the selected folder without creating backup files.</p></html>");
    }

    private void createWarningLabel() {
        this.warningLabel = new JLabel();
        this.warningLabel.setText("<html><p><span color=\"red\">WARNING:</span> This SLF4J migration tool will directly modify all Java source files</p><p>in the selected project folder without creating a backup of the original files.</p></html>");
    }

    private void createMigrateButton() {
        this.migrateButton = new JButton();
        this.migrateButton.setText("Migrate Project to SLF4J");
        this.migrateButton.setToolTipText("Click this button to initiate migration of your project.");
        this.migrateButton.addActionListener(this);
        this.migrateButton.setActionCommand(MIGRATE_COMMAND);
    }

    private void createFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Source folder selector");
        this.fileChooser.setFileSelectionMode(1);
    }

    private void createProgressBar() {
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setPreferredSize(new Dimension(560, 5));
        this.progressBar.setVisible(false);
    }

    public void disableInput() {
        this.radioJCL.setEnabled(false);
        this.radioLog4j.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.folderTextField.setEnabled(false);
        this.awareCheckBox.setEnabled(false);
        this.migrateButton.setText("Migration in progress");
        this.migrateButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (MIGRATE_COMMAND.equals(actionEvent.getActionCommand())) {
            List<String> list = this.doSanityAnalysis();
            if (list.size() > 0) {
                this.showDialogBox(list);
            } else {
                int n;
                File file = new File(this.folderTextField.getText());
                if (this.radioJCL.isSelected()) {
                    n = 0;
                } else if (this.radioLog4j.isSelected()) {
                    n = 1;
                } else if (this.radioJUL.isSelected()) {
                    n = 2;
                } else {
                    throw new IllegalStateException("One of JCL or log4j project must have been previously chosen.");
                }
                ConversionTask conversionTask = new ConversionTask(file, this, n);
                conversionTask.launch();
            }
        } else if (BROWSE_COMMAND.equals(actionEvent.getActionCommand())) {
            this.showFileChooser();
        } else if (EXIT_COMMAND.equals(actionEvent.getActionCommand())) {
            this.dispose();
        }
    }

    void showFileChooser() {
        int n = this.fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.folderTextField.setText(file.getAbsolutePath());
        }
    }

    List<String> doSanityAnalysis() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(this.radioJCL.isSelected() || this.radioLog4j.isSelected() || this.radioJUL.isSelected())) {
            arrayList.add("Please select the migration type: JCL, log4j, or JUL to SLF4J.");
        }
        if ((string = this.folderTextField.getText()) == null || string.length() == 0) {
            arrayList.add("Please select the folder of the project to migrate");
        } else if (!this.isDirectory(string)) {
            arrayList.add("[" + string + "] does not look like a valid folder");
        }
        if (!this.awareCheckBox.isSelected()) {
            arrayList.add("Cannot initiate migration unless you acknowledge<p>that files will be modified without creating backup files");
        }
        return arrayList;
    }

    void showDialogBox(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        int n = 1;
        for (String string : list) {
            stringBuilder.append("<p>");
            stringBuilder.append(n);
            stringBuilder.append(". ");
            stringBuilder.append(string);
            stringBuilder.append("</p>");
            ++n;
        }
        stringBuilder.append("</html>");
        JOptionPane.showMessageDialog(this, stringBuilder.toString(), "", 0);
    }

    boolean isDirectory(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }
}

