/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.JCLLoggerAdapter;

public class JCLLoggerFactory
implements ILoggerFactory {
    private static final String JCL_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#jclDelegationLoop";
    final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String string) {
        Logger logger = (Logger)this.loggerMap.get(string);
        if (logger != null) {
            return logger;
        }
        Log log = LogFactory.getLog((String)string);
        JCLLoggerAdapter jCLLoggerAdapter = new JCLLoggerAdapter(log, string);
        Logger logger2 = this.loggerMap.putIfAbsent(string, (Logger)jCLLoggerAdapter);
        return logger2 == null ? jCLLoggerAdapter : logger2;
    }

    static {
        try {
            Class.forName("org.apache.commons.logging.impl.SLF4JLogFactory");
            String string = "Detected both jcl-over-slf4j.jar AND bound slf4j-jcl.jar on the class path, preempting StackOverflowError. ";
            String string2 = "See also http://www.slf4j.org/codes.html#jclDelegationLoop for more details.";
            Util.report((String)string);
            Util.report((String)string2);
            throw new IllegalStateException(string + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

