/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class NamespaceImpl
extends NodeImpl {
    private int nsCode;
    private int nameCode;
    private int index;

    public NamespaceImpl(ElementImpl elementImpl, int n, int n2) {
        this.parent = elementImpl;
        this.nsCode = n;
        NamePool namePool = this.getNamePool();
        this.nameCode = namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n));
        this.index = n2;
    }

    @Override
    public int getNameCode() {
        return this.nameCode;
    }

    public int getNamespaceCode() {
        return this.nsCode;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        NamespaceImpl namespaceImpl = (NamespaceImpl)nodeInfo;
        return this.parent.isSameNode(namespaceImpl.parent) && this.nsCode == namespaceImpl.nsCode;
    }

    @Override
    public String getLocalName() {
        return this.getNamePool().getPrefixFromNamespaceCode(this.nsCode);
    }

    public void setNamespaceCode(int n) {
        NamePool namePool = this.getNamePool();
        this.nsCode = n;
        this.nameCode = namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n));
    }

    @Override
    public final short getNodeType() {
        return 13;
    }

    @Override
    public String getStringValue() {
        return this.getNamePool().getURIFromNamespaceCode(this.nsCode);
    }

    @Override
    public String getNodeName() {
        return this.getLocalName();
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    @Override
    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (this == nodeImpl) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    @Override
    public String generateId() {
        return this.parent.generateId() + "_xmlns_" + this.getFingerprint();
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        outputter.copyNamespaceNode(this.nsCode);
    }

    @Override
    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + (long)this.index;
    }
}

