/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyElementImpl;
import com.icl.saxon.tinytree.TinyNamespaceImpl;
import java.util.Vector;

final class NamespaceEnumeration
implements AxisEnumeration {
    private TinyDocumentImpl document;
    private TinyElementImpl element;
    private NamePool pool;
    private int owner;
    private int currentElement;
    private int index;
    private Vector list = new Vector();
    private NodeTest nodeTest;
    private int last = -1;
    private int xmlNamespace;

    protected NamespaceEnumeration(TinyElementImpl tinyElementImpl, NodeTest nodeTest) {
        this.element = tinyElementImpl;
        this.owner = tinyElementImpl.nodeNr;
        this.document = (TinyDocumentImpl)tinyElementImpl.getDocumentRoot();
        this.pool = this.document.getNamePool();
        this.currentElement = this.owner;
        this.index = this.document.length[this.currentElement];
        this.nodeTest = nodeTest;
        this.xmlNamespace = this.pool.allocate("", "", "xml");
        this.advance();
    }

    private void advance() {
        NodeInfo nodeInfo;
        if (this.index == 0) {
            this.index = -1;
            return;
        }
        if (this.index > 0) {
            while (this.index < this.document.numberOfNamespaces && this.document.namespaceParent[this.index] == this.currentElement) {
                int n = this.document.namespaceCode[this.index];
                if (n == 0) {
                    this.list.addElement(new Short(0));
                } else if (this.matches(n)) {
                    short s = (short)(n >> 16);
                    int n2 = this.list.size();
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        short s2;
                        if ((s2 = ((Short)this.list.elementAt(n3++)).shortValue()) != s) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.list.addElement(new Short(s));
                        return;
                    }
                }
                ++this.index;
            }
        }
        if ((nodeInfo = this.document.getNode(this.currentElement).getParent()).getNodeType() == 9) {
            this.index = this.nodeTest.matches((short)13, this.xmlNamespace) ? 0 : -1;
        } else {
            this.currentElement = ((TinyElementImpl)nodeInfo).nodeNr;
            this.index = this.document.length[this.currentElement];
            this.advance();
        }
    }

    private boolean matches(int n) {
        if (this.nodeTest instanceof NodeTypeTest && this.nodeTest.getNodeType() == 13) {
            return true;
        }
        int n2 = this.pool.allocate("", "", this.pool.getPrefixFromNamespaceCode(n));
        return this.nodeTest.matches((short)13, n2);
    }

    @Override
    public boolean hasMoreElements() {
        return this.index >= 0;
    }

    @Override
    public NodeInfo nextElement() {
        TinyNamespaceImpl tinyNamespaceImpl = this.document.getNamespaceNode(this.index);
        tinyNamespaceImpl.setParentNode(this.owner);
        this.advance();
        return tinyNamespaceImpl;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isReverseSorted() {
        return false;
    }

    @Override
    public boolean isPeer() {
        return true;
    }

    @Override
    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        NamespaceEnumeration namespaceEnumeration = new NamespaceEnumeration(this.element, this.nodeTest);
        this.last = 0;
        while (namespaceEnumeration.hasMoreElements()) {
            namespaceEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

