/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class DescendantEnumeration
implements AxisEnumeration {
    TinyDocumentImpl document;
    TinyNodeImpl startNode;
    boolean includeSelf;
    int nextNodeNr;
    int startDepth;
    NodeTest test;
    int last = -1;
    TinyNodeImpl parentNode;

    protected DescendantEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.startNode = tinyNodeImpl;
        this.includeSelf = bl;
        this.test = nodeTest;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.startDepth = tinyDocumentImpl.depth[this.nextNodeNr];
        if (!bl) {
            ++this.nextNodeNr;
            if (tinyDocumentImpl.depth[this.nextNodeNr] <= this.startDepth) {
                this.nextNodeNr = -1;
            }
        }
        if (this.nextNodeNr >= 0 && this.nextNodeNr < tinyDocumentImpl.numberOfNodes && !nodeTest.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr])) {
            this.advance();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextNodeNr >= 0;
    }

    @Override
    public NodeInfo nextElement() {
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        this.advance();
        return tinyNodeImpl;
    }

    private void advance() {
        do {
            ++this.nextNodeNr;
            if (this.nextNodeNr < this.document.numberOfNodes && this.document.depth[this.nextNodeNr] > this.startDepth) continue;
            this.nextNodeNr = -1;
            return;
        } while (!this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr]));
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverseSorted() {
        return false;
    }

    @Override
    public boolean isPeer() {
        return false;
    }

    @Override
    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        DescendantEnumeration descendantEnumeration = new DescendantEnumeration(this.document, this.startNode, this.test, this.includeSelf);
        this.last = 0;
        while (descendantEnumeration.hasMoreElements()) {
            descendantEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

