/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.tree.AttributeCollection;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLMessage
extends StyleElement {
    boolean terminate = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.TERMINATE) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.terminate = true;
            } else if (string.equals("no")) {
                this.terminate = false;
            } else {
                this.styleError("terminate must be \"yes\" or \"no\"");
            }
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        Controller controller = context.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        Outputter outputter = controller.getOutputter();
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        controller.changeOutputDestination(properties, emitter);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        if (this.terminate) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
        }
    }
}

