/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.GroupActivation;
import com.icl.saxon.style.SAXONGroup;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class SAXONItem
extends StyleElement {
    private SAXONGroup group;

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            this.checkUnknownAttribute(n);
        }
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof SAXONGroup)) continue;
            this.group = (SAXONGroup)node;
            break;
        }
        if (this.group == null) {
            this.compileError("saxon:item must be within a saxon:group");
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        GroupActivation groupActivation = (GroupActivation)context.getGroupActivationStack().peek();
        while (true) {
            this.processChildren(context);
            if (!groupActivation.sameAsNext()) break;
            groupActivation.nextElement();
        }
    }
}

