/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.sql.SQLColumn;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class SQLInsert
extends StyleElement {
    String table;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        this.table = this.getAttribute("table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        DocumentInfo documentInfo;
        Controller controller = context.getController();
        Connection connection = (Connection)controller.getUserData(documentInfo = context.getCurrentNodeInfo().getDocumentRoot(), "sql:connection");
        if (connection == null) {
            throw this.styleError("No SQL connection has been established");
        }
        PreparedStatement preparedStatement = (PreparedStatement)controller.getUserData(this, "sql:statement");
        try {
            int n;
            Object object;
            if (preparedStatement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("INSERT INTO " + this.table + " (");
                n = 0;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof SQLColumn)) continue;
                    if (n++ > 0) {
                        ((StringBuffer)object).append(',');
                    }
                    String string = ((SQLColumn)node).getColumnName();
                    ((StringBuffer)object).append(string);
                }
                ((StringBuffer)object).append(") VALUES (");
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        ((StringBuffer)object).append(',');
                    }
                    ((StringBuffer)object).append('?');
                }
                ((StringBuffer)object).append(')');
                preparedStatement = connection.prepareStatement(((StringBuffer)object).toString());
                controller.setUserData(this, "sql:statement", preparedStatement);
            }
            int n2 = 1;
            for (object = this.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!(object instanceof SQLColumn)) continue;
                Value value = ((SQLColumn)object).getColumnValue(context);
                String string = value.asString();
                if (string.length() == 1) {
                    string = string + " ";
                }
                preparedStatement.setObject(n2++, string);
            }
            n = preparedStatement.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            throw this.styleError("(SQL) " + sQLException.getMessage());
        }
    }
}

