/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;

public class NodeListExpression
extends NodeSetExpression {
    private Expression baseExpression;

    public NodeListExpression(Expression expression) {
        this.baseExpression = expression;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.baseExpression = this.baseExpression.simplify();
        if (this.baseExpression instanceof EmptyNodeSet) {
            return this.baseExpression;
        }
        if (this.baseExpression instanceof SingletonNodeSet) {
            return this.baseExpression;
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.baseExpression.getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.getDependencies() & n) != 0) {
            return new NodeListExpression(this.baseExpression.reduce(n, context));
        }
        return this;
    }

    @Override
    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        return this.baseExpression.enumerate(context, true);
    }

    @Override
    public void display(int n) {
        System.err.println(NodeListExpression.indent(n) + "NodeListExpression");
        this.baseExpression.display(n + 1);
    }
}

