/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "PipeWire", "index.html", [
    [ "Components", "index.html#autotoc_md0", null ],
    [ "API Documentation", "index.html#autotoc_md1", null ],
    [ "More Documentation", "index.html#autotoc_md2", null ],
    [ "Resources", "index.html#autotoc_md3", null ],
    [ "Overview", "page_overview.html", [
      [ "Motivation", "page_overview.html#autotoc_md4", null ]
    ] ],
    [ "PipeWire Design", "page_pipewire.html", [
      [ "Internals", "page_pipewire.html#autotoc_md5", null ],
      [ "Components", "page_pipewire.html#autotoc_md6", null ],
      [ "Backends", "page_pipewire.html#autotoc_md7", null ],
      [ "Design", "page_design.html", [
        [ "Protocol", "page_design.html#autotoc_md8", null ],
        [ "Extensibility", "page_design.html#autotoc_md9", null ]
      ] ],
      [ "Audio", "page_audio.html", [
        [ "Use Cases", "page_audio.html#autotoc_md94", [
          [ "Audio Devices Are Made Available As Processing Nodes/Ports", "page_audio.html#autotoc_md95", null ],
          [ "Audio Devices Can Be Plugged and Unplugged", "page_audio.html#autotoc_md96", null ],
          [ "Audio Port In Canonical Format", "page_audio.html#autotoc_md97", null ],
          [ "Applications Can Connect To Audio Devices", "page_audio.html#autotoc_md98", null ],
          [ "Default Audio Sink and Sources", "page_audio.html#autotoc_md99", null ],
          [ "Application Should Be Able To Move Between Sinks/Sources", "page_audio.html#autotoc_md100", null ],
          [ "Exclusive Access", "page_audio.html#autotoc_md101", null ]
        ] ],
        [ "Design", "page_audio.html#autotoc_md102", [
          [ "SPA", "page_audio.html#autotoc_md103", null ],
          [ "Audio Adapter", "page_audio.html#autotoc_md104", null ],
          [ "The Session Manager", "page_audio.html#autotoc_md105", null ]
        ] ],
        [ "Implementation", "page_audio.html#autotoc_md106", [
          [ "PipeWire Media Session (alsa-monitor)", "page_audio.html#autotoc_md107", null ]
        ] ]
      ] ],
      [ "Access Control", "page_access.html", [
        [ "Use Cases", "page_access.html#autotoc_md10", [
          [ "New Clients Need Their Permissions Configured", "page_access.html#autotoc_md11", null ],
          [ "Flatpaks Can't Modify Other Stream/Device Volumes", "page_access.html#autotoc_md12", null ],
          [ "Flatpaks Can't Move Other Streams To Different Devices", "page_access.html#autotoc_md13", null ],
          [ "Application Should Be Restricted In What They Can See", "page_access.html#autotoc_md14", null ],
          [ "\"Manager\" Applications Require Full Access", "page_access.html#autotoc_md15", null ]
        ] ],
        [ "Design", "page_access.html#autotoc_md16", [
          [ "The PipeWire Daemon", "page_access.html#autotoc_md17", null ],
          [ "The PipeWire Access Module", "page_access.html#autotoc_md18", null ],
          [ "The Session Manager", "page_access.html#autotoc_md19", null ]
        ] ]
      ] ],
      [ "Portal Access Control", "page_portal.html", [
        [ "Use Cases", "page_portal.html#autotoc_md33", [
          [ "New Portal Managed Clients Need Device Permissions Configured", "page_portal.html#autotoc_md34", null ],
          [ "New Devices Need To Be Made Visible To Portal Managed Clients", "page_portal.html#autotoc_md35", null ],
          [ "Permissions For A Device Need To Be Revoked", "page_portal.html#autotoc_md36", null ]
        ] ],
        [ "Design", "page_portal.html#autotoc_md37", [
          [ "The Portal", "page_portal.html#autotoc_md38", null ],
          [ "The PipeWire Portal Module", "page_portal.html#autotoc_md39", null ],
          [ "The Client", "page_portal.html#autotoc_md40", null ],
          [ "The Session Manager", "page_portal.html#autotoc_md41", null ]
        ] ]
      ] ],
      [ "MIDI Support", "page_midi.html", [
        [ "Use Cases", "page_midi.html#autotoc_md20", [
          [ "MIDI Devices Are Made Available As Processing Nodes/Ports", "page_midi.html#autotoc_md21", null ],
          [ "MIDI Devices Can Be Plugged and Unplugged", "page_midi.html#autotoc_md22", null ],
          [ "Applications Can Connect To MIDI Devices", "page_midi.html#autotoc_md23", null ],
          [ "Some MIDI Devices Are Sinks Or Sources For MIDI Data", "page_midi.html#autotoc_md24", null ],
          [ "Applications Should Auto-connect To MIDI Sinks Or Sources", "page_midi.html#autotoc_md25", null ]
        ] ],
        [ "Design", "page_midi.html#autotoc_md26", [
          [ "SPA", "page_midi.html#autotoc_md27", null ],
          [ "The PipeWire Daemon", "page_midi.html#autotoc_md28", null ],
          [ "The Session Manager", "page_midi.html#autotoc_md29", null ]
        ] ],
        [ "Implementation", "page_midi.html#autotoc_md30", [
          [ "PipeWire Media Session", "page_midi.html#autotoc_md31", null ],
          [ "JACK", "page_midi.html#autotoc_md32", null ]
        ] ]
      ] ],
      [ "Objects Design", "page_objects_design.html", [
        [ "The Media Graph", "page_objects_design.html#autotoc_md68", [
          [ "Node", "page_objects_design.html#autotoc_md69", null ],
          [ "Port", "page_objects_design.html#autotoc_md70", null ],
          [ "Link", "page_objects_design.html#autotoc_md71", null ]
        ] ],
        [ "The Session Management Graph", "page_objects_design.html#autotoc_md72", [
          [ "Endpoint", "page_objects_design.html#autotoc_md73", [
            [ "Target", "page_objects_design.html#autotoc_md74", null ]
          ] ],
          [ "Endpoint Stream", "page_objects_design.html#autotoc_md75", null ],
          [ "Endpoint Link", "page_objects_design.html#autotoc_md76", [
            [ "Constructing", "page_objects_design.html#autotoc_md77", null ]
          ] ]
        ] ],
        [ "Other Related Objects", "page_objects_design.html#autotoc_md78", [
          [ "Device", "page_objects_design.html#autotoc_md79", null ],
          [ "Session", "page_objects_design.html#autotoc_md80", [
            [ "Default Endpoints", "page_objects_design.html#autotoc_md81", null ],
            [ "Multiple Sessions", "page_objects_design.html#autotoc_md82", null ]
          ] ]
        ] ],
        [ "Mappings To Underlying Subsystem Objects", "page_objects_design.html#autotoc_md83", [
          [ "ALSA UCM", "page_objects_design.html#autotoc_md84", null ],
          [ "ALSA Fallback", "page_objects_design.html#autotoc_md85", null ],
          [ "V4L2", "page_objects_design.html#autotoc_md86", null ]
        ] ],
        [ "Relationship To Other API's", "page_objects_design.html#autotoc_md87", [
          [ "PulseAudio", "page_objects_design.html#autotoc_md88", [
            [ "Mapping PipeWire Objects For Access By PulseAudio Clients", "page_objects_design.html#autotoc_md89", null ],
            [ "Mapping PulseAudio Clients To PipeWire", "page_objects_design.html#autotoc_md90", null ]
          ] ],
          [ "Jack", "page_objects_design.html#autotoc_md91", [
            [ "Mapping PipeWire Objects For Access By JACK Clients", "page_objects_design.html#autotoc_md92", null ],
            [ "Mapping JACK Clients To PipeWire", "page_objects_design.html#autotoc_md93", null ]
          ] ]
        ] ]
      ] ],
      [ "PipeWire Library", "page_library.html", [
        [ "Principles", "page_library.html#autotoc_md45", null ],
        [ "Versioning", "page_library.html#autotoc_md46", null ],
        [ "Proxies and Resources", "page_library.html#autotoc_md47", null ],
        [ "Interfaces", "page_library.html#autotoc_md48", [
          [ "struct pw_loop", "page_library.html#autotoc_md49", null ],
          [ "struct pw_context", "page_library.html#autotoc_md50", null ],
          [ "struct pw_core", "page_library.html#autotoc_md51", null ],
          [ "struct pw_registry", "page_library.html#autotoc_md52", null ],
          [ "struct pw_module", "page_library.html#autotoc_md53", null ],
          [ "struct pw_factory", "page_library.html#autotoc_md54", null ],
          [ "struct pw_device", "page_library.html#autotoc_md55", null ],
          [ "struct pw_node", "page_library.html#autotoc_md56", null ],
          [ "struct pw_port", "page_library.html#autotoc_md57", null ],
          [ "struct pw_link", "page_library.html#autotoc_md58", null ]
        ] ],
        [ "High Level Helper Objects", "page_library.html#autotoc_md59", [
          [ "struct pw_filter", "page_library.html#autotoc_md60", null ],
          [ "struct pw_stream", "page_library.html#autotoc_md61", null ]
        ] ],
        [ "Security", "page_library.html#autotoc_md62", null ],
        [ "Implementation", "page_library.html#autotoc_md63", null ],
        [ "Error Reporting", "page_library.html#autotoc_md64", null ]
      ] ],
      [ "DMA-BUF Sharing", "page_dma_buf.html", [
        [ "Capability Negotiations", "page_dma_buf.html#autotoc_md290", [
          [ "pw_stream_connect", "page_dma_buf.html#autotoc_md291", null ],
          [ "param_changed Hook", "page_dma_buf.html#autotoc_md292", [
            [ "For Consumers", "page_dma_buf.html#autotoc_md293", null ],
            [ "For Producers", "page_dma_buf.html#autotoc_md294", null ]
          ] ],
          [ "add_buffer Hook", "page_dma_buf.html#autotoc_md295", null ],
          [ "on_event Hook", "page_dma_buf.html#autotoc_md296", null ],
          [ "Example Programs", "page_dma_buf.html#autotoc_md297", null ]
        ] ],
        [ "DMA-BUF Mapping Warning", "page_dma_buf.html#autotoc_md298", null ],
        [ "Size of DMA-BUFs", "page_dma_buf.html#autotoc_md299", null ],
        [ "SPA param video format helpers", "page_dma_buf.html#autotoc_md300", null ],
        [ "v4l2", "page_dma_buf.html#autotoc_md301", null ]
      ] ],
      [ "Graph Scheduling", "page_scheduling.html", [
        [ "Nodes", "page_scheduling.html#autotoc_md108", null ],
        [ "Links", "page_scheduling.html#autotoc_md109", null ],
        [ "Drivers", "page_scheduling.html#autotoc_md110", [
          [ "Scheduling node A", "page_scheduling.html#autotoc_md111", null ],
          [ "Scheduling node B", "page_scheduling.html#autotoc_md112", null ],
          [ "Scheduling the driver", "page_scheduling.html#autotoc_md113", null ]
        ] ],
        [ "Remote nodes.", "page_scheduling.html#autotoc_md114", [
          [ "Remote driver nodes.", "page_scheduling.html#autotoc_md115", null ]
        ] ]
      ] ],
      [ "Native Protocol", "page_native_protocol.html", [
        [ "Message header", "page_native_protocol.html#autotoc_md116", null ],
        [ "Making a connection", "page_native_protocol.html#autotoc_md117", null ],
        [ "Core proxy/resource", "page_native_protocol.html#autotoc_md118", [
          [ "Core Methods (Id 0)", "page_native_protocol.html#autotoc_md119", [
            [ "Core::Hello (Opcode 1)", "page_native_protocol.html#autotoc_md120", null ],
            [ "Core::Sync (Opcode 2)", "page_native_protocol.html#autotoc_md121", null ],
            [ "Core::Pong (Opcode 3)", "page_native_protocol.html#autotoc_md122", null ],
            [ "Core::Error (Opcode 4)", "page_native_protocol.html#autotoc_md123", null ],
            [ "Core::GetRegistry (Opcode 5)", "page_native_protocol.html#autotoc_md124", null ],
            [ "Core::CreateObject (Opcode 6)", "page_native_protocol.html#autotoc_md125", null ],
            [ "Core::Destroy (Opcode 7)", "page_native_protocol.html#autotoc_md126", null ]
          ] ],
          [ "Core Events", "page_native_protocol.html#autotoc_md127", [
            [ "Core::Info (Opcode 0)", "page_native_protocol.html#autotoc_md128", null ],
            [ "Core::Done (Opcode 1)", "page_native_protocol.html#autotoc_md129", null ],
            [ "Core::Ping (Opcode 2)", "page_native_protocol.html#autotoc_md130", null ],
            [ "Core::Error (Opcode 3)", "page_native_protocol.html#autotoc_md131", null ],
            [ "Core::RemoveId (Opcode 4)", "page_native_protocol.html#autotoc_md132", null ],
            [ "Core::BoundId (Opcode 5)", "page_native_protocol.html#autotoc_md133", null ],
            [ "Core::AddMem (Opcode 6)", "page_native_protocol.html#autotoc_md134", null ],
            [ "Core::RemoveMem (Opcode 7)", "page_native_protocol.html#autotoc_md135", null ],
            [ "Core::BoundProps (Opcode 8)", "page_native_protocol.html#autotoc_md136", null ]
          ] ]
        ] ],
        [ "Registry proxy/resource", "page_native_protocol.html#autotoc_md137", [
          [ "Registry Methods", "page_native_protocol.html#autotoc_md138", [
            [ "Registry::Bind (Opcode 1)", "page_native_protocol.html#autotoc_md139", null ],
            [ "Registry::Destroy (Opcode 2)", "page_native_protocol.html#autotoc_md140", null ]
          ] ],
          [ "Registry Events", "page_native_protocol.html#autotoc_md141", [
            [ "Registry::Global (Opcode 0)", "page_native_protocol.html#autotoc_md142", null ],
            [ "Registry::GlobalRemove (Opcode 1)", "page_native_protocol.html#autotoc_md143", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Client", "page_native_protocol.html#autotoc_md144", [
          [ "Client Methods", "page_native_protocol.html#autotoc_md145", [
            [ "Client::Error (Opcode 1)", "page_native_protocol.html#autotoc_md146", null ],
            [ "Client::UpdateProperties (Opcode 2)", "page_native_protocol.html#autotoc_md147", null ],
            [ "Client::GetPermissions (Opcode 3)", "page_native_protocol.html#autotoc_md148", null ],
            [ "Client::UpdatePermissions (Opcode 4)", "page_native_protocol.html#autotoc_md149", null ]
          ] ],
          [ "Client Events", "page_native_protocol.html#autotoc_md150", [
            [ "Client::Info (Opcode 0)", "page_native_protocol.html#autotoc_md151", null ],
            [ "Client::Permissions (Opcode 1)", "page_native_protocol.html#autotoc_md152", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Device", "page_native_protocol.html#autotoc_md153", [
          [ "Device methods", "page_native_protocol.html#autotoc_md154", [
            [ "Device::SubscribeParams (Opcode 1)", "page_native_protocol.html#autotoc_md155", null ],
            [ "Device::EnumParams (Opcode 2)", "page_native_protocol.html#autotoc_md156", null ],
            [ "Device::SetParam (Opcode 3)", "page_native_protocol.html#autotoc_md157", null ]
          ] ],
          [ "Device events", "page_native_protocol.html#autotoc_md158", [
            [ "Device::Info (Opcode 0)", "page_native_protocol.html#autotoc_md159", null ],
            [ "Device::Param (Opcode 1)", "page_native_protocol.html#autotoc_md160", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Factory", "page_native_protocol.html#autotoc_md161", [
          [ "Factory methods", "page_native_protocol.html#autotoc_md162", null ],
          [ "Factory events", "page_native_protocol.html#autotoc_md163", [
            [ "Factory::Info (Opcode 0)", "page_native_protocol.html#autotoc_md164", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Link", "page_native_protocol.html#autotoc_md165", [
          [ "Link methods", "page_native_protocol.html#autotoc_md166", null ],
          [ "Link events", "page_native_protocol.html#autotoc_md167", [
            [ "Link::Info (Opcode 0)", "page_native_protocol.html#autotoc_md168", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Module", "page_native_protocol.html#autotoc_md169", [
          [ "Module methods", "page_native_protocol.html#autotoc_md170", null ],
          [ "Module events", "page_native_protocol.html#autotoc_md171", [
            [ "Module::Info (Opcode 0)", "page_native_protocol.html#autotoc_md172", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Node", "page_native_protocol.html#autotoc_md173", [
          [ "Node methods", "page_native_protocol.html#autotoc_md174", [
            [ "Node::SubscribeParams (Opcode 1)", "page_native_protocol.html#autotoc_md175", null ],
            [ "Node::EnumParams (Opcode 2)", "page_native_protocol.html#autotoc_md176", null ],
            [ "Node::SetParam (Opcode 3)", "page_native_protocol.html#autotoc_md177", null ],
            [ "Node::SendCommand (Opcode 4)", "page_native_protocol.html#autotoc_md178", null ]
          ] ],
          [ "Node events", "page_native_protocol.html#autotoc_md179", [
            [ "Node::Info (Opcode 0)", "page_native_protocol.html#autotoc_md180", null ],
            [ "Node::Param (Opcode 1)", "page_native_protocol.html#autotoc_md181", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Port", "page_native_protocol.html#autotoc_md182", [
          [ "Port methods", "page_native_protocol.html#autotoc_md183", [
            [ "Port::SubscribeParams (Opcode 1)", "page_native_protocol.html#autotoc_md184", null ],
            [ "Port::EnumParams (Opcode 2)", "page_native_protocol.html#autotoc_md185", null ]
          ] ],
          [ "Port events", "page_native_protocol.html#autotoc_md186", [
            [ "Port::Info (Opcode 0)", "page_native_protocol.html#autotoc_md187", null ],
            [ "Port::Param (Opcode 1)", "page_native_protocol.html#autotoc_md188", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:ClientNode", "page_native_protocol.html#autotoc_md189", [
          [ "ClientNode methods", "page_native_protocol.html#autotoc_md190", [
            [ "ClientNode::GetNode (Opcode 1)", "page_native_protocol.html#autotoc_md191", null ],
            [ "ClientNode::Update (Opcode 2)", "page_native_protocol.html#autotoc_md192", null ],
            [ "ClientNode::PortUpdate (Opcode 3)", "page_native_protocol.html#autotoc_md193", null ],
            [ "ClientNode::SetActive (Opcode 4)", "page_native_protocol.html#autotoc_md194", null ],
            [ "ClientNode::Event (Opcode 5)", "page_native_protocol.html#autotoc_md195", null ],
            [ "ClientNode::PortBuffers (Opcode 6)", "page_native_protocol.html#autotoc_md196", null ]
          ] ],
          [ "ClientNode events", "page_native_protocol.html#autotoc_md197", [
            [ "ClientNode::Transport (Opcode 0)", "page_native_protocol.html#autotoc_md198", null ],
            [ "ClientNode::SetParam (Opcode 1)", "page_native_protocol.html#autotoc_md199", null ],
            [ "ClientNode::SetIO (Opcode 2)", "page_native_protocol.html#autotoc_md200", null ],
            [ "ClientNode::Event (Opcode 3)", "page_native_protocol.html#autotoc_md201", null ],
            [ "ClientNode::Command (Opcode 4)", "page_native_protocol.html#autotoc_md202", null ],
            [ "ClientNode::AddPort (Opcode 5)", "page_native_protocol.html#autotoc_md203", null ],
            [ "ClientNode::RemovePort (Opcode 6)", "page_native_protocol.html#autotoc_md204", null ],
            [ "ClientNode::PortSetParam (Opcode 7)", "page_native_protocol.html#autotoc_md205", null ],
            [ "ClientNode::UseBuffers (Opcode 8)", "page_native_protocol.html#autotoc_md206", null ],
            [ "ClientNode::PortSetIO (Opcode 9)", "page_native_protocol.html#autotoc_md207", null ],
            [ "ClientNode::SetActivation (Opcode 10)", "page_native_protocol.html#autotoc_md208", null ],
            [ "ClientNode::PortSetMixInfo (Opcode 11)", "page_native_protocol.html#autotoc_md209", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Metadata", "page_native_protocol.html#autotoc_md210", [
          [ "Metadata methods", "page_native_protocol.html#autotoc_md211", [
            [ "Metadata::SetProperty (Opcode 1)", "page_native_protocol.html#autotoc_md212", null ],
            [ "Metadata::Clear (Opcode 2)", "page_native_protocol.html#autotoc_md213", null ]
          ] ],
          [ "Metadata events", "page_native_protocol.html#autotoc_md214", [
            [ "Metadata::Property (Opcode 0)", "page_native_protocol.html#autotoc_md215", null ]
          ] ]
        ] ],
        [ "PipeWire:Interface:Profiler", "page_native_protocol.html#autotoc_md216", [
          [ "Profiler methods", "page_native_protocol.html#autotoc_md217", null ],
          [ "Profiler events", "page_native_protocol.html#autotoc_md218", [
            [ "Profiler::Profile (Opcode 0)", "page_native_protocol.html#autotoc_md219", null ]
          ] ]
        ] ]
      ] ],
      [ "PipeWire Daemon", "page_daemon.html", [
        [ "Configuration Files", "page_daemon.html#autotoc_md42", [
          [ "Configuration File Format", "page_daemon.html#autotoc_md43", null ]
        ] ],
        [ "Logging", "page_daemon.html#autotoc_md44", null ]
      ] ],
      [ "PipeWire Tools", "page_tools.html", [
        [ "pipewire", "page_man_pipewire_1.html", null ],
        [ "pipewire-pulse", "page_man_pipewire_pulse_1.html", null ],
        [ "pipewire.conf", "page_man_pipewire_conf_5.html", null ],
        [ "pw-cat", "page_man_pw_cat_1.html", null ],
        [ "pw-cli", "page_man_pw_cli_1.html", null ],
        [ "pw-config", "page_man_pw_config_1.html", null ],
        [ "pw-dot", "page_man_pw_dot_1.html", null ],
        [ "pw-link", "page_man_pw_link_1.html", null ],
        [ "pw-metadata", "page_man_pw_metadata_1.html", null ],
        [ "pw-mididump", "page_man_pw_mididump_1.html", null ],
        [ "pw-mon", "page_man_pw_mon_1.html", null ],
        [ "pw-profiler", "page_man_pw_profiler_1.html", null ],
        [ "pw-top", "page_man_pw_top_1.html", null ],
        [ "pw-jack", "page_man_pw_jack_1.html", null ]
      ] ],
      [ "PipeWire Session Manager", "page_session_manager.html", [
        [ "Client Management", "page_session_manager.html#autotoc_md65", null ],
        [ "Device Management", "page_session_manager.html#autotoc_md66", null ],
        [ "Endpoint Grouping", "page_session_manager.html#autotoc_md67", null ]
      ] ],
      [ "PulseAudio Compatibility", "page_pulseaudio.html", [
        [ "Internals - Mapping Between ALSA and Streams", "page_pulseaudio.html#autotoc_md281", [
          [ "ALSA Cards", "page_pulseaudio.html#autotoc_md282", null ],
          [ "Streams", "page_pulseaudio.html#autotoc_md283", null ]
        ] ],
        [ "Session Manager", "page_pulseaudio.html#autotoc_md284", [
          [ "ALSA UCM", "page_pulseaudio.html#autotoc_md285", null ],
          [ "ALSA Fallback", "page_pulseaudio.html#autotoc_md286", null ],
          [ "ALSA Pulse UCM", "page_pulseaudio.html#autotoc_md287", null ],
          [ "ALSA Pulse Fallback", "page_pulseaudio.html#autotoc_md288", null ]
        ] ],
        [ "PulseAudio", "page_pulseaudio.html#autotoc_md289", null ]
      ] ]
    ] ],
    [ "PipeWire Modules", "page_pipewire_modules.html", [
      [ "PipeWire Module: Access", "page_module_access.html", null ],
      [ "PipeWire Module: Adapter", "page_module_adapter.html", null ],
      [ "PipeWire Module: AVB", "page_module_avb.html", null ],
      [ "PipeWire Module: Client Device", "page_module_client_device.html", null ],
      [ "PipeWire Module: Client Node", "page_module_client_node.html", null ],
      [ "PipeWire Module: Combine Stream", "page_module_combine_stream.html", null ],
      [ "PipeWire Module: Echo Cancel", "page_module_echo_cancel.html", null ],
      [ "PipeWire Module: Example Filter", "page_module_example_filter.html", null ],
      [ "PipeWire Module: Example Sink", "page_module_example_sink.html", null ],
      [ "PipeWire Module: Example Source", "page_module_example_source.html", null ],
      [ "PipeWire Module: Fallback Sink", "page_module_fallback_sink.html", null ],
      [ "PipeWire Module: FFADO firewire audio driver", "page_module_ffado_driver.html", null ],
      [ "PipeWire Module: Filter-Chain", "page_module_filter_chain.html", null ],
      [ "PipeWire Module: JACK DBus detect", "page_module_jackdbus_detect.html", null ],
      [ "PipeWire Module: JACK Tunnel", "page_module_jack_tunnel.html", null ],
      [ "PipeWire Module: Link Factory", "page_module_link_factory.html", null ],
      [ "PipeWire Module: Loopback", "page_module_loopback.html", null ],
      [ "PipeWire Module: Metadata", "page_module_metadata.html", null ],
      [ "PipeWire Module: Netjack2 driver", "page_module_netjack2_driver.html", null ],
      [ "PipeWire Module: Netjack2 manager", "page_module_netjack2_manager.html", null ],
      [ "PipeWire Module: Unix Pipe Tunnel", "page_module_pipe_tunnel.html", null ],
      [ "PipeWire Module: Portal", "page_module_portal.html", null ],
      [ "PipeWire Module: Profiler", "page_module_profiler.html", null ],
      [ "PipeWire Module: Protocol Native", "page_module_protocol_native.html", null ],
      [ "PipeWire Module: Protocol Pulse", "page_module_protocol_pulse.html", null ],
      [ "PipeWire Module: Protocol Simple", "page_module_protocol_simple.html", null ],
      [ "PipeWire Module: Pulse Tunnel", "page_module_pulse_tunnel.html", null ],
      [ "PipeWire Module: AirPlay Sink", "page_module_raop_sink.html", null ],
      [ "PipeWire Module: RAOP Discover", "page_module_raop_discover.html", null ],
      [ "PipeWire Module: ROC sink", "page_module_roc_sink.html", null ],
      [ "PipeWire Module: ROC source", "page_module_roc_source.html", null ],
      [ "PipeWire Module: SAP Announce and create RTP streams", "page_module_rtp_sap.html", null ],
      [ "PipeWire Module: RTP sink", "page_module_rtp_sink.html", null ],
      [ "PipeWire Module: RTP source", "page_module_rtp_source.html", null ],
      [ "PipeWire Module: RTP session", "page_module_rtp_session.html", null ],
      [ "PipeWire Module: RT", "page_module_rt.html", null ],
      [ "PipeWire Module: Session Manager", "page_module_session_manager.html", null ],
      [ "PipeWire Module: VBAN receiver", "page_module_vban_recv.html", null ],
      [ "PipeWire Module: VBAN sender", "page_module_vban_send.html", null ],
      [ "PipeWire Module: X11 Bell", "page_module_x11_bell.html", null ],
      [ "PipeWire Module: Zeroconf Discover", "page_module_zeroconf_discover.html", null ]
    ] ],
    [ "Tutorial", "page_tutorial.html", [
      [ "More Example Programs", "page_tutorial.html#autotoc_md220", null ],
      [ "Tutorial - Part 1: Getting Started", "page_tutorial1.html", [
        [ "Initialization", "page_tutorial1.html#autotoc_md221", null ],
        [ "Compilation", "page_tutorial1.html#autotoc_md222", null ]
      ] ],
      [ "Tutorial - Part 2: Enumerating Objects", "page_tutorial2.html", null ],
      [ "Tutorial - Part 3: Forcing A Roundtrip", "page_tutorial3.html", null ],
      [ "Tutorial - Part 4: Playing A Tone", "page_tutorial4.html", null ],
      [ "Tutorial - Part 5: Capturing Video Frames", "page_tutorial5.html", null ],
      [ "Tutorial - Part 6: Binding Objects", "page_tutorial6.html", null ],
      [ "List of example programs", "page_examples.html", null ]
    ] ],
    [ "PipeWire API", "page_api.html", [
      [ "Client Implementation", "page_client_impl.html", [
        [ "Overview", "page_client_impl.html#sec_page_client_impl_overview", null ],
        [ "Credentials", "page_client_impl.html#sec_page_client_impl_credentials", null ],
        [ "Types", "page_client_impl.html#sec_page_client_impl_types", null ],
        [ "Resources", "page_client_impl.html#sec_page_client_impl_resources", null ]
      ] ],
      [ "Proxy", "page_proxy.html", [
        [ "Overview", "page_proxy.html#sec_page_proxy_overview", null ],
        [ "Core proxy", "page_proxy.html#sec_page_proxy_core", null ],
        [ "Create", "page_proxy.html#sec_page_proxy_create", null ],
        [ "Bind", "page_proxy.html#sec_page_proxy_bind", null ],
        [ "Methods", "page_proxy.html#sec_page_proxy_methods", null ],
        [ "Events", "page_proxy.html#sec_page_proxy_events", null ],
        [ "Destroy", "page_proxy.html#sec_page_proxy_destroy", null ]
      ] ],
      [ "Streams", "page_streams.html", [
        [ "Overview", "page_streams.html#sec_overview", null ],
        [ "Create", "page_streams.html#sec_create", null ],
        [ "Connect", "page_streams.html#sec_connect", [
          [ "Stream target", "page_streams.html#ssec_stream_target", null ],
          [ "Stream formats", "page_streams.html#ssec_stream_formats", null ]
        ] ],
        [ "Format negotiation", "page_streams.html#sec_format", null ],
        [ "Buffer negotiation", "page_streams.html#sec_buffers", null ],
        [ "Streaming", "page_streams.html#sec_streaming", [
          [ "Consume data", "page_streams.html#ssec_consume", null ],
          [ "Produce data", "page_streams.html#ssec_produce", null ]
        ] ],
        [ "Disconnect", "page_streams.html#sec_stream_disconnect", null ],
        [ "Configuration", "page_streams.html#sec_stream_configuration", [
          [ "Stream Properties", "page_streams.html#ssec_config_properties", null ],
          [ "Stream Rules", "page_streams.html#ssec_config_rules", null ]
        ] ],
        [ "Environment Variables", "page_streams.html#sec_stream_environment", null ]
      ] ],
      [ "Thread Loop", "page_thread_loop.html", [
        [ "Overview", "page_thread_loop.html#sec_thread_loop_overview", null ],
        [ "Creation", "page_thread_loop.html#sec_thread_loop_create", null ],
        [ "Destruction", "page_thread_loop.html#sec_thread_loop_destruction", null ],
        [ "Locking", "page_thread_loop.html#sec_thread_loop_locking", null ],
        [ "Events and Callbacks", "page_thread_loop.html#sec_thread_loop_events", null ]
      ] ]
    ] ],
    [ "SPA (Simple Plugin API)", "page_spa.html", [
      [ "Motivation", "page_spa.html#autotoc_md223", null ],
      [ "The SPA Header-Only API", "page_spa.html#autotoc_md224", null ],
      [ "SPA Plugins", "page_spa.html#autotoc_md225", null ],
      [ "Further details", "page_spa.html#autotoc_md226", null ],
      [ "SPA Design", "page_spa_design.html", [
        [ "Conventions", "page_spa_design.html#autotoc_md239", [
          [ "Types", "page_spa_design.html#autotoc_md240", null ],
          [ "Error Codes", "page_spa_design.html#autotoc_md241", null ],
          [ "Useful Macros", "page_spa_design.html#autotoc_md242", null ]
        ] ]
      ] ],
      [ "SPA Plugins", "page_spa_plugins.html", [
        [ "Outline", "page_spa_plugins.html#autotoc_md227", null ],
        [ "Open A Plugin", "page_spa_plugins.html#autotoc_md228", null ],
        [ "Enumerating Factories", "page_spa_plugins.html#autotoc_md229", null ],
        [ "Making A Handle", "page_spa_plugins.html#autotoc_md230", null ],
        [ "Retrieving An Interface", "page_spa_plugins.html#autotoc_md231", null ],
        [ "Clearing An Object", "page_spa_plugins.html#autotoc_md232", null ],
        [ "SPA Interfaces", "page_spa_plugins.html#autotoc_md233", null ],
        [ "SPA Events", "page_spa_plugins.html#autotoc_md234", null ],
        [ "API Results", "page_spa_plugins.html#autotoc_md235", [
          [ "Synchronous Results", "page_spa_plugins.html#autotoc_md236", null ],
          [ "Asynchronous Results", "page_spa_plugins.html#autotoc_md237", null ]
        ] ],
        [ "Implementing A New Plugin", "page_spa_plugins.html#autotoc_md238", null ]
      ] ],
      [ "SPA POD", "page_spa_pod.html", [
        [ "Types", "page_spa_pod.html#autotoc_md243", null ],
        [ "Constructing A POD", "page_spa_pod.html#autotoc_md244", [
          [ "Using varargs Builder", "page_spa_pod.html#autotoc_md245", null ],
          [ "Making Objects", "page_spa_pod.html#autotoc_md246", null ],
          [ "Choice Values", "page_spa_pod.html#autotoc_md247", null ],
          [ "Choice Examples", "page_spa_pod.html#autotoc_md248", null ],
          [ "Fixate", "page_spa_pod.html#autotoc_md249", null ]
        ] ],
        [ "Parsing A POD", "page_spa_pod.html#autotoc_md250", [
          [ "Validating Bytes", "page_spa_pod.html#autotoc_md251", null ],
          [ "Checking The Type Of POD", "page_spa_pod.html#autotoc_md252", null ],
          [ "Struct Fields", "page_spa_pod.html#autotoc_md253", null ],
          [ "Object Properties", "page_spa_pod.html#autotoc_md254", null ],
          [ "Parser", "page_spa_pod.html#autotoc_md255", null ],
          [ "Parser With Variable Arguments", "page_spa_pod.html#autotoc_md256", null ],
          [ "Choice Values", "page_spa_pod.html#autotoc_md257", null ]
        ] ],
        [ "Filter", "page_spa_pod.html#autotoc_md258", null ],
        [ "POD Layout", "page_spa_pod.html#autotoc_md259", null ],
        [ "POD Types", "page_spa_pod.html#autotoc_md260", [
          [ "None (1)", "page_spa_pod.html#autotoc_md261", null ],
          [ "Bool (2)", "page_spa_pod.html#autotoc_md262", null ],
          [ "Id (3)", "page_spa_pod.html#autotoc_md263", null ],
          [ "Int (4)", "page_spa_pod.html#autotoc_md264", null ],
          [ "Long (5)", "page_spa_pod.html#autotoc_md265", null ],
          [ "Float (6)", "page_spa_pod.html#autotoc_md266", null ],
          [ "Double (7)", "page_spa_pod.html#autotoc_md267", null ],
          [ "String (8)", "page_spa_pod.html#autotoc_md268", null ],
          [ "Bytes (9)", "page_spa_pod.html#autotoc_md269", null ],
          [ "Rectangle (10)", "page_spa_pod.html#autotoc_md270", null ],
          [ "Fraction (11)", "page_spa_pod.html#autotoc_md271", null ],
          [ "Bitmap (12)", "page_spa_pod.html#autotoc_md272", null ],
          [ "Array (13)", "page_spa_pod.html#autotoc_md273", null ],
          [ "Struct (14)", "page_spa_pod.html#autotoc_md274", null ],
          [ "Object (15)", "page_spa_pod.html#autotoc_md275", null ],
          [ "Sequence (16)", "page_spa_pod.html#autotoc_md276", null ],
          [ "Pointer (17)", "page_spa_pod.html#autotoc_md277", null ],
          [ "Fd (18)", "page_spa_pod.html#autotoc_md278", null ],
          [ "Choice (19)", "page_spa_pod.html#autotoc_md279", null ],
          [ "Pod (20)", "page_spa_pod.html#autotoc_md280", null ]
        ] ]
      ] ],
      [ "SPA Buffers", "page_spa_buffer.html", null ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Data Structures", "annotated.html", [
      [ "Data Structures", "annotated.html", "annotated_dup" ],
      [ "Data Structure Index", "classes.html", null ],
      [ "Data Fields", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Variables", "functions_vars.html", "functions_vars" ]
      ] ]
    ] ],
    [ "Globals", "globals.html", [
      [ "All", "globals.html", "globals_dup" ],
      [ "Functions", "globals_func.html", "globals_func" ],
      [ "Variables", "globals_vars.html", null ],
      [ "Typedefs", "globals_type.html", null ],
      [ "Enumerations", "globals_enum.html", null ],
      [ "Enumerator", "globals_eval.html", "globals_eval" ],
      [ "Macros", "globals_defs.html", "globals_defs" ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"alloc_8h.html",
"group__pw__client.html#gae9c05c6686aa7db3f69466363e7b8077",
"group__pw__global.html#ga37767f3d8d027ae10433a0801cab0dda",
"group__pw__keys.html#ga7e12dd6c9dec4a345c8a2a62f138b5bf",
"group__pw__module.html#ga8c4bfe6ad4da2e2443ba7985ae7527cb",
"group__pw__resource.html#ga61e286d92a2f528ebe48cb1436ac4eba",
"group__pw__thread__loop.html#gacb9c26a513d752803fd272a4ea2bc891",
"group__spa__cpu.html#ga36f54e2aac3837cb3631db07cbfde3e2",
"group__spa__hooks.html#gacbc74f9ceab3dc7c5d6d8c3eca6a41e5",
"group__spa__names.html#ga0847db019357b78b2fda5d40da8f2d39",
"group__spa__param.html#ga1b344a251727332372451ba66b0c8162",
"group__spa__param.html#gga09c0ecc808ca333e1dd8a994b8809586aa95628ab8f3e1d11150be7c7964d36df",
"group__spa__param.html#gga6fa558a42ebf277d0fe21e1bee5c1218ac7f8797af31fc4ac37d4ad72fe80a92c",
"group__spa__param.html#ggad7758d1c91573ef57ebf61ac113bb43ea107b70d9ca312a61fa29c3daecc91cb8",
"group__spa__pod.html#ga85016b1c73cf76d8c4789a6f539ac4ec",
"group__spa__types.html#gga726ca809ffd3d67ab4b8476646f26635a1195438b5c43f33a3fe50accde463f9b",
"page_library.html#autotoc_md63",
"page_session_manager.html#autotoc_md67",
"structpw__context__events.html#a9c874d491dfbdd13eb81c7b0b7561e87",
"structpw__impl__port__events.html#a3e2788e02240c77076c32642e1d57c82",
"structpw__stream__events.html#a4d1ed03aa78fb2c8324ae13bc45731e3",
"structspa__fraction.html#a55246db96d647cd96be18983d59feb56",
"structspa__node__events.html#a37b6ed18688f456b4c4e9b157879414f",
"structspa__thread__utils__methods.html#ab1126024161570f88d077ecee01066e8"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';