/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "bluez5-interface-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_path,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.Adapter1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5Adapter1
 * @title: Bluez5Adapter1
 * @short_description: Generated C code for the org.bluez.Adapter1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.Adapter1 ---- */

static const _ExtendedGDBusArgInfo _bluez5_adapter1_method_info_register_application_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez5_adapter1_method_info_register_application_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_adapter1_method_info_register_application_IN_ARG_pointers[] =
{
  &_bluez5_adapter1_method_info_register_application_IN_ARG_path.parent_struct,
  &_bluez5_adapter1_method_info_register_application_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_adapter1_method_info_register_application =
{
  {
    -1,
    (gchar *) "RegisterApplication",
    (GDBusArgInfo **) &_bluez5_adapter1_method_info_register_application_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-application",
  FALSE
};

static const GDBusMethodInfo * const _bluez5_adapter1_method_info_pointers[] =
{
  &_bluez5_adapter1_method_info_register_application.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_adapter1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.Adapter1",
    (GDBusMethodInfo **) &_bluez5_adapter1_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "adapter1",
};


/**
 * bluez5_adapter1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_adapter1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct;
}

/**
 * bluez5_adapter1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5Adapter1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_adapter1_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
bluez5_adapter1_method_marshal_register_application (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Bluez5Adapter1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>.
 */

/**
 * Bluez5Adapter1Iface:
 * @parent_iface: The parent interface.
 * @handle_register_application: Handler for the #Bluez5Adapter1::handle-register-application signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>.
 */

typedef Bluez5Adapter1Iface Bluez5Adapter1Interface;
G_DEFINE_INTERFACE (Bluez5Adapter1, bluez5_adapter1, G_TYPE_OBJECT)

static void
bluez5_adapter1_default_init (Bluez5Adapter1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Bluez5Adapter1::handle-register-application:
   * @object: A #Bluez5Adapter1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter1.RegisterApplication">RegisterApplication()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_adapter1_complete_register_application() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-application",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5Adapter1Iface, handle_register_application),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_adapter1_method_marshal_register_application,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * bluez5_adapter1_call_register_application:
 * @proxy: A #Bluez5Adapter1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter1.RegisterApplication">RegisterApplication()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_adapter1_call_register_application_finish() to get the result of the operation.
 *
 * See bluez5_adapter1_call_register_application_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_adapter1_call_register_application (
    Bluez5Adapter1 *proxy,
    const gchar *arg_path,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterApplication",
    g_variant_new ("(o@a{sv})",
                   arg_path,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_adapter1_call_register_application_finish:
 * @proxy: A #Bluez5Adapter1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_adapter1_call_register_application().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_adapter1_call_register_application().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_adapter1_call_register_application_finish (
    Bluez5Adapter1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_adapter1_call_register_application_sync:
 * @proxy: A #Bluez5Adapter1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter1.RegisterApplication">RegisterApplication()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_adapter1_call_register_application() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_adapter1_call_register_application_sync (
    Bluez5Adapter1 *proxy,
    const gchar *arg_path,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterApplication",
    g_variant_new ("(o@a{sv})",
                   arg_path,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_adapter1_complete_register_application:
 * @object: A #Bluez5Adapter1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter1.RegisterApplication">RegisterApplication()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_adapter1_complete_register_application (
    Bluez5Adapter1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5Adapter1Proxy:
 *
 * The #Bluez5Adapter1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5Adapter1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5Adapter1Proxy.
 */

struct _Bluez5Adapter1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_adapter1_proxy_iface_init (Bluez5Adapter1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5Adapter1Proxy, bluez5_adapter1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5Adapter1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_ADAPTER1, bluez5_adapter1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5Adapter1Proxy, bluez5_adapter1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_ADAPTER1, bluez5_adapter1_proxy_iface_init))

#endif
static void
bluez5_adapter1_proxy_finalize (GObject *object)
{
  Bluez5Adapter1Proxy *proxy = BLUEZ5_ADAPTER1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_adapter1_proxy_parent_class)->finalize (object);
}

static void
bluez5_adapter1_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
bluez5_adapter1_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
bluez5_adapter1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_ADAPTER1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_ADAPTER1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_adapter1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5Adapter1Proxy *proxy = BLUEZ5_ADAPTER1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
bluez5_adapter1_proxy_init (Bluez5Adapter1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_adapter1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_ADAPTER1_PROXY, Bluez5Adapter1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_adapter1_interface_info ());
}

static void
bluez5_adapter1_proxy_class_init (Bluez5Adapter1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_adapter1_proxy_finalize;
  gobject_class->get_property = bluez5_adapter1_proxy_get_property;
  gobject_class->set_property = bluez5_adapter1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_adapter1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_adapter1_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5Adapter1ProxyPrivate));
#endif
}

static void
bluez5_adapter1_proxy_iface_init (Bluez5Adapter1Iface *iface G_GNUC_UNUSED)
{
}

/**
 * bluez5_adapter1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_adapter1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_adapter1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_adapter1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_ADAPTER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter1", NULL);
}

/**
 * bluez5_adapter1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_adapter1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_adapter1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5Adapter1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Adapter1 *
bluez5_adapter1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_ADAPTER1 (ret);
  else
    return NULL;
}

/**
 * bluez5_adapter1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_adapter1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5Adapter1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Adapter1 *
bluez5_adapter1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_ADAPTER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter1", NULL);
  if (ret != NULL)
    return BLUEZ5_ADAPTER1 (ret);
  else
    return NULL;
}


/**
 * bluez5_adapter1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_adapter1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_adapter1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_adapter1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_adapter1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_ADAPTER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter1", NULL);
}

/**
 * bluez5_adapter1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_adapter1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_adapter1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5Adapter1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Adapter1 *
bluez5_adapter1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_ADAPTER1 (ret);
  else
    return NULL;
}

/**
 * bluez5_adapter1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_adapter1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_adapter1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5Adapter1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Adapter1 *
bluez5_adapter1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_ADAPTER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter1", NULL);
  if (ret != NULL)
    return BLUEZ5_ADAPTER1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5Adapter1Skeleton:
 *
 * The #Bluez5Adapter1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5Adapter1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5Adapter1Skeleton.
 */

struct _Bluez5Adapter1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_adapter1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5Adapter1Skeleton *skeleton = BLUEZ5_ADAPTER1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_ADAPTER1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_ADAPTER1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_adapter1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5Adapter1Skeleton *skeleton = BLUEZ5_ADAPTER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_adapter1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5Adapter1Skeleton *skeleton = BLUEZ5_ADAPTER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_adapter1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_adapter1_skeleton_vtable =
{
  _bluez5_adapter1_skeleton_handle_method_call,
  _bluez5_adapter1_skeleton_handle_get_property,
  _bluez5_adapter1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_adapter1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_adapter1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_adapter1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_adapter1_skeleton_vtable;
}

static GVariant *
bluez5_adapter1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5Adapter1Skeleton *skeleton = BLUEZ5_ADAPTER1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_adapter1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_adapter1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_adapter1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_adapter1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
bluez5_adapter1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void bluez5_adapter1_skeleton_iface_init (Bluez5Adapter1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5Adapter1Skeleton, bluez5_adapter1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5Adapter1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_ADAPTER1, bluez5_adapter1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5Adapter1Skeleton, bluez5_adapter1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_ADAPTER1, bluez5_adapter1_skeleton_iface_init))

#endif
static void
bluez5_adapter1_skeleton_finalize (GObject *object)
{
  Bluez5Adapter1Skeleton *skeleton = BLUEZ5_ADAPTER1_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_adapter1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_adapter1_skeleton_init (Bluez5Adapter1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_adapter1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_ADAPTER1_SKELETON, Bluez5Adapter1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
bluez5_adapter1_skeleton_class_init (Bluez5Adapter1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_adapter1_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_adapter1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_adapter1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_adapter1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_adapter1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5Adapter1SkeletonPrivate));
#endif
}

static void
bluez5_adapter1_skeleton_iface_init (Bluez5Adapter1Iface *iface G_GNUC_UNUSED)
{
}

/**
 * bluez5_adapter1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>.
 *
 * Returns: (transfer full) (type Bluez5Adapter1Skeleton): The skeleton object.
 */
Bluez5Adapter1 *
bluez5_adapter1_skeleton_new (void)
{
  return BLUEZ5_ADAPTER1 (g_object_new (BLUEZ5_TYPE_ADAPTER1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.Device1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5Device1
 * @title: Bluez5Device1
 * @short_description: Generated C code for the org.bluez.Device1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.Device1 ---- */

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_adapter =
{
  {
    -1,
    (gchar *) "Adapter",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "adapter",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_connected =
{
  {
    -1,
    (gchar *) "Connected",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "connected",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_services_resolved =
{
  {
    -1,
    (gchar *) "ServicesResolved",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "services-resolved",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_alias =
{
  {
    -1,
    (gchar *) "Alias",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "alias",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_address =
{
  {
    -1,
    (gchar *) "Address",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_icon =
{
  {
    -1,
    (gchar *) "Icon",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_class =
{
  {
    -1,
    (gchar *) "Class",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "class",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_device1_property_info_appearance =
{
  {
    -1,
    (gchar *) "Appearance",
    (gchar *) "q",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "appearance",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez5_device1_property_info_pointers[] =
{
  &_bluez5_device1_property_info_adapter.parent_struct,
  &_bluez5_device1_property_info_connected.parent_struct,
  &_bluez5_device1_property_info_services_resolved.parent_struct,
  &_bluez5_device1_property_info_name.parent_struct,
  &_bluez5_device1_property_info_alias.parent_struct,
  &_bluez5_device1_property_info_address.parent_struct,
  &_bluez5_device1_property_info_icon.parent_struct,
  &_bluez5_device1_property_info_class.parent_struct,
  &_bluez5_device1_property_info_appearance.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_device1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.Device1",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_bluez5_device1_property_info_pointers,
    NULL
  },
  "device1",
};


/**
 * bluez5_device1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_device1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct;
}

/**
 * bluez5_device1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5Device1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_device1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "adapter");
  g_object_class_override_property (klass, property_id_begin++, "connected");
  g_object_class_override_property (klass, property_id_begin++, "services-resolved");
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "alias");
  g_object_class_override_property (klass, property_id_begin++, "address");
  g_object_class_override_property (klass, property_id_begin++, "icon");
  g_object_class_override_property (klass, property_id_begin++, "class");
  g_object_class_override_property (klass, property_id_begin++, "appearance");
  return property_id_begin - 1;
}



/**
 * Bluez5Device1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>.
 */

/**
 * Bluez5Device1Iface:
 * @parent_iface: The parent interface.
 * @get_adapter: Getter for the #Bluez5Device1:adapter property.
 * @get_address: Getter for the #Bluez5Device1:address property.
 * @get_alias: Getter for the #Bluez5Device1:alias property.
 * @get_appearance: Getter for the #Bluez5Device1:appearance property.
 * @get_class: Getter for the #Bluez5Device1:class property.
 * @get_connected: Getter for the #Bluez5Device1:connected property.
 * @get_icon: Getter for the #Bluez5Device1:icon property.
 * @get_name: Getter for the #Bluez5Device1:name property.
 * @get_services_resolved: Getter for the #Bluez5Device1:services-resolved property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>.
 */

typedef Bluez5Device1Iface Bluez5Device1Interface;
G_DEFINE_INTERFACE (Bluez5Device1, bluez5_device1, G_TYPE_OBJECT)

static void
bluez5_device1_default_init (Bluez5Device1Iface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * Bluez5Device1:adapter:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Adapter">"Adapter"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("adapter", "Adapter", "Adapter", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:connected:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Connected">"Connected"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("connected", "Connected", "Connected", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:services-resolved:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.ServicesResolved">"ServicesResolved"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("services-resolved", "ServicesResolved", "ServicesResolved", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:alias:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Alias">"Alias"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("alias", "Alias", "Alias", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Address">"Address"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("address", "Address", "Address", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:icon:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Icon">"Icon"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon", "Icon", "Icon", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:class:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Class">"Class"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("class", "Class", "Class", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5Device1:appearance:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-Device1.Appearance">"Appearance"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("appearance", "Appearance", "Appearance", 0, G_MAXUINT16, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez5_device1_get_adapter: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_device1_dup_adapter() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_device1_get_adapter (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), NULL);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_adapter (object);
}

/**
 * bluez5_device1_dup_adapter: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-Device1.Adapter">"Adapter"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_device1_dup_adapter (Bluez5Device1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "adapter", &value, NULL);
  return value;
}

/**
 * bluez5_device1_set_adapter: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Adapter">"Adapter"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_adapter (Bluez5Device1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "adapter", value, NULL);
}

/**
 * bluez5_device1_get_connected: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Connected">"Connected"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez5_device1_get_connected (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), FALSE);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_connected (object);
}

/**
 * bluez5_device1_set_connected: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Connected">"Connected"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_connected (Bluez5Device1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "connected", value, NULL);
}

/**
 * bluez5_device1_get_services_resolved: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.ServicesResolved">"ServicesResolved"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez5_device1_get_services_resolved (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), FALSE);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_services_resolved (object);
}

/**
 * bluez5_device1_set_services_resolved: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.ServicesResolved">"ServicesResolved"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_services_resolved (Bluez5Device1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "services-resolved", value, NULL);
}

/**
 * bluez5_device1_get_name: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_device1_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_device1_get_name (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), NULL);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_name (object);
}

/**
 * bluez5_device1_dup_name: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-Device1.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_device1_dup_name (Bluez5Device1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * bluez5_device1_set_name: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_name (Bluez5Device1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * bluez5_device1_get_alias: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Alias">"Alias"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_device1_dup_alias() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_device1_get_alias (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), NULL);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_alias (object);
}

/**
 * bluez5_device1_dup_alias: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-Device1.Alias">"Alias"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_device1_dup_alias (Bluez5Device1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "alias", &value, NULL);
  return value;
}

/**
 * bluez5_device1_set_alias: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Alias">"Alias"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_alias (Bluez5Device1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "alias", value, NULL);
}

/**
 * bluez5_device1_get_address: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Address">"Address"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_device1_dup_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_device1_get_address (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), NULL);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_address (object);
}

/**
 * bluez5_device1_dup_address: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-Device1.Address">"Address"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_device1_dup_address (Bluez5Device1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "address", &value, NULL);
  return value;
}

/**
 * bluez5_device1_set_address: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Address">"Address"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_address (Bluez5Device1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "address", value, NULL);
}

/**
 * bluez5_device1_get_icon: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Icon">"Icon"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_device1_dup_icon() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_device1_get_icon (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), NULL);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_icon (object);
}

/**
 * bluez5_device1_dup_icon: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-Device1.Icon">"Icon"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_device1_dup_icon (Bluez5Device1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon", &value, NULL);
  return value;
}

/**
 * bluez5_device1_set_icon: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Icon">"Icon"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_icon (Bluez5Device1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon", value, NULL);
}

/**
 * bluez5_device1_get_class: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Class">"Class"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
bluez5_device1_get_class (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), 0);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_class (object);
}

/**
 * bluez5_device1_set_class: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Class">"Class"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_class (Bluez5Device1 *object, guint value)
{
  g_object_set (G_OBJECT (object), "class", value, NULL);
}

/**
 * bluez5_device1_get_appearance: (skip)
 * @object: A #Bluez5Device1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-Device1.Appearance">"Appearance"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint16 
bluez5_device1_get_appearance (Bluez5Device1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_DEVICE1 (object), 0);

  return BLUEZ5_DEVICE1_GET_IFACE (object)->get_appearance (object);
}

/**
 * bluez5_device1_set_appearance: (skip)
 * @object: A #Bluez5Device1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-Device1.Appearance">"Appearance"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_device1_set_appearance (Bluez5Device1 *object, guint16 value)
{
  g_object_set (G_OBJECT (object), "appearance", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5Device1Proxy:
 *
 * The #Bluez5Device1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5Device1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5Device1Proxy.
 */

struct _Bluez5Device1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_device1_proxy_iface_init (Bluez5Device1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5Device1Proxy, bluez5_device1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5Device1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_DEVICE1, bluez5_device1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5Device1Proxy, bluez5_device1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_DEVICE1, bluez5_device1_proxy_iface_init))

#endif
static void
bluez5_device1_proxy_finalize (GObject *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_device1_proxy_parent_class)->finalize (object);
}

static void
bluez5_device1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_device1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez5_device1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.Device1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez5_device1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_device1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.Device1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez5_device1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez5_device1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_DEVICE1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_DEVICE1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_device1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez5_device1_proxy_get_adapter (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Adapter");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez5_device1_proxy_get_connected (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Connected");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez5_device1_proxy_get_services_resolved (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ServicesResolved");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_device1_proxy_get_name (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_device1_proxy_get_alias (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Alias");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_device1_proxy_get_address (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Address");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_device1_proxy_get_icon (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Icon");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
bluez5_device1_proxy_get_class (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Class");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint16 
bluez5_device1_proxy_get_appearance (Bluez5Device1 *object)
{
  Bluez5Device1Proxy *proxy = BLUEZ5_DEVICE1_PROXY (object);
  GVariant *variant;
  guint16 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Appearance");
  if (variant != NULL)
    {
      value = g_variant_get_uint16 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez5_device1_proxy_init (Bluez5Device1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_device1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_DEVICE1_PROXY, Bluez5Device1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_device1_interface_info ());
}

static void
bluez5_device1_proxy_class_init (Bluez5Device1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_device1_proxy_finalize;
  gobject_class->get_property = bluez5_device1_proxy_get_property;
  gobject_class->set_property = bluez5_device1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_device1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_device1_proxy_g_properties_changed;

  bluez5_device1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5Device1ProxyPrivate));
#endif
}

static void
bluez5_device1_proxy_iface_init (Bluez5Device1Iface *iface)
{
  iface->get_adapter = bluez5_device1_proxy_get_adapter;
  iface->get_connected = bluez5_device1_proxy_get_connected;
  iface->get_services_resolved = bluez5_device1_proxy_get_services_resolved;
  iface->get_name = bluez5_device1_proxy_get_name;
  iface->get_alias = bluez5_device1_proxy_get_alias;
  iface->get_address = bluez5_device1_proxy_get_address;
  iface->get_icon = bluez5_device1_proxy_get_icon;
  iface->get_class = bluez5_device1_proxy_get_class;
  iface->get_appearance = bluez5_device1_proxy_get_appearance;
}

/**
 * bluez5_device1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_device1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_device1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_device1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_DEVICE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Device1", NULL);
}

/**
 * bluez5_device1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_device1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_device1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5Device1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Device1 *
bluez5_device1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_DEVICE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_device1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_device1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5Device1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Device1 *
bluez5_device1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_DEVICE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Device1", NULL);
  if (ret != NULL)
    return BLUEZ5_DEVICE1 (ret);
  else
    return NULL;
}


/**
 * bluez5_device1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_device1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_device1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_device1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_device1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_DEVICE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Device1", NULL);
}

/**
 * bluez5_device1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_device1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_device1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5Device1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Device1 *
bluez5_device1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_DEVICE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_device1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_device1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_device1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5Device1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5Device1 *
bluez5_device1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_DEVICE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Device1", NULL);
  if (ret != NULL)
    return BLUEZ5_DEVICE1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5Device1Skeleton:
 *
 * The #Bluez5Device1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5Device1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5Device1Skeleton.
 */

struct _Bluez5Device1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_device1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_DEVICE1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_DEVICE1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_device1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_device1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_device1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_device1_skeleton_vtable =
{
  _bluez5_device1_skeleton_handle_method_call,
  _bluez5_device1_skeleton_handle_get_property,
  _bluez5_device1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_device1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_device1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_device1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_device1_skeleton_vtable;
}

static GVariant *
bluez5_device1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_device1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_device1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_device1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_device1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Device1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez5_device1_emit_changed (gpointer user_data);

static void
bluez5_device1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez5_device1_emit_changed (skeleton);
}

static void bluez5_device1_skeleton_iface_init (Bluez5Device1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5Device1Skeleton, bluez5_device1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5Device1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_DEVICE1, bluez5_device1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5Device1Skeleton, bluez5_device1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_DEVICE1, bluez5_device1_skeleton_iface_init))

#endif
static void
bluez5_device1_skeleton_finalize (GObject *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_device1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_device1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez5_device1_emit_changed (gpointer user_data)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.Device1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez5_device1_schedule_emit_changed (Bluez5Device1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez5_device1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez5_device1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez5_device1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez5_device1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_device1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez5_device1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez5_device1_skeleton_init (Bluez5Device1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_device1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_DEVICE1_SKELETON, Bluez5Device1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT);
}

static const gchar *
bluez5_device1_skeleton_get_adapter (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez5_device1_skeleton_get_connected (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez5_device1_skeleton_get_services_resolved (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_device1_skeleton_get_name (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_device1_skeleton_get_alias (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_device1_skeleton_get_address (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_device1_skeleton_get_icon (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
bluez5_device1_skeleton_get_class (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint16 
bluez5_device1_skeleton_get_appearance (Bluez5Device1 *object)
{
  Bluez5Device1Skeleton *skeleton = BLUEZ5_DEVICE1_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez5_device1_skeleton_class_init (Bluez5Device1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_device1_skeleton_finalize;
  gobject_class->get_property = bluez5_device1_skeleton_get_property;
  gobject_class->set_property = bluez5_device1_skeleton_set_property;
  gobject_class->notify       = bluez5_device1_skeleton_notify;


  bluez5_device1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_device1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_device1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_device1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_device1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5Device1SkeletonPrivate));
#endif
}

static void
bluez5_device1_skeleton_iface_init (Bluez5Device1Iface *iface)
{
  iface->get_adapter = bluez5_device1_skeleton_get_adapter;
  iface->get_connected = bluez5_device1_skeleton_get_connected;
  iface->get_services_resolved = bluez5_device1_skeleton_get_services_resolved;
  iface->get_name = bluez5_device1_skeleton_get_name;
  iface->get_alias = bluez5_device1_skeleton_get_alias;
  iface->get_address = bluez5_device1_skeleton_get_address;
  iface->get_icon = bluez5_device1_skeleton_get_icon;
  iface->get_class = bluez5_device1_skeleton_get_class;
  iface->get_appearance = bluez5_device1_skeleton_get_appearance;
}

/**
 * bluez5_device1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>.
 *
 * Returns: (transfer full) (type Bluez5Device1Skeleton): The skeleton object.
 */
Bluez5Device1 *
bluez5_device1_skeleton_new (void)
{
  return BLUEZ5_DEVICE1 (g_object_new (BLUEZ5_TYPE_DEVICE1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.GattManager1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5GattManager1
 * @title: Bluez5GattManager1
 * @short_description: Generated C code for the org.bluez.GattManager1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.GattManager1 ---- */

static const _ExtendedGDBusArgInfo _bluez5_gatt_manager1_method_info_register_application_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_manager1_method_info_register_application_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_manager1_method_info_register_application_IN_ARG_pointers[] =
{
  &_bluez5_gatt_manager1_method_info_register_application_IN_ARG_path.parent_struct,
  &_bluez5_gatt_manager1_method_info_register_application_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_gatt_manager1_method_info_register_application =
{
  {
    -1,
    (gchar *) "RegisterApplication",
    (GDBusArgInfo **) &_bluez5_gatt_manager1_method_info_register_application_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-application",
  FALSE
};

static const GDBusMethodInfo * const _bluez5_gatt_manager1_method_info_pointers[] =
{
  &_bluez5_gatt_manager1_method_info_register_application.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_gatt_manager1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.GattManager1",
    (GDBusMethodInfo **) &_bluez5_gatt_manager1_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "gatt-manager1",
};


/**
 * bluez5_gatt_manager1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_gatt_manager1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct;
}

/**
 * bluez5_gatt_manager1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5GattManager1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_gatt_manager1_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
bluez5_gatt_manager1_method_marshal_register_application (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Bluez5GattManager1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>.
 */

/**
 * Bluez5GattManager1Iface:
 * @parent_iface: The parent interface.
 * @handle_register_application: Handler for the #Bluez5GattManager1::handle-register-application signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>.
 */

typedef Bluez5GattManager1Iface Bluez5GattManager1Interface;
G_DEFINE_INTERFACE (Bluez5GattManager1, bluez5_gatt_manager1, G_TYPE_OBJECT)

static void
bluez5_gatt_manager1_default_init (Bluez5GattManager1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Bluez5GattManager1::handle-register-application:
   * @object: A #Bluez5GattManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattManager1.RegisterApplication">RegisterApplication()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_manager1_complete_register_application() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-application",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattManager1Iface, handle_register_application),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_manager1_method_marshal_register_application,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * bluez5_gatt_manager1_call_register_application:
 * @proxy: A #Bluez5GattManager1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattManager1.RegisterApplication">RegisterApplication()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_manager1_call_register_application_finish() to get the result of the operation.
 *
 * See bluez5_gatt_manager1_call_register_application_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_manager1_call_register_application (
    Bluez5GattManager1 *proxy,
    const gchar *arg_path,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterApplication",
    g_variant_new ("(o@a{sv})",
                   arg_path,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_manager1_call_register_application_finish:
 * @proxy: A #Bluez5GattManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_manager1_call_register_application().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_manager1_call_register_application().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_manager1_call_register_application_finish (
    Bluez5GattManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_manager1_call_register_application_sync:
 * @proxy: A #Bluez5GattManager1Proxy.
 * @arg_path: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattManager1.RegisterApplication">RegisterApplication()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_manager1_call_register_application() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_manager1_call_register_application_sync (
    Bluez5GattManager1 *proxy,
    const gchar *arg_path,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterApplication",
    g_variant_new ("(o@a{sv})",
                   arg_path,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_manager1_complete_register_application:
 * @object: A #Bluez5GattManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattManager1.RegisterApplication">RegisterApplication()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_manager1_complete_register_application (
    Bluez5GattManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattManager1Proxy:
 *
 * The #Bluez5GattManager1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattManager1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattManager1Proxy.
 */

struct _Bluez5GattManager1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_gatt_manager1_proxy_iface_init (Bluez5GattManager1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattManager1Proxy, bluez5_gatt_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5GattManager1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_MANAGER1, bluez5_gatt_manager1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattManager1Proxy, bluez5_gatt_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_MANAGER1, bluez5_gatt_manager1_proxy_iface_init))

#endif
static void
bluez5_gatt_manager1_proxy_finalize (GObject *object)
{
  Bluez5GattManager1Proxy *proxy = BLUEZ5_GATT_MANAGER1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_gatt_manager1_proxy_parent_class)->finalize (object);
}

static void
bluez5_gatt_manager1_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
bluez5_gatt_manager1_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
bluez5_gatt_manager1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_GATT_MANAGER1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_MANAGER1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_gatt_manager1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5GattManager1Proxy *proxy = BLUEZ5_GATT_MANAGER1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
bluez5_gatt_manager1_proxy_init (Bluez5GattManager1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_gatt_manager1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_GATT_MANAGER1_PROXY, Bluez5GattManager1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_gatt_manager1_interface_info ());
}

static void
bluez5_gatt_manager1_proxy_class_init (Bluez5GattManager1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_gatt_manager1_proxy_finalize;
  gobject_class->get_property = bluez5_gatt_manager1_proxy_get_property;
  gobject_class->set_property = bluez5_gatt_manager1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_gatt_manager1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_gatt_manager1_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattManager1ProxyPrivate));
#endif
}

static void
bluez5_gatt_manager1_proxy_iface_init (Bluez5GattManager1Iface *iface G_GNUC_UNUSED)
{
}

/**
 * bluez5_gatt_manager1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_manager1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_gatt_manager1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_manager1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattManager1", NULL);
}

/**
 * bluez5_gatt_manager1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_manager1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_manager1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5GattManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattManager1 *
bluez5_gatt_manager1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_manager1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_manager1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattManager1 *
bluez5_gatt_manager1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattManager1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_MANAGER1 (ret);
  else
    return NULL;
}


/**
 * bluez5_gatt_manager1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_gatt_manager1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_manager1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_gatt_manager1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_manager1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattManager1", NULL);
}

/**
 * bluez5_gatt_manager1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_manager1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_manager1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5GattManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattManager1 *
bluez5_gatt_manager1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_manager1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_gatt_manager1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_manager1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattManager1 *
bluez5_gatt_manager1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattManager1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_MANAGER1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattManager1Skeleton:
 *
 * The #Bluez5GattManager1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattManager1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattManager1Skeleton.
 */

struct _Bluez5GattManager1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_gatt_manager1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5GattManager1Skeleton *skeleton = BLUEZ5_GATT_MANAGER1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_GATT_MANAGER1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_MANAGER1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_gatt_manager1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5GattManager1Skeleton *skeleton = BLUEZ5_GATT_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_gatt_manager1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5GattManager1Skeleton *skeleton = BLUEZ5_GATT_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_gatt_manager1_skeleton_vtable =
{
  _bluez5_gatt_manager1_skeleton_handle_method_call,
  _bluez5_gatt_manager1_skeleton_handle_get_property,
  _bluez5_gatt_manager1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_gatt_manager1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_gatt_manager1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_gatt_manager1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_gatt_manager1_skeleton_vtable;
}

static GVariant *
bluez5_gatt_manager1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattManager1Skeleton *skeleton = BLUEZ5_GATT_MANAGER1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_gatt_manager1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_gatt_manager1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_gatt_manager1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_gatt_manager1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.GattManager1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
bluez5_gatt_manager1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void bluez5_gatt_manager1_skeleton_iface_init (Bluez5GattManager1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattManager1Skeleton, bluez5_gatt_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5GattManager1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_MANAGER1, bluez5_gatt_manager1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattManager1Skeleton, bluez5_gatt_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_MANAGER1, bluez5_gatt_manager1_skeleton_iface_init))

#endif
static void
bluez5_gatt_manager1_skeleton_finalize (GObject *object)
{
  Bluez5GattManager1Skeleton *skeleton = BLUEZ5_GATT_MANAGER1_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_gatt_manager1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_gatt_manager1_skeleton_init (Bluez5GattManager1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_gatt_manager1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_GATT_MANAGER1_SKELETON, Bluez5GattManager1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
bluez5_gatt_manager1_skeleton_class_init (Bluez5GattManager1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_gatt_manager1_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_gatt_manager1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_gatt_manager1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_gatt_manager1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_gatt_manager1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattManager1SkeletonPrivate));
#endif
}

static void
bluez5_gatt_manager1_skeleton_iface_init (Bluez5GattManager1Iface *iface G_GNUC_UNUSED)
{
}

/**
 * bluez5_gatt_manager1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>.
 *
 * Returns: (transfer full) (type Bluez5GattManager1Skeleton): The skeleton object.
 */
Bluez5GattManager1 *
bluez5_gatt_manager1_skeleton_new (void)
{
  return BLUEZ5_GATT_MANAGER1 (g_object_new (BLUEZ5_TYPE_GATT_MANAGER1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.GattProfile1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5GattProfile1
 * @title: Bluez5GattProfile1
 * @short_description: Generated C code for the org.bluez.GattProfile1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.GattProfile1 ---- */

static const _ExtendedGDBusMethodInfo _bluez5_gatt_profile1_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const GDBusMethodInfo * const _bluez5_gatt_profile1_method_info_pointers[] =
{
  &_bluez5_gatt_profile1_method_info_release.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_profile1_property_info_uuids =
{
  {
    -1,
    (gchar *) "UUIDs",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuids",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez5_gatt_profile1_property_info_pointers[] =
{
  &_bluez5_gatt_profile1_property_info_uuids.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_gatt_profile1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.GattProfile1",
    (GDBusMethodInfo **) &_bluez5_gatt_profile1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_bluez5_gatt_profile1_property_info_pointers,
    NULL
  },
  "gatt-profile1",
};


/**
 * bluez5_gatt_profile1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_gatt_profile1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct;
}

/**
 * bluez5_gatt_profile1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5GattProfile1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_gatt_profile1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "uuids");
  return property_id_begin - 1;
}


inline static void
bluez5_gatt_profile1_method_marshal_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Bluez5GattProfile1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>.
 */

/**
 * Bluez5GattProfile1Iface:
 * @parent_iface: The parent interface.
 * @handle_release: Handler for the #Bluez5GattProfile1::handle-release signal.
 * @get_uuids: Getter for the #Bluez5GattProfile1:uuids property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>.
 */

typedef Bluez5GattProfile1Iface Bluez5GattProfile1Interface;
G_DEFINE_INTERFACE (Bluez5GattProfile1, bluez5_gatt_profile1, G_TYPE_OBJECT)

static void
bluez5_gatt_profile1_default_init (Bluez5GattProfile1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Bluez5GattProfile1::handle-release:
   * @object: A #Bluez5GattProfile1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattProfile1.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_profile1_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattProfile1Iface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_profile1_method_marshal_release,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * Bluez5GattProfile1:uuids:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattProfile1.UUIDs">"UUIDs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("uuids", "UUIDs", "UUIDs", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez5_gatt_profile1_get_uuids: (skip)
 * @object: A #Bluez5GattProfile1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattProfile1.UUIDs">"UUIDs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_profile1_dup_uuids() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
bluez5_gatt_profile1_get_uuids (Bluez5GattProfile1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_PROFILE1 (object), NULL);

  return BLUEZ5_GATT_PROFILE1_GET_IFACE (object)->get_uuids (object);
}

/**
 * bluez5_gatt_profile1_dup_uuids: (skip)
 * @object: A #Bluez5GattProfile1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattProfile1.UUIDs">"UUIDs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
bluez5_gatt_profile1_dup_uuids (Bluez5GattProfile1 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "uuids", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_profile1_set_uuids: (skip)
 * @object: A #Bluez5GattProfile1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattProfile1.UUIDs">"UUIDs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_profile1_set_uuids (Bluez5GattProfile1 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "uuids", value, NULL);
}

/**
 * bluez5_gatt_profile1_call_release:
 * @proxy: A #Bluez5GattProfile1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattProfile1.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_profile1_call_release_finish() to get the result of the operation.
 *
 * See bluez5_gatt_profile1_call_release_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_profile1_call_release (
    Bluez5GattProfile1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_profile1_call_release_finish:
 * @proxy: A #Bluez5GattProfile1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_profile1_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_profile1_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_profile1_call_release_finish (
    Bluez5GattProfile1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_profile1_call_release_sync:
 * @proxy: A #Bluez5GattProfile1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattProfile1.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_profile1_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_profile1_call_release_sync (
    Bluez5GattProfile1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_profile1_complete_release:
 * @object: A #Bluez5GattProfile1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattProfile1.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_profile1_complete_release (
    Bluez5GattProfile1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattProfile1Proxy:
 *
 * The #Bluez5GattProfile1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattProfile1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattProfile1Proxy.
 */

struct _Bluez5GattProfile1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_gatt_profile1_proxy_iface_init (Bluez5GattProfile1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattProfile1Proxy, bluez5_gatt_profile1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5GattProfile1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_PROFILE1, bluez5_gatt_profile1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattProfile1Proxy, bluez5_gatt_profile1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_PROFILE1, bluez5_gatt_profile1_proxy_iface_init))

#endif
static void
bluez5_gatt_profile1_proxy_finalize (GObject *object)
{
  Bluez5GattProfile1Proxy *proxy = BLUEZ5_GATT_PROFILE1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_gatt_profile1_proxy_parent_class)->finalize (object);
}

static void
bluez5_gatt_profile1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_profile1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez5_gatt_profile1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.GattProfile1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez5_gatt_profile1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_profile1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.GattProfile1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez5_gatt_profile1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez5_gatt_profile1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_GATT_PROFILE1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_PROFILE1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_gatt_profile1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5GattProfile1Proxy *proxy = BLUEZ5_GATT_PROFILE1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
bluez5_gatt_profile1_proxy_get_uuids (Bluez5GattProfile1 *object)
{
  Bluez5GattProfile1Proxy *proxy = BLUEZ5_GATT_PROFILE1_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "UUIDs");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUIDs");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "UUIDs", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez5_gatt_profile1_proxy_init (Bluez5GattProfile1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_gatt_profile1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_GATT_PROFILE1_PROXY, Bluez5GattProfile1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_gatt_profile1_interface_info ());
}

static void
bluez5_gatt_profile1_proxy_class_init (Bluez5GattProfile1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_gatt_profile1_proxy_finalize;
  gobject_class->get_property = bluez5_gatt_profile1_proxy_get_property;
  gobject_class->set_property = bluez5_gatt_profile1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_gatt_profile1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_gatt_profile1_proxy_g_properties_changed;

  bluez5_gatt_profile1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattProfile1ProxyPrivate));
#endif
}

static void
bluez5_gatt_profile1_proxy_iface_init (Bluez5GattProfile1Iface *iface)
{
  iface->get_uuids = bluez5_gatt_profile1_proxy_get_uuids;
}

/**
 * bluez5_gatt_profile1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_profile1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_gatt_profile1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_profile1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_PROFILE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattProfile1", NULL);
}

/**
 * bluez5_gatt_profile1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_profile1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_profile1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5GattProfile1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattProfile1 *
bluez5_gatt_profile1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_PROFILE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_profile1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_profile1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattProfile1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattProfile1 *
bluez5_gatt_profile1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_PROFILE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattProfile1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_PROFILE1 (ret);
  else
    return NULL;
}


/**
 * bluez5_gatt_profile1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_gatt_profile1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_profile1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_gatt_profile1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_profile1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_PROFILE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattProfile1", NULL);
}

/**
 * bluez5_gatt_profile1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_profile1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_profile1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5GattProfile1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattProfile1 *
bluez5_gatt_profile1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_PROFILE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_profile1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_gatt_profile1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_profile1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattProfile1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattProfile1 *
bluez5_gatt_profile1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_PROFILE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattProfile1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_PROFILE1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattProfile1Skeleton:
 *
 * The #Bluez5GattProfile1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattProfile1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattProfile1Skeleton.
 */

struct _Bluez5GattProfile1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_gatt_profile1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_GATT_PROFILE1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_PROFILE1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_gatt_profile1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_gatt_profile1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_profile1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_gatt_profile1_skeleton_vtable =
{
  _bluez5_gatt_profile1_skeleton_handle_method_call,
  _bluez5_gatt_profile1_skeleton_handle_get_property,
  _bluez5_gatt_profile1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_gatt_profile1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_gatt_profile1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_gatt_profile1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_gatt_profile1_skeleton_vtable;
}

static GVariant *
bluez5_gatt_profile1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_gatt_profile1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_gatt_profile1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_gatt_profile1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_gatt_profile1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.GattProfile1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez5_gatt_profile1_emit_changed (gpointer user_data);

static void
bluez5_gatt_profile1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez5_gatt_profile1_emit_changed (skeleton);
}

static void bluez5_gatt_profile1_skeleton_iface_init (Bluez5GattProfile1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattProfile1Skeleton, bluez5_gatt_profile1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5GattProfile1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_PROFILE1, bluez5_gatt_profile1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattProfile1Skeleton, bluez5_gatt_profile1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_PROFILE1, bluez5_gatt_profile1_skeleton_iface_init))

#endif
static void
bluez5_gatt_profile1_skeleton_finalize (GObject *object)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_gatt_profile1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_gatt_profile1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez5_gatt_profile1_emit_changed (gpointer user_data)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.GattProfile1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez5_gatt_profile1_schedule_emit_changed (Bluez5GattProfile1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez5_gatt_profile1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez5_gatt_profile1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez5_gatt_profile1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez5_gatt_profile1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_profile1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez5_gatt_profile1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez5_gatt_profile1_skeleton_init (Bluez5GattProfile1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_gatt_profile1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_GATT_PROFILE1_SKELETON, Bluez5GattProfile1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
}

static const gchar *const *
bluez5_gatt_profile1_skeleton_get_uuids (Bluez5GattProfile1 *object)
{
  Bluez5GattProfile1Skeleton *skeleton = BLUEZ5_GATT_PROFILE1_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez5_gatt_profile1_skeleton_class_init (Bluez5GattProfile1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_gatt_profile1_skeleton_finalize;
  gobject_class->get_property = bluez5_gatt_profile1_skeleton_get_property;
  gobject_class->set_property = bluez5_gatt_profile1_skeleton_set_property;
  gobject_class->notify       = bluez5_gatt_profile1_skeleton_notify;


  bluez5_gatt_profile1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_gatt_profile1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_gatt_profile1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_gatt_profile1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_gatt_profile1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattProfile1SkeletonPrivate));
#endif
}

static void
bluez5_gatt_profile1_skeleton_iface_init (Bluez5GattProfile1Iface *iface)
{
  iface->get_uuids = bluez5_gatt_profile1_skeleton_get_uuids;
}

/**
 * bluez5_gatt_profile1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>.
 *
 * Returns: (transfer full) (type Bluez5GattProfile1Skeleton): The skeleton object.
 */
Bluez5GattProfile1 *
bluez5_gatt_profile1_skeleton_new (void)
{
  return BLUEZ5_GATT_PROFILE1 (g_object_new (BLUEZ5_TYPE_GATT_PROFILE1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.GattService1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5GattService1
 * @title: Bluez5GattService1
 * @short_description: Generated C code for the org.bluez.GattService1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.GattService1 ---- */

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_service1_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_service1_property_info_primary =
{
  {
    -1,
    (gchar *) "Primary",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_service1_property_info_device =
{
  {
    -1,
    (gchar *) "Device",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez5_gatt_service1_property_info_pointers[] =
{
  &_bluez5_gatt_service1_property_info_uuid.parent_struct,
  &_bluez5_gatt_service1_property_info_primary.parent_struct,
  &_bluez5_gatt_service1_property_info_device.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_gatt_service1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.GattService1",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_bluez5_gatt_service1_property_info_pointers,
    NULL
  },
  "gatt-service1",
};


/**
 * bluez5_gatt_service1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_gatt_service1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct;
}

/**
 * bluez5_gatt_service1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5GattService1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_gatt_service1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "primary");
  g_object_class_override_property (klass, property_id_begin++, "device");
  return property_id_begin - 1;
}



/**
 * Bluez5GattService1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>.
 */

/**
 * Bluez5GattService1Iface:
 * @parent_iface: The parent interface.
 * @get_device: Getter for the #Bluez5GattService1:device property.
 * @get_primary: Getter for the #Bluez5GattService1:primary property.
 * @get_uuid: Getter for the #Bluez5GattService1:uuid property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>.
 */

typedef Bluez5GattService1Iface Bluez5GattService1Interface;
G_DEFINE_INTERFACE (Bluez5GattService1, bluez5_gatt_service1, G_TYPE_OBJECT)

static void
bluez5_gatt_service1_default_init (Bluez5GattService1Iface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * Bluez5GattService1:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattService1.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattService1:primary:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattService1.Primary">"Primary"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("primary", "Primary", "Primary", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattService1:device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattService1.Device">"Device"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device", "Device", "Device", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez5_gatt_service1_get_uuid: (skip)
 * @object: A #Bluez5GattService1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattService1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_service1_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_service1_get_uuid (Bluez5GattService1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_SERVICE1 (object), NULL);

  return BLUEZ5_GATT_SERVICE1_GET_IFACE (object)->get_uuid (object);
}

/**
 * bluez5_gatt_service1_dup_uuid: (skip)
 * @object: A #Bluez5GattService1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattService1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_service1_dup_uuid (Bluez5GattService1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_service1_set_uuid: (skip)
 * @object: A #Bluez5GattService1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattService1.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_service1_set_uuid (Bluez5GattService1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * bluez5_gatt_service1_get_primary: (skip)
 * @object: A #Bluez5GattService1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattService1.Primary">"Primary"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez5_gatt_service1_get_primary (Bluez5GattService1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_SERVICE1 (object), FALSE);

  return BLUEZ5_GATT_SERVICE1_GET_IFACE (object)->get_primary (object);
}

/**
 * bluez5_gatt_service1_set_primary: (skip)
 * @object: A #Bluez5GattService1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattService1.Primary">"Primary"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_service1_set_primary (Bluez5GattService1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "primary", value, NULL);
}

/**
 * bluez5_gatt_service1_get_device: (skip)
 * @object: A #Bluez5GattService1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattService1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_service1_dup_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_service1_get_device (Bluez5GattService1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_SERVICE1 (object), NULL);

  return BLUEZ5_GATT_SERVICE1_GET_IFACE (object)->get_device (object);
}

/**
 * bluez5_gatt_service1_dup_device: (skip)
 * @object: A #Bluez5GattService1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattService1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_service1_dup_device (Bluez5GattService1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_service1_set_device: (skip)
 * @object: A #Bluez5GattService1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattService1.Device">"Device"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_service1_set_device (Bluez5GattService1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattService1Proxy:
 *
 * The #Bluez5GattService1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattService1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattService1Proxy.
 */

struct _Bluez5GattService1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_gatt_service1_proxy_iface_init (Bluez5GattService1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattService1Proxy, bluez5_gatt_service1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5GattService1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_SERVICE1, bluez5_gatt_service1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattService1Proxy, bluez5_gatt_service1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_SERVICE1, bluez5_gatt_service1_proxy_iface_init))

#endif
static void
bluez5_gatt_service1_proxy_finalize (GObject *object)
{
  Bluez5GattService1Proxy *proxy = BLUEZ5_GATT_SERVICE1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_gatt_service1_proxy_parent_class)->finalize (object);
}

static void
bluez5_gatt_service1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_service1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez5_gatt_service1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.GattService1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez5_gatt_service1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_service1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.GattService1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez5_gatt_service1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez5_gatt_service1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_GATT_SERVICE1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_SERVICE1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_gatt_service1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5GattService1Proxy *proxy = BLUEZ5_GATT_SERVICE1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez5_gatt_service1_proxy_get_uuid (Bluez5GattService1 *object)
{
  Bluez5GattService1Proxy *proxy = BLUEZ5_GATT_SERVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez5_gatt_service1_proxy_get_primary (Bluez5GattService1 *object)
{
  Bluez5GattService1Proxy *proxy = BLUEZ5_GATT_SERVICE1_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Primary");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_gatt_service1_proxy_get_device (Bluez5GattService1 *object)
{
  Bluez5GattService1Proxy *proxy = BLUEZ5_GATT_SERVICE1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Device");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez5_gatt_service1_proxy_init (Bluez5GattService1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_gatt_service1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_GATT_SERVICE1_PROXY, Bluez5GattService1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_gatt_service1_interface_info ());
}

static void
bluez5_gatt_service1_proxy_class_init (Bluez5GattService1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_gatt_service1_proxy_finalize;
  gobject_class->get_property = bluez5_gatt_service1_proxy_get_property;
  gobject_class->set_property = bluez5_gatt_service1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_gatt_service1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_gatt_service1_proxy_g_properties_changed;

  bluez5_gatt_service1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattService1ProxyPrivate));
#endif
}

static void
bluez5_gatt_service1_proxy_iface_init (Bluez5GattService1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_service1_proxy_get_uuid;
  iface->get_primary = bluez5_gatt_service1_proxy_get_primary;
  iface->get_device = bluez5_gatt_service1_proxy_get_device;
}

/**
 * bluez5_gatt_service1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_service1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_gatt_service1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_service1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_SERVICE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattService1", NULL);
}

/**
 * bluez5_gatt_service1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_service1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_service1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5GattService1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattService1 *
bluez5_gatt_service1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_SERVICE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_service1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_service1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattService1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattService1 *
bluez5_gatt_service1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_SERVICE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattService1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_SERVICE1 (ret);
  else
    return NULL;
}


/**
 * bluez5_gatt_service1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_gatt_service1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_service1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_gatt_service1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_service1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_SERVICE1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattService1", NULL);
}

/**
 * bluez5_gatt_service1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_service1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_service1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5GattService1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattService1 *
bluez5_gatt_service1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_SERVICE1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_service1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_gatt_service1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_service1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattService1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattService1 *
bluez5_gatt_service1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_SERVICE1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattService1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_SERVICE1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattService1Skeleton:
 *
 * The #Bluez5GattService1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattService1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattService1Skeleton.
 */

struct _Bluez5GattService1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_gatt_service1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_GATT_SERVICE1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_SERVICE1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_gatt_service1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_gatt_service1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_service1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_gatt_service1_skeleton_vtable =
{
  _bluez5_gatt_service1_skeleton_handle_method_call,
  _bluez5_gatt_service1_skeleton_handle_get_property,
  _bluez5_gatt_service1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_gatt_service1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_gatt_service1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_gatt_service1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_gatt_service1_skeleton_vtable;
}

static GVariant *
bluez5_gatt_service1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_gatt_service1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_gatt_service1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_gatt_service1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_gatt_service1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.GattService1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez5_gatt_service1_emit_changed (gpointer user_data);

static void
bluez5_gatt_service1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez5_gatt_service1_emit_changed (skeleton);
}

static void bluez5_gatt_service1_skeleton_iface_init (Bluez5GattService1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattService1Skeleton, bluez5_gatt_service1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5GattService1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_SERVICE1, bluez5_gatt_service1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattService1Skeleton, bluez5_gatt_service1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_SERVICE1, bluez5_gatt_service1_skeleton_iface_init))

#endif
static void
bluez5_gatt_service1_skeleton_finalize (GObject *object)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_gatt_service1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_gatt_service1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez5_gatt_service1_emit_changed (gpointer user_data)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.GattService1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez5_gatt_service1_schedule_emit_changed (Bluez5GattService1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez5_gatt_service1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez5_gatt_service1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez5_gatt_service1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez5_gatt_service1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_service1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez5_gatt_service1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez5_gatt_service1_skeleton_init (Bluez5GattService1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_gatt_service1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_GATT_SERVICE1_SKELETON, Bluez5GattService1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static const gchar *
bluez5_gatt_service1_skeleton_get_uuid (Bluez5GattService1 *object)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez5_gatt_service1_skeleton_get_primary (Bluez5GattService1 *object)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_gatt_service1_skeleton_get_device (Bluez5GattService1 *object)
{
  Bluez5GattService1Skeleton *skeleton = BLUEZ5_GATT_SERVICE1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez5_gatt_service1_skeleton_class_init (Bluez5GattService1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_gatt_service1_skeleton_finalize;
  gobject_class->get_property = bluez5_gatt_service1_skeleton_get_property;
  gobject_class->set_property = bluez5_gatt_service1_skeleton_set_property;
  gobject_class->notify       = bluez5_gatt_service1_skeleton_notify;


  bluez5_gatt_service1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_gatt_service1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_gatt_service1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_gatt_service1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_gatt_service1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattService1SkeletonPrivate));
#endif
}

static void
bluez5_gatt_service1_skeleton_iface_init (Bluez5GattService1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_service1_skeleton_get_uuid;
  iface->get_primary = bluez5_gatt_service1_skeleton_get_primary;
  iface->get_device = bluez5_gatt_service1_skeleton_get_device;
}

/**
 * bluez5_gatt_service1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>.
 *
 * Returns: (transfer full) (type Bluez5GattService1Skeleton): The skeleton object.
 */
Bluez5GattService1 *
bluez5_gatt_service1_skeleton_new (void)
{
  return BLUEZ5_GATT_SERVICE1 (g_object_new (BLUEZ5_TYPE_GATT_SERVICE1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.GattCharacteristic1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5GattCharacteristic1
 * @title: Bluez5GattCharacteristic1
 * @short_description: Generated C code for the org.bluez.GattCharacteristic1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.GattCharacteristic1 ---- */

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_read_value_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_read_value_IN_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_read_value_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_read_value_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_read_value_OUT_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_read_value_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_gatt_characteristic1_method_info_read_value =
{
  {
    -1,
    (gchar *) "ReadValue",
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_read_value_IN_ARG_pointers,
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_read_value_OUT_ARG_pointers,
    NULL
  },
  "handle-read-value",
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_notify_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_acquire_notify_IN_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_acquire_notify_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_mtu =
{
  {
    -1,
    (gchar *) "mtu",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_fd.parent_struct,
  &_bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_mtu.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_gatt_characteristic1_method_info_acquire_notify =
{
  {
    -1,
    (gchar *) "AcquireNotify",
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_acquire_notify_IN_ARG_pointers,
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_acquire_notify_OUT_ARG_pointers,
    NULL
  },
  "handle-acquire-notify",
  TRUE
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_write_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_acquire_write_IN_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_acquire_write_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_mtu =
{
  {
    -1,
    (gchar *) "mtu",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_fd.parent_struct,
  &_bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_mtu.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_gatt_characteristic1_method_info_acquire_write =
{
  {
    -1,
    (gchar *) "AcquireWrite",
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_acquire_write_IN_ARG_pointers,
    (GDBusArgInfo **) &_bluez5_gatt_characteristic1_method_info_acquire_write_OUT_ARG_pointers,
    NULL
  },
  "handle-acquire-write",
  TRUE
};

static const GDBusMethodInfo * const _bluez5_gatt_characteristic1_method_info_pointers[] =
{
  &_bluez5_gatt_characteristic1_method_info_read_value.parent_struct,
  &_bluez5_gatt_characteristic1_method_info_acquire_notify.parent_struct,
  &_bluez5_gatt_characteristic1_method_info_acquire_write.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_characteristic1_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_characteristic1_property_info_service =
{
  {
    -1,
    (gchar *) "Service",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "service",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_characteristic1_property_info_write_acquired =
{
  {
    -1,
    (gchar *) "WriteAcquired",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "write-acquired",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_characteristic1_property_info_notify_acquired =
{
  {
    -1,
    (gchar *) "NotifyAcquired",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "notify-acquired",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_characteristic1_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez5_gatt_characteristic1_property_info_pointers[] =
{
  &_bluez5_gatt_characteristic1_property_info_uuid.parent_struct,
  &_bluez5_gatt_characteristic1_property_info_service.parent_struct,
  &_bluez5_gatt_characteristic1_property_info_write_acquired.parent_struct,
  &_bluez5_gatt_characteristic1_property_info_notify_acquired.parent_struct,
  &_bluez5_gatt_characteristic1_property_info_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_gatt_characteristic1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.GattCharacteristic1",
    (GDBusMethodInfo **) &_bluez5_gatt_characteristic1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_bluez5_gatt_characteristic1_property_info_pointers,
    NULL
  },
  "gatt-characteristic1",
};


/**
 * bluez5_gatt_characteristic1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_gatt_characteristic1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct;
}

/**
 * bluez5_gatt_characteristic1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5GattCharacteristic1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_gatt_characteristic1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "service");
  g_object_class_override_property (klass, property_id_begin++, "write-acquired");
  g_object_class_override_property (klass, property_id_begin++, "notify-acquired");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  return property_id_begin - 1;
}


inline static void
bluez5_gatt_characteristic1_method_marshal_read_value (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
bluez5_gatt_characteristic1_method_marshal_acquire_notify (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
bluez5_gatt_characteristic1_method_marshal_acquire_write (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Bluez5GattCharacteristic1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>.
 */

/**
 * Bluez5GattCharacteristic1Iface:
 * @parent_iface: The parent interface.
 * @handle_acquire_notify: Handler for the #Bluez5GattCharacteristic1::handle-acquire-notify signal.
 * @handle_acquire_write: Handler for the #Bluez5GattCharacteristic1::handle-acquire-write signal.
 * @handle_read_value: Handler for the #Bluez5GattCharacteristic1::handle-read-value signal.
 * @get_flags: Getter for the #Bluez5GattCharacteristic1:flags property.
 * @get_notify_acquired: Getter for the #Bluez5GattCharacteristic1:notify-acquired property.
 * @get_service: Getter for the #Bluez5GattCharacteristic1:service property.
 * @get_uuid: Getter for the #Bluez5GattCharacteristic1:uuid property.
 * @get_write_acquired: Getter for the #Bluez5GattCharacteristic1:write-acquired property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>.
 */

typedef Bluez5GattCharacteristic1Iface Bluez5GattCharacteristic1Interface;
G_DEFINE_INTERFACE (Bluez5GattCharacteristic1, bluez5_gatt_characteristic1, G_TYPE_OBJECT)

static void
bluez5_gatt_characteristic1_default_init (Bluez5GattCharacteristic1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Bluez5GattCharacteristic1::handle-read-value:
   * @object: A #Bluez5GattCharacteristic1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.ReadValue">ReadValue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_characteristic1_complete_read_value() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read-value",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattCharacteristic1Iface, handle_read_value),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_characteristic1_method_marshal_read_value,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * Bluez5GattCharacteristic1::handle-acquire-notify:
   * @object: A #Bluez5GattCharacteristic1.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireNotify">AcquireNotify()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_characteristic1_complete_acquire_notify() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-acquire-notify",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattCharacteristic1Iface, handle_acquire_notify),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_characteristic1_method_marshal_acquire_notify,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * Bluez5GattCharacteristic1::handle-acquire-write:
   * @object: A #Bluez5GattCharacteristic1.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireWrite">AcquireWrite()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_characteristic1_complete_acquire_write() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-acquire-write",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattCharacteristic1Iface, handle_acquire_write),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_characteristic1_method_marshal_acquire_write,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * Bluez5GattCharacteristic1:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattCharacteristic1.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattCharacteristic1:service:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Service">"Service"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("service", "Service", "Service", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattCharacteristic1:write-acquired:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattCharacteristic1.WriteAcquired">"WriteAcquired"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("write-acquired", "WriteAcquired", "WriteAcquired", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattCharacteristic1:notify-acquired:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattCharacteristic1.NotifyAcquired">"NotifyAcquired"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("notify-acquired", "NotifyAcquired", "NotifyAcquired", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattCharacteristic1:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("flags", "Flags", "Flags", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez5_gatt_characteristic1_get_uuid: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_characteristic1_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_characteristic1_get_uuid (Bluez5GattCharacteristic1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (object), NULL);

  return BLUEZ5_GATT_CHARACTERISTIC1_GET_IFACE (object)->get_uuid (object);
}

/**
 * bluez5_gatt_characteristic1_dup_uuid: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_characteristic1_dup_uuid (Bluez5GattCharacteristic1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_characteristic1_set_uuid: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_characteristic1_set_uuid (Bluez5GattCharacteristic1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * bluez5_gatt_characteristic1_get_service: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Service">"Service"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_characteristic1_dup_service() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_characteristic1_get_service (Bluez5GattCharacteristic1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (object), NULL);

  return BLUEZ5_GATT_CHARACTERISTIC1_GET_IFACE (object)->get_service (object);
}

/**
 * bluez5_gatt_characteristic1_dup_service: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Service">"Service"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_characteristic1_dup_service (Bluez5GattCharacteristic1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "service", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_characteristic1_set_service: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Service">"Service"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_characteristic1_set_service (Bluez5GattCharacteristic1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "service", value, NULL);
}

/**
 * bluez5_gatt_characteristic1_get_write_acquired: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.WriteAcquired">"WriteAcquired"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez5_gatt_characteristic1_get_write_acquired (Bluez5GattCharacteristic1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (object), FALSE);

  return BLUEZ5_GATT_CHARACTERISTIC1_GET_IFACE (object)->get_write_acquired (object);
}

/**
 * bluez5_gatt_characteristic1_set_write_acquired: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.WriteAcquired">"WriteAcquired"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_characteristic1_set_write_acquired (Bluez5GattCharacteristic1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "write-acquired", value, NULL);
}

/**
 * bluez5_gatt_characteristic1_get_notify_acquired: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.NotifyAcquired">"NotifyAcquired"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez5_gatt_characteristic1_get_notify_acquired (Bluez5GattCharacteristic1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (object), FALSE);

  return BLUEZ5_GATT_CHARACTERISTIC1_GET_IFACE (object)->get_notify_acquired (object);
}

/**
 * bluez5_gatt_characteristic1_set_notify_acquired: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.NotifyAcquired">"NotifyAcquired"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_characteristic1_set_notify_acquired (Bluez5GattCharacteristic1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "notify-acquired", value, NULL);
}

/**
 * bluez5_gatt_characteristic1_get_flags: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_characteristic1_dup_flags() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
bluez5_gatt_characteristic1_get_flags (Bluez5GattCharacteristic1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (object), NULL);

  return BLUEZ5_GATT_CHARACTERISTIC1_GET_IFACE (object)->get_flags (object);
}

/**
 * bluez5_gatt_characteristic1_dup_flags: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
bluez5_gatt_characteristic1_dup_flags (Bluez5GattCharacteristic1 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "flags", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_characteristic1_set_flags: (skip)
 * @object: A #Bluez5GattCharacteristic1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattCharacteristic1.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_characteristic1_set_flags (Bluez5GattCharacteristic1 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/**
 * bluez5_gatt_characteristic1_call_read_value:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.ReadValue">ReadValue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_characteristic1_call_read_value_finish() to get the result of the operation.
 *
 * See bluez5_gatt_characteristic1_call_read_value_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_characteristic1_call_read_value (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReadValue",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_characteristic1_call_read_value_finish:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_characteristic1_call_read_value().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_characteristic1_call_read_value().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_read_value_finish (
    Bluez5GattCharacteristic1 *proxy,
    gchar **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_call_read_value_sync:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.ReadValue">ReadValue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_characteristic1_call_read_value() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_read_value_sync (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    gchar **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReadValue",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_call_acquire_notify:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireNotify">AcquireNotify()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_characteristic1_call_acquire_notify_finish() to get the result of the operation.
 *
 * See bluez5_gatt_characteristic1_call_acquire_notify_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_characteristic1_call_acquire_notify (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AcquireNotify",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_characteristic1_call_acquire_notify_finish:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_characteristic1_call_acquire_notify().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_characteristic1_call_acquire_notify().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_acquire_notify_finish (
    Bluez5GattCharacteristic1 *proxy,
    GVariant **out_fd,
    guint16 *out_mtu,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hq)",
                 out_fd,
                 out_mtu);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_call_acquire_notify_sync:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireNotify">AcquireNotify()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_characteristic1_call_acquire_notify() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_acquire_notify_sync (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    guint16 *out_mtu,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AcquireNotify",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hq)",
                 out_fd,
                 out_mtu);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_call_acquire_write:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireWrite">AcquireWrite()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_characteristic1_call_acquire_write_finish() to get the result of the operation.
 *
 * See bluez5_gatt_characteristic1_call_acquire_write_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_characteristic1_call_acquire_write (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AcquireWrite",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_characteristic1_call_acquire_write_finish:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_characteristic1_call_acquire_write().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_characteristic1_call_acquire_write().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_acquire_write_finish (
    Bluez5GattCharacteristic1 *proxy,
    GVariant **out_fd,
    guint16 *out_mtu,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hq)",
                 out_fd,
                 out_mtu);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_call_acquire_write_sync:
 * @proxy: A #Bluez5GattCharacteristic1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireWrite">AcquireWrite()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_characteristic1_call_acquire_write() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_characteristic1_call_acquire_write_sync (
    Bluez5GattCharacteristic1 *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    guint16 *out_mtu,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AcquireWrite",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hq)",
                 out_fd,
                 out_mtu);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_characteristic1_complete_read_value:
 * @object: A #Bluez5GattCharacteristic1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.ReadValue">ReadValue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_characteristic1_complete_read_value (
    Bluez5GattCharacteristic1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay)",
                   value));
}

/**
 * bluez5_gatt_characteristic1_complete_acquire_notify:
 * @object: A #Bluez5GattCharacteristic1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @mtu: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireNotify">AcquireNotify()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_characteristic1_complete_acquire_notify (
    Bluez5GattCharacteristic1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    guint16 mtu)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hq)",
                   fd,
                   mtu),
    fd_list);
}

/**
 * bluez5_gatt_characteristic1_complete_acquire_write:
 * @object: A #Bluez5GattCharacteristic1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @mtu: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattCharacteristic1.AcquireWrite">AcquireWrite()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_characteristic1_complete_acquire_write (
    Bluez5GattCharacteristic1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    guint16 mtu)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hq)",
                   fd,
                   mtu),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattCharacteristic1Proxy:
 *
 * The #Bluez5GattCharacteristic1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattCharacteristic1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattCharacteristic1Proxy.
 */

struct _Bluez5GattCharacteristic1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_gatt_characteristic1_proxy_iface_init (Bluez5GattCharacteristic1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattCharacteristic1Proxy, bluez5_gatt_characteristic1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5GattCharacteristic1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_CHARACTERISTIC1, bluez5_gatt_characteristic1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattCharacteristic1Proxy, bluez5_gatt_characteristic1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_CHARACTERISTIC1, bluez5_gatt_characteristic1_proxy_iface_init))

#endif
static void
bluez5_gatt_characteristic1_proxy_finalize (GObject *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_gatt_characteristic1_proxy_parent_class)->finalize (object);
}

static void
bluez5_gatt_characteristic1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_characteristic1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez5_gatt_characteristic1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.GattCharacteristic1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez5_gatt_characteristic1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_characteristic1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.GattCharacteristic1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez5_gatt_characteristic1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez5_gatt_characteristic1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_GATT_CHARACTERISTIC1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_CHARACTERISTIC1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_gatt_characteristic1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez5_gatt_characteristic1_proxy_get_uuid (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_gatt_characteristic1_proxy_get_service (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Service");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez5_gatt_characteristic1_proxy_get_write_acquired (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WriteAcquired");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez5_gatt_characteristic1_proxy_get_notify_acquired (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NotifyAcquired");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
bluez5_gatt_characteristic1_proxy_get_flags (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Proxy *proxy = BLUEZ5_GATT_CHARACTERISTIC1_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Flags");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Flags", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez5_gatt_characteristic1_proxy_init (Bluez5GattCharacteristic1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_gatt_characteristic1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY, Bluez5GattCharacteristic1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_gatt_characteristic1_interface_info ());
}

static void
bluez5_gatt_characteristic1_proxy_class_init (Bluez5GattCharacteristic1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_gatt_characteristic1_proxy_finalize;
  gobject_class->get_property = bluez5_gatt_characteristic1_proxy_get_property;
  gobject_class->set_property = bluez5_gatt_characteristic1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_gatt_characteristic1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_gatt_characteristic1_proxy_g_properties_changed;

  bluez5_gatt_characteristic1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattCharacteristic1ProxyPrivate));
#endif
}

static void
bluez5_gatt_characteristic1_proxy_iface_init (Bluez5GattCharacteristic1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_characteristic1_proxy_get_uuid;
  iface->get_service = bluez5_gatt_characteristic1_proxy_get_service;
  iface->get_write_acquired = bluez5_gatt_characteristic1_proxy_get_write_acquired;
  iface->get_notify_acquired = bluez5_gatt_characteristic1_proxy_get_notify_acquired;
  iface->get_flags = bluez5_gatt_characteristic1_proxy_get_flags;
}

/**
 * bluez5_gatt_characteristic1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_characteristic1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_gatt_characteristic1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_characteristic1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattCharacteristic1", NULL);
}

/**
 * bluez5_gatt_characteristic1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_characteristic1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_characteristic1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5GattCharacteristic1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattCharacteristic1 *
bluez5_gatt_characteristic1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_characteristic1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_characteristic1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattCharacteristic1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattCharacteristic1 *
bluez5_gatt_characteristic1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattCharacteristic1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
  else
    return NULL;
}


/**
 * bluez5_gatt_characteristic1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_gatt_characteristic1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_characteristic1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_gatt_characteristic1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_characteristic1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattCharacteristic1", NULL);
}

/**
 * bluez5_gatt_characteristic1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_characteristic1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_characteristic1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5GattCharacteristic1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattCharacteristic1 *
bluez5_gatt_characteristic1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_characteristic1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_gatt_characteristic1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_characteristic1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattCharacteristic1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattCharacteristic1 *
bluez5_gatt_characteristic1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattCharacteristic1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattCharacteristic1Skeleton:
 *
 * The #Bluez5GattCharacteristic1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattCharacteristic1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattCharacteristic1Skeleton.
 */

struct _Bluez5GattCharacteristic1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_gatt_characteristic1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_GATT_CHARACTERISTIC1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_CHARACTERISTIC1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_gatt_characteristic1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_gatt_characteristic1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_characteristic1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_gatt_characteristic1_skeleton_vtable =
{
  _bluez5_gatt_characteristic1_skeleton_handle_method_call,
  _bluez5_gatt_characteristic1_skeleton_handle_get_property,
  _bluez5_gatt_characteristic1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_gatt_characteristic1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_gatt_characteristic1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_gatt_characteristic1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_gatt_characteristic1_skeleton_vtable;
}

static GVariant *
bluez5_gatt_characteristic1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_gatt_characteristic1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_gatt_characteristic1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_gatt_characteristic1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_gatt_characteristic1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.GattCharacteristic1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez5_gatt_characteristic1_emit_changed (gpointer user_data);

static void
bluez5_gatt_characteristic1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez5_gatt_characteristic1_emit_changed (skeleton);
}

static void bluez5_gatt_characteristic1_skeleton_iface_init (Bluez5GattCharacteristic1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattCharacteristic1Skeleton, bluez5_gatt_characteristic1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5GattCharacteristic1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_CHARACTERISTIC1, bluez5_gatt_characteristic1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattCharacteristic1Skeleton, bluez5_gatt_characteristic1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_CHARACTERISTIC1, bluez5_gatt_characteristic1_skeleton_iface_init))

#endif
static void
bluez5_gatt_characteristic1_skeleton_finalize (GObject *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_gatt_characteristic1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_gatt_characteristic1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez5_gatt_characteristic1_emit_changed (gpointer user_data)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.GattCharacteristic1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez5_gatt_characteristic1_schedule_emit_changed (Bluez5GattCharacteristic1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez5_gatt_characteristic1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez5_gatt_characteristic1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez5_gatt_characteristic1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez5_gatt_characteristic1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_characteristic1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez5_gatt_characteristic1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez5_gatt_characteristic1_skeleton_init (Bluez5GattCharacteristic1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_gatt_characteristic1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_GATT_CHARACTERISTIC1_SKELETON, Bluez5GattCharacteristic1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
}

static const gchar *
bluez5_gatt_characteristic1_skeleton_get_uuid (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_gatt_characteristic1_skeleton_get_service (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez5_gatt_characteristic1_skeleton_get_write_acquired (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez5_gatt_characteristic1_skeleton_get_notify_acquired (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
bluez5_gatt_characteristic1_skeleton_get_flags (Bluez5GattCharacteristic1 *object)
{
  Bluez5GattCharacteristic1Skeleton *skeleton = BLUEZ5_GATT_CHARACTERISTIC1_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez5_gatt_characteristic1_skeleton_class_init (Bluez5GattCharacteristic1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_gatt_characteristic1_skeleton_finalize;
  gobject_class->get_property = bluez5_gatt_characteristic1_skeleton_get_property;
  gobject_class->set_property = bluez5_gatt_characteristic1_skeleton_set_property;
  gobject_class->notify       = bluez5_gatt_characteristic1_skeleton_notify;


  bluez5_gatt_characteristic1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_gatt_characteristic1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_gatt_characteristic1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_gatt_characteristic1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_gatt_characteristic1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattCharacteristic1SkeletonPrivate));
#endif
}

static void
bluez5_gatt_characteristic1_skeleton_iface_init (Bluez5GattCharacteristic1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_characteristic1_skeleton_get_uuid;
  iface->get_service = bluez5_gatt_characteristic1_skeleton_get_service;
  iface->get_write_acquired = bluez5_gatt_characteristic1_skeleton_get_write_acquired;
  iface->get_notify_acquired = bluez5_gatt_characteristic1_skeleton_get_notify_acquired;
  iface->get_flags = bluez5_gatt_characteristic1_skeleton_get_flags;
}

/**
 * bluez5_gatt_characteristic1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>.
 *
 * Returns: (transfer full) (type Bluez5GattCharacteristic1Skeleton): The skeleton object.
 */
Bluez5GattCharacteristic1 *
bluez5_gatt_characteristic1_skeleton_new (void)
{
  return BLUEZ5_GATT_CHARACTERISTIC1 (g_object_new (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.GattDescriptor1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5GattDescriptor1
 * @title: Bluez5GattDescriptor1
 * @short_description: Generated C code for the org.bluez.GattDescriptor1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.GattDescriptor1 ---- */

static const _ExtendedGDBusArgInfo _bluez5_gatt_descriptor1_method_info_read_value_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_descriptor1_method_info_read_value_IN_ARG_pointers[] =
{
  &_bluez5_gatt_descriptor1_method_info_read_value_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _bluez5_gatt_descriptor1_method_info_read_value_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez5_gatt_descriptor1_method_info_read_value_OUT_ARG_pointers[] =
{
  &_bluez5_gatt_descriptor1_method_info_read_value_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez5_gatt_descriptor1_method_info_read_value =
{
  {
    -1,
    (gchar *) "ReadValue",
    (GDBusArgInfo **) &_bluez5_gatt_descriptor1_method_info_read_value_IN_ARG_pointers,
    (GDBusArgInfo **) &_bluez5_gatt_descriptor1_method_info_read_value_OUT_ARG_pointers,
    NULL
  },
  "handle-read-value",
  FALSE
};

static const GDBusMethodInfo * const _bluez5_gatt_descriptor1_method_info_pointers[] =
{
  &_bluez5_gatt_descriptor1_method_info_read_value.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_descriptor1_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_descriptor1_property_info_characteristic =
{
  {
    -1,
    (gchar *) "Characteristic",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "characteristic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez5_gatt_descriptor1_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez5_gatt_descriptor1_property_info_pointers[] =
{
  &_bluez5_gatt_descriptor1_property_info_uuid.parent_struct,
  &_bluez5_gatt_descriptor1_property_info_characteristic.parent_struct,
  &_bluez5_gatt_descriptor1_property_info_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez5_gatt_descriptor1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.GattDescriptor1",
    (GDBusMethodInfo **) &_bluez5_gatt_descriptor1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_bluez5_gatt_descriptor1_property_info_pointers,
    NULL
  },
  "gatt-descriptor1",
};


/**
 * bluez5_gatt_descriptor1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez5_gatt_descriptor1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct;
}

/**
 * bluez5_gatt_descriptor1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Bluez5GattDescriptor1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez5_gatt_descriptor1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "characteristic");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  return property_id_begin - 1;
}


inline static void
bluez5_gatt_descriptor1_method_marshal_read_value (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Bluez5GattDescriptor1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>.
 */

/**
 * Bluez5GattDescriptor1Iface:
 * @parent_iface: The parent interface.
 * @handle_read_value: Handler for the #Bluez5GattDescriptor1::handle-read-value signal.
 * @get_characteristic: Getter for the #Bluez5GattDescriptor1:characteristic property.
 * @get_flags: Getter for the #Bluez5GattDescriptor1:flags property.
 * @get_uuid: Getter for the #Bluez5GattDescriptor1:uuid property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>.
 */

typedef Bluez5GattDescriptor1Iface Bluez5GattDescriptor1Interface;
G_DEFINE_INTERFACE (Bluez5GattDescriptor1, bluez5_gatt_descriptor1, G_TYPE_OBJECT)

static void
bluez5_gatt_descriptor1_default_init (Bluez5GattDescriptor1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Bluez5GattDescriptor1::handle-read-value:
   * @object: A #Bluez5GattDescriptor1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-GattDescriptor1.ReadValue">ReadValue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez5_gatt_descriptor1_complete_read_value() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read-value",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Bluez5GattDescriptor1Iface, handle_read_value),
    g_signal_accumulator_true_handled,
    NULL,
      bluez5_gatt_descriptor1_method_marshal_read_value,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * Bluez5GattDescriptor1:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattDescriptor1.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattDescriptor1:characteristic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattDescriptor1.Characteristic">"Characteristic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("characteristic", "Characteristic", "Characteristic", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Bluez5GattDescriptor1:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-GattDescriptor1.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("flags", "Flags", "Flags", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez5_gatt_descriptor1_get_uuid: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_descriptor1_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_descriptor1_get_uuid (Bluez5GattDescriptor1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_DESCRIPTOR1 (object), NULL);

  return BLUEZ5_GATT_DESCRIPTOR1_GET_IFACE (object)->get_uuid (object);
}

/**
 * bluez5_gatt_descriptor1_dup_uuid: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_descriptor1_dup_uuid (Bluez5GattDescriptor1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_descriptor1_set_uuid: (skip)
 * @object: A #Bluez5GattDescriptor1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattDescriptor1.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_descriptor1_set_uuid (Bluez5GattDescriptor1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * bluez5_gatt_descriptor1_get_characteristic: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Characteristic">"Characteristic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_descriptor1_dup_characteristic() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez5_gatt_descriptor1_get_characteristic (Bluez5GattDescriptor1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_DESCRIPTOR1 (object), NULL);

  return BLUEZ5_GATT_DESCRIPTOR1_GET_IFACE (object)->get_characteristic (object);
}

/**
 * bluez5_gatt_descriptor1_dup_characteristic: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Characteristic">"Characteristic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez5_gatt_descriptor1_dup_characteristic (Bluez5GattDescriptor1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "characteristic", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_descriptor1_set_characteristic: (skip)
 * @object: A #Bluez5GattDescriptor1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Characteristic">"Characteristic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_descriptor1_set_characteristic (Bluez5GattDescriptor1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "characteristic", value, NULL);
}

/**
 * bluez5_gatt_descriptor1_get_flags: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez5_gatt_descriptor1_dup_flags() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
bluez5_gatt_descriptor1_get_flags (Bluez5GattDescriptor1 *object)
{
  g_return_val_if_fail (BLUEZ5_IS_GATT_DESCRIPTOR1 (object), NULL);

  return BLUEZ5_GATT_DESCRIPTOR1_GET_IFACE (object)->get_flags (object);
}

/**
 * bluez5_gatt_descriptor1_dup_flags: (skip)
 * @object: A #Bluez5GattDescriptor1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
bluez5_gatt_descriptor1_dup_flags (Bluez5GattDescriptor1 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "flags", &value, NULL);
  return value;
}

/**
 * bluez5_gatt_descriptor1_set_flags: (skip)
 * @object: A #Bluez5GattDescriptor1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-GattDescriptor1.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez5_gatt_descriptor1_set_flags (Bluez5GattDescriptor1 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/**
 * bluez5_gatt_descriptor1_call_read_value:
 * @proxy: A #Bluez5GattDescriptor1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-GattDescriptor1.ReadValue">ReadValue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_descriptor1_call_read_value_finish() to get the result of the operation.
 *
 * See bluez5_gatt_descriptor1_call_read_value_sync() for the synchronous, blocking version of this method.
 */
void
bluez5_gatt_descriptor1_call_read_value (
    Bluez5GattDescriptor1 *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReadValue",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez5_gatt_descriptor1_call_read_value_finish:
 * @proxy: A #Bluez5GattDescriptor1Proxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_descriptor1_call_read_value().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez5_gatt_descriptor1_call_read_value().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_descriptor1_call_read_value_finish (
    Bluez5GattDescriptor1 *proxy,
    gchar **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_descriptor1_call_read_value_sync:
 * @proxy: A #Bluez5GattDescriptor1Proxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-GattDescriptor1.ReadValue">ReadValue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_descriptor1_call_read_value() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez5_gatt_descriptor1_call_read_value_sync (
    Bluez5GattDescriptor1 *proxy,
    GVariant *arg_options,
    gchar **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReadValue",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez5_gatt_descriptor1_complete_read_value:
 * @object: A #Bluez5GattDescriptor1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-GattDescriptor1.ReadValue">ReadValue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez5_gatt_descriptor1_complete_read_value (
    Bluez5GattDescriptor1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay)",
                   value));
}

/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattDescriptor1Proxy:
 *
 * The #Bluez5GattDescriptor1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattDescriptor1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattDescriptor1Proxy.
 */

struct _Bluez5GattDescriptor1ProxyPrivate
{
  GData *qdata;
};

static void bluez5_gatt_descriptor1_proxy_iface_init (Bluez5GattDescriptor1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattDescriptor1Proxy, bluez5_gatt_descriptor1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Bluez5GattDescriptor1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_DESCRIPTOR1, bluez5_gatt_descriptor1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattDescriptor1Proxy, bluez5_gatt_descriptor1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_DESCRIPTOR1, bluez5_gatt_descriptor1_proxy_iface_init))

#endif
static void
bluez5_gatt_descriptor1_proxy_finalize (GObject *object)
{
  Bluez5GattDescriptor1Proxy *proxy = BLUEZ5_GATT_DESCRIPTOR1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez5_gatt_descriptor1_proxy_parent_class)->finalize (object);
}

static void
bluez5_gatt_descriptor1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_descriptor1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez5_gatt_descriptor1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.GattDescriptor1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez5_gatt_descriptor1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_descriptor1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.GattDescriptor1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez5_gatt_descriptor1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez5_gatt_descriptor1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ5_TYPE_GATT_DESCRIPTOR1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_DESCRIPTOR1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez5_gatt_descriptor1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Bluez5GattDescriptor1Proxy *proxy = BLUEZ5_GATT_DESCRIPTOR1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez5_gatt_descriptor1_proxy_get_uuid (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Proxy *proxy = BLUEZ5_GATT_DESCRIPTOR1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez5_gatt_descriptor1_proxy_get_characteristic (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Proxy *proxy = BLUEZ5_GATT_DESCRIPTOR1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Characteristic");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
bluez5_gatt_descriptor1_proxy_get_flags (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Proxy *proxy = BLUEZ5_GATT_DESCRIPTOR1_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Flags");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Flags", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez5_gatt_descriptor1_proxy_init (Bluez5GattDescriptor1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez5_gatt_descriptor1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY, Bluez5GattDescriptor1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez5_gatt_descriptor1_interface_info ());
}

static void
bluez5_gatt_descriptor1_proxy_class_init (Bluez5GattDescriptor1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez5_gatt_descriptor1_proxy_finalize;
  gobject_class->get_property = bluez5_gatt_descriptor1_proxy_get_property;
  gobject_class->set_property = bluez5_gatt_descriptor1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez5_gatt_descriptor1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez5_gatt_descriptor1_proxy_g_properties_changed;

  bluez5_gatt_descriptor1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattDescriptor1ProxyPrivate));
#endif
}

static void
bluez5_gatt_descriptor1_proxy_iface_init (Bluez5GattDescriptor1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_descriptor1_proxy_get_uuid;
  iface->get_characteristic = bluez5_gatt_descriptor1_proxy_get_characteristic;
  iface->get_flags = bluez5_gatt_descriptor1_proxy_get_flags;
}

/**
 * bluez5_gatt_descriptor1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_descriptor1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez5_gatt_descriptor1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_descriptor1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattDescriptor1", NULL);
}

/**
 * bluez5_gatt_descriptor1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_descriptor1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_descriptor1_proxy_new().
 *
 * Returns: (transfer full) (type Bluez5GattDescriptor1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattDescriptor1 *
bluez5_gatt_descriptor1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_DESCRIPTOR1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_descriptor1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_descriptor1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattDescriptor1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattDescriptor1 *
bluez5_gatt_descriptor1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.GattDescriptor1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_DESCRIPTOR1 (ret);
  else
    return NULL;
}


/**
 * bluez5_gatt_descriptor1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_gatt_descriptor1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_gatt_descriptor1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_gatt_descriptor1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_gatt_descriptor1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattDescriptor1", NULL);
}

/**
 * bluez5_gatt_descriptor1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_gatt_descriptor1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_gatt_descriptor1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5GattDescriptor1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattDescriptor1 *
bluez5_gatt_descriptor1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ5_GATT_DESCRIPTOR1 (ret);
  else
    return NULL;
}

/**
 * bluez5_gatt_descriptor1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_gatt_descriptor1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_gatt_descriptor1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5GattDescriptor1Proxy): The constructed proxy object or %NULL if @error is set.
 */
Bluez5GattDescriptor1 *
bluez5_gatt_descriptor1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.GattDescriptor1", NULL);
  if (ret != NULL)
    return BLUEZ5_GATT_DESCRIPTOR1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Bluez5GattDescriptor1Skeleton:
 *
 * The #Bluez5GattDescriptor1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5GattDescriptor1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5GattDescriptor1Skeleton.
 */

struct _Bluez5GattDescriptor1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez5_gatt_descriptor1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ5_TYPE_GATT_DESCRIPTOR1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ5_TYPE_GATT_DESCRIPTOR1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez5_gatt_descriptor1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez5_gatt_descriptor1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez5_gatt_descriptor1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez5_gatt_descriptor1_skeleton_vtable =
{
  _bluez5_gatt_descriptor1_skeleton_handle_method_call,
  _bluez5_gatt_descriptor1_skeleton_handle_get_property,
  _bluez5_gatt_descriptor1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez5_gatt_descriptor1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez5_gatt_descriptor1_interface_info ();
}

static GDBusInterfaceVTable *
bluez5_gatt_descriptor1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez5_gatt_descriptor1_skeleton_vtable;
}

static GVariant *
bluez5_gatt_descriptor1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_bluez5_gatt_descriptor1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez5_gatt_descriptor1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez5_gatt_descriptor1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez5_gatt_descriptor1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.GattDescriptor1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez5_gatt_descriptor1_emit_changed (gpointer user_data);

static void
bluez5_gatt_descriptor1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez5_gatt_descriptor1_emit_changed (skeleton);
}

static void bluez5_gatt_descriptor1_skeleton_iface_init (Bluez5GattDescriptor1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Bluez5GattDescriptor1Skeleton, bluez5_gatt_descriptor1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Bluez5GattDescriptor1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_DESCRIPTOR1, bluez5_gatt_descriptor1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Bluez5GattDescriptor1Skeleton, bluez5_gatt_descriptor1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_GATT_DESCRIPTOR1, bluez5_gatt_descriptor1_skeleton_iface_init))

#endif
static void
bluez5_gatt_descriptor1_skeleton_finalize (GObject *object)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez5_gatt_descriptor1_skeleton_parent_class)->finalize (object);
}

static void
bluez5_gatt_descriptor1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez5_gatt_descriptor1_emit_changed (gpointer user_data)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.GattDescriptor1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez5_gatt_descriptor1_schedule_emit_changed (Bluez5GattDescriptor1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez5_gatt_descriptor1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez5_gatt_descriptor1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez5_gatt_descriptor1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez5_gatt_descriptor1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez5_gatt_descriptor1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez5_gatt_descriptor1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez5_gatt_descriptor1_skeleton_init (Bluez5GattDescriptor1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez5_gatt_descriptor1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ5_TYPE_GATT_DESCRIPTOR1_SKELETON, Bluez5GattDescriptor1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
}

static const gchar *
bluez5_gatt_descriptor1_skeleton_get_uuid (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez5_gatt_descriptor1_skeleton_get_characteristic (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
bluez5_gatt_descriptor1_skeleton_get_flags (Bluez5GattDescriptor1 *object)
{
  Bluez5GattDescriptor1Skeleton *skeleton = BLUEZ5_GATT_DESCRIPTOR1_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez5_gatt_descriptor1_skeleton_class_init (Bluez5GattDescriptor1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez5_gatt_descriptor1_skeleton_finalize;
  gobject_class->get_property = bluez5_gatt_descriptor1_skeleton_get_property;
  gobject_class->set_property = bluez5_gatt_descriptor1_skeleton_set_property;
  gobject_class->notify       = bluez5_gatt_descriptor1_skeleton_notify;


  bluez5_gatt_descriptor1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez5_gatt_descriptor1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez5_gatt_descriptor1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez5_gatt_descriptor1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez5_gatt_descriptor1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Bluez5GattDescriptor1SkeletonPrivate));
#endif
}

static void
bluez5_gatt_descriptor1_skeleton_iface_init (Bluez5GattDescriptor1Iface *iface)
{
  iface->get_uuid = bluez5_gatt_descriptor1_skeleton_get_uuid;
  iface->get_characteristic = bluez5_gatt_descriptor1_skeleton_get_characteristic;
  iface->get_flags = bluez5_gatt_descriptor1_skeleton_get_flags;
}

/**
 * bluez5_gatt_descriptor1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>.
 *
 * Returns: (transfer full) (type Bluez5GattDescriptor1Skeleton): The skeleton object.
 */
Bluez5GattDescriptor1 *
bluez5_gatt_descriptor1_skeleton_new (void)
{
  return BLUEZ5_GATT_DESCRIPTOR1 (g_object_new (BLUEZ5_TYPE_GATT_DESCRIPTOR1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5Object
 * @title: Bluez5Object
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #Bluez5Object, #Bluez5ObjectProxy, and #Bluez5ObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * Bluez5Object:
 *
 * The #Bluez5Object type is a specialized container of interfaces.
 */

/**
 * Bluez5ObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #Bluez5Object interface.
 */

typedef Bluez5ObjectIface Bluez5ObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (Bluez5Object, bluez5_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
bluez5_object_default_init (Bluez5ObjectIface *iface)
{
  /**
   * Bluez5Object:adapter1:
   *
   * The #Bluez5Adapter1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("adapter1", "adapter1", "adapter1", BLUEZ5_TYPE_ADAPTER1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:device1:
   *
   * The #Bluez5Device1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("device1", "device1", "device1", BLUEZ5_TYPE_DEVICE1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:gatt-manager1:
   *
   * The #Bluez5GattManager1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("gatt-manager1", "gatt-manager1", "gatt-manager1", BLUEZ5_TYPE_GATT_MANAGER1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:gatt-profile1:
   *
   * The #Bluez5GattProfile1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("gatt-profile1", "gatt-profile1", "gatt-profile1", BLUEZ5_TYPE_GATT_PROFILE1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:gatt-service1:
   *
   * The #Bluez5GattService1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("gatt-service1", "gatt-service1", "gatt-service1", BLUEZ5_TYPE_GATT_SERVICE1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:gatt-characteristic1:
   *
   * The #Bluez5GattCharacteristic1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("gatt-characteristic1", "gatt-characteristic1", "gatt-characteristic1", BLUEZ5_TYPE_GATT_CHARACTERISTIC1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * Bluez5Object:gatt-descriptor1:
   *
   * The #Bluez5GattDescriptor1 instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("gatt-descriptor1", "gatt-descriptor1", "gatt-descriptor1", BLUEZ5_TYPE_GATT_DESCRIPTOR1, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * bluez5_object_get_adapter1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5Adapter1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5Adapter1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5Adapter1 *bluez5_object_get_adapter1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Adapter1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_ADAPTER1 (ret);
}

/**
 * bluez5_object_get_device1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5Device1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5Device1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5Device1 *bluez5_object_get_device1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Device1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_DEVICE1 (ret);
}

/**
 * bluez5_object_get_gatt_manager1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5GattManager1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5GattManager1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5GattManager1 *bluez5_object_get_gatt_manager1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattManager1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_GATT_MANAGER1 (ret);
}

/**
 * bluez5_object_get_gatt_profile1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5GattProfile1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5GattProfile1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5GattProfile1 *bluez5_object_get_gatt_profile1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattProfile1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_GATT_PROFILE1 (ret);
}

/**
 * bluez5_object_get_gatt_service1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5GattService1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5GattService1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5GattService1 *bluez5_object_get_gatt_service1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattService1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_GATT_SERVICE1 (ret);
}

/**
 * bluez5_object_get_gatt_characteristic1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5GattCharacteristic1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5GattCharacteristic1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5GattCharacteristic1 *bluez5_object_get_gatt_characteristic1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattCharacteristic1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
}

/**
 * bluez5_object_get_gatt_descriptor1:
 * @object: A #Bluez5Object.
 *
 * Gets the #Bluez5GattDescriptor1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #Bluez5GattDescriptor1 that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
Bluez5GattDescriptor1 *bluez5_object_get_gatt_descriptor1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattDescriptor1");
  if (ret == NULL)
    return NULL;
  return BLUEZ5_GATT_DESCRIPTOR1 (ret);
}


/**
 * bluez5_object_peek_adapter1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_adapter1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5Adapter1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5Adapter1 *bluez5_object_peek_adapter1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Adapter1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_ADAPTER1 (ret);
}

/**
 * bluez5_object_peek_device1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_device1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5Device1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5Device1 *bluez5_object_peek_device1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Device1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_DEVICE1 (ret);
}

/**
 * bluez5_object_peek_gatt_manager1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_gatt_manager1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5GattManager1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5GattManager1 *bluez5_object_peek_gatt_manager1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattManager1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_GATT_MANAGER1 (ret);
}

/**
 * bluez5_object_peek_gatt_profile1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_gatt_profile1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5GattProfile1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5GattProfile1 *bluez5_object_peek_gatt_profile1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattProfile1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_GATT_PROFILE1 (ret);
}

/**
 * bluez5_object_peek_gatt_service1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_gatt_service1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5GattService1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5GattService1 *bluez5_object_peek_gatt_service1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattService1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_GATT_SERVICE1 (ret);
}

/**
 * bluez5_object_peek_gatt_characteristic1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_gatt_characteristic1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5GattCharacteristic1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5GattCharacteristic1 *bluez5_object_peek_gatt_characteristic1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattCharacteristic1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_GATT_CHARACTERISTIC1 (ret);
}

/**
 * bluez5_object_peek_gatt_descriptor1: (skip)
 * @object: A #Bluez5Object.
 *
 * Like bluez5_object_get_gatt_descriptor1() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #Bluez5GattDescriptor1 or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
Bluez5GattDescriptor1 *bluez5_object_peek_gatt_descriptor1 (Bluez5Object *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattDescriptor1");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return BLUEZ5_GATT_DESCRIPTOR1 (ret);
}


static void
bluez5_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * Bluez5ObjectProxy:
 *
 * The #Bluez5ObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5ObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5ObjectProxy.
 */

static void
bluez5_object_proxy__bluez5_object_iface_init (Bluez5ObjectIface *iface G_GNUC_UNUSED)
{
}

static void
bluez5_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = bluez5_object_notify;
  iface->interface_removed = bluez5_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (Bluez5ObjectProxy, bluez5_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_OBJECT, bluez5_object_proxy__bluez5_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, bluez5_object_proxy__g_dbus_object_iface_init))

static void
bluez5_object_proxy_init (Bluez5ObjectProxy *object G_GNUC_UNUSED)
{
}

static void
bluez5_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
bluez5_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  Bluez5ObjectProxy *object = BLUEZ5_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Adapter1");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Device1");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattManager1");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattProfile1");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattService1");
      g_value_take_object (value, interface);
      break;

    case 6:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattCharacteristic1");
      g_value_take_object (value, interface);
      break;

    case 7:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattDescriptor1");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
bluez5_object_proxy_class_init (Bluez5ObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = bluez5_object_proxy_set_property;
  gobject_class->get_property = bluez5_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "adapter1");
  g_object_class_override_property (gobject_class, 2, "device1");
  g_object_class_override_property (gobject_class, 3, "gatt-manager1");
  g_object_class_override_property (gobject_class, 4, "gatt-profile1");
  g_object_class_override_property (gobject_class, 5, "gatt-service1");
  g_object_class_override_property (gobject_class, 6, "gatt-characteristic1");
  g_object_class_override_property (gobject_class, 7, "gatt-descriptor1");
}

/**
 * bluez5_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
Bluez5ObjectProxy *
bluez5_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return BLUEZ5_OBJECT_PROXY (g_object_new (BLUEZ5_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * Bluez5ObjectSkeleton:
 *
 * The #Bluez5ObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5ObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5ObjectSkeleton.
 */

static void
bluez5_object_skeleton__bluez5_object_iface_init (Bluez5ObjectIface *iface G_GNUC_UNUSED)
{
}


static void
bluez5_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = bluez5_object_notify;
  iface->interface_removed = bluez5_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (Bluez5ObjectSkeleton, bluez5_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ5_TYPE_OBJECT, bluez5_object_skeleton__bluez5_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, bluez5_object_skeleton__g_dbus_object_iface_init))

static void
bluez5_object_skeleton_init (Bluez5ObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
bluez5_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  Bluez5ObjectSkeleton *object = BLUEZ5_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_ADAPTER1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.Adapter1");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_DEVICE1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.Device1");
        }
      break;

    case 3:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_GATT_MANAGER1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.GattManager1");
        }
      break;

    case 4:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_GATT_PROFILE1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.GattProfile1");
        }
      break;

    case 5:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_GATT_SERVICE1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.GattService1");
        }
      break;

    case 6:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_GATT_CHARACTERISTIC1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.GattCharacteristic1");
        }
      break;

    case 7:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (BLUEZ5_IS_GATT_DESCRIPTOR1 (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.bluez.GattDescriptor1");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
bluez5_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  Bluez5ObjectSkeleton *object = BLUEZ5_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Adapter1");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.Device1");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattManager1");
      g_value_take_object (value, interface);
      break;

    case 4:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattProfile1");
      g_value_take_object (value, interface);
      break;

    case 5:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattService1");
      g_value_take_object (value, interface);
      break;

    case 6:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattCharacteristic1");
      g_value_take_object (value, interface);
      break;

    case 7:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.bluez.GattDescriptor1");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
bluez5_object_skeleton_class_init (Bluez5ObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = bluez5_object_skeleton_set_property;
  gobject_class->get_property = bluez5_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "adapter1");
  g_object_class_override_property (gobject_class, 2, "device1");
  g_object_class_override_property (gobject_class, 3, "gatt-manager1");
  g_object_class_override_property (gobject_class, 4, "gatt-profile1");
  g_object_class_override_property (gobject_class, 5, "gatt-service1");
  g_object_class_override_property (gobject_class, 6, "gatt-characteristic1");
  g_object_class_override_property (gobject_class, 7, "gatt-descriptor1");
}

/**
 * bluez5_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
Bluez5ObjectSkeleton *
bluez5_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return BLUEZ5_OBJECT_SKELETON (g_object_new (BLUEZ5_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * bluez5_object_skeleton_set_adapter1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5Adapter1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5Adapter1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter1.top_of_page">org.bluez.Adapter1</link> on @object.
 */
void bluez5_object_skeleton_set_adapter1 (Bluez5ObjectSkeleton *object, Bluez5Adapter1 *interface_)
{
  g_object_set (G_OBJECT (object), "adapter1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_device1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5Device1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5Device1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device1.top_of_page">org.bluez.Device1</link> on @object.
 */
void bluez5_object_skeleton_set_device1 (Bluez5ObjectSkeleton *object, Bluez5Device1 *interface_)
{
  g_object_set (G_OBJECT (object), "device1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_gatt_manager1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5GattManager1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5GattManager1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattManager1.top_of_page">org.bluez.GattManager1</link> on @object.
 */
void bluez5_object_skeleton_set_gatt_manager1 (Bluez5ObjectSkeleton *object, Bluez5GattManager1 *interface_)
{
  g_object_set (G_OBJECT (object), "gatt-manager1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_gatt_profile1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5GattProfile1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5GattProfile1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattProfile1.top_of_page">org.bluez.GattProfile1</link> on @object.
 */
void bluez5_object_skeleton_set_gatt_profile1 (Bluez5ObjectSkeleton *object, Bluez5GattProfile1 *interface_)
{
  g_object_set (G_OBJECT (object), "gatt-profile1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_gatt_service1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5GattService1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5GattService1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattService1.top_of_page">org.bluez.GattService1</link> on @object.
 */
void bluez5_object_skeleton_set_gatt_service1 (Bluez5ObjectSkeleton *object, Bluez5GattService1 *interface_)
{
  g_object_set (G_OBJECT (object), "gatt-service1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_gatt_characteristic1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5GattCharacteristic1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5GattCharacteristic1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattCharacteristic1.top_of_page">org.bluez.GattCharacteristic1</link> on @object.
 */
void bluez5_object_skeleton_set_gatt_characteristic1 (Bluez5ObjectSkeleton *object, Bluez5GattCharacteristic1 *interface_)
{
  g_object_set (G_OBJECT (object), "gatt-characteristic1", interface_, NULL);
}

/**
 * bluez5_object_skeleton_set_gatt_descriptor1:
 * @object: A #Bluez5ObjectSkeleton.
 * @interface_: (nullable): A #Bluez5GattDescriptor1 or %NULL to clear the interface.
 *
 * Sets the #Bluez5GattDescriptor1 instance for the D-Bus interface <link linkend="gdbus-interface-org-bluez-GattDescriptor1.top_of_page">org.bluez.GattDescriptor1</link> on @object.
 */
void bluez5_object_skeleton_set_gatt_descriptor1 (Bluez5ObjectSkeleton *object, Bluez5GattDescriptor1 *interface_)
{
  g_object_set (G_OBJECT (object), "gatt-descriptor1", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Bluez5ObjectManagerClient
 * @title: Bluez5ObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses bluez5_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * Bluez5ObjectManagerClient:
 *
 * The #Bluez5ObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Bluez5ObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Bluez5ObjectManagerClient.
 */

G_DEFINE_TYPE (Bluez5ObjectManagerClient, bluez5_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
bluez5_object_manager_client_init (Bluez5ObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
bluez5_object_manager_client_class_init (Bluez5ObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * bluez5_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #Bluez5ObjectProxy.
 */
GType
bluez5_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return BLUEZ5_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.Adapter1", (gpointer) (guintptr) (BLUEZ5_TYPE_ADAPTER1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.Device1", (gpointer) (guintptr) (BLUEZ5_TYPE_DEVICE1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.GattManager1", (gpointer) (guintptr) (BLUEZ5_TYPE_GATT_MANAGER1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.GattProfile1", (gpointer) (guintptr) (BLUEZ5_TYPE_GATT_PROFILE1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.GattService1", (gpointer) (guintptr) (BLUEZ5_TYPE_GATT_SERVICE1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.GattCharacteristic1", (gpointer) (guintptr) (BLUEZ5_TYPE_GATT_CHARACTERISTIC1_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.bluez.GattDescriptor1", (gpointer) (guintptr) (BLUEZ5_TYPE_GATT_DESCRIPTOR1_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * bluez5_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using bluez5_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_object_manager_client_new_finish() to get the result of the operation.
 *
 * See bluez5_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", bluez5_object_manager_client_get_proxy_type, NULL);
}

/**
 * bluez5_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_object_manager_client_new().
 *
 * Returns: (transfer full) (type Bluez5ObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
bluez5_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * bluez5_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using bluez5_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5ObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
bluez5_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", bluez5_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * bluez5_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez5_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez5_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez5_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez5_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (BLUEZ5_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", bluez5_object_manager_client_get_proxy_type, NULL);
}

/**
 * bluez5_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez5_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez5_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type Bluez5ObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
bluez5_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * bluez5_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez5_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez5_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Bluez5ObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
bluez5_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ5_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", bluez5_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


