# Copyright 2016-2017 Luke Shumaker <lukeshu@sbcglobal.net>.
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this manual; if not, see
# <http://www.gnu.org/licenses/>.

require 'set'
require 'yaml'

def cfg
	if @cfg.nil?
		@cfg = YAML::load(open("/etc/parabola-hackers.yml"))
		if ENV['PARABOLA_HACKERS_YAMLDIR']
			@cfg["yamldir"] = ENV['PARABOLA_HACKERS_YAMLDIR']
		end
	end
	return @cfg
end

def add_group(group_set, groupname)
	return if group_set.include?(groupname)
	group_set.add(groupname)
	(cfg["groupgroups"][groupname] || []).each do |subgroupname|
		add_group(group_set, subgroupname)
	end
end

def load_user_yaml(filename)
	user = YAML::load(open(filename))
	groups = Set.new
	(user["groups"] || []).each{|groupname| add_group(groups, groupname)}
	user["groups"] = groups
	return user
end

def load_all_users
	users = {}
	Dir.glob("#{cfg["yamldir"]}/*.yml").map{|filename|
		uid = File.basename(filename).sub(/^([0-9]*)\.yml$/, "\\1").to_i
		user = load_user_yaml(filename)
		users[uid] = user
	}
	return users
end
