/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.permissionadmin;

public class PermissionInfo {
    private final String type;
    private final String name;
    private final String actions;

    public PermissionInfo(String string, String string2, String string3) {
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (string == null) {
            throw new NullPointerException("type is null");
        }
        if (string2 == null && string3 != null) {
            throw new IllegalArgumentException("name missing");
        }
    }

    public PermissionInfo(String string) {
        if (string == null) {
            throw new NullPointerException("missing encoded permission");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty encoded permission");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (cArray[n2] != '(') {
                throw new IllegalArgumentException("expecting open parenthesis");
            }
            ++n2;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            int n3 = n2;
            while (!Character.isWhitespace(cArray[n2]) && cArray[n2] != ')') {
                ++n2;
            }
            if (n2 == n3 || cArray[n3] == '\"') {
                throw new IllegalArgumentException("expecting type");
            }
            string2 = new String(cArray, n3, n2 - n3);
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (cArray[n2] == '\"') {
                n3 = ++n2;
                while (cArray[n2] != '\"') {
                    if (cArray[n2] == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                string3 = PermissionInfo.unescapeString(cArray, n3, n2);
                if (Character.isWhitespace(cArray[++n2])) {
                    while (Character.isWhitespace(cArray[n2])) {
                        ++n2;
                    }
                    if (cArray[n2] == '\"') {
                        n3 = ++n2;
                        while (cArray[n2] != '\"') {
                            if (cArray[n2] == '\\') {
                                ++n2;
                            }
                            ++n2;
                        }
                        string4 = PermissionInfo.unescapeString(cArray, n3, n2);
                        ++n2;
                        while (Character.isWhitespace(cArray[n2])) {
                            ++n2;
                        }
                    }
                }
            }
            char c = cArray[n2];
            ++n2;
            while (n2 < n && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (c != ')' || n2 != n) {
                throw new IllegalArgumentException("expecting close parenthesis");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
        this.type = string2;
        this.name = string3;
        this.actions = string4;
    }

    public final String getEncoded() {
        StringBuffer stringBuffer = new StringBuffer(8 + this.type.length() + ((this.name == null ? 0 : this.name.length()) + (this.actions == null ? 0 : this.actions.length()) << 1));
        stringBuffer.append('(');
        stringBuffer.append(this.type);
        if (this.name != null) {
            stringBuffer.append(" \"");
            PermissionInfo.escapeString(this.name, stringBuffer);
            if (this.actions != null) {
                stringBuffer.append("\" \"");
                PermissionInfo.escapeString(this.actions, stringBuffer);
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getActions() {
        return this.actions;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo permissionInfo = (PermissionInfo)object;
        if (!this.type.equals(permissionInfo.type) || this.name == null ^ permissionInfo.name == null || this.actions == null ^ permissionInfo.actions == null) {
            return false;
        }
        if (this.name != null) {
            if (this.actions != null) {
                return this.name.equals(permissionInfo.name) && this.actions.equals(permissionInfo.actions);
            }
            return this.name.equals(permissionInfo.name);
        }
        return true;
    }

    public int hashCode() {
        int n = 527 + this.type.hashCode();
        if (this.name != null) {
            n = 31 * n + this.name.hashCode();
            if (this.actions != null) {
                n = 31 * n + this.actions.hashCode();
            }
        }
        return n;
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    private static String unescapeString(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        for (int i = n; i < n2; ++i) {
            int n3 = cArray[i];
            if (n3 == 92 && ++i < n2) {
                n3 = cArray[i];
                switch (n3) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        n3 = 13;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    default: {
                        n3 = 92;
                        --i;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }
}

