/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.subsystem;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemPermissionCollection;

public final class SubsystemPermission
extends BasicPermission {
    static final long serialVersionUID = 307051004521261705L;
    public static final String EXECUTE = "execute";
    public static final String LIFECYCLE = "lifecycle";
    public static final String METADATA = "metadata";
    public static final String CONTEXT = "context";
    private static final int ACTION_EXECUTE = 1;
    private static final int ACTION_LIFECYCLE = 2;
    private static final int ACTION_METADATA = 4;
    private static final int ACTION_CONTEXT = 8;
    private static final int ACTION_ALL = 15;
    static final int ACTION_NONE = 0;
    private volatile String actions = null;
    transient int action_mask;
    transient Filter filter;
    final transient Subsystem subsystem;
    private volatile transient Map<String, Object> properties;
    private static final ThreadLocal<Subsystem> recurse = new ThreadLocal();

    public SubsystemPermission(String string, String string2) {
        this(SubsystemPermission.parseFilter(string), SubsystemPermission.parseActions(string2));
    }

    public SubsystemPermission(Subsystem subsystem, String string) {
        super(SubsystemPermission.createName(subsystem));
        this.setTransients(null, SubsystemPermission.parseActions(string));
        this.subsystem = subsystem;
    }

    private static String createName(Subsystem subsystem) {
        if (subsystem == null) {
            throw new IllegalArgumentException("subsystem must not be null");
        }
        StringBuffer stringBuffer = new StringBuffer("(id=");
        stringBuffer.append(subsystem.getSubsystemId());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    SubsystemPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.subsystem = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 0xF) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 6 || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'x' && cArray[n2 - 5] != 'X' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 1;
            } else if (!(n2 < 8 || cArray[n2 - 8] != 'l' && cArray[n2 - 8] != 'L' || cArray[n2 - 7] != 'i' && cArray[n2 - 7] != 'I' || cArray[n2 - 6] != 'f' && cArray[n2 - 6] != 'F' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'y' && cArray[n2 - 3] != 'Y' || cArray[n2 - 2] != 'c' && cArray[n2 - 2] != 'C' || cArray[n2 - 1] != 'l' && cArray[n2 - 1] != 'L' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 9;
                n |= 2;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'm' && cArray[n2 - 7] != 'M' || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 't' && cArray[n2 - 5] != 'T' || cArray[n2 - 4] != 'a' && cArray[n2 - 4] != 'A' || cArray[n2 - 3] != 'd' && cArray[n2 - 3] != 'D' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'a' && cArray[n2] != 'A')) {
                n3 = 8;
                n |= 4;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'c' && cArray[n2 - 6] != 'C' || cArray[n2 - 5] != 'o' && cArray[n2 - 5] != 'O' || cArray[n2 - 4] != 'n' && cArray[n2 - 4] != 'N' || cArray[n2 - 3] != 't' && cArray[n2 - 3] != 'T' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'x' && cArray[n2 - 1] != 'X' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 7;
                n |= 8;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission subsystemPermission = (SubsystemPermission)permission;
        if (this.subsystem != null) {
            return false;
        }
        if (subsystemPermission.filter != null) {
            return false;
        }
        return this.implies0(subsystemPermission, 0);
    }

    boolean implies0(SubsystemPermission subsystemPermission, int n) {
        int n2 = subsystemPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        if (subsystemPermission.subsystem == null) {
            return false;
        }
        Map<String, Object> map = subsystemPermission.getProperties();
        if (map == null) {
            return true;
        }
        return filter.matches(map);
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(EXECUTE);
                stringBuffer.append(',');
            }
            if ((n & 2) == 2) {
                stringBuffer.append(LIFECYCLE);
                stringBuffer.append(',');
            }
            if ((n & 4) == 4) {
                stringBuffer.append(METADATA);
                stringBuffer.append(',');
            }
            if ((n & 8) == 8) {
                stringBuffer.append(CONTEXT);
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SubsystemPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SubsystemPermission)) {
            return false;
        }
        SubsystemPermission subsystemPermission = (SubsystemPermission)object;
        return this.action_mask == subsystemPermission.action_mask && (this.subsystem == subsystemPermission.subsystem || this.subsystem != null && this.subsystem.equals(subsystemPermission.subsystem)) && (this.filter == null ? subsystemPermission.filter == null : this.filter.equals((Object)subsystemPermission.filter));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.subsystem != null) {
            n = 31 * n + this.subsystem.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.subsystem != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(SubsystemPermission.parseFilter(this.getName()), SubsystemPermission.parseActions(this.actions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        Subsystem subsystem = recurse.get();
        if (subsystem == this.subsystem) {
            return null;
        }
        recurse.set(this.subsystem);
        try {
            final HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    hashMap.put("id", new Long(SubsystemPermission.this.subsystem.getSubsystemId()));
                    hashMap.put("location", SubsystemPermission.this.subsystem.getLocation());
                    hashMap.put("name", SubsystemPermission.this.subsystem.getSymbolicName());
                    return null;
                }
            });
            this.properties = hashMap;
            HashMap<String, Object> hashMap2 = this.properties;
            return hashMap2;
        }
        finally {
            recurse.set(null);
        }
    }
}

