/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.http.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.Bundle;

@ConsumerType
public abstract class ServletContextHelper {
    public static final String REMOTE_USER = "org.osgi.service.http.authentication.remote.user";
    public static final String AUTHENTICATION_TYPE = "org.osgi.service.http.authentication.type";
    public static final String AUTHORIZATION = "org.osgi.service.useradmin.authorization";
    private final Bundle bundle;

    public ServletContextHelper() {
        this(null);
    }

    public ServletContextHelper(Bundle bundle) {
        this.bundle = bundle;
    }

    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return true;
    }

    public URL getResource(String string) {
        if (string != null && this.bundle != null) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return this.bundle.getEntry(string);
        }
        return null;
    }

    public String getMimeType(String string) {
        return null;
    }

    public Set<String> getResourcePaths(String string) {
        Enumeration enumeration;
        if (string != null && this.bundle != null && (enumeration = this.bundle.findEntries(string, null, false)) != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add(((URL)enumeration.nextElement()).getPath());
            }
            return linkedHashSet;
        }
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }
}

