/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.osgi.service.dmt.Uri;
import org.osgi.service.dmt.security.DmtPermissionCollection;

public class DmtPermission
extends Permission {
    private static final long serialVersionUID = -1910969921419407809L;
    public static final String ADD = "Add";
    public static final String DELETE = "Delete";
    public static final String EXEC = "Exec";
    public static final String GET = "Get";
    public static final String REPLACE = "Replace";
    private final boolean prefixPath;
    private final String path;
    private final int mask;
    private final String actions;

    public DmtPermission(String string, String string2) {
        super(string);
        this.mask = DmtPermission.getMask(string2);
        this.actions = DmtPermission.canonicalActions(this.mask);
        if (string == null) {
            throw new NullPointerException("'dmtUri' parameter must not be null.");
        }
        boolean bl = this.prefixPath = string.endsWith("*") && !string.endsWith("\\*");
        if (this.prefixPath && (string = string.substring(0, string.length() - 1)).length() == 0) {
            this.path = "";
            return;
        }
        if (this.prefixPath && string.endsWith("/") && !string.endsWith("\\/")) {
            this.checkUri(string.substring(0, string.length() - 1));
        } else {
            this.checkUri(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            char c = stringBuffer.charAt(i + 1);
            if (c != '/' && c != '\\') {
                stringBuffer.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        this.path = stringBuffer.toString();
    }

    private void checkUri(String string) throws IllegalArgumentException {
        if (!Uri.isValidUri(string)) {
            throw new IllegalArgumentException("'dmtUri' parameter does not contain a valid URI.");
        }
        if (!Uri.isAbsoluteUri(string)) {
            throw new IllegalArgumentException("'dmtUri' parameter does not contain an absolute URI.");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DmtPermission)) {
            return false;
        }
        DmtPermission dmtPermission = (DmtPermission)object;
        return this.mask == dmtPermission.mask && this.prefixPath == dmtPermission.prefixPath && this.path.equals(dmtPermission.path);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public int hashCode() {
        return new Integer(this.mask).hashCode() ^ new Boolean(this.prefixPath).hashCode() ^ this.path.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPermission)) {
            return false;
        }
        DmtPermission dmtPermission = (DmtPermission)permission;
        if ((this.mask & dmtPermission.mask) != dmtPermission.mask) {
            return false;
        }
        return this.impliesPath(dmtPermission);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DmtPermissionCollection();
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            throw new NullPointerException("'actions' parameter cannot be null.");
        }
        if (string.equals("*")) {
            return 31;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase(GET)) {
                n |= 1;
                continue;
            }
            if (string2.equalsIgnoreCase(ADD)) {
                n |= 2;
                continue;
            }
            if (string2.equalsIgnoreCase(REPLACE)) {
                n |= 4;
                continue;
            }
            if (string2.equalsIgnoreCase(DELETE)) {
                n |= 8;
                continue;
            }
            if (string2.equalsIgnoreCase(EXEC)) {
                n |= 0x10;
                continue;
            }
            throw new IllegalArgumentException("Invalid action '" + string2 + "'");
        }
        if (n == 0) {
            throw new IllegalArgumentException("Action mask cannot be empty.");
        }
        return n;
    }

    private static String canonicalActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        DmtPermission.addAction(stringBuffer, n, 2, ADD);
        DmtPermission.addAction(stringBuffer, n, 8, DELETE);
        DmtPermission.addAction(stringBuffer, n, 16, EXEC);
        DmtPermission.addAction(stringBuffer, n, 1, GET);
        DmtPermission.addAction(stringBuffer, n, 4, REPLACE);
        return stringBuffer.toString();
    }

    private static void addAction(StringBuffer stringBuffer, int n, int n2, String string) {
        if ((n & n2) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
    }

    int getMask() {
        return this.mask;
    }

    boolean impliesPath(DmtPermission dmtPermission) {
        return this.prefixPath ? dmtPermission.path.startsWith(this.path) : !dmtPermission.prefixPath && dmtPermission.path.equals(this.path);
    }
}

