/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.cm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.cm.ConfigurationPermissionCollection;

public final class ConfigurationPermission
extends BasicPermission {
    static final long serialVersionUID = 5716868734811965383L;
    public static final String CONFIGURE = "configure";
    public static final String TARGET = "target";
    private static final int ACTION_CONFIGURE = 1;
    private static final int ACTION_TARGET = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    private transient List<String> substrings;

    public ConfigurationPermission(String string, String string2) {
        this(string, ConfigurationPermission.parseActions(string2));
    }

    ConfigurationPermission(String string, int n) {
        super(string);
        this.setTransients(n);
    }

    private void setTransients(int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.substrings = ConfigurationPermission.parseSubstring(this.getName());
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 5 || cArray[n2 - 5] != 't' && cArray[n2 - 5] != 'T' || cArray[n2 - 4] != 'a' && cArray[n2 - 4] != 'A' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'g' && cArray[n2 - 2] != 'G' || cArray[n2 - 1] != 'e' && cArray[n2 - 1] != 'E' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 2;
            } else if (!(n2 < 8 || cArray[n2 - 8] != 'c' && cArray[n2 - 8] != 'C' || cArray[n2 - 7] != 'o' && cArray[n2 - 7] != 'O' || cArray[n2 - 6] != 'n' && cArray[n2 - 6] != 'N' || cArray[n2 - 5] != 'f' && cArray[n2 - 5] != 'F' || cArray[n2 - 4] != 'i' && cArray[n2 - 4] != 'I' || cArray[n2 - 3] != 'g' && cArray[n2 - 3] != 'G' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 9;
                n |= 1;
            } else {
                throw new IllegalArgumentException("invalid actions: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid actions: " + string);
        }
        return n;
    }

    private static List<String> parseSubstring(String string) {
        int n;
        if (string.indexOf(42) < 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        block4: for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            switch (c) {
                case '*': {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    arrayList.add(null);
                    continue block4;
                }
                case '\\': {
                    if (++n < cArray.length) {
                        c = cArray[n];
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        if (n == 1 && arrayList.get(0) != null) {
            return null;
        }
        return arrayList;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission configurationPermission = (ConfigurationPermission)permission;
        return this.implies0(configurationPermission, 0);
    }

    boolean implies0(ConfigurationPermission configurationPermission, int n) {
        int n2 = configurationPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        String string = configurationPermission.getName();
        if (this.substrings == null) {
            return this.getName().equals(string);
        }
        int n3 = 0;
        int n4 = this.substrings.size();
        for (int i = 0; i < n4; ++i) {
            String string2 = this.substrings.get(i);
            if (i + 1 < n4) {
                if (string2 == null) {
                    String string3 = this.substrings.get(i + 1);
                    if (string3 == null) continue;
                    int n5 = string.indexOf(string3, n3);
                    if (n5 == -1) {
                        return false;
                    }
                    n3 = n5 + string3.length();
                    if (i + 2 >= n4) continue;
                    ++i;
                    continue;
                }
                int n6 = string2.length();
                if (string.regionMatches(n3, string2, 0, n6)) {
                    n3 += n6;
                    continue;
                }
                return false;
            }
            if (string2 == null) {
                return true;
            }
            return string.endsWith(string2);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission configurationPermission = (ConfigurationPermission)object;
        return this.action_mask == configurationPermission.action_mask && this.getName().equals(configurationPermission.getName());
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        return n;
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(CONFIGURE);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(TARGET);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ConfigurationPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(ConfigurationPermission.parseActions(this.actions));
    }
}

