/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.SmartPrinter;
import org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import org.mockito.invocation.Invocation;

public class MissingInvocationChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;

    public MissingInvocationChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    MissingInvocationChecker(InvocationsFinder invocationsFinder, Reporter reporter) {
        this.finder = invocationsFinder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher) {
        List<Invocation> list2 = this.finder.findInvocations(list, invocationMatcher);
        if (list2.isEmpty()) {
            Invocation invocation = this.finder.findSimilarInvocation(list, invocationMatcher);
            if (invocation != null) {
                ArgumentMatchingTool argumentMatchingTool = new ArgumentMatchingTool();
                Integer[] integerArray = argumentMatchingTool.getSuspiciouslyNotMatchingArgsIndexes(invocationMatcher.getMatchers(), invocation.getArguments());
                SmartPrinter smartPrinter = new SmartPrinter(invocationMatcher, invocation, integerArray);
                this.reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActual(), invocation.getLocation());
            } else {
                this.reporter.wantedButNotInvoked(invocationMatcher, list);
            }
        }
    }
}

