/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.Checks;

public abstract class GenericMetadataSupport {
    protected Map<TypeVariable, Type> contextualActualTypeParameters = new HashMap<TypeVariable, Type>();

    protected void registerTypeVariablesOn(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeArray.length; ++i) {
            TypeVariable typeVariable = typeVariableArray[i];
            Type type2 = typeArray[i];
            if (type2 instanceof WildcardType) {
                this.contextualActualTypeParameters.put(typeVariable, this.boundsOf((WildcardType)type2));
                continue;
            }
            if (typeVariable == type2) continue;
            this.contextualActualTypeParameters.put(typeVariable, type2);
        }
    }

    protected void registerTypeParametersOn(TypeVariable[] typeVariableArray) {
        for (TypeVariable typeVariable : typeVariableArray) {
            this.registerTypeVariableIfNotPresent(typeVariable);
        }
    }

    private void registerTypeVariableIfNotPresent(TypeVariable typeVariable) {
        if (!this.contextualActualTypeParameters.containsKey(typeVariable)) {
            this.contextualActualTypeParameters.put(typeVariable, this.boundsOf(typeVariable));
        }
    }

    private BoundedType boundsOf(TypeVariable typeVariable) {
        if (typeVariable.getBounds()[0] instanceof TypeVariable) {
            return this.boundsOf((TypeVariable)typeVariable.getBounds()[0]);
        }
        return new TypeVarBoundedType(typeVariable);
    }

    private BoundedType boundsOf(WildcardType wildcardType) {
        WildCardBoundedType wildCardBoundedType = new WildCardBoundedType(wildcardType);
        if (wildCardBoundedType.firstBound() instanceof TypeVariable) {
            return this.boundsOf((TypeVariable)wildCardBoundedType.firstBound());
        }
        return wildCardBoundedType;
    }

    public abstract Class<?> rawType();

    public List<Type> extraInterfaces() {
        return Collections.emptyList();
    }

    public Class<?>[] rawExtraInterfaces() {
        return new Class[0];
    }

    public boolean hasRawExtraInterfaces() {
        return this.rawExtraInterfaces().length > 0;
    }

    public Map<TypeVariable, Type> actualTypeArguments() {
        TypeVariable<Class<?>>[] typeVariableArray = this.rawType().getTypeParameters();
        LinkedHashMap<TypeVariable, Type> linkedHashMap = new LinkedHashMap<TypeVariable, Type>();
        for (TypeVariable<Class<?>> typeVariable : typeVariableArray) {
            Type type = this.getActualTypeArgumentFor(typeVariable);
            linkedHashMap.put(typeVariable, type);
        }
        return linkedHashMap;
    }

    protected Type getActualTypeArgumentFor(TypeVariable typeVariable) {
        Type type = this.contextualActualTypeParameters.get(typeVariable);
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable2 = (TypeVariable)type;
            return this.getActualTypeArgumentFor(typeVariable2);
        }
        return type;
    }

    public GenericMetadataSupport resolveGenericReturnType(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof Class) {
            return new NotGenericReturnTypeSupport(type);
        }
        if (type instanceof ParameterizedType) {
            return new ParameterizedReturnType(this, method.getTypeParameters(), (ParameterizedType)method.getGenericReturnType());
        }
        if (type instanceof TypeVariable) {
            return new TypeVariableReturnType(this, method.getTypeParameters(), (TypeVariable)type);
        }
        throw new MockitoException("Ouch, it shouldn't happen, type '" + type.getClass().getCanonicalName() + "' on method : '" + method.toGenericString() + "' is not supported : " + type);
    }

    public static GenericMetadataSupport inferFrom(Type type) {
        Checks.checkNotNull(type, "type");
        if (type instanceof Class) {
            return new FromClassGenericMetadataSupport((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return new FromParameterizedTypeGenericMetadataSupport((ParameterizedType)type);
        }
        throw new MockitoException("Type meta-data for this Type (" + type.getClass().getCanonicalName() + ") is not supported : " + type);
    }

    public static class WildCardBoundedType
    implements BoundedType {
        private final WildcardType wildcard;

        public WildCardBoundedType(WildcardType wildcardType) {
            this.wildcard = wildcardType;
        }

        @Override
        public Type firstBound() {
            Type[] typeArray = this.wildcard.getLowerBounds();
            Type[] typeArray2 = this.wildcard.getUpperBounds();
            return typeArray.length != 0 ? typeArray[0] : typeArray2[0];
        }

        @Override
        public Type[] interfaceBounds() {
            return new Type[0];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.wildcard.equals(((TypeVarBoundedType)object).typeVariable);
        }

        public int hashCode() {
            return this.wildcard.hashCode();
        }

        public String toString() {
            return "{firstBound=" + this.firstBound() + ", interfaceBounds=[]}";
        }

        public WildcardType wildCard() {
            return this.wildcard;
        }
    }

    public static class TypeVarBoundedType
    implements BoundedType {
        private final TypeVariable typeVariable;

        public TypeVarBoundedType(TypeVariable typeVariable) {
            this.typeVariable = typeVariable;
        }

        @Override
        public Type firstBound() {
            return this.typeVariable.getBounds()[0];
        }

        @Override
        public Type[] interfaceBounds() {
            Type[] typeArray = new Type[this.typeVariable.getBounds().length - 1];
            System.arraycopy(this.typeVariable.getBounds(), 1, typeArray, 0, this.typeVariable.getBounds().length - 1);
            return typeArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.typeVariable.equals(((TypeVarBoundedType)object).typeVariable);
        }

        public int hashCode() {
            return this.typeVariable.hashCode();
        }

        public String toString() {
            return "{firstBound=" + this.firstBound() + ", interfaceBounds=" + Arrays.deepToString(this.interfaceBounds()) + '}';
        }

        public TypeVariable typeVariable() {
            return this.typeVariable;
        }
    }

    public static interface BoundedType
    extends Type {
        public Type firstBound();

        public Type[] interfaceBounds();
    }

    private static class NotGenericReturnTypeSupport
    extends GenericMetadataSupport {
        private final Class<?> returnType;

        public NotGenericReturnTypeSupport(Type type) {
            this.returnType = (Class)type;
        }

        @Override
        public Class<?> rawType() {
            return this.returnType;
        }
    }

    private static class TypeVariableReturnType
    extends GenericMetadataSupport {
        private final TypeVariable typeVariable;
        private final TypeVariable[] typeParameters;
        private Class<?> rawType;

        public TypeVariableReturnType(GenericMetadataSupport genericMetadataSupport, TypeVariable[] typeVariableArray, TypeVariable typeVariable) {
            this.typeParameters = typeVariableArray;
            this.typeVariable = typeVariable;
            this.contextualActualTypeParameters = genericMetadataSupport.contextualActualTypeParameters;
            this.readTypeParameters();
            this.readTypeVariables();
        }

        private void readTypeParameters() {
            this.registerTypeParametersOn(this.typeParameters);
        }

        private void readTypeVariables() {
            for (Type type : this.typeVariable.getBounds()) {
                this.registerTypeVariablesOn(type);
            }
            this.registerTypeParametersOn(new TypeVariable[]{this.typeVariable});
            this.registerTypeVariablesOn(this.getActualTypeArgumentFor(this.typeVariable));
        }

        @Override
        public Class<?> rawType() {
            if (this.rawType == null) {
                this.rawType = this.extractRawTypeOf(this.typeVariable);
            }
            return this.rawType;
        }

        private Class<?> extractRawTypeOf(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof BoundedType) {
                return this.extractRawTypeOf(((BoundedType)type).firstBound());
            }
            if (type instanceof TypeVariable) {
                return this.extractRawTypeOf((Type)this.contextualActualTypeParameters.get(type));
            }
            throw new MockitoException("Raw extraction not supported for : '" + type + "'");
        }

        @Override
        public List<Type> extraInterfaces() {
            Type type = this.extractActualBoundedTypeOf(this.typeVariable);
            if (type instanceof BoundedType) {
                return Arrays.asList(((BoundedType)type).interfaceBounds());
            }
            if (type instanceof ParameterizedType) {
                return Collections.singletonList(type);
            }
            if (type instanceof Class) {
                return Collections.emptyList();
            }
            throw new MockitoException("Cannot extract extra-interfaces from '" + this.typeVariable + "' : '" + type + "'");
        }

        @Override
        public Class<?>[] rawExtraInterfaces() {
            List<Type> list = this.extraInterfaces();
            ArrayList arrayList = new ArrayList();
            for (Type type : list) {
                Class<?> clazz = this.extractRawTypeOf(type);
                if (this.rawType().equals(clazz)) continue;
                arrayList.add(clazz);
            }
            return arrayList.toArray(new Class[arrayList.size()]);
        }

        private Type extractActualBoundedTypeOf(Type type) {
            if (type instanceof TypeVariable) {
                return this.extractActualBoundedTypeOf((Type)this.contextualActualTypeParameters.get(type));
            }
            if (type instanceof BoundedType) {
                Type type2 = this.extractActualBoundedTypeOf(((BoundedType)type).firstBound());
                if (!(type2 instanceof BoundedType)) {
                    return type;
                }
                return type2;
            }
            return type;
        }
    }

    private static class ParameterizedReturnType
    extends GenericMetadataSupport {
        private final ParameterizedType parameterizedType;
        private final TypeVariable[] typeParameters;

        public ParameterizedReturnType(GenericMetadataSupport genericMetadataSupport, TypeVariable[] typeVariableArray, ParameterizedType parameterizedType) {
            this.parameterizedType = parameterizedType;
            this.typeParameters = typeVariableArray;
            this.contextualActualTypeParameters = genericMetadataSupport.contextualActualTypeParameters;
            this.readTypeParameters();
            this.readTypeVariables();
        }

        private void readTypeParameters() {
            this.registerTypeParametersOn(this.typeParameters);
        }

        private void readTypeVariables() {
            this.registerTypeVariablesOn(this.parameterizedType);
        }

        @Override
        public Class<?> rawType() {
            return (Class)this.parameterizedType.getRawType();
        }
    }

    private static class FromParameterizedTypeGenericMetadataSupport
    extends GenericMetadataSupport {
        private final ParameterizedType parameterizedType;

        public FromParameterizedTypeGenericMetadataSupport(ParameterizedType parameterizedType) {
            this.parameterizedType = parameterizedType;
            this.readActualTypeParameters();
        }

        private void readActualTypeParameters() {
            this.registerTypeVariablesOn(this.parameterizedType.getRawType());
            this.registerTypeVariablesOn(this.parameterizedType);
        }

        @Override
        public Class<?> rawType() {
            return (Class)this.parameterizedType.getRawType();
        }
    }

    private static class FromClassGenericMetadataSupport
    extends GenericMetadataSupport {
        private final Class<?> clazz;

        public FromClassGenericMetadataSupport(Class<?> clazz) {
            this.clazz = clazz;
            Class clazz2 = clazz;
            while (clazz2 != null && clazz2 != Object.class) {
                this.readActualTypeParametersOnDeclaringClass(clazz2);
                clazz2 = this.superClassOf(clazz2);
            }
        }

        private Class superClassOf(Class clazz) {
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                Type type2 = ((ParameterizedType)type).getRawType();
                return (Class)type2;
            }
            return (Class)type;
        }

        private void readActualTypeParametersOnDeclaringClass(Class<?> clazz) {
            this.registerTypeParametersOn(clazz.getTypeParameters());
            this.registerTypeVariablesOn(clazz.getGenericSuperclass());
            for (Type type : clazz.getGenericInterfaces()) {
                this.registerTypeVariablesOn(type);
            }
        }

        @Override
        public Class<?> rawType() {
            return this.clazz;
        }
    }
}

