/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.mockito.Mockito;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.Location;
import org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        Object object = this.delegate.answer(invocationOnMock);
        if (object != null) {
            return object;
        }
        Class<?> clazz = invocationOnMock.getMethod().getReturnType();
        if (!clazz.isPrimitive() && !Modifier.isFinal(clazz.getModifiers())) {
            LocationImpl locationImpl = new LocationImpl();
            return Mockito.mock(clazz, new ThrowsSmartNullPointer(invocationOnMock, locationImpl));
        }
        return null;
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        public ThrowsSmartNullPointer(InvocationOnMock invocationOnMock, Location location) {
            this.unstubbedInvocation = invocationOnMock;
            this.location = location;
        }

        public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
            if (new ObjectMethodsGuru().isToString(invocationOnMock.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation.toString();
            }
            new Reporter().smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
            return null;
        }
    }
}

