/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.io.Serializable;
import org.mockito.internal.listeners.MockingProgressListener;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.IOngoingStubbing;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.MockingProgressImpl;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class ThreadSafeMockingProgress
implements MockingProgress,
Serializable {
    private static final long serialVersionUID = 6839454041642082618L;
    private static final ThreadLocal<MockingProgress> mockingProgress = new ThreadLocal();

    static MockingProgress threadSafely() {
        if (mockingProgress.get() == null) {
            mockingProgress.set(new MockingProgressImpl());
        }
        return mockingProgress.get();
    }

    @Override
    public void reportOngoingStubbing(IOngoingStubbing iOngoingStubbing) {
        ThreadSafeMockingProgress.threadSafely().reportOngoingStubbing(iOngoingStubbing);
    }

    @Override
    public IOngoingStubbing pullOngoingStubbing() {
        return ThreadSafeMockingProgress.threadSafely().pullOngoingStubbing();
    }

    @Override
    public void verificationStarted(VerificationMode verificationMode) {
        ThreadSafeMockingProgress.threadSafely().verificationStarted(verificationMode);
    }

    @Override
    public VerificationMode pullVerificationMode() {
        return ThreadSafeMockingProgress.threadSafely().pullVerificationMode();
    }

    @Override
    public void stubbingStarted() {
        ThreadSafeMockingProgress.threadSafely().stubbingStarted();
    }

    @Override
    public void validateState() {
        ThreadSafeMockingProgress.threadSafely().validateState();
    }

    @Override
    public void stubbingCompleted(Invocation invocation) {
        ThreadSafeMockingProgress.threadSafely().stubbingCompleted(invocation);
    }

    public String toString() {
        return ThreadSafeMockingProgress.threadSafely().toString();
    }

    @Override
    public void reset() {
        ThreadSafeMockingProgress.threadSafely().reset();
    }

    @Override
    public void resetOngoingStubbing() {
        ThreadSafeMockingProgress.threadSafely().resetOngoingStubbing();
    }

    @Override
    public ArgumentMatcherStorage getArgumentMatcherStorage() {
        return ThreadSafeMockingProgress.threadSafely().getArgumentMatcherStorage();
    }

    @Override
    public void mockingStarted(Object object, Class clazz) {
        ThreadSafeMockingProgress.threadSafely().mockingStarted(object, clazz);
    }

    @Override
    public void setListener(MockingProgressListener mockingProgressListener) {
        ThreadSafeMockingProgress.threadSafely().setListener(mockingProgressListener);
    }
}

