/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.MockitoMethod;

public class SerializableMethod
implements Serializable,
MockitoMethod {
    private static final long serialVersionUID = 6005610965006048445L;
    private final Class<?> declaringClass;
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Class<?> returnType;
    private final Class<?>[] exceptionTypes;
    private final boolean isVarArgs;
    private final boolean isAbstract;

    public SerializableMethod(Method method) {
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType();
        this.exceptionTypes = method.getExceptionTypes();
        this.isVarArgs = method.isVarArgs();
        this.isAbstract = (method.getModifiers() & 0x400) != 0;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public Method getJavaMethod() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes);
        }
        catch (SecurityException securityException) {
            String string = String.format("The method %1$s.%2$s is probably private or protected and cannot be mocked.\nPlease report this as a defect with an example of how to reproduce it.", this.declaringClass, this.methodName);
            throw new MockitoException(string, securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = String.format("The method %1$s.%2$s does not exists and you should not get to this point.\nPlease report this as a defect with an example of how to reproduce it.", this.declaringClass, this.methodName);
            throw new MockitoException(string, noSuchMethodException);
        }
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SerializableMethod serializableMethod = (SerializableMethod)object;
        if (this.declaringClass == null ? serializableMethod.declaringClass != null : !this.declaringClass.equals(serializableMethod.declaringClass)) {
            return false;
        }
        if (this.methodName == null ? serializableMethod.methodName != null : !this.methodName.equals(serializableMethod.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, serializableMethod.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? serializableMethod.returnType != null : !this.returnType.equals(serializableMethod.returnType));
    }
}

