/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.listeners.NotifiedMethodInvocationReport;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;

class InvocationNotifierHandler<T>
implements MockHandler,
InternalMockHandler<T> {
    private final List<InvocationListener> invocationListeners;
    private final InternalMockHandler<T> mockHandler;

    public InvocationNotifierHandler(InternalMockHandler<T> internalMockHandler, MockCreationSettings mockCreationSettings) {
        this.mockHandler = internalMockHandler;
        this.invocationListeners = mockCreationSettings.getInvocationListeners();
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        try {
            Object object = this.mockHandler.handle(invocation);
            this.notifyMethodCall(invocation, object);
            return object;
        }
        catch (Throwable throwable) {
            this.notifyMethodCallException(invocation, throwable);
            throw throwable;
        }
    }

    private void notifyMethodCall(Invocation invocation, Object object) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            try {
                invocationListener.reportInvocation(new NotifiedMethodInvocationReport(invocation, object));
            }
            catch (Throwable throwable) {
                new Reporter().invocationListenerThrewException(invocationListener, throwable);
            }
        }
    }

    private void notifyMethodCallException(Invocation invocation, Throwable throwable) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            try {
                invocationListener.reportInvocation(new NotifiedMethodInvocationReport(invocation, throwable));
            }
            catch (Throwable throwable2) {
                new Reporter().invocationListenerThrewException(invocationListener, throwable2);
            }
        }
    }

    @Override
    public MockCreationSettings getMockSettings() {
        return this.mockHandler.getMockSettings();
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T t) {
        return this.mockHandler.voidMethodStubbable(t);
    }

    @Override
    public void setAnswersForStubbing(List<Answer> list) {
        this.mockHandler.setAnswersForStubbing(list);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.mockHandler.getInvocationContainer();
    }
}

