/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.cglib;

import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.cglib.AcrossJVMSerializationFeature;
import org.mockito.internal.creation.cglib.CGLIBHacker;
import org.mockito.internal.creation.cglib.DelegatingMockitoMethodProxy;
import org.mockito.internal.creation.cglib.SerializableMockitoMethodProxy;
import org.mockito.internal.creation.util.MockitoMethodProxy;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.realmethod.CleanTraceRealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;

class MethodInterceptorFilter
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 6182795666612683784L;
    private final InternalMockHandler handler;
    final ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
    private final MockCreationSettings mockSettings;
    private final AcrossJVMSerializationFeature acrossJVMSerializationFeature = new AcrossJVMSerializationFeature();

    public MethodInterceptorFilter(InternalMockHandler internalMockHandler, MockCreationSettings mockCreationSettings) {
        this.handler = internalMockHandler;
        this.mockSettings = mockCreationSettings;
    }

    public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return object == objectArray[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return this.hashCodeForMock(object);
        }
        if (this.acrossJVMSerializationFeature.isWriteReplace(method)) {
            return this.acrossJVMSerializationFeature.writeReplace(object);
        }
        MockitoMethodProxy mockitoMethodProxy = this.createMockitoMethodProxy(methodProxy);
        new CGLIBHacker().setMockitoNamingPolicy(methodProxy);
        MockitoMethod mockitoMethod = this.createMockitoMethod(method);
        CleanTraceRealMethod cleanTraceRealMethod = new CleanTraceRealMethod(mockitoMethodProxy);
        InvocationImpl invocationImpl = new InvocationImpl(object, mockitoMethod, objectArray, SequenceNumber.next(), cleanTraceRealMethod);
        return this.handler.handle(invocationImpl);
    }

    public MockHandler getHandler() {
        return this.handler;
    }

    private int hashCodeForMock(Object object) {
        return System.identityHashCode(object);
    }

    public MockitoMethodProxy createMockitoMethodProxy(MethodProxy methodProxy) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMockitoMethodProxy(methodProxy);
        }
        return new DelegatingMockitoMethodProxy(methodProxy);
    }

    public MockitoMethod createMockitoMethod(Method method) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

