/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class ConstructorInjection
extends MockInjectionStrategy {
    private FieldInitializer.ConstructorArgumentResolver argResolver;

    public ConstructorInjection() {
    }

    ConstructorInjection(FieldInitializer.ConstructorArgumentResolver constructorArgumentResolver) {
        this.argResolver = constructorArgumentResolver;
    }

    @Override
    public boolean processInjection(Field field, Object object, Set<Object> set) {
        try {
            SimpleArgumentResolver simpleArgumentResolver = new SimpleArgumentResolver(set);
            FieldInitializationReport fieldInitializationReport = new FieldInitializer(object, field, simpleArgumentResolver).initialize();
            return fieldInitializationReport.fieldWasInitializedUsingContructorArgs();
        }
        catch (MockitoException mockitoException) {
            if (mockitoException.getCause() instanceof InvocationTargetException) {
                Throwable throwable = mockitoException.getCause().getCause();
                new Reporter().fieldInitialisationThrewException(field, throwable);
            }
            return false;
        }
    }

    static class SimpleArgumentResolver
    implements FieldInitializer.ConstructorArgumentResolver {
        final Set<Object> objects;

        public SimpleArgumentResolver(Set<Object> set) {
            this.objects = set;
        }

        @Override
        public Object[] resolveTypeInstances(Class<?> ... classArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(classArray.length);
            for (Class<?> clazz : classArray) {
                arrayList.add(this.objectThatIsAssignableFrom(clazz));
            }
            return arrayList.toArray();
        }

        private Object objectThatIsAssignableFrom(Class<?> clazz) {
            for (Object object : this.objects) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                return object;
            }
            return null;
        }
    }
}

