/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.InterpolatorFilterReaderLineEnding;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenResourcesExecution
extends AbstractMavenFilteringRequest {
    private List<Resource> resources;
    private File outputDirectory;
    private List<String> nonFilteredFileExtensions;
    private List<FileUtils.FilterWrapper> filterWrappers;
    private File resourcesBaseDirectory;
    private boolean useDefaultFilterWrappers = false;
    private boolean filterFilenames = false;
    private boolean overwrite = false;
    private boolean includeEmptyDirs = false;
    private boolean supportMultiLineFiltering;

    public MavenResourcesExecution() {
    }

    public MavenResourcesExecution(List<Resource> resources, File outputDirectory, MavenProject mavenProject, String encoding, List<String> fileFilters, List<String> nonFilteredFileExtensions, MavenSession mavenSession) {
        super(mavenProject, fileFilters, encoding, mavenSession);
        this.resources = resources;
        this.outputDirectory = outputDirectory;
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
        this.useDefaultFilterWrappers = true;
        this.resourcesBaseDirectory = mavenProject.getBasedir();
    }

    public MavenResourcesExecution(List<Resource> resources, File outputDirectory, String encoding, List<FileUtils.FilterWrapper> filterWrappers, File resourcesBaseDirectory, List<String> nonFilteredFileExtensions) {
        this();
        this.resources = resources;
        this.outputDirectory = outputDirectory;
        this.filterWrappers = filterWrappers;
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
        this.resourcesBaseDirectory = resourcesBaseDirectory;
        this.useDefaultFilterWrappers = false;
        this.setEncoding(encoding);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<String> getNonFilteredFileExtensions() {
        return this.nonFilteredFileExtensions;
    }

    public void setNonFilteredFileExtensions(List<String> nonFilteredFileExtensions) {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    }

    public List<FileUtils.FilterWrapper> getFilterWrappers() {
        return this.filterWrappers;
    }

    public void setFilterWrappers(List<FileUtils.FilterWrapper> filterWrappers) {
        this.filterWrappers = filterWrappers;
    }

    public void addFilterWrapper(FileUtils.FilterWrapper filterWrapper) {
        if (this.filterWrappers == null) {
            this.filterWrappers = new ArrayList<FileUtils.FilterWrapper>();
        }
        this.filterWrappers.add(filterWrapper);
    }

    public void addFilerWrapper(final ValueSource valueSource) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolator = new RegexBasedInterpolator();
                propertiesInterpolator.addValueSource(valueSource);
                return new InterpolatorFilterReaderLineEnding(reader, (Interpolator)propertiesInterpolator, "${", "}", false);
            }
        });
    }

    public void addFilerWrapper(final ValueSource valueSource, final String startRegExp, final String endRegExp, final String startToken, final String endToken) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                RegexBasedInterpolator propertiesInterpolator = new RegexBasedInterpolator(startRegExp, endRegExp);
                propertiesInterpolator.addValueSource(valueSource);
                return new InterpolatorFilterReaderLineEnding(reader, (Interpolator)propertiesInterpolator, startToken, endToken, false);
            }
        });
    }

    public void addFilerWrapperWithEscaping(final ValueSource valueSource, final String startExp, final String endExp, final String escapeString) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator(startExp, endExp);
                propertiesInterpolator.addValueSource(valueSource);
                propertiesInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReaderLineEnding interpolatorFilterReader = new InterpolatorFilterReaderLineEnding(reader, (Interpolator)propertiesInterpolator, startExp, endExp, false);
                interpolatorFilterReader.setInterpolateWithPrefixPattern(false);
                return interpolatorFilterReader;
            }
        });
    }

    public void addFilerWrapperWithEscaping(final ValueSource valueSource, final String startExp, final String endExp, final String escapeString, final boolean supportMultiLineFiltering) {
        this.addFilterWrapper(new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator(startExp, endExp);
                propertiesInterpolator.addValueSource(valueSource);
                propertiesInterpolator.setEscapeString(escapeString);
                InterpolatorFilterReaderLineEnding interpolatorFilterReader = new InterpolatorFilterReaderLineEnding(reader, (Interpolator)propertiesInterpolator, startExp, endExp, supportMultiLineFiltering);
                interpolatorFilterReader.setInterpolateWithPrefixPattern(false);
                return interpolatorFilterReader;
            }
        });
    }

    public File getResourcesBaseDirectory() {
        return this.resourcesBaseDirectory;
    }

    public void setResourcesBaseDirectory(File resourcesBaseDirectory) {
        this.resourcesBaseDirectory = resourcesBaseDirectory;
    }

    public boolean isUseDefaultFilterWrappers() {
        return this.useDefaultFilterWrappers;
    }

    public void setUseDefaultFilterWrappers(boolean useDefaultFilterWrappers) {
        this.useDefaultFilterWrappers = useDefaultFilterWrappers;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public boolean isFilterFilenames() {
        return this.filterFilenames;
    }

    public void setFilterFilenames(boolean filterFilenames) {
        this.filterFilenames = filterFilenames;
    }

    public MavenResourcesExecution copyOf() {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setAdditionalProperties(mre.getAdditionalProperties());
        mre.setEncoding(mre.getEncoding());
        mre.setEscapedBackslashesInFilePath(mre.isEscapedBackslashesInFilePath());
        mre.setEscapeString(mre.getEscapeString());
        mre.setFileFilters(this.copyList(mre.getFileFilters()));
        mre.setFilterWrappers(this.copyList(mre.getFilterWrappers()));
        mre.setIncludeEmptyDirs(mre.isIncludeEmptyDirs());
        mre.setInjectProjectBuildFilters(mre.isInjectProjectBuildFilters());
        mre.setMavenProject(mre.getMavenProject());
        mre.setMavenSession(mre.getMavenSession());
        mre.setNonFilteredFileExtensions(this.copyList(mre.getNonFilteredFileExtensions()));
        mre.setOutputDirectory(mre.getOutputDirectory());
        mre.setOverwrite(mre.isOverwrite());
        mre.setProjectStartExpressions(this.copyList(mre.getProjectStartExpressions()));
        mre.setResources(this.copyList(mre.getResources()));
        mre.setResourcesBaseDirectory(mre.getResourcesBaseDirectory());
        mre.setUseDefaultFilterWrappers(mre.isUseDefaultFilterWrappers());
        mre.setSupportMultiLineFiltering(mre.isSupportMultiLineFiltering());
        return mre;
    }

    private <T> List<T> copyList(List<T> lst) {
        if (lst == null) {
            return null;
        }
        if (lst.isEmpty()) {
            return new ArrayList();
        }
        return new ArrayList<T>(lst);
    }

    @Override
    public boolean isSupportMultiLineFiltering() {
        return this.supportMultiLineFiltering;
    }

    @Override
    public void setSupportMultiLineFiltering(boolean supportMultiLineFiltering) {
        this.supportMultiLineFiltering = supportMultiLineFiltering;
    }
}

