/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import java.io.File;
import java.util.Set;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.db.SqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.SqlJetOptions;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDefaultBusyHandler;

public class SqlJetDb {
    public static final File IN_MEMORY = new File(":memory:");
    private static final String TRANSACTION_ALREADY_STARTED = "Transaction already started";
    private static final Set<SqlJetBtreeFlags> READ_FLAGS = SqlJetUtility.of(SqlJetBtreeFlags.READONLY);
    private static final Set<SqlJetFileOpenPermission> READ_PERMISSIONS = SqlJetUtility.of(SqlJetFileOpenPermission.READONLY);
    private static final Set<SqlJetBtreeFlags> WRITE_FLAGS = SqlJetUtility.of(SqlJetBtreeFlags.READWRITE, SqlJetBtreeFlags.CREATE);
    private static final Set<SqlJetFileOpenPermission> WRITE_PREMISSIONS = SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.CREATE);
    private boolean writable;
    private ISqlJetDbHandle dbHandle;
    private ISqlJetBtree btree;
    private boolean transaction;
    private SqlJetTransactionMode transactionMode;
    private boolean open = false;
    private File file;

    public SqlJetDb(File file, boolean writable) {
        this.writable = writable;
        this.file = file;
    }

    public synchronized void open() throws SqlJetException {
        if (!this.open) {
            this.dbHandle = new SqlJetDbHandle();
            this.dbHandle.setBusyHandler(new SqlJetDefaultBusyHandler());
            this.btree = new SqlJetBtree();
            Set<SqlJetBtreeFlags> flags = this.writable ? WRITE_FLAGS : READ_FLAGS;
            Set<SqlJetFileOpenPermission> permissions = this.writable ? WRITE_PREMISSIONS : READ_PERMISSIONS;
            SqlJetFileType type = this.file != null ? SqlJetFileType.MAIN_DB : SqlJetFileType.TEMP_DB;
            this.btree.open(this.file, this.dbHandle, flags, type, permissions);
            ISqlJetFile file = this.btree.getPager().getFile();
            if (file != null) {
                Set<SqlJetFileOpenPermission> realPermissions = this.btree.getPager().getFile().getPermissions();
                this.writable = realPermissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
            }
        } else {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database is open already");
        }
        this.open = true;
    }

    public static SqlJetDb open(File file, boolean write) throws SqlJetException {
        SqlJetDb db = new SqlJetDb(file, write);
        db.open();
        return db;
    }

    public boolean isOpen() {
        return this.open;
    }

    private void checkOpen() throws SqlJetException {
        if (!this.isOpen()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database closed");
        }
    }

    public void close() throws SqlJetException {
        if (this.open) {
            this.runWithLock(new ISqlJetRunnableWithLock(){

                public Object runWithLock(SqlJetDb db) throws SqlJetException {
                    if (SqlJetDb.this.btree != null) {
                        SqlJetDb.this.btree.close();
                        SqlJetDb.this.btree = null;
                        SqlJetDb.this.open = false;
                    }
                    return null;
                }
            });
            if (!this.open) {
                this.dbHandle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.open) {
                this.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private void readSchema() throws SqlJetException {
        this.runWithLock(new ISqlJetRunnableWithLock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.btree.enter();
                try {
                    SqlJetDb.this.dbHandle.setOptions(new SqlJetOptions(SqlJetDb.this.btree, SqlJetDb.this.dbHandle));
                    SqlJetDb.this.btree.setSchema(new SqlJetSchema(SqlJetDb.this.dbHandle, SqlJetDb.this.btree));
                    Object var3_2 = null;
                    SqlJetDb.this.btree.leave();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    SqlJetDb.this.btree.leave();
                    throw throwable;
                }
                return null;
            }
        });
    }

    public void setCacheSize(final int cacheSize) throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.btree.setCacheSize(cacheSize);
                return null;
            }
        });
    }

    public int getCacheSize() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (Integer)this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.btree.getCacheSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runWithLock(ISqlJetRunnableWithLock op) throws SqlJetException {
        this.checkOpen();
        this.dbHandle.getMutex().enter();
        try {
            Object object = op.runWithLock(this);
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isWritable() throws SqlJetException {
        this.checkOpen();
        return this.writable;
    }

    public ISqlJetSchema getSchema() throws SqlJetException {
        return this.getSchemaInternal();
    }

    private SqlJetSchema getSchemaInternal() throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getSchema();
    }

    public ISqlJetTable getTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetTable)this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetTable(db, SqlJetDb.this.btree, tableName, SqlJetDb.this.writable);
            }
        });
    }

    public Object runWriteTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        if (this.writable) {
            return this.runTransaction(op, SqlJetTransactionMode.WRITE);
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public Object runReadTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        return this.runTransaction(op, SqlJetTransactionMode.READ_ONLY);
    }

    public Object runTransaction(final ISqlJetTransaction op, final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        return this.runWithLock(new ISqlJetRunnableWithLock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                Object object;
                block5: {
                    if (SqlJetDb.this.transaction) {
                        if (mode != SqlJetDb.this.transactionMode && SqlJetDb.this.transactionMode == SqlJetTransactionMode.READ_ONLY) {
                            throw new SqlJetException(SqlJetErrorCode.MISUSE, SqlJetDb.TRANSACTION_ALREADY_STARTED);
                        }
                        return op.run(SqlJetDb.this);
                    }
                    SqlJetDb.this.beginTransaction(mode);
                    boolean success = false;
                    try {
                        Object result = op.run(SqlJetDb.this);
                        SqlJetDb.this.btree.commit();
                        success = true;
                        object = result;
                        Object var6_5 = null;
                        if (success) break block5;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!success) {
                            SqlJetDb.this.btree.rollback();
                        }
                        SqlJetDb.this.transaction = false;
                        SqlJetDb.this.transactionMode = null;
                        throw throwable;
                    }
                    SqlJetDb.this.btree.rollback();
                }
                SqlJetDb.this.transaction = false;
                SqlJetDb.this.transactionMode = null;
                return object;
            }
        });
    }

    public Object runTransaction(ISqlJetTransaction op, org.tmatesoft.sqljet.core.internal.SqlJetTransactionMode mode) throws SqlJetException {
        return this.runTransaction(op, mode.mode());
    }

    public void beginTransaction(final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.refreshSchema();
                if (SqlJetDb.this.transaction) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, SqlJetDb.TRANSACTION_ALREADY_STARTED);
                }
                SqlJetDb.this.btree.beginTrans(mode);
                SqlJetDb.this.transaction = true;
                SqlJetDb.this.transactionMode = mode;
                return null;
            }
        });
    }

    public void beginTransaction(org.tmatesoft.sqljet.core.internal.SqlJetTransactionMode mode) throws SqlJetException {
        this.beginTransaction(mode.mode());
    }

    public void commit() throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (!SqlJetDb.this.transaction) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Transaction wasn't started");
                }
                SqlJetDb.this.btree.closeAllCursors();
                SqlJetDb.this.btree.commit();
                SqlJetDb.this.transaction = false;
                SqlJetDb.this.transactionMode = null;
                return null;
            }
        });
    }

    public void rollback() throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.btree.closeAllCursors();
                SqlJetDb.this.btree.rollback();
                SqlJetDb.this.transaction = false;
                SqlJetDb.this.transactionMode = null;
                return null;
            }
        });
    }

    public ISqlJetOptions getOptions() throws SqlJetException {
        this.checkOpen();
        if (null == this.btree.getSchema()) {
            this.readSchema();
        }
        return this.dbHandle.getOptions();
    }

    public Object pragma(final String sql) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetPragmasHandler(SqlJetDb.this.getOptions()).pragma(sql);
            }
        });
    }

    public ISqlJetTableDef createTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createTable(sql);
            }
        });
    }

    public ISqlJetIndexDef createIndex(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetIndexDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createIndex(sql);
            }
        });
    }

    public void dropTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropTable(tableName);
                return null;
            }
        });
    }

    public void dropIndex(final String indexName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropIndex(indexName);
                return null;
            }
        });
    }

    public ISqlJetTableDef alterTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().alterTable(sql);
            }
        });
    }

    public ISqlJetVirtualTableDef createVirtualTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetVirtualTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createVirtualTable(sql, 0);
            }
        });
    }

    public ISqlJetBusyHandler getBusyHandler() {
        return this.dbHandle.getBusyHandler();
    }

    public void setBusyHandler(ISqlJetBusyHandler busyHandler) {
        this.dbHandle.setBusyHandler(busyHandler);
    }

    public void refreshSchema() throws SqlJetException {
        if (null == this.btree.getSchema() || !this.getOptions().verifySchemaVersion(false)) {
            this.readSchema();
        }
    }

    public boolean isInTransaction() {
        return this.transaction;
    }

    public SqlJetTransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public ISqlJetMutex getMutex() {
        return this.dbHandle.getMutex();
    }
}

