/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.resources.remote.RemoteResourcesBundle;
import org.apache.maven.plugin.resources.remote.RemoteResourcesClassLoader;
import org.apache.maven.plugin.resources.remote.Supplement;
import org.apache.maven.plugin.resources.remote.SupplementalDataModel;
import org.apache.maven.plugin.resources.remote.io.xpp3.RemoteResourcesBundleXpp3Reader;
import org.apache.maven.plugin.resources.remote.io.xpp3.SupplementalDataModelXpp3Reader;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class ProcessRemoteResourcesMojo
extends AbstractMojo
implements LogChute {
    private static final String TEMPLATE_SUFFIX = ".vm";
    @Parameter
    protected List<String> filterDelimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultFilterDelimiters;
    @Parameter(defaultValue="false")
    protected boolean runOnlyAtExecutionRoot;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/maven-shared-archive-resources")
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/appended-resources")
    private File appendedResourcesDirectory;
    @Parameter
    private String[] supplementalModels;
    @Parameter
    private List<String> supplementalModelArtifacts;
    private Map<String, Model> supplementModels;
    @Component
    private ModelInheritanceAssembler inheritanceAssembler;
    @Parameter(required=true)
    private List<String> resourceBundles;
    @Parameter(property="remoteresources.skip", defaultValue="false")
    private boolean skip;
    @Deprecated
    @Parameter(defaultValue="true")
    private boolean attached = true;
    @Parameter(defaultValue="true", property="attachToMain")
    private boolean attachToMain;
    @Parameter(defaultValue="true", property="attachToTest")
    private boolean attachToTest;
    @Parameter
    private Map<String, Object> properties = new HashMap<String, Object>();
    @Parameter(defaultValue="false")
    protected boolean includeProjectProperties = false;
    @Parameter(defaultValue="${project.resources}", readonly=true, required=true)
    private List<Resource> resources;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private MavenFileFilter fileFilter;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private MavenSession mavenSession;
    @Component(role=MavenProjectBuilder.class)
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private ResourceManager locator;
    @Parameter(property="includeScope", defaultValue="runtime")
    protected String includeScope;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter
    private String[] resolveScopes;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Component(hint="default")
    protected ProjectDependenciesResolver dependencyResolver;
    private VelocityEngine velocity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File sups;
        if (this.skip) {
            return;
        }
        if (this.runOnlyAtExecutionRoot && !this.isExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping remote-resource generation in this project because it's not the Execution Root");
            return;
        }
        if (this.resolveScopes == null) {
            this.resolveScopes = this.excludeScope == null || "".equals(this.excludeScope) ? new String[]{this.includeScope} : new String[]{"test"};
        }
        this.velocity = new VelocityEngine();
        this.velocity.setProperty("runtime.log.logsystem", (Object)this);
        this.velocity.setProperty("resource.loader", (Object)"classpath");
        this.velocity.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.velocity.init();
        if (this.supplementalModels == null && (sups = new File(this.appendedResourcesDirectory, "supplemental-models.xml")).exists()) {
            try {
                this.supplementalModels = new String[]{sups.toURI().toURL().toString()};
            }
            catch (MalformedURLException e) {
                this.getLog().debug((CharSequence)("URL issue with supplemental-models.xml: " + e.toString()));
            }
        }
        this.addSupplementalModelArtifacts();
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        if (this.appendedResourcesDirectory != null) {
            this.locator.addSearchPath("file", this.appendedResourcesDirectory.getAbsolutePath());
        }
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        if (this.includeProjectProperties) {
            Properties projectProperties = this.project.getProperties();
            for (Object key : projectProperties.keySet()) {
                this.properties.put(key.toString(), projectProperties.get(key).toString());
            }
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.validate();
            List<File> resourceBundleArtifacts = this.downloadBundles(this.resourceBundles);
            this.supplementModels = this.loadSupplements(this.supplementalModels);
            VelocityContext context = new VelocityContext(this.properties);
            this.configureVelocityContext(context);
            RemoteResourcesClassLoader classLoader = new RemoteResourcesClassLoader(null);
            this.initalizeClassloader(classLoader, resourceBundleArtifacts);
            Thread.currentThread().setContextClassLoader(classLoader);
            this.processResourceBundles(classLoader, context);
            try {
                if (this.outputDirectory.exists()) {
                    Resource resource = new Resource();
                    resource.setDirectory(this.outputDirectory.getAbsolutePath());
                    if (this.attached && this.attachToMain) {
                        this.project.getResources().add(resource);
                    }
                    if (this.attached && this.attachToTest) {
                        this.project.getTestResources().add(resource);
                    }
                    File dotFile = new File(this.project.getBuild().getDirectory(), ".plxarc");
                    FileUtils.mkdir((String)dotFile.getParentFile().getAbsolutePath());
                    FileUtils.fileWrite((String)dotFile.getAbsolutePath(), (String)this.outputDirectory.getName());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating dot file for archiving instructions.", (Exception)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private boolean isExecutionRoot() {
        Log log = this.getLog();
        boolean result = this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.basedir.toString());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Root Folder:" + this.mavenSession.getExecutionRootDirectory()));
            log.debug((CharSequence)("Current Folder:" + this.basedir));
            if (result) {
                log.debug((CharSequence)"This is the execution root.");
            } else {
                log.debug((CharSequence)"This is NOT the execution root.");
            }
        }
        return result;
    }

    private void addSupplementalModelArtifacts() throws MojoExecutionException {
        if (this.supplementalModelArtifacts != null && !this.supplementalModelArtifacts.isEmpty()) {
            List<File> artifacts = this.downloadBundles(this.supplementalModelArtifacts);
            for (File artifact : artifacts) {
                if (artifact.isDirectory()) {
                    this.locator.addSearchPath("file", artifact.getAbsolutePath());
                    continue;
                }
                try {
                    this.locator.addSearchPath("jar", "jar:" + artifact.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Could not use jar " + artifact.getAbsolutePath(), (Exception)e);
                }
            }
        }
    }

    protected List<MavenProject> getProjects() throws MojoExecutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        FilterArtifacts filter = new FilterArtifacts();
        Set artifacts = this.resolveProjectArtifacts();
        if (this.excludeTransitive) {
            Set depArtifacts = this.runOnlyAtExecutionRoot ? this.aggregateProjectDependencyArtifacts() : this.project.getDependencyArtifacts();
            filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(depArtifacts, true));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        for (Artifact artifact : artifacts) {
            try {
                List<ArtifactRepository> remoteRepo = this.remoteArtifactRepositories;
                if (artifact.isSnapshot()) {
                    VersionRange rng = VersionRange.createFromVersion((String)artifact.getBaseVersion());
                    artifact = this.artifactFactory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), rng, artifact.getType(), artifact.getClassifier(), artifact.getScope(), null, artifact.isOptional());
                }
                this.getLog().debug((CharSequence)("Building project for " + artifact));
                MavenProject p = null;
                try {
                    p = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepo, this.localRepository);
                }
                catch (InvalidProjectModelException e) {
                    this.getLog().warn((CharSequence)("Invalid project model for artifact [" + artifact.getArtifactId() + ":" + artifact.getGroupId() + ":" + artifact.getVersion() + "]. " + "It will be ignored by the remote resources Mojo."));
                    continue;
                }
                String supplementKey = ProcessRemoteResourcesMojo.generateSupplementMapKey(p.getModel().getGroupId(), p.getModel().getArtifactId());
                if (this.supplementModels.containsKey(supplementKey)) {
                    Model mergedModel = this.mergeModels(p.getModel(), this.supplementModels.get(supplementKey));
                    MavenProject mergedProject = new MavenProject(mergedModel);
                    projects.add(mergedProject);
                    mergedProject.setArtifact(artifact);
                    mergedProject.setVersion(artifact.getVersion());
                    this.getLog().debug((CharSequence)("Adding project with groupId [" + mergedProject.getGroupId() + "] (supplemented)"));
                    continue;
                }
                projects.add(p);
                this.getLog().debug((CharSequence)("Adding project with groupId [" + p.getGroupId() + "]"));
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        Collections.sort(projects, new ProjectComparator());
        return projects;
    }

    private Set<Artifact> resolveProjectArtifacts() throws MojoExecutionException {
        try {
            if (this.runOnlyAtExecutionRoot) {
                List projects = this.mavenSession.getSortedProjects();
                return this.dependencyResolver.resolve((Collection)projects, Arrays.asList(this.resolveScopes), this.mavenSession);
            }
            return this.dependencyResolver.resolve(this.project, Arrays.asList(this.resolveScopes), this.mavenSession);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve dependencies for one or more projects in the reactor. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to resolve dependencies for one or more projects in the reactor. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set<Artifact> aggregateProjectDependencyArtifacts() throws MojoExecutionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        List projects = this.mavenSession.getSortedProjects();
        for (MavenProject p : projects) {
            if (p.getDependencyArtifacts() != null) continue;
            try {
                Set depArtifacts = p.createArtifacts(this.artifactFactory, null, null);
                if (depArtifacts == null || depArtifacts.isEmpty()) continue;
                for (Artifact artifact : depArtifacts) {
                    if (artifact.getVersion() == null && artifact.getVersionRange() != null) {
                        artifact.setResolvedVersion("LATEST");
                    }
                    artifacts.add(artifact);
                }
            }
            catch (InvalidDependencyVersionException e) {
                throw new MojoExecutionException("Failed to create dependency artifacts for: " + p.getId() + ". Reason: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        return artifacts;
    }

    protected Map<Organization, List<MavenProject>> getProjectsSortedByOrganization(List<MavenProject> projects) throws MojoExecutionException {
        TreeMap<Organization, List<MavenProject>> organizations = new TreeMap<Organization, List<MavenProject>>(new OrganizationComparator());
        ArrayList<MavenProject> unknownOrganization = new ArrayList<MavenProject>();
        for (MavenProject p : projects) {
            if (p.getOrganization() != null && StringUtils.isNotEmpty((String)p.getOrganization().getName())) {
                ArrayList<MavenProject> sortedProjects = (ArrayList<MavenProject>)organizations.get(p.getOrganization());
                if (sortedProjects == null) {
                    sortedProjects = new ArrayList<MavenProject>();
                }
                sortedProjects.add(p);
                organizations.put(p.getOrganization(), sortedProjects);
                continue;
            }
            unknownOrganization.add(p);
        }
        if (!unknownOrganization.isEmpty()) {
            Organization unknownOrg = new Organization();
            unknownOrg.setName("an unknown organization");
            organizations.put(unknownOrg, unknownOrganization);
        }
        return organizations;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean copyResourceIfExists(File file, String relFileName, VelocityContext context) throws IOException, MojoExecutionException {
        File templateSource;
        File source;
        Resource resource;
        Iterator<Resource> i$ = this.resources.iterator();
        while (true) {
            if (!i$.hasNext()) {
                return false;
            }
            resource = i$.next();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists()) continue;
            source = new File(resourceDirectory, relFileName);
            templateSource = new File(resourceDirectory, relFileName + TEMPLATE_SUFFIX);
            if (!source.exists() && templateSource.exists()) {
                source = templateSource;
            }
            if (source.exists() && !source.equals(file)) break;
        }
        if (source == templateSource) {
            Reader reader = null;
            Writer writer = null;
            try {
                if (this.encoding != null) {
                    reader = new InputStreamReader((InputStream)new FileInputStream(source), this.encoding);
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
                } else {
                    reader = ReaderFactory.newPlatformReader((File)source);
                    writer = WriterFactory.newPlatformWriter((File)file);
                }
                this.velocity.evaluate((Context)context, writer, "", reader);
                this.velocity.evaluate((Context)context, writer, "", reader);
            }
            catch (ParseErrorException e) {
                try {
                    throw new MojoExecutionException("Error rendering velocity resource.", (Exception)((Object)e));
                    catch (MethodInvocationException e2) {
                        throw new MojoExecutionException("Error rendering velocity resource.", (Exception)((Object)e2));
                    }
                    catch (ResourceNotFoundException e3) {
                        throw new MojoExecutionException("Error rendering velocity resource.", (Exception)((Object)e3));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    IOUtil.close((Reader)reader);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            IOUtil.close((Reader)reader);
        } else if (resource.isFiltering()) {
            MavenFileFilterRequest req = this.setupRequest(resource, source, file);
            try {
                this.fileFilter.copyFile(req);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Error filtering resource: " + source, (Exception)((Object)e));
            }
        } else {
            FileUtils.copyFile((File)source, (File)file);
        }
        resource.addExclude(relFileName);
        return true;
    }

    private MavenFileFilterRequest setupRequest(Resource resource, File source, File file) {
        MavenFileFilterRequest req = new MavenFileFilterRequest();
        req.setFrom(source);
        req.setTo(file);
        req.setFiltering(resource.isFiltering());
        req.setMavenProject(this.project);
        req.setMavenSession(this.mavenSession);
        req.setInjectProjectBuildFilters(true);
        if (this.encoding != null) {
            req.setEncoding(this.encoding);
        }
        if (this.filterDelimiters != null && !this.filterDelimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultFilterDelimiters) {
                delims.addAll(req.getDelimiters());
            }
            for (String delim : this.filterDelimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            req.setDelimiters(delims);
        }
        return req;
    }

    protected void validate() throws MojoExecutionException {
        int bundleCount = 1;
        for (String artifactDescriptor : this.resourceBundles) {
            String[] s = StringUtils.split((String)artifactDescriptor, (String)":");
            if (s.length < 3 || s.length > 5) {
                String position = bundleCount == 1 ? "1st" : (bundleCount == 2 ? "2nd" : (bundleCount == 3 ? "3rd" : bundleCount + "th"));
                throw new MojoExecutionException("The " + position + " resource bundle configured must specify a groupId, artifactId, " + " version and, optionally, type and classifier for a remote resource bundle. " + "Must be of the form <resourceBundle>groupId:artifactId:version</resourceBundle>, " + "<resourceBundle>groupId:artifactId:version:type</resourceBundle> or " + "<resourceBundle>groupId:artifactId:version:type:classifier</resourceBundle>");
            }
            ++bundleCount;
        }
    }

    protected void configureVelocityContext(VelocityContext context) throws MojoExecutionException {
        String inceptionYear = this.project.getInceptionYear();
        String year = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtils.isEmpty((String)inceptionYear)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("inceptionYear not specified, defaulting to " + year));
            }
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        List<MavenProject> projects = this.getProjects();
        context.put("projects", projects);
        context.put("projectsSortedByOrganization", this.getProjectsSortedByOrganization(projects));
        context.put("presentYear", (Object)year);
        context.put("locator", (Object)this.locator);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
    }

    private List<File> downloadBundles(List<String> bundles) throws MojoExecutionException {
        ArrayList<File> bundleArtifacts = new ArrayList<File>();
        try {
            for (String artifactDescriptor : bundles) {
                String[] s = artifactDescriptor.split(":");
                File artifactFile = null;
                if (this.mavenSession != null) {
                    List list = this.mavenSession.getSortedProjects();
                    for (MavenProject p : list) {
                        if (!s[0].equals(p.getGroupId()) || !s[1].equals(p.getArtifactId()) || !s[2].equals(p.getVersion())) continue;
                        if (s.length >= 4 && "test-jar".equals(s[3])) {
                            artifactFile = new File(p.getBuild().getTestOutputDirectory());
                            continue;
                        }
                        artifactFile = new File(p.getBuild().getOutputDirectory());
                    }
                }
                if (artifactFile == null || !artifactFile.exists()) {
                    String type = s.length >= 4 ? s[3] : "jar";
                    String classifier = s.length == 5 ? s[4] : null;
                    Artifact artifact = this.artifactFactory.createDependencyArtifact(s[0], s[1], VersionRange.createFromVersion((String)s[2]), type, classifier, "runtime");
                    this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localRepository);
                    artifactFile = artifact.getFile();
                }
                bundleArtifacts.add(artifactFile);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error downloading resources archive.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Resources archive cannot be found.", (Exception)((Object)e));
        }
        return bundleArtifacts;
    }

    private void initalizeClassloader(RemoteResourcesClassLoader cl, List<File> artifacts) throws MojoExecutionException {
        try {
            for (File artifact : artifacts) {
                cl.addURL(artifact.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to configure resources classloader: " + e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResourceBundles(RemoteResourcesClassLoader classLoader, VelocityContext context) throws MojoExecutionException {
        InputStreamReader reader = null;
        try {
            Enumeration<URL> e = classLoader.getResources("META-INF/maven/remote-resources.xml");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    reader = new InputStreamReader(url.openStream());
                    RemoteResourcesBundleXpp3Reader bundleReader = new RemoteResourcesBundleXpp3Reader();
                    RemoteResourcesBundle bundle = bundleReader.read(reader);
                    Iterator<String> i$ = bundle.getRemoteResources().iterator();
                    while (i$.hasNext()) {
                        String bundleResource;
                        String projectResource = bundleResource = i$.next();
                        boolean doVelocity = false;
                        if (projectResource.endsWith(TEMPLATE_SUFFIX)) {
                            projectResource = projectResource.substring(0, projectResource.length() - 3);
                            doVelocity = true;
                        }
                        File f = new File(this.outputDirectory, projectResource);
                        FileUtils.mkdir((String)f.getParentFile().getAbsolutePath());
                        if (this.copyResourceIfExists(f, projectResource, context)) continue;
                        if (doVelocity) {
                            PrintWriter writer = bundle.getSourceEncoding() == null ? new PrintWriter(new FileWriter(f)) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), bundle.getSourceEncoding()));
                            try {
                                if (bundle.getSourceEncoding() == null) {
                                    this.velocity.mergeTemplate(bundleResource, "ISO-8859-1", (Context)context, (Writer)writer);
                                }
                                this.velocity.mergeTemplate(bundleResource, bundle.getSourceEncoding(), (Context)context, (Writer)writer);
                            }
                            finally {
                                IOUtil.close((Writer)writer);
                            }
                        } else {
                            URL resUrl = classLoader.getResource(bundleResource);
                            if (resUrl != null) {
                                FileUtils.copyURLToFile((URL)resUrl, (File)f);
                            }
                        }
                        File appendedResourceFile = new File(this.appendedResourcesDirectory, projectResource);
                        File appendedVmResourceFile = new File(this.appendedResourcesDirectory, projectResource + TEMPLATE_SUFFIX);
                        if (appendedResourceFile.exists()) {
                            FileInputStream in = new FileInputStream(appendedResourceFile);
                            FileOutputStream append = new FileOutputStream(f, true);
                            try {
                                IOUtil.copy((InputStream)in, (OutputStream)append);
                                continue;
                            }
                            finally {
                                IOUtil.close((InputStream)in);
                                IOUtil.close((OutputStream)append);
                                continue;
                            }
                        }
                        if (!appendedVmResourceFile.exists()) continue;
                        FileReader freader = new FileReader(appendedVmResourceFile);
                        PrintWriter writer = bundle.getSourceEncoding() == null ? new PrintWriter(new FileWriter(f, true)) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), bundle.getSourceEncoding()));
                        try {
                            Velocity.init();
                            Velocity.evaluate((Context)context, (Writer)writer, (String)"remote-resources", (Reader)freader);
                        }
                        finally {
                            IOUtil.close((Writer)writer);
                            IOUtil.close((Reader)freader);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error finding remote resources manifests", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing remote resource bundle descriptor.", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error rendering velocity resource.", e);
        }
    }

    protected Model getSupplement(Xpp3Dom supplementModelXml) throws MojoExecutionException {
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)new StringReader(supplementModelXml.toString()));
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            if (groupId == null || groupId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <groupId> element be present.");
            }
            if (artifactId == null || artifactId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <artifactId> element be present.");
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)("Unable to parse supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        return model;
    }

    protected Model mergeModels(Model parent, Model child) {
        this.inheritanceAssembler.assembleModelInheritance(child, parent);
        return child;
    }

    private static String generateSupplementMapKey(String groupId, String artifactId) {
        return groupId.trim() + ":" + artifactId.trim();
    }

    private Map<String, Model> loadSupplements(String[] models) throws MojoExecutionException {
        if (models == null) {
            this.getLog().debug((CharSequence)"Supplemental data models won't be loaded.  No models specified.");
            return Collections.emptyMap();
        }
        ArrayList<Supplement> supplements = new ArrayList<Supplement>();
        for (int idx = 0; idx < models.length; ++idx) {
            String set = models[idx];
            this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
            try {
                File f = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                if (null == f || !f.exists()) {
                    throw new MojoExecutionException("Cold not resolve " + set);
                }
                if (!f.canRead()) {
                    throw new MojoExecutionException("Supplemental data models won't be loaded. File " + f.getAbsolutePath() + " cannot be read, check permissions on the file.");
                }
                this.getLog().debug((CharSequence)("Loading supplemental models from " + f.getAbsolutePath()));
                SupplementalDataModelXpp3Reader reader = new SupplementalDataModelXpp3Reader();
                SupplementalDataModel supplementalModel = reader.read(new FileReader(f));
                supplements.addAll(supplementalModel.getSupplement());
                continue;
            }
            catch (Exception e) {
                String msg = "Error loading supplemental data models: " + e.getMessage();
                this.getLog().error((CharSequence)msg, (Throwable)e);
                throw new MojoExecutionException(msg, e);
            }
        }
        this.getLog().debug((CharSequence)"Loading supplements complete.");
        HashMap<String, Model> supplementMap = new HashMap<String, Model>();
        for (Supplement sd : supplements) {
            Xpp3Dom dom = (Xpp3Dom)sd.getProject();
            Model m = this.getSupplement(dom);
            supplementMap.put(ProcessRemoteResourcesMojo.generateSupplementMapKey(m.getGroupId(), m.getArtifactId()), m);
        }
        return supplementMap;
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.getLog().warn((CharSequence)message);
                break;
            }
            case 1: {
                this.getLog().debug((CharSequence)message);
                break;
            }
            case 0: {
                this.getLog().debug((CharSequence)message);
                break;
            }
            case 3: {
                this.getLog().error((CharSequence)message);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.getLog().warn((CharSequence)message, t);
                break;
            }
            case 1: {
                this.getLog().debug((CharSequence)message, t);
                break;
            }
            case 0: {
                this.getLog().debug((CharSequence)message, t);
                break;
            }
            case 3: {
                this.getLog().error((CharSequence)message, t);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectComparator
    implements Comparator<MavenProject> {
        ProjectComparator() {
        }

        @Override
        public int compare(MavenProject p1, MavenProject p2) {
            return p1.getArtifact().compareTo((Object)p2.getArtifact());
        }

        public boolean equals(MavenProject p1, MavenProject p2) {
            return p1.getArtifact().equals(p2.getArtifact());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OrganizationComparator
    implements Comparator<Organization> {
        OrganizationComparator() {
        }

        @Override
        public int compare(Organization org1, Organization org2) {
            int i = this.compareStrings(org1.getName(), org2.getName());
            if (i == 0) {
                i = this.compareStrings(org1.getUrl(), org2.getUrl());
            }
            return i;
        }

        public boolean equals(Organization o1, Organization o2) {
            return this.compare(o1, o2) == 0;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            if (s1 != null && s2 == null) {
                return -1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

