/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsBlameConsumer
extends AbstractConsumer {
    private static final String CVS_TIMESTAMP_PATTERN = "dd-MMM-yy";
    private static final String LINE_PATTERN = "(.*)\\((.*)\\s+(.*)\\)";
    private RE lineRegexp;
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public CvsBlameConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    public void consumeLine(String line) {
        String annotation;
        if (line != null && line.indexOf(58) > 0 && this.lineRegexp.match(annotation = line.substring(0, line.indexOf(58)))) {
            String revision = this.lineRegexp.getParen(1).trim();
            String author = this.lineRegexp.getParen(2).trim();
            String dateTimeStr = this.lineRegexp.getParen(3).trim();
            Date dateTime = this.parseDate(dateTimeStr, null, CVS_TIMESTAMP_PATTERN, Locale.US);
            this.lines.add(new BlameLine(dateTime, revision, author));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(author + " " + dateTimeStr);
            }
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

