/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.changelog;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeLogConsumer
extends AbstractConsumer {
    private static final String GIT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private static final int STATUS_GET_HEADER = 1;
    private static final int STATUS_GET_AUTHOR = 2;
    private static final int STATUS_RAW_TREE = 21;
    private static final int STATUS_RAW_PARENT = 22;
    private static final int STATUS_RAW_AUTHOR = 23;
    private static final int STATUS_RAW_COMMITTER = 24;
    private static final int STATUS_GET_DATE = 3;
    private static final int STATUS_GET_FILE = 4;
    private static final int STATUS_GET_COMMENT = 5;
    private static final String HEADER_PATTERN = "^commit (.*)";
    private static final String AUTHOR_PATTERN = "^Author: (.*)";
    private static final String RAW_TREE_PATTERN = "^tree ([:xdigit:]+)";
    private static final String RAW_PARENT_PATTERN = "^parent ([:xdigit:]+)";
    private static final String RAW_AUTHOR_PATTERN = "^author (.+ <.+>) ([:digit:]+) (.*)";
    private static final String RAW_COMMITTER_PATTERN = "^committer (.+ <.+>) ([:digit:]+) (.*)";
    private static final String DATE_PATTERN = "^Date:\\s*(.*)";
    private static final String FILE_PATTERN = "^:\\d* \\d* [:xdigit:]*\\.* [:xdigit:]*\\.* ([:upper:])[:digit:]*\\t([^\\t]*)(\\t(.*))?";
    private int status = 1;
    private List<ChangeSet> entries = new ArrayList<ChangeSet>();
    private ChangeSet currentChange;
    private String currentRevision;
    private StringBuilder currentComment;
    private RE headerRegexp;
    private RE authorRegexp;
    private RE rawTreeRegexp;
    private RE rawParentRegexp;
    private RE rawAuthorRegexp;
    private RE rawCommitterRegexp;
    private RE dateRegexp;
    private RE fileRegexp;
    private String userDateFormat;

    public GitChangeLogConsumer(ScmLogger logger, String userDateFormat) {
        super(logger);
        this.userDateFormat = userDateFormat;
        try {
            this.headerRegexp = new RE(HEADER_PATTERN);
            this.authorRegexp = new RE(AUTHOR_PATTERN);
            this.dateRegexp = new RE(DATE_PATTERN);
            this.fileRegexp = new RE(FILE_PATTERN);
            this.rawTreeRegexp = new RE(RAW_TREE_PATTERN);
            this.rawParentRegexp = new RE(RAW_PARENT_PATTERN);
            this.rawAuthorRegexp = new RE(RAW_AUTHOR_PATTERN);
            this.rawCommitterRegexp = new RE(RAW_COMMITTER_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public List<ChangeSet> getModifications() {
        this.processGetFile("");
        return this.entries;
    }

    public void consumeLine(String line) {
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetAuthor(line);
                break;
            }
            case 3: {
                this.processGetDate(line, null);
                break;
            }
            case 5: {
                this.processGetComment(line);
                break;
            }
            case 4: {
                this.processGetFile(line);
                break;
            }
            case 21: {
                this.processGetRawTree(line);
                break;
            }
            case 22: {
                this.processGetRawParent(line);
                break;
            }
            case 23: {
                this.processGetRawAuthor(line);
                break;
            }
            case 24: {
                this.processGetRawCommitter(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!this.headerRegexp.match(line)) {
            return;
        }
        this.currentRevision = this.headerRegexp.getParen(1);
        this.currentChange = new ChangeSet();
        this.currentChange.setRevision(this.currentRevision);
        this.status = 2;
    }

    private void processGetAuthor(String line) {
        if (this.rawTreeRegexp.match(line)) {
            this.status = 21;
            this.processGetRawTree(line);
            return;
        }
        if (!this.authorRegexp.match(line)) {
            return;
        }
        String author = this.authorRegexp.getParen(1);
        this.currentChange.setAuthor(author);
        this.status = 3;
    }

    private void processGetRawTree(String line) {
        if (!this.rawTreeRegexp.match(line)) {
            return;
        }
        this.status = 22;
    }

    private void processGetRawParent(String line) {
        if (!this.rawParentRegexp.match(line)) {
            this.status = 23;
            this.processGetRawAuthor(line);
            return;
        }
        String parentHash = this.rawParentRegexp.getParen(1);
        this.addParentRevision(parentHash);
    }

    private void addParentRevision(String hash) {
        if (this.currentChange.getParentRevision() == null) {
            this.currentChange.setParentRevision(hash);
        } else {
            this.currentChange.addMergedRevision(hash);
        }
    }

    private void processGetRawAuthor(String line) {
        if (!this.rawAuthorRegexp.match(line)) {
            return;
        }
        String author = this.rawAuthorRegexp.getParen(1);
        this.currentChange.setAuthor(author);
        String datestring = this.rawAuthorRegexp.getParen(2);
        String tz = this.rawAuthorRegexp.getParen(3);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(tz));
        c.setTimeInMillis(Long.parseLong(datestring) * 1000L);
        this.currentChange.setDate(c.getTime());
        this.status = 24;
    }

    private void processGetRawCommitter(String line) {
        if (!this.rawCommitterRegexp.match(line)) {
            return;
        }
        this.status = 5;
    }

    private void processGetDate(String line, Locale locale) {
        if (!this.dateRegexp.match(line)) {
            return;
        }
        String datestring = this.dateRegexp.getParen(1);
        Date date = this.parseDate(datestring.trim(), this.userDateFormat, GIT_TIMESTAMP_PATTERN, locale);
        this.currentChange.setDate(date);
        this.status = 5;
    }

    private void processGetComment(String line) {
        if (line.length() < 4) {
            if (this.currentComment == null) {
                this.currentComment = new StringBuilder();
            } else {
                this.currentChange.setComment(this.currentComment.toString());
                this.status = 4;
            }
        } else {
            if (this.currentComment.length() > 0) {
                this.currentComment.append('\n');
            }
            this.currentComment.append(line.substring(4));
        }
    }

    private void processGetFile(String line) {
        if (line.length() == 0) {
            if (this.currentChange != null) {
                this.entries.add(this.currentChange);
            }
            this.resetChangeLog();
            this.status = 1;
        } else {
            ScmFileStatus action;
            if (!this.fileRegexp.match(line)) {
                return;
            }
            String actionChar = this.fileRegexp.getParen(1);
            String name = this.fileRegexp.getParen(2);
            String originalName = null;
            String originalRevision = null;
            if ("A".equals(actionChar)) {
                action = ScmFileStatus.ADDED;
            } else if ("M".equals(actionChar)) {
                action = ScmFileStatus.MODIFIED;
            } else if ("D".equals(actionChar)) {
                action = ScmFileStatus.DELETED;
            } else if ("R".equals(actionChar)) {
                action = ScmFileStatus.RENAMED;
                originalName = name;
                name = this.fileRegexp.getParen(4);
                originalRevision = this.currentChange.getParentRevision();
            } else if ("C".equals(actionChar)) {
                action = ScmFileStatus.COPIED;
                originalName = name;
                name = this.fileRegexp.getParen(4);
                originalRevision = this.currentChange.getParentRevision();
            } else {
                action = ScmFileStatus.UNKNOWN;
            }
            ChangeFile changeFile = new ChangeFile(name, this.currentRevision);
            changeFile.setAction(action);
            changeFile.setOriginalName(originalName);
            changeFile.setOriginalRevision(originalRevision);
            this.currentChange.addFile(changeFile);
        }
    }

    private void resetChangeLog() {
        this.currentComment = null;
        this.currentChange = null;
    }
}

