# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_selinux')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_selinux')
    _selinux = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_selinux', [dirname(__file__)])
        except ImportError:
            import _selinux
            return _selinux
        try:
            _mod = imp.load_module('_selinux', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _selinux = swig_import_helper()
    del swig_import_helper
else:
    import _selinux
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0



import shutil, os, errno, stat

DISABLED = -1
PERMISSIVE = 0
ENFORCING = 1

def restorecon(path, recursive=False, verbose=False):
    """ Restore SELinux context on a given path

    Arguments:
    path -- The pathname for the file or directory to be relabeled.

    Keyword arguments:
    recursive -- Change files and directories file labels recursively (default False)
    verbose -- Show changes in file labels (default False)
    """

    restorecon_flags = SELINUX_RESTORECON_IGNORE_DIGEST | SELINUX_RESTORECON_REALPATH
    if recursive:
        restorecon_flags |= SELINUX_RESTORECON_RECURSE
    if verbose:
        restorecon_flags |= SELINUX_RESTORECON_VERBOSE
    selinux_restorecon(os.path.expanduser(path), restorecon_flags)

def chcon(path, context, recursive=False):
    """ Set the SELinux context on a given path """
    lsetfilecon(path, context)
    if recursive:
        for root, dirs, files in os.walk(path):
            for name in files + dirs:
               lsetfilecon(os.path.join(root,name), context)

def copytree(src, dest):
    """ An SELinux-friendly shutil.copytree method """
    shutil.copytree(src, dest)
    restorecon(dest, recursive=True)

def install(src, dest):
    """ An SELinux-friendly shutil.move method """
    shutil.move(src, dest)
    restorecon(dest, recursive=True)

class security_id(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, security_id, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, security_id, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ctx"] = _selinux.security_id_ctx_set
    __swig_getmethods__["ctx"] = _selinux.security_id_ctx_get
    if _newclass:
        ctx = _swig_property(_selinux.security_id_ctx_get, _selinux.security_id_ctx_set)
    __swig_setmethods__["refcnt"] = _selinux.security_id_refcnt_set
    __swig_getmethods__["refcnt"] = _selinux.security_id_refcnt_get
    if _newclass:
        refcnt = _swig_property(_selinux.security_id_refcnt_get, _selinux.security_id_refcnt_set)

    def __init__(self):
        this = _selinux.new_security_id()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_security_id
    __del__ = lambda self: None
security_id_swigregister = _selinux.security_id_swigregister
security_id_swigregister(security_id)


def avc_sid_to_context(sid):
    return _selinux.avc_sid_to_context(sid)
avc_sid_to_context = _selinux.avc_sid_to_context

def avc_sid_to_context_raw(sid):
    return _selinux.avc_sid_to_context_raw(sid)
avc_sid_to_context_raw = _selinux.avc_sid_to_context_raw

def avc_context_to_sid(ctx):
    return _selinux.avc_context_to_sid(ctx)
avc_context_to_sid = _selinux.avc_context_to_sid

def avc_context_to_sid_raw(ctx):
    return _selinux.avc_context_to_sid_raw(ctx)
avc_context_to_sid_raw = _selinux.avc_context_to_sid_raw

def sidget(sid):
    return _selinux.sidget(sid)
sidget = _selinux.sidget

def sidput(sid):
    return _selinux.sidput(sid)
sidput = _selinux.sidput

def avc_get_initial_sid(name):
    return _selinux.avc_get_initial_sid(name)
avc_get_initial_sid = _selinux.avc_get_initial_sid
class avc_entry_ref(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_entry_ref, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_entry_ref, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ae"] = _selinux.avc_entry_ref_ae_set
    __swig_getmethods__["ae"] = _selinux.avc_entry_ref_ae_get
    if _newclass:
        ae = _swig_property(_selinux.avc_entry_ref_ae_get, _selinux.avc_entry_ref_ae_set)

    def __init__(self):
        this = _selinux.new_avc_entry_ref()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_entry_ref
    __del__ = lambda self: None
avc_entry_ref_swigregister = _selinux.avc_entry_ref_swigregister
avc_entry_ref_swigregister(avc_entry_ref)

class avc_memory_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_memory_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_memory_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_malloc"] = _selinux.avc_memory_callback_func_malloc_set
    __swig_getmethods__["func_malloc"] = _selinux.avc_memory_callback_func_malloc_get
    if _newclass:
        func_malloc = _swig_property(_selinux.avc_memory_callback_func_malloc_get, _selinux.avc_memory_callback_func_malloc_set)
    __swig_setmethods__["func_free"] = _selinux.avc_memory_callback_func_free_set
    __swig_getmethods__["func_free"] = _selinux.avc_memory_callback_func_free_get
    if _newclass:
        func_free = _swig_property(_selinux.avc_memory_callback_func_free_get, _selinux.avc_memory_callback_func_free_set)

    def __init__(self):
        this = _selinux.new_avc_memory_callback()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_memory_callback
    __del__ = lambda self: None
avc_memory_callback_swigregister = _selinux.avc_memory_callback_swigregister
avc_memory_callback_swigregister(avc_memory_callback)

class avc_log_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_log_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_log_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_log"] = _selinux.avc_log_callback_func_log_set
    __swig_getmethods__["func_log"] = _selinux.avc_log_callback_func_log_get
    if _newclass:
        func_log = _swig_property(_selinux.avc_log_callback_func_log_get, _selinux.avc_log_callback_func_log_set)
    __swig_setmethods__["func_audit"] = _selinux.avc_log_callback_func_audit_set
    __swig_getmethods__["func_audit"] = _selinux.avc_log_callback_func_audit_get
    if _newclass:
        func_audit = _swig_property(_selinux.avc_log_callback_func_audit_get, _selinux.avc_log_callback_func_audit_set)

    def __init__(self):
        this = _selinux.new_avc_log_callback()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_log_callback
    __del__ = lambda self: None
avc_log_callback_swigregister = _selinux.avc_log_callback_swigregister
avc_log_callback_swigregister(avc_log_callback)

class avc_thread_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_thread_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_thread_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_create_thread"] = _selinux.avc_thread_callback_func_create_thread_set
    __swig_getmethods__["func_create_thread"] = _selinux.avc_thread_callback_func_create_thread_get
    if _newclass:
        func_create_thread = _swig_property(_selinux.avc_thread_callback_func_create_thread_get, _selinux.avc_thread_callback_func_create_thread_set)
    __swig_setmethods__["func_stop_thread"] = _selinux.avc_thread_callback_func_stop_thread_set
    __swig_getmethods__["func_stop_thread"] = _selinux.avc_thread_callback_func_stop_thread_get
    if _newclass:
        func_stop_thread = _swig_property(_selinux.avc_thread_callback_func_stop_thread_get, _selinux.avc_thread_callback_func_stop_thread_set)

    def __init__(self):
        this = _selinux.new_avc_thread_callback()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_thread_callback
    __del__ = lambda self: None
avc_thread_callback_swigregister = _selinux.avc_thread_callback_swigregister
avc_thread_callback_swigregister(avc_thread_callback)

class avc_lock_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_lock_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_lock_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_alloc_lock"] = _selinux.avc_lock_callback_func_alloc_lock_set
    __swig_getmethods__["func_alloc_lock"] = _selinux.avc_lock_callback_func_alloc_lock_get
    if _newclass:
        func_alloc_lock = _swig_property(_selinux.avc_lock_callback_func_alloc_lock_get, _selinux.avc_lock_callback_func_alloc_lock_set)
    __swig_setmethods__["func_get_lock"] = _selinux.avc_lock_callback_func_get_lock_set
    __swig_getmethods__["func_get_lock"] = _selinux.avc_lock_callback_func_get_lock_get
    if _newclass:
        func_get_lock = _swig_property(_selinux.avc_lock_callback_func_get_lock_get, _selinux.avc_lock_callback_func_get_lock_set)
    __swig_setmethods__["func_release_lock"] = _selinux.avc_lock_callback_func_release_lock_set
    __swig_getmethods__["func_release_lock"] = _selinux.avc_lock_callback_func_release_lock_get
    if _newclass:
        func_release_lock = _swig_property(_selinux.avc_lock_callback_func_release_lock_get, _selinux.avc_lock_callback_func_release_lock_set)
    __swig_setmethods__["func_free_lock"] = _selinux.avc_lock_callback_func_free_lock_set
    __swig_getmethods__["func_free_lock"] = _selinux.avc_lock_callback_func_free_lock_get
    if _newclass:
        func_free_lock = _swig_property(_selinux.avc_lock_callback_func_free_lock_get, _selinux.avc_lock_callback_func_free_lock_set)

    def __init__(self):
        this = _selinux.new_avc_lock_callback()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_lock_callback
    __del__ = lambda self: None
avc_lock_callback_swigregister = _selinux.avc_lock_callback_swigregister
avc_lock_callback_swigregister(avc_lock_callback)

AVC_OPT_UNUSED = _selinux.AVC_OPT_UNUSED
AVC_OPT_SETENFORCE = _selinux.AVC_OPT_SETENFORCE

def avc_init(msgprefix, mem_callbacks, log_callbacks, thread_callbacks, lock_callbacks):
    return _selinux.avc_init(msgprefix, mem_callbacks, log_callbacks, thread_callbacks, lock_callbacks)
avc_init = _selinux.avc_init

def avc_open(opts, nopts):
    return _selinux.avc_open(opts, nopts)
avc_open = _selinux.avc_open

def avc_cleanup():
    return _selinux.avc_cleanup()
avc_cleanup = _selinux.avc_cleanup

def avc_reset():
    return _selinux.avc_reset()
avc_reset = _selinux.avc_reset

def avc_destroy():
    return _selinux.avc_destroy()
avc_destroy = _selinux.avc_destroy

def avc_has_perm_noaudit(ssid, tsid, tclass, requested, aeref, avd):
    return _selinux.avc_has_perm_noaudit(ssid, tsid, tclass, requested, aeref, avd)
avc_has_perm_noaudit = _selinux.avc_has_perm_noaudit

def avc_has_perm(ssid, tsid, tclass, requested, aeref):
    return _selinux.avc_has_perm(ssid, tsid, tclass, requested, aeref)
avc_has_perm = _selinux.avc_has_perm

def avc_audit(ssid, tsid, tclass, requested, avd, result):
    return _selinux.avc_audit(ssid, tsid, tclass, requested, avd, result)
avc_audit = _selinux.avc_audit

def avc_compute_create(ssid, tsid, tclass):
    return _selinux.avc_compute_create(ssid, tsid, tclass)
avc_compute_create = _selinux.avc_compute_create

def avc_compute_member(ssid, tsid, tclass):
    return _selinux.avc_compute_member(ssid, tsid, tclass)
avc_compute_member = _selinux.avc_compute_member
AVC_CALLBACK_GRANT = _selinux.AVC_CALLBACK_GRANT
AVC_CALLBACK_TRY_REVOKE = _selinux.AVC_CALLBACK_TRY_REVOKE
AVC_CALLBACK_REVOKE = _selinux.AVC_CALLBACK_REVOKE
AVC_CALLBACK_RESET = _selinux.AVC_CALLBACK_RESET
AVC_CALLBACK_AUDITALLOW_ENABLE = _selinux.AVC_CALLBACK_AUDITALLOW_ENABLE
AVC_CALLBACK_AUDITALLOW_DISABLE = _selinux.AVC_CALLBACK_AUDITALLOW_DISABLE
AVC_CALLBACK_AUDITDENY_ENABLE = _selinux.AVC_CALLBACK_AUDITDENY_ENABLE
AVC_CALLBACK_AUDITDENY_DISABLE = _selinux.AVC_CALLBACK_AUDITDENY_DISABLE
AVC_CACHE_STATS = _selinux.AVC_CACHE_STATS
class avc_cache_stats(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, avc_cache_stats, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, avc_cache_stats, name)
    __repr__ = _swig_repr
    __swig_setmethods__["entry_lookups"] = _selinux.avc_cache_stats_entry_lookups_set
    __swig_getmethods__["entry_lookups"] = _selinux.avc_cache_stats_entry_lookups_get
    if _newclass:
        entry_lookups = _swig_property(_selinux.avc_cache_stats_entry_lookups_get, _selinux.avc_cache_stats_entry_lookups_set)
    __swig_setmethods__["entry_hits"] = _selinux.avc_cache_stats_entry_hits_set
    __swig_getmethods__["entry_hits"] = _selinux.avc_cache_stats_entry_hits_get
    if _newclass:
        entry_hits = _swig_property(_selinux.avc_cache_stats_entry_hits_get, _selinux.avc_cache_stats_entry_hits_set)
    __swig_setmethods__["entry_misses"] = _selinux.avc_cache_stats_entry_misses_set
    __swig_getmethods__["entry_misses"] = _selinux.avc_cache_stats_entry_misses_get
    if _newclass:
        entry_misses = _swig_property(_selinux.avc_cache_stats_entry_misses_get, _selinux.avc_cache_stats_entry_misses_set)
    __swig_setmethods__["entry_discards"] = _selinux.avc_cache_stats_entry_discards_set
    __swig_getmethods__["entry_discards"] = _selinux.avc_cache_stats_entry_discards_get
    if _newclass:
        entry_discards = _swig_property(_selinux.avc_cache_stats_entry_discards_get, _selinux.avc_cache_stats_entry_discards_set)
    __swig_setmethods__["cav_lookups"] = _selinux.avc_cache_stats_cav_lookups_set
    __swig_getmethods__["cav_lookups"] = _selinux.avc_cache_stats_cav_lookups_get
    if _newclass:
        cav_lookups = _swig_property(_selinux.avc_cache_stats_cav_lookups_get, _selinux.avc_cache_stats_cav_lookups_set)
    __swig_setmethods__["cav_hits"] = _selinux.avc_cache_stats_cav_hits_set
    __swig_getmethods__["cav_hits"] = _selinux.avc_cache_stats_cav_hits_get
    if _newclass:
        cav_hits = _swig_property(_selinux.avc_cache_stats_cav_hits_get, _selinux.avc_cache_stats_cav_hits_set)
    __swig_setmethods__["cav_probes"] = _selinux.avc_cache_stats_cav_probes_set
    __swig_getmethods__["cav_probes"] = _selinux.avc_cache_stats_cav_probes_get
    if _newclass:
        cav_probes = _swig_property(_selinux.avc_cache_stats_cav_probes_get, _selinux.avc_cache_stats_cav_probes_set)
    __swig_setmethods__["cav_misses"] = _selinux.avc_cache_stats_cav_misses_set
    __swig_getmethods__["cav_misses"] = _selinux.avc_cache_stats_cav_misses_get
    if _newclass:
        cav_misses = _swig_property(_selinux.avc_cache_stats_cav_misses_get, _selinux.avc_cache_stats_cav_misses_set)

    def __init__(self):
        this = _selinux.new_avc_cache_stats()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_avc_cache_stats
    __del__ = lambda self: None
avc_cache_stats_swigregister = _selinux.avc_cache_stats_swigregister
avc_cache_stats_swigregister(avc_cache_stats)


def avc_av_stats():
    return _selinux.avc_av_stats()
avc_av_stats = _selinux.avc_av_stats

def avc_sid_stats():
    return _selinux.avc_sid_stats()
avc_sid_stats = _selinux.avc_sid_stats

def avc_netlink_open(blocking):
    return _selinux.avc_netlink_open(blocking)
avc_netlink_open = _selinux.avc_netlink_open

def avc_netlink_loop():
    return _selinux.avc_netlink_loop()
avc_netlink_loop = _selinux.avc_netlink_loop

def avc_netlink_close():
    return _selinux.avc_netlink_close()
avc_netlink_close = _selinux.avc_netlink_close

def selinux_status_open(fallback):
    return _selinux.selinux_status_open(fallback)
selinux_status_open = _selinux.selinux_status_open

def selinux_status_close():
    return _selinux.selinux_status_close()
selinux_status_close = _selinux.selinux_status_close

def selinux_status_updated():
    return _selinux.selinux_status_updated()
selinux_status_updated = _selinux.selinux_status_updated

def selinux_status_getenforce():
    return _selinux.selinux_status_getenforce()
selinux_status_getenforce = _selinux.selinux_status_getenforce

def selinux_status_policyload():
    return _selinux.selinux_status_policyload()
selinux_status_policyload = _selinux.selinux_status_policyload

def selinux_status_deny_unknown():
    return _selinux.selinux_status_deny_unknown()
selinux_status_deny_unknown = _selinux.selinux_status_deny_unknown
class context_s_t(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, context_s_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, context_s_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ptr"] = _selinux.context_s_t_ptr_set
    __swig_getmethods__["ptr"] = _selinux.context_s_t_ptr_get
    if _newclass:
        ptr = _swig_property(_selinux.context_s_t_ptr_get, _selinux.context_s_t_ptr_set)

    def __init__(self):
        this = _selinux.new_context_s_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_context_s_t
    __del__ = lambda self: None
context_s_t_swigregister = _selinux.context_s_t_swigregister
context_s_t_swigregister(context_s_t)


def context_new(arg1):
    return _selinux.context_new(arg1)
context_new = _selinux.context_new

def context_str(arg1):
    return _selinux.context_str(arg1)
context_str = _selinux.context_str

def context_free(arg1):
    return _selinux.context_free(arg1)
context_free = _selinux.context_free

def context_type_get(arg1):
    return _selinux.context_type_get(arg1)
context_type_get = _selinux.context_type_get

def context_range_get(arg1):
    return _selinux.context_range_get(arg1)
context_range_get = _selinux.context_range_get

def context_role_get(arg1):
    return _selinux.context_role_get(arg1)
context_role_get = _selinux.context_role_get

def context_user_get(arg1):
    return _selinux.context_user_get(arg1)
context_user_get = _selinux.context_user_get

def context_type_set(arg1, arg2):
    return _selinux.context_type_set(arg1, arg2)
context_type_set = _selinux.context_type_set

def context_range_set(arg1, arg2):
    return _selinux.context_range_set(arg1, arg2)
context_range_set = _selinux.context_range_set

def context_role_set(arg1, arg2):
    return _selinux.context_role_set(arg1, arg2)
context_role_set = _selinux.context_role_set

def context_user_set(arg1, arg2):
    return _selinux.context_user_set(arg1, arg2)
context_user_set = _selinux.context_user_set
SELINUX_DEFAULTUSER = _selinux.SELINUX_DEFAULTUSER

def get_ordered_context_list(user, fromcon):
    return _selinux.get_ordered_context_list(user, fromcon)
get_ordered_context_list = _selinux.get_ordered_context_list

def get_ordered_context_list_with_level(user, level, fromcon):
    return _selinux.get_ordered_context_list_with_level(user, level, fromcon)
get_ordered_context_list_with_level = _selinux.get_ordered_context_list_with_level

def get_default_context(user, fromcon):
    return _selinux.get_default_context(user, fromcon)
get_default_context = _selinux.get_default_context

def get_default_context_with_level(user, level, fromcon):
    return _selinux.get_default_context_with_level(user, level, fromcon)
get_default_context_with_level = _selinux.get_default_context_with_level

def get_default_context_with_role(user, role, fromcon):
    return _selinux.get_default_context_with_role(user, role, fromcon)
get_default_context_with_role = _selinux.get_default_context_with_role

def get_default_context_with_rolelevel(user, role, level, fromcon):
    return _selinux.get_default_context_with_rolelevel(user, role, level, fromcon)
get_default_context_with_rolelevel = _selinux.get_default_context_with_rolelevel

def query_user_context():
    return _selinux.query_user_context()
query_user_context = _selinux.query_user_context

def manual_user_enter_context(user):
    return _selinux.manual_user_enter_context(user)
manual_user_enter_context = _selinux.manual_user_enter_context

def selinux_default_type_path():
    return _selinux.selinux_default_type_path()
selinux_default_type_path = _selinux.selinux_default_type_path

def get_default_type(role):
    return _selinux.get_default_type(role)
get_default_type = _selinux.get_default_type
SELABEL_CTX_FILE = _selinux.SELABEL_CTX_FILE
SELABEL_CTX_MEDIA = _selinux.SELABEL_CTX_MEDIA
SELABEL_CTX_X = _selinux.SELABEL_CTX_X
SELABEL_CTX_DB = _selinux.SELABEL_CTX_DB
SELABEL_CTX_ANDROID_PROP = _selinux.SELABEL_CTX_ANDROID_PROP
SELABEL_CTX_ANDROID_SERVICE = _selinux.SELABEL_CTX_ANDROID_SERVICE
SELABEL_OPT_UNUSED = _selinux.SELABEL_OPT_UNUSED
SELABEL_OPT_VALIDATE = _selinux.SELABEL_OPT_VALIDATE
SELABEL_OPT_BASEONLY = _selinux.SELABEL_OPT_BASEONLY
SELABEL_OPT_PATH = _selinux.SELABEL_OPT_PATH
SELABEL_OPT_SUBSET = _selinux.SELABEL_OPT_SUBSET
SELABEL_OPT_DIGEST = _selinux.SELABEL_OPT_DIGEST
SELABEL_NOPT = _selinux.SELABEL_NOPT

def selabel_open(backend, opts, nopts):
    return _selinux.selabel_open(backend, opts, nopts)
selabel_open = _selinux.selabel_open

def selabel_close(handle):
    return _selinux.selabel_close(handle)
selabel_close = _selinux.selabel_close

def selabel_lookup(handle, key, type):
    return _selinux.selabel_lookup(handle, key, type)
selabel_lookup = _selinux.selabel_lookup

def selabel_lookup_raw(handle, key, type):
    return _selinux.selabel_lookup_raw(handle, key, type)
selabel_lookup_raw = _selinux.selabel_lookup_raw

def selabel_partial_match(handle, key):
    return _selinux.selabel_partial_match(handle, key)
selabel_partial_match = _selinux.selabel_partial_match

def selabel_lookup_best_match(rec, key, type):
    return _selinux.selabel_lookup_best_match(rec, key, type)
selabel_lookup_best_match = _selinux.selabel_lookup_best_match

def selabel_lookup_best_match_raw(rec, key, type):
    return _selinux.selabel_lookup_best_match_raw(rec, key, type)
selabel_lookup_best_match_raw = _selinux.selabel_lookup_best_match_raw

def selabel_digest(rec, digest):
    return _selinux.selabel_digest(rec, digest)
selabel_digest = _selinux.selabel_digest
SELABEL_SUBSET = _selinux.SELABEL_SUBSET
SELABEL_EQUAL = _selinux.SELABEL_EQUAL
SELABEL_SUPERSET = _selinux.SELABEL_SUPERSET
SELABEL_INCOMPARABLE = _selinux.SELABEL_INCOMPARABLE

def selabel_cmp(h1, h2):
    return _selinux.selabel_cmp(h1, h2)
selabel_cmp = _selinux.selabel_cmp

def selabel_stats(handle):
    return _selinux.selabel_stats(handle)
selabel_stats = _selinux.selabel_stats
SELABEL_X_PROP = _selinux.SELABEL_X_PROP
SELABEL_X_EXT = _selinux.SELABEL_X_EXT
SELABEL_X_CLIENT = _selinux.SELABEL_X_CLIENT
SELABEL_X_EVENT = _selinux.SELABEL_X_EVENT
SELABEL_X_SELN = _selinux.SELABEL_X_SELN
SELABEL_X_POLYPROP = _selinux.SELABEL_X_POLYPROP
SELABEL_X_POLYSELN = _selinux.SELABEL_X_POLYSELN
SELABEL_DB_DATABASE = _selinux.SELABEL_DB_DATABASE
SELABEL_DB_SCHEMA = _selinux.SELABEL_DB_SCHEMA
SELABEL_DB_TABLE = _selinux.SELABEL_DB_TABLE
SELABEL_DB_COLUMN = _selinux.SELABEL_DB_COLUMN
SELABEL_DB_SEQUENCE = _selinux.SELABEL_DB_SEQUENCE
SELABEL_DB_VIEW = _selinux.SELABEL_DB_VIEW
SELABEL_DB_PROCEDURE = _selinux.SELABEL_DB_PROCEDURE
SELABEL_DB_BLOB = _selinux.SELABEL_DB_BLOB
SELABEL_DB_TUPLE = _selinux.SELABEL_DB_TUPLE
SELABEL_DB_LANGUAGE = _selinux.SELABEL_DB_LANGUAGE
SELABEL_DB_EXCEPTION = _selinux.SELABEL_DB_EXCEPTION
SELABEL_DB_DATATYPE = _selinux.SELABEL_DB_DATATYPE

def selinux_restorecon(pathname, restorecon_flags):
    return _selinux.selinux_restorecon(pathname, restorecon_flags)
selinux_restorecon = _selinux.selinux_restorecon
SELINUX_RESTORECON_IGNORE_DIGEST = _selinux.SELINUX_RESTORECON_IGNORE_DIGEST
SELINUX_RESTORECON_NOCHANGE = _selinux.SELINUX_RESTORECON_NOCHANGE
SELINUX_RESTORECON_SET_SPECFILE_CTX = _selinux.SELINUX_RESTORECON_SET_SPECFILE_CTX
SELINUX_RESTORECON_RECURSE = _selinux.SELINUX_RESTORECON_RECURSE
SELINUX_RESTORECON_VERBOSE = _selinux.SELINUX_RESTORECON_VERBOSE
SELINUX_RESTORECON_PROGRESS = _selinux.SELINUX_RESTORECON_PROGRESS
SELINUX_RESTORECON_REALPATH = _selinux.SELINUX_RESTORECON_REALPATH
SELINUX_RESTORECON_XDEV = _selinux.SELINUX_RESTORECON_XDEV
SELINUX_RESTORECON_ADD_ASSOC = _selinux.SELINUX_RESTORECON_ADD_ASSOC
SELINUX_RESTORECON_ABORT_ON_ERROR = _selinux.SELINUX_RESTORECON_ABORT_ON_ERROR
SELINUX_RESTORECON_SYSLOG_CHANGES = _selinux.SELINUX_RESTORECON_SYSLOG_CHANGES
SELINUX_RESTORECON_LOG_MATCHES = _selinux.SELINUX_RESTORECON_LOG_MATCHES
SELINUX_RESTORECON_IGNORE_NOENTRY = _selinux.SELINUX_RESTORECON_IGNORE_NOENTRY
SELINUX_RESTORECON_IGNORE_MOUNTS = _selinux.SELINUX_RESTORECON_IGNORE_MOUNTS
SELINUX_RESTORECON_MASS_RELABEL = _selinux.SELINUX_RESTORECON_MASS_RELABEL

def selinux_restorecon_set_sehandle(hndl):
    return _selinux.selinux_restorecon_set_sehandle(hndl)
selinux_restorecon_set_sehandle = _selinux.selinux_restorecon_set_sehandle

def selinux_restorecon_default_handle():
    return _selinux.selinux_restorecon_default_handle()
selinux_restorecon_default_handle = _selinux.selinux_restorecon_default_handle

def selinux_restorecon_set_exclude_list():
    return _selinux.selinux_restorecon_set_exclude_list()
selinux_restorecon_set_exclude_list = _selinux.selinux_restorecon_set_exclude_list

def selinux_restorecon_set_alt_rootpath(alt_rootpath):
    return _selinux.selinux_restorecon_set_alt_rootpath(alt_rootpath)
selinux_restorecon_set_alt_rootpath = _selinux.selinux_restorecon_set_alt_rootpath
MATCH = _selinux.MATCH
NOMATCH = _selinux.NOMATCH
DELETED_MATCH = _selinux.DELETED_MATCH
DELETED_NOMATCH = _selinux.DELETED_NOMATCH
ERROR = _selinux.ERROR
class dir_xattr(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, dir_xattr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, dir_xattr, name)
    __repr__ = _swig_repr
    __swig_setmethods__["directory"] = _selinux.dir_xattr_directory_set
    __swig_getmethods__["directory"] = _selinux.dir_xattr_directory_get
    if _newclass:
        directory = _swig_property(_selinux.dir_xattr_directory_get, _selinux.dir_xattr_directory_set)
    __swig_setmethods__["digest"] = _selinux.dir_xattr_digest_set
    __swig_getmethods__["digest"] = _selinux.dir_xattr_digest_get
    if _newclass:
        digest = _swig_property(_selinux.dir_xattr_digest_get, _selinux.dir_xattr_digest_set)
    __swig_setmethods__["result"] = _selinux.dir_xattr_result_set
    __swig_getmethods__["result"] = _selinux.dir_xattr_result_get
    if _newclass:
        result = _swig_property(_selinux.dir_xattr_result_get, _selinux.dir_xattr_result_set)
    __swig_setmethods__["next"] = _selinux.dir_xattr_next_set
    __swig_getmethods__["next"] = _selinux.dir_xattr_next_get
    if _newclass:
        next = _swig_property(_selinux.dir_xattr_next_get, _selinux.dir_xattr_next_set)

    def __init__(self):
        this = _selinux.new_dir_xattr()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_dir_xattr
    __del__ = lambda self: None
dir_xattr_swigregister = _selinux.dir_xattr_swigregister
dir_xattr_swigregister(dir_xattr)


def selinux_restorecon_xattr(pathname, xattr_flags, xattr_list):
    return _selinux.selinux_restorecon_xattr(pathname, xattr_flags, xattr_list)
selinux_restorecon_xattr = _selinux.selinux_restorecon_xattr
SELINUX_RESTORECON_XATTR_RECURSE = _selinux.SELINUX_RESTORECON_XATTR_RECURSE
SELINUX_RESTORECON_XATTR_DELETE_NONMATCH_DIGESTS = _selinux.SELINUX_RESTORECON_XATTR_DELETE_NONMATCH_DIGESTS
SELINUX_RESTORECON_XATTR_DELETE_ALL_DIGESTS = _selinux.SELINUX_RESTORECON_XATTR_DELETE_ALL_DIGESTS
SELINUX_RESTORECON_XATTR_IGNORE_MOUNTS = _selinux.SELINUX_RESTORECON_XATTR_IGNORE_MOUNTS

def is_selinux_enabled():
    return _selinux.is_selinux_enabled()
is_selinux_enabled = _selinux.is_selinux_enabled

def is_selinux_mls_enabled():
    return _selinux.is_selinux_mls_enabled()
is_selinux_mls_enabled = _selinux.is_selinux_mls_enabled

def getcon():
    return _selinux.getcon()
getcon = _selinux.getcon

def getcon_raw():
    return _selinux.getcon_raw()
getcon_raw = _selinux.getcon_raw

def setcon(con):
    return _selinux.setcon(con)
setcon = _selinux.setcon

def setcon_raw(con):
    return _selinux.setcon_raw(con)
setcon_raw = _selinux.setcon_raw

def getpidcon(pid):
    return _selinux.getpidcon(pid)
getpidcon = _selinux.getpidcon

def getpidcon_raw(pid):
    return _selinux.getpidcon_raw(pid)
getpidcon_raw = _selinux.getpidcon_raw

def getprevcon():
    return _selinux.getprevcon()
getprevcon = _selinux.getprevcon

def getprevcon_raw():
    return _selinux.getprevcon_raw()
getprevcon_raw = _selinux.getprevcon_raw

def getexeccon():
    return _selinux.getexeccon()
getexeccon = _selinux.getexeccon

def getexeccon_raw():
    return _selinux.getexeccon_raw()
getexeccon_raw = _selinux.getexeccon_raw

def setexeccon(con):
    return _selinux.setexeccon(con)
setexeccon = _selinux.setexeccon

def setexeccon_raw(con):
    return _selinux.setexeccon_raw(con)
setexeccon_raw = _selinux.setexeccon_raw

def getfscreatecon():
    return _selinux.getfscreatecon()
getfscreatecon = _selinux.getfscreatecon

def getfscreatecon_raw():
    return _selinux.getfscreatecon_raw()
getfscreatecon_raw = _selinux.getfscreatecon_raw

def setfscreatecon(context):
    return _selinux.setfscreatecon(context)
setfscreatecon = _selinux.setfscreatecon

def setfscreatecon_raw(context):
    return _selinux.setfscreatecon_raw(context)
setfscreatecon_raw = _selinux.setfscreatecon_raw

def getkeycreatecon():
    return _selinux.getkeycreatecon()
getkeycreatecon = _selinux.getkeycreatecon

def getkeycreatecon_raw():
    return _selinux.getkeycreatecon_raw()
getkeycreatecon_raw = _selinux.getkeycreatecon_raw

def setkeycreatecon(context):
    return _selinux.setkeycreatecon(context)
setkeycreatecon = _selinux.setkeycreatecon

def setkeycreatecon_raw(context):
    return _selinux.setkeycreatecon_raw(context)
setkeycreatecon_raw = _selinux.setkeycreatecon_raw

def getsockcreatecon():
    return _selinux.getsockcreatecon()
getsockcreatecon = _selinux.getsockcreatecon

def getsockcreatecon_raw():
    return _selinux.getsockcreatecon_raw()
getsockcreatecon_raw = _selinux.getsockcreatecon_raw

def setsockcreatecon(context):
    return _selinux.setsockcreatecon(context)
setsockcreatecon = _selinux.setsockcreatecon

def setsockcreatecon_raw(context):
    return _selinux.setsockcreatecon_raw(context)
setsockcreatecon_raw = _selinux.setsockcreatecon_raw

def getfilecon(path):
    return _selinux.getfilecon(path)
getfilecon = _selinux.getfilecon

def getfilecon_raw(path):
    return _selinux.getfilecon_raw(path)
getfilecon_raw = _selinux.getfilecon_raw

def lgetfilecon(path):
    return _selinux.lgetfilecon(path)
lgetfilecon = _selinux.lgetfilecon

def lgetfilecon_raw(path):
    return _selinux.lgetfilecon_raw(path)
lgetfilecon_raw = _selinux.lgetfilecon_raw

def fgetfilecon(fd):
    return _selinux.fgetfilecon(fd)
fgetfilecon = _selinux.fgetfilecon

def fgetfilecon_raw(fd):
    return _selinux.fgetfilecon_raw(fd)
fgetfilecon_raw = _selinux.fgetfilecon_raw

def setfilecon(path, con):
    return _selinux.setfilecon(path, con)
setfilecon = _selinux.setfilecon

def setfilecon_raw(path, con):
    return _selinux.setfilecon_raw(path, con)
setfilecon_raw = _selinux.setfilecon_raw

def lsetfilecon(path, con):
    return _selinux.lsetfilecon(path, con)
lsetfilecon = _selinux.lsetfilecon

def lsetfilecon_raw(path, con):
    return _selinux.lsetfilecon_raw(path, con)
lsetfilecon_raw = _selinux.lsetfilecon_raw

def fsetfilecon(fd, con):
    return _selinux.fsetfilecon(fd, con)
fsetfilecon = _selinux.fsetfilecon

def fsetfilecon_raw(fd, con):
    return _selinux.fsetfilecon_raw(fd, con)
fsetfilecon_raw = _selinux.fsetfilecon_raw

def getpeercon(fd):
    return _selinux.getpeercon(fd)
getpeercon = _selinux.getpeercon

def getpeercon_raw(fd):
    return _selinux.getpeercon_raw(fd)
getpeercon_raw = _selinux.getpeercon_raw
class av_decision(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, av_decision, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, av_decision, name)
    __repr__ = _swig_repr
    __swig_setmethods__["allowed"] = _selinux.av_decision_allowed_set
    __swig_getmethods__["allowed"] = _selinux.av_decision_allowed_get
    if _newclass:
        allowed = _swig_property(_selinux.av_decision_allowed_get, _selinux.av_decision_allowed_set)
    __swig_setmethods__["decided"] = _selinux.av_decision_decided_set
    __swig_getmethods__["decided"] = _selinux.av_decision_decided_get
    if _newclass:
        decided = _swig_property(_selinux.av_decision_decided_get, _selinux.av_decision_decided_set)
    __swig_setmethods__["auditallow"] = _selinux.av_decision_auditallow_set
    __swig_getmethods__["auditallow"] = _selinux.av_decision_auditallow_get
    if _newclass:
        auditallow = _swig_property(_selinux.av_decision_auditallow_get, _selinux.av_decision_auditallow_set)
    __swig_setmethods__["auditdeny"] = _selinux.av_decision_auditdeny_set
    __swig_getmethods__["auditdeny"] = _selinux.av_decision_auditdeny_get
    if _newclass:
        auditdeny = _swig_property(_selinux.av_decision_auditdeny_get, _selinux.av_decision_auditdeny_set)
    __swig_setmethods__["seqno"] = _selinux.av_decision_seqno_set
    __swig_getmethods__["seqno"] = _selinux.av_decision_seqno_get
    if _newclass:
        seqno = _swig_property(_selinux.av_decision_seqno_get, _selinux.av_decision_seqno_set)
    __swig_setmethods__["flags"] = _selinux.av_decision_flags_set
    __swig_getmethods__["flags"] = _selinux.av_decision_flags_get
    if _newclass:
        flags = _swig_property(_selinux.av_decision_flags_get, _selinux.av_decision_flags_set)

    def __init__(self):
        this = _selinux.new_av_decision()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_av_decision
    __del__ = lambda self: None
av_decision_swigregister = _selinux.av_decision_swigregister
av_decision_swigregister(av_decision)

SELINUX_AVD_FLAGS_PERMISSIVE = _selinux.SELINUX_AVD_FLAGS_PERMISSIVE
class selinux_opt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, selinux_opt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, selinux_opt, name)
    __repr__ = _swig_repr
    __swig_setmethods__["type"] = _selinux.selinux_opt_type_set
    __swig_getmethods__["type"] = _selinux.selinux_opt_type_get
    if _newclass:
        type = _swig_property(_selinux.selinux_opt_type_get, _selinux.selinux_opt_type_set)
    __swig_setmethods__["value"] = _selinux.selinux_opt_value_set
    __swig_getmethods__["value"] = _selinux.selinux_opt_value_get
    if _newclass:
        value = _swig_property(_selinux.selinux_opt_value_get, _selinux.selinux_opt_value_set)

    def __init__(self):
        this = _selinux.new_selinux_opt()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_selinux_opt
    __del__ = lambda self: None
selinux_opt_swigregister = _selinux.selinux_opt_swigregister
selinux_opt_swigregister(selinux_opt)

class selinux_callback(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, selinux_callback, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, selinux_callback, name)
    __repr__ = _swig_repr
    __swig_setmethods__["func_log"] = _selinux.selinux_callback_func_log_set
    __swig_getmethods__["func_log"] = _selinux.selinux_callback_func_log_get
    if _newclass:
        func_log = _swig_property(_selinux.selinux_callback_func_log_get, _selinux.selinux_callback_func_log_set)
    __swig_setmethods__["func_audit"] = _selinux.selinux_callback_func_audit_set
    __swig_getmethods__["func_audit"] = _selinux.selinux_callback_func_audit_get
    if _newclass:
        func_audit = _swig_property(_selinux.selinux_callback_func_audit_get, _selinux.selinux_callback_func_audit_set)
    __swig_setmethods__["func_validate"] = _selinux.selinux_callback_func_validate_set
    __swig_getmethods__["func_validate"] = _selinux.selinux_callback_func_validate_get
    if _newclass:
        func_validate = _swig_property(_selinux.selinux_callback_func_validate_get, _selinux.selinux_callback_func_validate_set)
    __swig_setmethods__["func_setenforce"] = _selinux.selinux_callback_func_setenforce_set
    __swig_getmethods__["func_setenforce"] = _selinux.selinux_callback_func_setenforce_get
    if _newclass:
        func_setenforce = _swig_property(_selinux.selinux_callback_func_setenforce_get, _selinux.selinux_callback_func_setenforce_set)
    __swig_setmethods__["func_policyload"] = _selinux.selinux_callback_func_policyload_set
    __swig_getmethods__["func_policyload"] = _selinux.selinux_callback_func_policyload_get
    if _newclass:
        func_policyload = _swig_property(_selinux.selinux_callback_func_policyload_get, _selinux.selinux_callback_func_policyload_set)

    def __init__(self):
        this = _selinux.new_selinux_callback()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_selinux_callback
    __del__ = lambda self: None
selinux_callback_swigregister = _selinux.selinux_callback_swigregister
selinux_callback_swigregister(selinux_callback)

SELINUX_CB_LOG = _selinux.SELINUX_CB_LOG
SELINUX_CB_AUDIT = _selinux.SELINUX_CB_AUDIT
SELINUX_CB_VALIDATE = _selinux.SELINUX_CB_VALIDATE
SELINUX_CB_SETENFORCE = _selinux.SELINUX_CB_SETENFORCE
SELINUX_CB_POLICYLOAD = _selinux.SELINUX_CB_POLICYLOAD

def selinux_get_callback(type):
    return _selinux.selinux_get_callback(type)
selinux_get_callback = _selinux.selinux_get_callback

def selinux_set_callback(type, cb):
    return _selinux.selinux_set_callback(type, cb)
selinux_set_callback = _selinux.selinux_set_callback
SELINUX_ERROR = _selinux.SELINUX_ERROR
SELINUX_WARNING = _selinux.SELINUX_WARNING
SELINUX_INFO = _selinux.SELINUX_INFO
SELINUX_AVC = _selinux.SELINUX_AVC
SELINUX_TRANS_DIR = _selinux.SELINUX_TRANS_DIR

def security_compute_av(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av(scon, tcon, tclass, requested, avd)
security_compute_av = _selinux.security_compute_av

def security_compute_av_raw(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_raw(scon, tcon, tclass, requested, avd)
security_compute_av_raw = _selinux.security_compute_av_raw

def security_compute_av_flags(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_flags(scon, tcon, tclass, requested, avd)
security_compute_av_flags = _selinux.security_compute_av_flags

def security_compute_av_flags_raw(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_flags_raw(scon, tcon, tclass, requested, avd)
security_compute_av_flags_raw = _selinux.security_compute_av_flags_raw

def security_compute_create(scon, tcon, tclass):
    return _selinux.security_compute_create(scon, tcon, tclass)
security_compute_create = _selinux.security_compute_create

def security_compute_create_raw(scon, tcon, tclass):
    return _selinux.security_compute_create_raw(scon, tcon, tclass)
security_compute_create_raw = _selinux.security_compute_create_raw

def security_compute_create_name(scon, tcon, tclass, objname):
    return _selinux.security_compute_create_name(scon, tcon, tclass, objname)
security_compute_create_name = _selinux.security_compute_create_name

def security_compute_create_name_raw(scon, tcon, tclass, objname):
    return _selinux.security_compute_create_name_raw(scon, tcon, tclass, objname)
security_compute_create_name_raw = _selinux.security_compute_create_name_raw

def security_compute_relabel(scon, tcon, tclass):
    return _selinux.security_compute_relabel(scon, tcon, tclass)
security_compute_relabel = _selinux.security_compute_relabel

def security_compute_relabel_raw(scon, tcon, tclass):
    return _selinux.security_compute_relabel_raw(scon, tcon, tclass)
security_compute_relabel_raw = _selinux.security_compute_relabel_raw

def security_compute_member(scon, tcon, tclass):
    return _selinux.security_compute_member(scon, tcon, tclass)
security_compute_member = _selinux.security_compute_member

def security_compute_member_raw(scon, tcon, tclass):
    return _selinux.security_compute_member_raw(scon, tcon, tclass)
security_compute_member_raw = _selinux.security_compute_member_raw

def security_compute_user(scon, username):
    return _selinux.security_compute_user(scon, username)
security_compute_user = _selinux.security_compute_user

def security_compute_user_raw(scon, username):
    return _selinux.security_compute_user_raw(scon, username)
security_compute_user_raw = _selinux.security_compute_user_raw

def security_load_policy(len):
    return _selinux.security_load_policy(len)
security_load_policy = _selinux.security_load_policy

def security_get_initial_context(name):
    return _selinux.security_get_initial_context(name)
security_get_initial_context = _selinux.security_get_initial_context

def security_get_initial_context_raw(name):
    return _selinux.security_get_initial_context_raw(name)
security_get_initial_context_raw = _selinux.security_get_initial_context_raw

def selinux_mkload_policy(preservebools):
    return _selinux.selinux_mkload_policy(preservebools)
selinux_mkload_policy = _selinux.selinux_mkload_policy

def selinux_init_load_policy():
    return _selinux.selinux_init_load_policy()
selinux_init_load_policy = _selinux.selinux_init_load_policy
class SELboolean(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SELboolean, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SELboolean, name)
    __repr__ = _swig_repr
    __swig_setmethods__["name"] = _selinux.SELboolean_name_set
    __swig_getmethods__["name"] = _selinux.SELboolean_name_get
    if _newclass:
        name = _swig_property(_selinux.SELboolean_name_get, _selinux.SELboolean_name_set)
    __swig_setmethods__["value"] = _selinux.SELboolean_value_set
    __swig_getmethods__["value"] = _selinux.SELboolean_value_get
    if _newclass:
        value = _swig_property(_selinux.SELboolean_value_get, _selinux.SELboolean_value_set)

    def __init__(self):
        this = _selinux.new_SELboolean()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_SELboolean
    __del__ = lambda self: None
SELboolean_swigregister = _selinux.SELboolean_swigregister
SELboolean_swigregister(SELboolean)


def security_set_boolean_list(boolcnt, boollist, permanent):
    return _selinux.security_set_boolean_list(boolcnt, boollist, permanent)
security_set_boolean_list = _selinux.security_set_boolean_list

def security_load_booleans(path):
    return _selinux.security_load_booleans(path)
security_load_booleans = _selinux.security_load_booleans

def security_check_context(con):
    return _selinux.security_check_context(con)
security_check_context = _selinux.security_check_context

def security_check_context_raw(con):
    return _selinux.security_check_context_raw(con)
security_check_context_raw = _selinux.security_check_context_raw

def security_canonicalize_context(con):
    return _selinux.security_canonicalize_context(con)
security_canonicalize_context = _selinux.security_canonicalize_context

def security_canonicalize_context_raw(con):
    return _selinux.security_canonicalize_context_raw(con)
security_canonicalize_context_raw = _selinux.security_canonicalize_context_raw

def security_getenforce():
    return _selinux.security_getenforce()
security_getenforce = _selinux.security_getenforce

def security_setenforce(value):
    return _selinux.security_setenforce(value)
security_setenforce = _selinux.security_setenforce

def security_deny_unknown():
    return _selinux.security_deny_unknown()
security_deny_unknown = _selinux.security_deny_unknown

def security_get_checkreqprot():
    return _selinux.security_get_checkreqprot()
security_get_checkreqprot = _selinux.security_get_checkreqprot

def security_disable():
    return _selinux.security_disable()
security_disable = _selinux.security_disable

def security_policyvers():
    return _selinux.security_policyvers()
security_policyvers = _selinux.security_policyvers

def security_get_boolean_names():
    return _selinux.security_get_boolean_names()
security_get_boolean_names = _selinux.security_get_boolean_names

def security_get_boolean_pending(name):
    return _selinux.security_get_boolean_pending(name)
security_get_boolean_pending = _selinux.security_get_boolean_pending

def security_get_boolean_active(name):
    return _selinux.security_get_boolean_active(name)
security_get_boolean_active = _selinux.security_get_boolean_active

def security_set_boolean(name, value):
    return _selinux.security_set_boolean(name, value)
security_set_boolean = _selinux.security_set_boolean

def security_commit_booleans():
    return _selinux.security_commit_booleans()
security_commit_booleans = _selinux.security_commit_booleans
class security_class_mapping(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, security_class_mapping, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, security_class_mapping, name)
    __repr__ = _swig_repr
    __swig_setmethods__["name"] = _selinux.security_class_mapping_name_set
    __swig_getmethods__["name"] = _selinux.security_class_mapping_name_get
    if _newclass:
        name = _swig_property(_selinux.security_class_mapping_name_get, _selinux.security_class_mapping_name_set)
    __swig_setmethods__["perms"] = _selinux.security_class_mapping_perms_set
    __swig_getmethods__["perms"] = _selinux.security_class_mapping_perms_get
    if _newclass:
        perms = _swig_property(_selinux.security_class_mapping_perms_get, _selinux.security_class_mapping_perms_set)

    def __init__(self):
        this = _selinux.new_security_class_mapping()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _selinux.delete_security_class_mapping
    __del__ = lambda self: None
security_class_mapping_swigregister = _selinux.security_class_mapping_swigregister
security_class_mapping_swigregister(security_class_mapping)


def selinux_set_mapping(map):
    return _selinux.selinux_set_mapping(map)
selinux_set_mapping = _selinux.selinux_set_mapping

def mode_to_security_class(mode):
    return _selinux.mode_to_security_class(mode)
mode_to_security_class = _selinux.mode_to_security_class

def string_to_security_class(name):
    return _selinux.string_to_security_class(name)
string_to_security_class = _selinux.string_to_security_class

def security_class_to_string(cls):
    return _selinux.security_class_to_string(cls)
security_class_to_string = _selinux.security_class_to_string

def security_av_perm_to_string(tclass, perm):
    return _selinux.security_av_perm_to_string(tclass, perm)
security_av_perm_to_string = _selinux.security_av_perm_to_string

def string_to_av_perm(tclass, name):
    return _selinux.string_to_av_perm(tclass, name)
string_to_av_perm = _selinux.string_to_av_perm

def security_av_string(tclass, av):
    return _selinux.security_av_string(tclass, av)
security_av_string = _selinux.security_av_string

def print_access_vector(tclass, av):
    return _selinux.print_access_vector(tclass, av)
print_access_vector = _selinux.print_access_vector
MATCHPATHCON_BASEONLY = _selinux.MATCHPATHCON_BASEONLY
MATCHPATHCON_NOTRANS = _selinux.MATCHPATHCON_NOTRANS
MATCHPATHCON_VALIDATE = _selinux.MATCHPATHCON_VALIDATE

def set_matchpathcon_flags(flags):
    return _selinux.set_matchpathcon_flags(flags)
set_matchpathcon_flags = _selinux.set_matchpathcon_flags

def matchpathcon_init(path):
    return _selinux.matchpathcon_init(path)
matchpathcon_init = _selinux.matchpathcon_init

def matchpathcon_init_prefix(path, prefix):
    return _selinux.matchpathcon_init_prefix(path, prefix)
matchpathcon_init_prefix = _selinux.matchpathcon_init_prefix

def matchpathcon_fini():
    return _selinux.matchpathcon_fini()
matchpathcon_fini = _selinux.matchpathcon_fini

def realpath_not_final(name, resolved_path):
    return _selinux.realpath_not_final(name, resolved_path)
realpath_not_final = _selinux.realpath_not_final

def matchpathcon(path, mode):
    return _selinux.matchpathcon(path, mode)
matchpathcon = _selinux.matchpathcon

def matchpathcon_index(path, mode):
    return _selinux.matchpathcon_index(path, mode)
matchpathcon_index = _selinux.matchpathcon_index

def matchpathcon_filespec_add(ino, specind, file):
    return _selinux.matchpathcon_filespec_add(ino, specind, file)
matchpathcon_filespec_add = _selinux.matchpathcon_filespec_add

def matchpathcon_filespec_destroy():
    return _selinux.matchpathcon_filespec_destroy()
matchpathcon_filespec_destroy = _selinux.matchpathcon_filespec_destroy

def matchpathcon_filespec_eval():
    return _selinux.matchpathcon_filespec_eval()
matchpathcon_filespec_eval = _selinux.matchpathcon_filespec_eval

def matchpathcon_checkmatches(str):
    return _selinux.matchpathcon_checkmatches(str)
matchpathcon_checkmatches = _selinux.matchpathcon_checkmatches

def matchmediacon(media):
    return _selinux.matchmediacon(media)
matchmediacon = _selinux.matchmediacon

def selinux_getenforcemode():
    return _selinux.selinux_getenforcemode()
selinux_getenforcemode = _selinux.selinux_getenforcemode

def selinux_boolean_sub(boolean_name):
    return _selinux.selinux_boolean_sub(boolean_name)
selinux_boolean_sub = _selinux.selinux_boolean_sub

def selinux_getpolicytype():
    return _selinux.selinux_getpolicytype()
selinux_getpolicytype = _selinux.selinux_getpolicytype

def selinux_policy_root():
    return _selinux.selinux_policy_root()
selinux_policy_root = _selinux.selinux_policy_root

def selinux_set_policy_root(rootpath):
    return _selinux.selinux_set_policy_root(rootpath)
selinux_set_policy_root = _selinux.selinux_set_policy_root

def selinux_current_policy_path():
    return _selinux.selinux_current_policy_path()
selinux_current_policy_path = _selinux.selinux_current_policy_path

def selinux_binary_policy_path():
    return _selinux.selinux_binary_policy_path()
selinux_binary_policy_path = _selinux.selinux_binary_policy_path

def selinux_failsafe_context_path():
    return _selinux.selinux_failsafe_context_path()
selinux_failsafe_context_path = _selinux.selinux_failsafe_context_path

def selinux_removable_context_path():
    return _selinux.selinux_removable_context_path()
selinux_removable_context_path = _selinux.selinux_removable_context_path

def selinux_default_context_path():
    return _selinux.selinux_default_context_path()
selinux_default_context_path = _selinux.selinux_default_context_path

def selinux_user_contexts_path():
    return _selinux.selinux_user_contexts_path()
selinux_user_contexts_path = _selinux.selinux_user_contexts_path

def selinux_file_context_path():
    return _selinux.selinux_file_context_path()
selinux_file_context_path = _selinux.selinux_file_context_path

def selinux_file_context_homedir_path():
    return _selinux.selinux_file_context_homedir_path()
selinux_file_context_homedir_path = _selinux.selinux_file_context_homedir_path

def selinux_file_context_local_path():
    return _selinux.selinux_file_context_local_path()
selinux_file_context_local_path = _selinux.selinux_file_context_local_path

def selinux_file_context_subs_path():
    return _selinux.selinux_file_context_subs_path()
selinux_file_context_subs_path = _selinux.selinux_file_context_subs_path

def selinux_file_context_subs_dist_path():
    return _selinux.selinux_file_context_subs_dist_path()
selinux_file_context_subs_dist_path = _selinux.selinux_file_context_subs_dist_path

def selinux_homedir_context_path():
    return _selinux.selinux_homedir_context_path()
selinux_homedir_context_path = _selinux.selinux_homedir_context_path

def selinux_media_context_path():
    return _selinux.selinux_media_context_path()
selinux_media_context_path = _selinux.selinux_media_context_path

def selinux_virtual_domain_context_path():
    return _selinux.selinux_virtual_domain_context_path()
selinux_virtual_domain_context_path = _selinux.selinux_virtual_domain_context_path

def selinux_virtual_image_context_path():
    return _selinux.selinux_virtual_image_context_path()
selinux_virtual_image_context_path = _selinux.selinux_virtual_image_context_path

def selinux_lxc_contexts_path():
    return _selinux.selinux_lxc_contexts_path()
selinux_lxc_contexts_path = _selinux.selinux_lxc_contexts_path

def selinux_x_context_path():
    return _selinux.selinux_x_context_path()
selinux_x_context_path = _selinux.selinux_x_context_path

def selinux_sepgsql_context_path():
    return _selinux.selinux_sepgsql_context_path()
selinux_sepgsql_context_path = _selinux.selinux_sepgsql_context_path

def selinux_openrc_contexts_path():
    return _selinux.selinux_openrc_contexts_path()
selinux_openrc_contexts_path = _selinux.selinux_openrc_contexts_path

def selinux_openssh_contexts_path():
    return _selinux.selinux_openssh_contexts_path()
selinux_openssh_contexts_path = _selinux.selinux_openssh_contexts_path

def selinux_snapperd_contexts_path():
    return _selinux.selinux_snapperd_contexts_path()
selinux_snapperd_contexts_path = _selinux.selinux_snapperd_contexts_path

def selinux_systemd_contexts_path():
    return _selinux.selinux_systemd_contexts_path()
selinux_systemd_contexts_path = _selinux.selinux_systemd_contexts_path

def selinux_contexts_path():
    return _selinux.selinux_contexts_path()
selinux_contexts_path = _selinux.selinux_contexts_path

def selinux_securetty_types_path():
    return _selinux.selinux_securetty_types_path()
selinux_securetty_types_path = _selinux.selinux_securetty_types_path

def selinux_booleans_subs_path():
    return _selinux.selinux_booleans_subs_path()
selinux_booleans_subs_path = _selinux.selinux_booleans_subs_path

def selinux_booleans_path():
    return _selinux.selinux_booleans_path()
selinux_booleans_path = _selinux.selinux_booleans_path

def selinux_customizable_types_path():
    return _selinux.selinux_customizable_types_path()
selinux_customizable_types_path = _selinux.selinux_customizable_types_path

def selinux_users_path():
    return _selinux.selinux_users_path()
selinux_users_path = _selinux.selinux_users_path

def selinux_usersconf_path():
    return _selinux.selinux_usersconf_path()
selinux_usersconf_path = _selinux.selinux_usersconf_path

def selinux_translations_path():
    return _selinux.selinux_translations_path()
selinux_translations_path = _selinux.selinux_translations_path

def selinux_colors_path():
    return _selinux.selinux_colors_path()
selinux_colors_path = _selinux.selinux_colors_path

def selinux_netfilter_context_path():
    return _selinux.selinux_netfilter_context_path()
selinux_netfilter_context_path = _selinux.selinux_netfilter_context_path

def selinux_path():
    return _selinux.selinux_path()
selinux_path = _selinux.selinux_path

def selinux_check_access(scon, tcon, tclass, perm):
    return _selinux.selinux_check_access(scon, tcon, tclass, perm)
selinux_check_access = _selinux.selinux_check_access

def selinux_check_passwd_access(requested):
    return _selinux.selinux_check_passwd_access(requested)
selinux_check_passwd_access = _selinux.selinux_check_passwd_access

def checkPasswdAccess(requested):
    return _selinux.checkPasswdAccess(requested)
checkPasswdAccess = _selinux.checkPasswdAccess

def selinux_check_securetty_context(tty_context):
    return _selinux.selinux_check_securetty_context(tty_context)
selinux_check_securetty_context = _selinux.selinux_check_securetty_context

def set_selinuxmnt(mnt):
    return _selinux.set_selinuxmnt(mnt)
set_selinuxmnt = _selinux.set_selinuxmnt

def selinuxfs_exists():
    return _selinux.selinuxfs_exists()
selinuxfs_exists = _selinux.selinuxfs_exists

def fini_selinuxmnt():
    return _selinux.fini_selinuxmnt()
fini_selinuxmnt = _selinux.fini_selinuxmnt

def setexecfilecon(filename, fallback_type):
    return _selinux.setexecfilecon(filename, fallback_type)
setexecfilecon = _selinux.setexecfilecon

def is_context_customizable(scontext):
    return _selinux.is_context_customizable(scontext)
is_context_customizable = _selinux.is_context_customizable

def selinux_trans_to_raw_context(trans):
    return _selinux.selinux_trans_to_raw_context(trans)
selinux_trans_to_raw_context = _selinux.selinux_trans_to_raw_context

def selinux_raw_to_trans_context(raw):
    return _selinux.selinux_raw_to_trans_context(raw)
selinux_raw_to_trans_context = _selinux.selinux_raw_to_trans_context

def selinux_raw_context_to_color(raw):
    return _selinux.selinux_raw_context_to_color(raw)
selinux_raw_context_to_color = _selinux.selinux_raw_context_to_color

def getseuserbyname(linuxuser):
    return _selinux.getseuserbyname(linuxuser)
getseuserbyname = _selinux.getseuserbyname

def getseuser(username, service):
    return _selinux.getseuser(username, service)
getseuser = _selinux.getseuser

def selinux_file_context_cmp(a, b):
    return _selinux.selinux_file_context_cmp(a, b)
selinux_file_context_cmp = _selinux.selinux_file_context_cmp

def selinux_file_context_verify(path, mode):
    return _selinux.selinux_file_context_verify(path, mode)
selinux_file_context_verify = _selinux.selinux_file_context_verify

def selinux_lsetfilecon_default(path):
    return _selinux.selinux_lsetfilecon_default(path)
selinux_lsetfilecon_default = _selinux.selinux_lsetfilecon_default

def selinux_reset_config():
    return _selinux.selinux_reset_config()
selinux_reset_config = _selinux.selinux_reset_config
# This file is compatible with both classic and new-style classes.


