/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import lcmc.utilities.Tools;
import tightvnc.AuthPanel;
import tightvnc.ButtonPanel;
import tightvnc.ClipboardFrame;
import tightvnc.DesCipher;
import tightvnc.OptionsFrame;
import tightvnc.RecordingFrame;
import tightvnc.ReloginPanel;
import tightvnc.RfbProto;
import tightvnc.VncCanvas;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    Label connStatusLabel;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String socketFactory;
    String host;
    int port;
    String passwordParam;
    boolean showControls;
    boolean offerRelogin;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    int debugStatsExcludeUpdates;
    int debugStatsMeasureUpdates;
    public static Applet refApplet;
    int[] encodingsSaved;
    int nEncodingsSaved;

    public VncViewer(String[] mainArgs, boolean inAnApplet, boolean inSeparateFrame) {
        this.mainArgs = mainArgs;
        this.inAnApplet = inAnApplet;
        this.inSeparateFrame = inSeparateFrame;
    }

    @Override
    public void init() {
        this.readParameters();
        refApplet = this;
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public final Component getVncCanvas() {
        return this.vc;
    }

    @Override
    public void update(Graphics g) {
    }

    public void join() {
        try {
            this.rfbThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gbc);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            if (this.options.autoScale && this.inSeparateFrame) {
                Dimension screenSize;
                try {
                    screenSize = this.vncContainer.getToolkit().getScreenSize();
                }
                catch (Exception e) {
                    screenSize = new Dimension(0, 0);
                }
                this.createCanvas(screenSize.width - 32, screenSize.height - 32);
            } else {
                this.createCanvas(0, 0);
            }
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            if (this.inSeparateFrame) {
                Panel canvasPanel = new Panel();
                canvasPanel.setLayout(new FlowLayout(0, 0, 0));
                canvasPanel.add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gbc.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gbc);
                this.desktopScrollPane.add(canvasPanel);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gbc);
                this.add(this.vc);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.processNormalProtocol();
        }
        catch (NoRouteToHostException e) {
            this.fatalError("Network error: no route to server: " + this.host, e);
        }
        catch (UnknownHostException e) {
            this.fatalError("Network error: server name unknown: " + this.host, e);
        }
        catch (ConnectException e) {
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, e);
        }
        catch (EOFException e) {
            if (this.showOfflineDesktop) {
                e.printStackTrace();
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                }
                if (this.rfb != null && !this.rfb.closed()) {
                    this.rfb.close();
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection", e);
            }
        }
        catch (IOException e) {
            String str = e.getMessage();
            if (str != null && str.length() != 0) {
                this.fatalError("Network Error: " + str, e);
            } else {
                this.fatalError(e.toString(), e);
            }
        }
        catch (Exception e) {
            String str = e.getMessage();
            if (str != null && str.length() != 0) {
                this.fatalError("Error: " + str, e);
            }
            this.fatalError(e.toString(), e);
        }
    }

    void createCanvas(int maxWidth, int maxHeight) throws IOException {
        this.vc = null;
        try {
            Class<?> cl = Class.forName("java.awt.Graphics2D");
            cl = Class.forName("VncCanvas2");
            Class[] argClasses = new Class[]{this.getClass(), Integer.TYPE, Integer.TYPE};
            Constructor<?> cstr = cl.getConstructor(argClasses);
            Object[] argObjects = new Object[]{this, new Integer(maxWidth), new Integer(maxHeight)};
            this.vc = (VncCanvas)cstr.newInstance(argObjects);
        }
        catch (Exception e) {
            System.out.println("Warning: Java 2D API is not available: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.vc == null) {
            this.vc = new VncCanvas(this, maxWidth, maxHeight);
        }
        Tools.hideMousePointer(this.vc);
    }

    void processNormalProtocol() throws Exception {
        try {
            this.vc.processNormalProtocol();
        }
        catch (Exception e) {
            if (this.rfbThread == null) {
                System.out.println("Ignoring RFB socket exceptions because applet is stopping");
            }
            throw e;
        }
    }

    void connectAndAuthenticate() throws Exception {
        int authType;
        this.showConnectionStatus("Initializing...");
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
        }
        this.showConnectionStatus("Connecting to " + this.host + ", port " + this.port + "...");
        this.rfb = new RfbProto(this.host, this.port, this);
        this.showConnectionStatus("Connected to server");
        this.rfb.readVersionMsg();
        this.showConnectionStatus("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        this.showConnectionStatus("Using RFB protocol version " + this.rfb.clientMajor + "." + this.rfb.clientMinor);
        int secType = this.rfb.negotiateSecurity();
        if (secType == 16) {
            this.showConnectionStatus("Enabling TightVNC protocol extensions");
            this.rfb.setupTunneling();
            authType = this.rfb.negotiateAuthenticationTight();
        } else {
            authType = secType;
        }
        switch (authType) {
            case 1: {
                this.showConnectionStatus("No authentication needed");
                this.rfb.authenticateNone();
                break;
            }
            case 2: {
                this.showConnectionStatus("Performing standard VNC authentication");
                if (this.passwordParam != null) {
                    this.rfb.authenticateVNC(this.passwordParam);
                    break;
                }
                String pw = this.askPassword();
                this.rfb.authenticateVNC(pw);
                break;
            }
            default: {
                throw new Exception("Unknown authentication scheme " + authType);
            }
        }
    }

    void showConnectionStatus(String msg) {
        if (msg == null) {
            if (this.vncContainer.isAncestorOf(this.connStatusLabel)) {
                this.vncContainer.remove(this.connStatusLabel);
            }
            return;
        }
        System.out.println(msg);
        if (this.connStatusLabel == null) {
            this.connStatusLabel = new Label("Status: " + msg);
            this.connStatusLabel.setFont(new Font("Helvetica", 0, 12));
        } else {
            this.connStatusLabel.setText("Status: " + msg);
        }
        if (!this.vncContainer.isAncestorOf(this.connStatusLabel)) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(20, 30, 20, 30);
            this.gridbag.setConstraints(this.connStatusLabel, gbc);
            this.vncContainer.add(this.connStatusLabel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    String askPassword() throws Exception {
        this.showConnectionStatus(null);
        AuthPanel authPanel = new AuthPanel(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gbc.ipady = 50;
        this.gridbag.setConstraints(authPanel, gbc);
        this.vncContainer.add(authPanel);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
        authPanel.moveFocusToDefaultField();
        String pw = authPanel.getPassword();
        this.vncContainer.remove(authPanel);
        return pw;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
        this.showConnectionStatus(null);
    }

    void setEncodings() {
        this.setEncodings(false);
    }

    void autoSelectEncodings() {
        this.setEncodings(true);
    }

    void setEncodings(boolean autoSelectOnly) {
        if (this.options == null || this.rfb == null || !this.rfb.inNormalProtocol) {
            return;
        }
        int preferredEncoding = this.options.preferredEncoding;
        if (preferredEncoding == -1) {
            long kbitsPerSecond = this.rfb.kbitsPerSecond();
            if (this.nEncodingsSaved < 1) {
                System.out.println("Using Tight/ZRLE encodings");
                preferredEncoding = 7;
            } else if (kbitsPerSecond > 2000L && this.encodingsSaved[0] != 5) {
                System.out.println("Throughput " + kbitsPerSecond + " kbit/s - changing to Hextile encoding");
                preferredEncoding = 5;
            } else if (kbitsPerSecond < 1000L && this.encodingsSaved[0] != 7) {
                System.out.println("Throughput " + kbitsPerSecond + " kbit/s - changing to Tight/ZRLE encodings");
                preferredEncoding = 7;
            } else {
                if (autoSelectOnly) {
                    return;
                }
                preferredEncoding = this.encodingsSaved[0];
            }
        } else if (autoSelectOnly) {
            return;
        }
        int[] encodings = new int[20];
        int nEncodings = 0;
        encodings[nEncodings++] = preferredEncoding;
        if (this.options.useCopyRect) {
            encodings[nEncodings++] = 1;
        }
        if (preferredEncoding != 7) {
            encodings[nEncodings++] = 7;
        }
        if (preferredEncoding != 16) {
            encodings[nEncodings++] = 16;
        }
        if (preferredEncoding != 5) {
            encodings[nEncodings++] = 5;
        }
        if (preferredEncoding != 6) {
            encodings[nEncodings++] = 6;
        }
        if (preferredEncoding != 4) {
            encodings[nEncodings++] = 4;
        }
        if (preferredEncoding != 2) {
            encodings[nEncodings++] = 2;
        }
        if (this.options.compressLevel >= 0 && this.options.compressLevel <= 9) {
            encodings[nEncodings++] = -256 + this.options.compressLevel;
        }
        if (this.options.jpegQuality >= 0 && this.options.jpegQuality <= 9) {
            encodings[nEncodings++] = -32 + this.options.jpegQuality;
        }
        if (this.options.requestCursorUpdates) {
            encodings[nEncodings++] = -240;
            encodings[nEncodings++] = -239;
            if (!this.options.ignoreCursorUpdates) {
                encodings[nEncodings++] = -232;
            }
        }
        encodings[nEncodings++] = -224;
        encodings[nEncodings++] = -223;
        boolean encodingsWereChanged = false;
        if (nEncodings != this.nEncodingsSaved) {
            encodingsWereChanged = true;
        } else {
            for (int i = 0; i < nEncodings; ++i) {
                if (encodings[i] == this.encodingsSaved[i]) continue;
                encodingsWereChanged = true;
                break;
            }
        }
        if (encodingsWereChanged) {
            try {
                this.rfb.writeSetEncodings(encodings, nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.encodingsSaved = encodings;
            this.nEncodingsSaved = nEncodings;
        }
    }

    void setCutText(String text) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String fname) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = fname;
            this.recordingStatusChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[this.options.cursorUpdatesIndex].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[this.options.eightBitColorsIndex].getSelectedItem();
                this.options.choices[this.options.cursorUpdatesIndex].select("Disable");
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select("No");
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[this.options.cursorUpdatesIndex].select(this.cursorUpdatesDef);
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select(this.eightBitColorsDef);
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    void readParameters() {
        String str;
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        this.port = this.readIntParameter("PORT", 5900);
        this.readPasswordParameters();
        if (this.inAnApplet && (str = this.readParameter("Open New Window", false)) != null && str.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.showControls = true;
        str = this.readParameter("Show Controls", false);
        if (str != null && str.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.offerRelogin = true;
        str = this.readParameter("Offer Relogin", false);
        if (str != null && str.equalsIgnoreCase("No")) {
            this.offerRelogin = false;
        }
        this.showOfflineDesktop = false;
        str = this.readParameter("Show Offline Desktop", false);
        if (str != null && str.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 0);
        this.debugStatsExcludeUpdates = this.readIntParameter("DEBUG_XU", 0);
        this.debugStatsMeasureUpdates = this.readIntParameter("DEBUG_CU", 0);
        this.socketFactory = this.readParameter("SocketFactory", false);
    }

    private void readPasswordParameters() {
        String encPasswordParam = this.readParameter("ENCPASSWORD", false);
        if (encPasswordParam == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        } else {
            byte[] pw = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int len = encPasswordParam.length() / 2;
            if (len > 8) {
                len = 8;
            }
            for (int i = 0; i < len; ++i) {
                String hex = encPasswordParam.substring(i * 2, i * 2 + 2);
                Integer x = new Integer(Integer.parseInt(hex, 16));
                pw[i] = x.byteValue();
            }
            byte[] key = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            DesCipher des = new DesCipher(key);
            des.decrypt(pw, 0, pw, 0);
            this.passwordParam = new String(pw);
        }
    }

    public String readParameter(String name, boolean required) {
        if (this.inAnApplet) {
            String s = this.getParameter(name);
            if (s == null && required) {
                this.fatalError(name + " parameter not specified");
            }
            return s;
        }
        for (int i = 0; i < this.mainArgs.length; i += 2) {
            if (!this.mainArgs[i].equalsIgnoreCase(name)) continue;
            try {
                return this.mainArgs[i + 1];
            }
            catch (Exception e) {
                if (required) {
                    this.fatalError(name + " parameter not specified");
                }
                return null;
            }
        }
        if (required) {
            this.fatalError(name + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String name, int defaultValue) {
        String str = this.readParameter(name, false);
        int result = defaultValue;
        if (str != null) {
            try {
                result = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null && this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
            this.vc.requestFocus();
        }
    }

    public synchronized void disconnect() {
        System.out.println("Disconnecting");
        if (this.vc != null) {
            double sec = (double)(System.currentTimeMillis() - this.vc.statStartTime) / 1000.0;
            double rate = (double)Math.round((double)this.vc.statNumUpdates / sec * 100.0) / 100.0;
            int nRealRects = this.vc.statNumPixelRects;
            int nPseudoRects = this.vc.statNumTotalRects - this.vc.statNumPixelRects;
            System.out.println("Updates received: " + this.vc.statNumUpdates + " (" + nRealRects + " rectangles + " + nPseudoRects + " pseudo), " + rate + " updates/sec");
            int numRectsOther = nRealRects - this.vc.statNumRectsTight - this.vc.statNumRectsZRLE - this.vc.statNumRectsHextile - this.vc.statNumRectsRaw - this.vc.statNumRectsCopy;
            System.out.println("Rectangles: Tight=" + this.vc.statNumRectsTight + "(JPEG=" + this.vc.statNumRectsTightJPEG + ") ZRLE=" + this.vc.statNumRectsZRLE + " Hextile=" + this.vc.statNumRectsHextile + " Raw=" + this.vc.statNumRectsRaw + " CopyRect=" + this.vc.statNumRectsCopy + " other=" + numRectsOther);
            int raw = this.vc.statNumBytesDecoded;
            int compressed = this.vc.statNumBytesEncoded;
            if (compressed > 0) {
                double ratio = (double)Math.round((double)raw / (double)compressed * 1000.0) / 1000.0;
                System.out.println("Pixel data: " + this.vc.statNumBytesDecoded + " bytes, " + this.vc.statNumBytesEncoded + " compressed, ratio " + ratio);
            }
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.showMessage("Disconnected");
        } else {
            this.vncFrame.dispose();
        }
    }

    public synchronized void fatalError(String str) {
        System.out.println(str);
        if (this.inAnApplet) {
            Thread.currentThread().stop();
        } else {
            this.vncFrame.dispose();
        }
    }

    public synchronized void fatalError(String str, Exception e) {
        if (this.rfb != null && this.rfb.closed()) {
            System.out.println("RFB thread finished");
            return;
        }
        System.out.println(str);
        e.printStackTrace();
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inAnApplet) {
            this.showMessage(str);
        } else {
            this.vncFrame.dispose();
        }
    }

    void showMessage(String msg) {
        this.vncContainer.removeAll();
        Label errLabel = new Label(msg, 1);
        errLabel.setFont(new Font("Helvetica", 0, 12));
        if (this.offerRelogin) {
            Panel gridPanel = new Panel(new GridLayout(0, 1));
            Panel outerPanel = new Panel(new FlowLayout(0));
            outerPanel.add(gridPanel);
            this.vncContainer.setLayout(new FlowLayout(0, 30, 16));
            this.vncContainer.add(outerPanel);
            Panel textPanel = new Panel(new FlowLayout(1));
            textPanel.add(errLabel);
            gridPanel.add(textPanel);
            gridPanel.add(new ReloginPanel(this));
        } else {
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(errLabel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    @Override
    public void stop() {
        System.out.println("Stopping applet");
        this.rfbThread = null;
    }

    @Override
    public void destroy() {
        System.out.println("Destroying applet");
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public void enableInput(boolean enable) {
        this.vc.enableInput(enable);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        System.out.println("Closing window");
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncContainer.hide();
        if (!this.inAnApplet) {
            this.vncFrame.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }
}

