/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.CConnection;
import rfb.CSecurity;
import rfb.LogWriter;
import rfb.UserPasswdGetter;
import rfb.VncAuth;

public class CSecurityVncAuth
extends CSecurity {
    UserPasswdGetter upg;
    static LogWriter vlog = new LogWriter("VncAuth");

    public CSecurityVncAuth(UserPasswdGetter upg_) {
        this.upg = upg_;
    }

    @Override
    public int processMsg(CConnection cc) {
        InStream is = cc.getInStream();
        OutStream os = cc.getOutStream();
        byte[] challenge = new byte[16];
        is.readBytes(challenge, 0, 16);
        StringBuffer passwd = new StringBuffer();
        if (!this.upg.getUserPasswd(null, passwd)) {
            vlog.error("Getting password failed");
            return 0;
        }
        VncAuth.encryptChallenge(challenge, passwd.toString());
        os.writeBytes(challenge, 0, 16);
        os.flush();
        return 1;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String description() {
        return "No Encryption";
    }
}

