/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.AuthFailureException;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.CMsgReaderV3;
import rfb.CMsgWriter;
import rfb.CMsgWriterV3;
import rfb.CSecurity;
import rfb.ConnFailedException;
import rfb.Exception;
import rfb.LogWriter;
import rfb.SecTypes;

public abstract class CConnection
extends CMsgHandler {
    public static final int RFBSTATE_UNINITIALISED = 0;
    public static final int RFBSTATE_PROTOCOL_VERSION = 1;
    public static final int RFBSTATE_SECURITY_TYPES = 2;
    public static final int RFBSTATE_SECURITY = 3;
    public static final int RFBSTATE_SECURITY_RESULT = 4;
    public static final int RFBSTATE_INITIALISATION = 5;
    public static final int RFBSTATE_NORMAL = 6;
    public static final int RFBSTATE_INVALID = 7;
    InStream is;
    OutStream os;
    CMsgReader reader_;
    CMsgWriter writer_;
    boolean shared;
    CSecurity security;
    public static final int maxSecTypes = 8;
    int nSecTypes;
    int[] secTypes = new int[8];
    int state_ = 0;
    String serverName;
    boolean useProtocol3_3;
    boolean clientSecTypeOrder;
    static LogWriter vlog = new LogWriter("CConnection");

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setStreams(InStream is_, OutStream os_) {
        this.is = is_;
        this.os = os_;
    }

    public void initSecTypes() {
        this.nSecTypes = 0;
    }

    public void addSecType(int secType) {
        if (this.nSecTypes == 8) {
            throw new Exception("too many security types");
        }
        this.secTypes[this.nSecTypes++] = secType;
    }

    public void setShared(boolean s) {
        this.shared = s;
    }

    public void setProtocol3_3(boolean b) {
        this.useProtocol3_3 = b;
    }

    public void initialiseProtocol() {
        this.state_ = 1;
    }

    public void processMsg() {
        switch (this.state_) {
            case 1: {
                this.processVersionMsg();
                break;
            }
            case 2: {
                this.processSecurityTypesMsg();
                break;
            }
            case 3: {
                this.processSecurityMsg();
                break;
            }
            case 4: {
                this.processSecurityResultMsg();
                break;
            }
            case 5: {
                this.processInitMsg();
                break;
            }
            case 6: {
                this.reader_.readMsg();
                break;
            }
            case 0: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    public abstract CSecurity getCSecurity(int var1);

    public CSecurity getCurrentCSecurity() {
        return this.security;
    }

    public void setClientSecTypeOrder(boolean csto) {
        this.clientSecTypeOrder = csto;
    }

    public void authSuccess() {
    }

    @Override
    public void serverInit() {
        this.state_ = 6;
        vlog.debug("initialisation done");
    }

    public CMsgReader reader() {
        return this.reader_;
    }

    public CMsgWriter writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int state() {
        return this.state_;
    }

    protected void setState(int s) {
        this.state_ = s;
    }

    void processVersionMsg() {
        vlog.debug("reading protocol version");
        if (!this.cp.readVersion(this.is)) {
            this.state_ = 7;
            throw new Exception("reading version failed: not an RFB server?");
        }
        vlog.info("Server supports RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
        if (this.cp.beforeVersion(3, 3)) {
            String msg = "Server gave unsupported RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion;
            vlog.error(msg);
            this.state_ = 7;
            throw new Exception(msg);
        }
        if (this.useProtocol3_3 || this.cp.beforeVersion(3, 7)) {
            this.cp.setVersion(3, 3);
        } else if (this.cp.afterVersion(3, 8)) {
            this.cp.setVersion(3, 8);
        }
        this.cp.writeVersion(this.os);
        this.state_ = 2;
        vlog.info("Using RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
    }

    /*
     * Unable to fully structure code
     */
    void processSecurityTypesMsg() {
        CConnection.vlog.debug("processing security types message");
        secType = 0;
        if (this.cp.majorVersion != 3 || this.cp.minorVersion != 3) ** GOTO lbl16
        secType = this.is.readU32();
        if (secType == 0) {
            this.throwConnFailedException();
        } else if (secType == 1 || secType == 2) {
            for (j = 0; j < this.nSecTypes && this.secTypes[j] != secType; ++j) {
            }
            if (j == this.nSecTypes) {
                secType = 0;
            }
        } else {
            CConnection.vlog.error("Unknown 3.3 security type " + secType);
            throw new Exception("Unknown 3.3 security type");
lbl16:
            // 1 sources

            nServerSecTypes = this.is.readU8();
            if (nServerSecTypes == 0) {
                this.throwConnFailedException();
            }
            secTypePos = this.nSecTypes;
            block1: for (i = 0; i < nServerSecTypes; ++i) {
                serverSecType = this.is.readU8();
                CConnection.vlog.debug("Server offers security type " + SecTypes.name(serverSecType) + "(" + serverSecType + ")");
                if (secType != 0 && !this.clientSecTypeOrder) continue;
                for (j = 0; j < this.nSecTypes; ++j) {
                    if (this.secTypes[j] != serverSecType || j >= secTypePos) continue;
                    secType = this.secTypes[j];
                    secTypePos = j;
                    continue block1;
                }
            }
            if (secType != 0) {
                this.os.writeU8(secType);
                this.os.flush();
                CConnection.vlog.debug("Choosing security type " + SecTypes.name(secType) + "(" + secType + ")");
            }
        }
        if (secType == 0) {
            this.state_ = 7;
            CConnection.vlog.error("No matching security types");
            throw new Exception("No matching security types");
        }
        this.state_ = 3;
        this.security = this.getCSecurity(secType);
        this.processSecurityMsg();
    }

    void processSecurityMsg() {
        vlog.debug("processing security message");
        int rc = this.security.processMsg(this);
        if (rc == 0) {
            this.throwAuthFailureException();
        }
        if (rc == 1) {
            this.state_ = 4;
            this.processSecurityResultMsg();
        }
    }

    void processSecurityResultMsg() {
        vlog.debug("processing security result message");
        int result = this.cp.beforeVersion(3, 8) && this.security.getType() == 1 ? 0 : this.is.readU32();
        switch (result) {
            case 0: {
                this.securityCompleted();
                break;
            }
            case 1: {
                vlog.debug("auth failed");
                this.throwAuthFailureException();
            }
            case 2: {
                vlog.debug("auth failed - too many tries");
                this.throwAuthFailureException();
            }
            default: {
                vlog.error("unknown security result");
                this.throwAuthFailureException();
            }
        }
    }

    void processInitMsg() {
        vlog.debug("reading server initialisation");
        this.reader_.readServerInit();
    }

    void throwAuthFailureException() {
        vlog.debug("state=" + this.state() + ", ver=" + this.cp.majorVersion + "." + this.cp.minorVersion);
        String reason = this.state() == 4 && !this.cp.beforeVersion(3, 8) ? this.is.readString() : "Authentication failure";
        this.state_ = 7;
        vlog.error(reason);
        throw new AuthFailureException(reason);
    }

    void throwConnFailedException() {
        this.state_ = 7;
        String reason = this.is.readString();
        throw new ConnFailedException(reason);
    }

    void securityCompleted() {
        this.state_ = 5;
        this.reader_ = new CMsgReaderV3(this, this.is);
        this.writer_ = new CMsgWriterV3(this.cp, this.os);
        vlog.debug("Authentication success!");
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }
}

